window.addEventListener('shake', shakeEventDidOccur, false);

var shakeCount = 0;
var sound  = document.querySelector("#sound");
var lock = window.navigator.requestWakeLock('screen');
var vibrateInterval;

function startVibrate(duration) {
	navigator.vibrate(duration);
}

function stopVibrate() {
	if(vibrateInterval) clearInterval(vibrateInterval);
	navigator.vibrate(0);
}

function startPeristentVibrate(duration, interval) {
	vibrateInterval = setInterval(function() {
		startVibrate(duration);
	}, interval);
}

function shakeEventDidOccur () {
	if( shakeCount > 3 ) {
		$( "#run" ).hide(  );
		$( "#shake-time" ).hide(  );
		$( "#set" ).show(  );
		shakeCount = 0;
		sound.pause();
		stopVibrate();
	}
	shakeCount++;
}

$( document ).on( "click", "#start", function( e ) {
	e.preventDefault(  );

	var duration = $( "#duration" ).val(  );
	
	setTimeout( function(  ) {
		
		$( "#run" ).hide(  );
		$( "#shake-time" ).show(  );
		
		sound.play(  );
		startPeristentVibrate( 200, 200 );


	}, duration );
	
	$( "#countdown" ).html( "" );

	var secs = duration / 1000;
	var countdown = new Countdown( { 
		time: secs, 
		rangeHi:"hours", 
		width:280, 
		height:90, 
		hideLine: true, 
		labels: { 
			color:"#ffffff" 
		}, 
		target: "countdown",
	});
	
	$( "#set" ).hide(  );
	$( "#run" ).show(  );

} );

