/**
 * Lista feltöltése
 */
function ListAllNote() {
	var note_list = document.querySelector('#note-list');
	var _data = '';
	for ( var i = 0; i < window.localStorage.length; i++) {
		_current_data = '';
		_current_key = window.localStorage.key(i);
		if (_current_key != 'greennotes_settings') {
			_current_item = JSON.parse(window.localStorage
					.getItem(_current_key));
			var _date = new Date(_current_item.create_date);
			_current_data = '<li> '
					+ '<aside class="pack-end"> '
					+ '<a style="display:block; '
					+ 'width:60px; '
					+ 'height:60px; '
					+ 'background-repeat:no-repeat; '
					+ 'background-position:center; '
					+ 'background-image: url(\'icons/delete.png\')"  onclick="ItemDelete(\''
					+ _current_key + '\')" href="#"></a>' + '</aside>'
					+ '<a onclick="ItemClick(\'' + _current_key
					+ '\')" href="#">' + ' <p>' + _current_item.title + '</p>'
					+ ' <p>' + _date.toLocaleString() + '</p>' + '</a> '
					+ '</li>';
			_data += _current_data;
		}
	}
	note_list.innerHTML = _data;
}

/**
 * Beolvas egy adott kodu bejegyzést
 * 
 * @param _noteKey
 * @returns {___anonymous__current_note}
 */
function getNote(_noteKey) {
	var _current_key = window.localStorage.getItem(_noteKey);
	_current_note = JSON.parse(_current_key);
	return (_current_note);
}

/**
 * Bejegyzés betöltése a formra és a form megynyitása
 * 
 * @param _noteKey
 */
/*function OpenNoteEdit(_noteKey) {
	current_note_id = _noteKey;
	GetNoteToForm(_noteKey);
	document.querySelector('#note').className = 'current';
	document.querySelector('[data-position="current"]').className = 'left';
	if (settings.autosave == 1) {
		console.log('auto');
		autosave = window.setInterval(function() {
			AutoSave()
		}, settings.autosave_time*1000);
	}

}*/

/**
 * Létrehoz egy új bejegyzést
 */
function CreateDeafultNote() {
	_latitude=0;
	_longitude=0;
	var localStorageCount = window.localStorage.length;
	var _date = new Date();
	var _current_timestamp = _date.getTime();
	var _noteKey = 'greennotes_' + _current_timestamp;
	current_note_id = _noteKey;
	var _default_title = navigator.mozL10n.get('title') + '-'
			+ localStorageCount;
	var _new_note = {
		title : _default_title,
		content : '',
		latitude : _latitude,
		longitude : _longitude,
		create_date : _current_timestamp,
		modify_date : _current_timestamp
	};
	window.localStorage.setItem(_noteKey, JSON.stringify(_new_note));
}


function NewNote() {
	CreateDeafultNote();
	OpenNote(current_note_id);
	document.querySelector('#note-title').style.display='block';
	document.querySelector('#note-content').style.display='block';
	document.querySelector('#noteview-title').style.display='none';
	document.querySelector('#noteview-content').style.display='none';
	//GetNoteToForm(current_note_id);
}

/**
 * Elem törlése képernyő
 * @param key_id
 */
function ItemDelete(key_id) {
	current_note_id = key_id;
	document.querySelector('#delete-note').className = 'fade-in';

}

/**
 * Elem beolvasása szerkesztő nézetbe
 * @param key_id
 */
function ItemClick(key_id) {
	OpenNote(key_id);
	if (settings.quick_edit==1) {
		edit=1;
		console.log('quick_edit=1');
		document.querySelector('#btn-save-note').style.display='block';
		document.querySelector('#btn-edit-note').style.display='none';
		
		document.querySelector('#note-title').style.display='block';
		document.querySelector('#note-content').style.display='block';
		document.querySelector('#noteview-title').style.display='none';
		document.querySelector('#noteview-content').style.display='none';
	} else {
		edit=0;
		console.log('quick_edit=0');
		document.querySelector('#btn-save-note').style.display='none';
		document.querySelector('#btn-edit-note').style.display='block';
		
		document.querySelector('#noteview-title').style.display='block';
		document.querySelector('#noteview-content').style.display='block';
		document.querySelector('#note-title').style.display='none';
		document.querySelector('#note-content').style.display='none';
	}	
}

/**
 * Új Bejegyzés Mentés
 */
function createNote() {
	if (current_note_id == 0) {
		CreateDeafultNote();
		getNote(current_note_id);
	}
	var _date = new Date();
	var _current_timestamp = _date.getTime();
	var _create_date = _current_note.create_date;
	var _modify_date = _current_timestamp;
	var _title = document.querySelector('#note-title').value;
	var _content = document.querySelector('#note-content').value;
	var _create_date = _current_note.create_date;
	var _new_note = {
		title : _title,
		content : _content,
		latitude : _latitude,
		longitude : _longitude,
		create_date : _create_date,
		modify_date : _modify_date
	};
	window.localStorage.setItem(current_note_id, JSON.stringify(_new_note));
}

/**
 * Elmenti a beálltásokat az adatbázisba
 */
function SaveSettings() {
	save_start = 0;
	save_location = 0;
	autosave = 0;
	quick_edit = 0;
	if (document.querySelector('#setting_save_start').checked) {
		save_start = 1;
	}
	if (document.querySelector('#setting_autosave').checked) {
		autosave = 1;
	}
	if (document.querySelector('#setting_quick_edit').checked) {
		quick_edit = 1;
	}
	settings = {
		save_start : save_start,
		save_location : save_location,
		autosave : autosave,
		autosave_time : 20,
		quick_edit : quick_edit
	};
	utils.status.show(navigator.mozL10n.get('save-settings'));
	SaveSettingFromObject();
}

/**
 * Beolvassa a beállításokat a golbális változóba
 */
function GetSettings() {
	var _noteKey = 'greennotes_settings';
	var _current_key = window.localStorage.getItem(_noteKey);
	_settings = JSON.parse(_current_key);
	
	if (_settings === null) {
	} else {
		settings = _settings;
	}
	if (typeof settings.quick_edit == 'undefined') {
		settings.quick_edit=0;
		SaveSettingFromObject();		
	}
}

/**
 * Az aktuális Beálltásokat elmenti az adatbázisba 
 */
function SaveSettingFromObject() {
	window.localStorage.setItem('greennotes_settings', JSON.stringify(settings));
}

/**
 * Beálltásokat a képernyőre helyezi
 */
function SettingsToForm() {
	
	document.querySelector('#setting_save_start').checked = false;
	document.querySelector('#setting_autosave').checked = false;
	document.querySelector('#setting_quick_edit').checked = false;
	if (settings.save_start == 1) {
		document.querySelector('#setting_save_start').checked = true;
	}
	if (settings.autosave == 1) {
		document.querySelector('#setting_autosave').checked = true;
	}
	if (settings.quick_edit == 1) {
		document.querySelector('#setting_quick_edit').checked = true;
	}
}

/**
 * Automatikus mentés
 */
function AutoSave() {
	//autosave_counter++;
	//if (autosave_counter == settings.autosave_time) {
		createNote();
		utils.status.show(navigator.mozL10n.get('auto-save-message'));
		//autosave_counter = 0;
	//}
}

/**
 * Elkészti a térképet
 */
function showMap() {
	var zoom = 11;
	map = new OpenLayers.Map({
		div : "demoMap",
		theme : null,
		controls : [ new OpenLayers.Control.Attribution(),
				new OpenLayers.Control.TouchNavigation({
					dragPanOptions : {
						enableKinetic : true
					}
				}), new OpenLayers.Control.Zoom() ],
		layers : [ new OpenLayers.Layer.OSM("OpenStreetMap", null, {
			transitionEffect : 'resize'
		}) ]
	});

	MarkerLayer = new OpenLayers.Layer.Markers("Markers");
	map.addLayer(MarkerLayer);
	// a jegyzetek koordinátáit elhelyezi a térképen
	//TODO: a középre igaztést meg kell még oldalni
	for ( var i = 0; i < window.localStorage.length; i++) {
		_current_data = '';
		_current_key = window.localStorage.key(i);
		if (_current_key != 'greennotes_settings') {
			_current_item = JSON.parse(window.localStorage
					.getItem(_current_key));
			addMarker(MarkerLayer,_current_item.longitude,_current_item.latitude);
			map.setCenter(coord(_current_item.longitude,_current_item.latitude), 11);
		}
	}
	

}

/**
 * Hozzáad a térképhez egy jelölőt
 * @param MarkerLayer
 * @param lat
 * @param lon
 */
function addMarker(MarkerLayer, lat, lon) {
	var size = new OpenLayers.Size(21, 25);
	var offset = new OpenLayers.Pixel(-(size.w / 2), -size.h);
	var icon = new OpenLayers.Icon('images/marker.png', size, offset);
	//MarkerLayer.addMarker(new OpenLayers.Marker(coord(lat, lon), icon));
	MarkerLayer.addMarker(new OpenLayers.Marker(coord(lat, lon), icon));
}

/**
 * Google jelölőt átalktja OSM értékekké
 * @param lon
 * @param lat
 * @returns
 */
function coord(lon, lat) {
	var lonLat = new OpenLayers.LonLat(lon, lat).transform(
			new OpenLayers.Projection("EPSG:4326"), map.getProjectionObject());
	return lonLat;
}

/**
 * Kereső mező feltöltése
 * @param search_string 
 */
function listSearch(search_string) {
	var search_list = document.querySelector('#search-list');
	var text_search_value = document.querySelector('#text-search-value');
	text_search_value.innerHTML=search_string;
	var _data = '';
	for ( var i = 0; i < window.localStorage.length; i++) {
		_current_data = '';
		_current_key = window.localStorage.key(i);
		if (_current_key != 'greennotes_settings') {
			add=false;
			_current_item = JSON.parse(window.localStorage
					.getItem(_current_key));
			console.log(_current_item);
			var current_title=_current_item.title;
			var current_content=_current_item.content;
			current_title=current_title.toLowerCase();
			if (current_title.indexOf(search_string)!=-1) {
				add=true;
			} else {
				if (current_content.indexOf(search_string)!=-1) {
					add=true;
				}
			}
			if (add) {
				var _date = new Date(_current_item.create_date);	
				_current_data = '<li> '
						+ '<a onclick="ItemClick(\'' + _current_key
						+ '\')" href="#">' + ' <p>' + _current_item.title + '</p>'
						+ ' <p>' + _date.toLocaleString() + '</p>' + '</a> '
						+ '</li>';
				_data += _current_data;
			}
		}
		search_list.innerHTML = _data;
	}
}

/**
 * Megnyitja a jegyzetet nézet üzemmódban
 * @param _noteKey
 */
function OpenNote(_noteKey) {
	current_note_id = _noteKey;
	current_note=getNote(_noteKey);
	
	document.querySelector('#noteview-title').innerHTML=current_note.title;
	document.querySelector('#noteview-content').innerHTML=current_note.content;
	
	document.querySelector('#note-title').value = current_note.title;
	document.querySelector('#note-content').value = current_note.content;
	
	document.querySelector('#note').className = 'current';
	document.querySelector('[data-position="current"]').className = 'left';

}

/**
 * Program indulás, változók inicializálása
 */
function init() {	
	GetSettings();
	ListAllNote();
}
