var actual_class = "";
var valid_mask_block = [255, 254, 252, 248, 240, 224, 192, 128, 0];

function format_number(numb) {
	numb += '';
	var rgx = /(\d+)(\d{3})/;
	while (rgx.test(numb)) {
		numb = numb.replace(rgx, '$1' + '.' + '$2');
	}
	return numb;
}

var nprint = function(msg, clear) {
  if (clear) {
    $$("#main-output p").destroy();
  }
  $("main-output").adopt(new Element("p").appendText(msg));
};

var nerror = function(msg) {
  nprint(msg, true);
  $("main-output").highlight("#ff0000");
};

var part_convert = function(at8) {
    var r = 0,
        a = 128;
    for (var i = 0; i < at8; i++) {
      r += a;
      a /= 2;
    }
    return r;
  };

var IPAddress = new Class({
  ip: [0, 0, 0, 0],
  invalid: true,
  initialize: function(ip_param) {
    this.invalid = false;
    var ip = ip_param || "invalid";
    var ii = ip.split('.');
    if (ii.length != 4) {
      this.invalid = true;
      return;
    }
    for (var i = 0; i < ii.length; i++) {
      ii[i] = parseInt(ii[i]);
    }
    for (i = 0; i < ii.length; i++) {
      if ((ii[i] < 0) || (ii[i] > 255)) {
        this.invalid = true;
        return;
      }
    }  
    this.ip = ii.clone();
  },
  validate: function(mask) {
    var finished = false,
        p = 0;
    for (var i = 0; i < 4; i++) {
      if (mask) {
        p = valid_mask_block.indexOf(this.ip[i]);
        if ((p < 0) || ((p != 8) && finished))
          return false;
        if (p > 0)
          finished = true
      } else {
        if ((this.ip[i] < 0) || (this.ip[i] > 255)) {
          return false;
        }
      }
    }
    return true && !this.invalid;
  },
  fromMaskNumber: function(nm){
    this.ip = [0, 0, 0, 0];
    this.invalid = false;
    nm = parseInt(nm);
    if (nm > 30 || nm < 4) {
      this.invalid = true;
      return;
    } else if (nm >= 24) {
      this.ip[3] = part_convert(nm % 8);
      this.ip[0] = this.ip[1] = this.ip[2] = 255;
    } else if (nm >= 16) {
      this.ip[2] = part_convert(nm % 8);
      this.ip[0] = this.ip[1] = 255;
    } else if (nm >= 8) {
      this.ip[1] = part_convert(nm % 8);
      this.ip[0] = 255;
    } else if (nm >= 0) {
      this.ip[0] = part_convert(nm % 8); 
    }
  },
  toMaskNumber: function() {
    var aux = "zero",
        pos = 0,
        bits = 0;
    console.log(bits + " bits; IP: " + this.ip);
    while (pos < 4) {
      if (aux == "zero") {
        aux = this.ip[pos];
        console.log("Pegando posição " + pos + ": " + aux);
      }
      if (aux == 1) {
        pos++;
        aux = "zero";
        bits++;
        console.log("Como zerou, " + bits + " bits, vamos para o próximo");
      } else {
        if (aux > 0){
          if (aux % 2) {
            bits++;
          }
          aux = Math.floor(aux/2);
          console.log(bits + " bits, restam " + aux);
        } else {
          return bits;
        }
      }
    }
    return bits;
  },
  applyMask: function(m, rout) {
    var old = this.ip.clone();
    for (var i = 0; i < 4; i++) {
      this.ip[i] = parseInt(old[i] & m.ip[i]);  
    }
    if (rout) {
      i = Object.clone(this);
      this.ip = old;
      return i;
    }
  },
  plus: function(n) {
    this.ip[3] += n - 1;
    for (var i = 3; i > 0; i--) {
      if (this.ip[i] >= 256) {
        aux = this.ip[i];
        this.ip[i] = aux % 256;
        this.ip[i - 1] += Math.floor(aux / 256);
      }
    }
  },
  getClass: function() {
    var nm = 0,
        lip = 0;
    
    nm = 4;
    lip = this.applyMask(classes[nm], true).toString();
    if (lip == "224.0.0.0")
      return "multicast";
    else if (lip == "240.0.0.0")
      return "reserved";
    
    nm = 8;
    lip = this.applyMask(classes[nm], true).toString();
    if (lip == "10.0.0.0")
      return "private-a";
    else if (lip == "14.0.0.0")
      return "public";
    else if (lip == "39.0.0.0")
    return "reserved";
    else if (lip == "127.0.0.0")
      return "localhost";

    nm = 12;
    lip = this.applyMask(classes[nm], true).toString();
    if (lip == "172.16.0.0")
      return "private-b";
    
    nm = 15;
    lip = this.applyMask(classes[nm], true).toString();
    if (lip == "198.18.0.0")
      return "benchmark";
        
    nm = 16;
    lip = this.applyMask(classes[nm], true).toString();
    if (lip == "128.0.0.0")
      return "reserved";
    else if (lip == "169.254.0.0")
      return "zeroconf";
    else if (lip == "191.255.0.0")
      return "reserved";
    else if (lip == "192.168.0.0")
      return "private-c";
        
    nm = 24;
    lip = this.applyMask(classes[nm], true).toString();
    if (lip == "192.0.2.0")
      return "document";
    else if (lip == "192.88.99.0")
      return "ipv6";
    else if (lip == "223.255.255.0")
      return "reserved";

    return "vulgar";
  },
  toString: function() {
    return this.ip[0] + "." + this.ip[1] + "." + this.ip[2] + "." + this.ip[3];
  }
});

var classes = {};
[4, 8, 12, 15, 16, 24].each(function(c) {
  classes[c] = new IPAddress();
  classes[c].fromMaskNumber(c);
});

var netinfo = function () {
  var na = $("ipaddress").get("value");
  if (na.indexOf("/") > -1) {
    var nb = na.split('/');
    $("mask").set("value", nb[1]);
    $("mask").fireEvent("change");
    if (! $("mask-mode").bitMode) {
		$("mask-mode").fireEvent("click");
	}
	$("ipaddress").set("value", nb[0])
  }
  var machines = 0,
      netAddress = new IPAddress(na),
      i = 0,
      aux = 0,
      dnw = [],
      nm = 0;
  var netMask = new IPAddress();
  if ($("mask-mode").bitMode) {
    nm = $("mask").get("value");
    netMask.fromMaskNumber(nm);
  } else {
    netMask = new IPAddress($("mask-full").get("value"));
    nm = netMask.toMaskNumber();
  }
  if (!netAddress.validate()) {
    $("ipaddress").highlight("#ff0000");
    nerror("Invalid IP");
  } else if (!netMask.validate(true)) {
    $("mask-block").highlight("#ff0000");
    nerror("Invalid Mask");
  } else {
    machines = Math.pow(2, (32 - nm)) - 2;
    var nas = netAddress.toString();
    netAddress.applyMask(netMask);
    nprint(nas + "/" + nm, true);
    nprint(format_number(machines) + " máquinas!"); 
    var rangeIni = Object.clone(netAddress);
    var rangeFin = Object.clone(netAddress);
    rangeIni.plus(2);
    rangeFin.plus(machines - 1);
    var bCast = Object.clone(rangeFin);
    bCast.plus(2);
    var new_class = netAddress.getClass();
    if ((actual_class != "vulgar") && (actual_class != new_class)) {
      $("main-page").removeClass(actual_class);
    }
    actual_class = new_class;
    if (actual_class != "vulgar") {
      $("main-page").addClass(actual_class);
    }
    nprint("Network: " + netAddress.toString());
    nprint("Netmask: " + netMask.toString());
    nprint("Broadcast: " + bCast);
    nprint("Netrange: " + rangeIni.toString() + " - " + rangeFin.toString());
  }
};

var update_mask_value = function() {
  $("mask-output").set("value", "/" + this.value);
  $("mask-output").highlight("#ffff00");
};

document.addEvent("domready", function() {
  $("mask-mode").addEvent("click", function() {
    this.highlight("#ffff00");
    if (this.bitMode === undefined) {
      this.bitMode = false;
    }
    this.bitMode = ! this.bitMode;
    if (this.bitMode) {
      $("mask-full").setStyle("display", "none");
      $("mask-label").setStyle("display", "inline");
      $("mask").setStyle("display", "inline");
      $("mask-output").setStyle("display", "inline");
      $("mask-mode").set("text", "Bits"); 
    } else {
      $("mask-full").setStyle("display", "inline");
      $("mask-label").setStyle("display", "none");
      $("mask").setStyle("display", "none");
      $("mask-output").setStyle("display", "none");
      $("mask-mode").set("text", "Subnet");
    }
  });
  $("mask-mode").fireEvent("click");
  $("mask").addEvent("change", update_mask_value);
  $("mask").addEvent("click", update_mask_value);
  $("mask").addEvent("keyup", update_mask_value);
  $("net-button").addEvent("click", netinfo);
  $("mask").fireEvent("change");
  window.setTimeout(function() {
	$("splash").fade("out");
  }, 500);
});
