/**
 * Data models
 */
Apperyio.Entity = new Apperyio.EntityFactory({
    "worldoffline": {
        "type": "object",
        "properties": {
            "article": {
                "type": "string"
            },
            "title": {
                "type": "string"
            },
            "link": {
                "type": "string"
            },
            "image": {
                "type": "string"
            }
        }
    },
    "techoffline": {
        "type": "object",
        "properties": {
            "title": {
                "type": "string"
            },
            "link": {
                "type": "string"
            },
            "article": {
                "type": "string"
            },
            "image": {
                "type": "string"
            }
        }
    },
    "image": {
        "type": "object",
        "properties": {
            "url": {
                "type": "string"
            }
        }
    },
    "Number": {
        "type": "number"
    },
    "ukarray": {
        "type": "array",
        "items": {
            "type": "ukoffline"
        }
    },
    "worldarray": {
        "type": "array",
        "items": {
            "type": "worldoffline"
        }
    },
    "techarray": {
        "type": "array",
        "items": {
            "type": "techoffline"
        }
    },
    "businessarray": {
        "type": "array",
        "items": {
            "type": "businessoffline"
        }
    },
    "worldpic": {
        "type": "array",
        "items": {
            "type": "image"
        }
    },
    "ukoffline": {
        "type": "object",
        "properties": {
            "image": {
                "type": "string"
            },
            "link": {
                "type": "string"
            },
            "article": {
                "type": "string"
            },
            "title": {
                "type": "string"
            }
        }
    },
    "specialarray": {
        "type": "array",
        "items": {
            "type": "specialoffline"
        }
    },
    "Boolean": {
        "type": "boolean"
    },
    "businessoffline": {
        "type": "object",
        "properties": {
            "image": {
                "type": "string"
            },
            "article": {
                "type": "string"
            },
            "link": {
                "type": "string"
            },
            "title": {
                "type": "string"
            }
        }
    },
    "String": {
        "type": "string"
    },
    "ukimage": {
        "type": "object",
        "properties": {
            "url": {
                "type": "string"
            }
        }
    },
    "ukpic": {
        "type": "array",
        "items": {
            "type": "ukimage"
        }
    },
    "specialoffline": {
        "type": "object",
        "properties": {
            "title": {
                "type": "string"
            },
            "link": {
                "type": "string"
            },
            "article": {
                "type": "string"
            },
            "image": {
                "type": "string"
            }
        }
    },
    "healtharray": {
        "type": "array",
        "items": {
            "type": "healthoffline"
        }
    },
    "healthoffline": {
        "type": "object",
        "properties": {
            "image": {
                "type": "string"
            },
            "link": {
                "type": "string"
            },
            "article": {
                "type": "string"
            },
            "title": {
                "type": "string"
            }
        }
    }
});
Apperyio.getModel = Apperyio.Entity.get.bind(Apperyio.Entity);

/**
 * Data storage
 */
Apperyio.storage = {

    "topic": new $a.LocalStorage("topic", "String"),

    "title1": new $a.LocalStorage("title1", "String"),

    "title2": new $a.LocalStorage("title2", "String"),

    "title3": new $a.LocalStorage("title3", "String"),

    "status": new $a.LocalStorage("status", "String"),

    "save1": new $a.LocalStorage("save1", "String"),

    "savetitle": new $a.LocalStorage("savetitle", "String"),

    "save2": new $a.LocalStorage("save2", "String"),

    "savetitle2": new $a.LocalStorage("savetitle2", "String"),

    "save3": new $a.LocalStorage("save3", "String"),

    "savetitle3": new $a.LocalStorage("savetitle3", "String"),

    "save4": new $a.LocalStorage("save4", "String"),

    "savetitle4": new $a.LocalStorage("savetitle4", "String"),

    "title4": new $a.LocalStorage("title4", "String"),

    "TITLE": new $a.LocalStorage("TITLE", "String"),

    "ratecount": new $a.LocalStorage("ratecount", "String"),

    "storage": new $a.LocalStorage("storage", "String"),

    "worldoffline": new $a.LocalStorage("worldoffline", "worldarray"),

    "ukoffline": new $a.LocalStorage("ukoffline", "ukarray"),

    "techoffline": new $a.LocalStorage("techoffline", "techarray"),

    "businessoffline": new $a.LocalStorage("businessoffline", "businessarray"),

    "healthoffline": new $a.LocalStorage("healthoffline", "healtharray"),

    "regionstore": new $a.LocalStorage("regionstore", "String"),

    "regiontitle": new $a.LocalStorage("regiontitle", "String"),

    "specialoffline": new $a.LocalStorage("specialoffline", "specialarray"),

    "loadtech": new $a.LocalStorage("loadtech", "String"),

    "loadbus": new $a.LocalStorage("loadbus", "String"),

    "loadhealth": new $a.LocalStorage("loadhealth", "String"),

    "loadspecial": new $a.LocalStorage("loadspecial", "String"),

    "setcounter": new $a.LocalStorage("setcounter", "Number"),

    "loadpicture": new $a.LocalStorage("loadpicture", "String"),

    "rsspichtml": new $a.LocalStorage("rsspichtml", "String"),

    "rsspictitle": new $a.LocalStorage("rsspictitle", "String"),

    "identify": new $a.LocalStorage("identify", "Number"),

    "loadload": new $a.LocalStorage("loadload", "String"),

    "link": new $a.LocalStorage("link", "String")
};

/**
 * Push Notification specific data storage
 */
Apperyio.storage.pushNotificationToken = new $a.LocalStorage("pushNotificationToken", "String");
Apperyio.storage.pushNotificationDeviceID = new $a.LocalStorage("pushNotificationDeviceID", "String");
Apperyio.storage.deviceTimeZone = new $a.LocalStorage("deviceTimeZone", "String");