
var app = {
    query: {
        rss: "select * from html where url="
    },
    categoryName: {
        top: "Top Stories",
        business: "Business",
        design: "Art and Design",
        health: "Health",
        humor: "Humor and Comedy",
        science: "Science",
        sports: "Sports",
        technology: "Technology",
        travel: "Travel"
    },
    feeds: {},
    init: function() {
        var fontSize = localStorage.getItem('fontsize');
        if(!fontSize) {
            localStorage.setItem('fontsize','50');
        }
        
        $('.refresh-menu-item').on('click', app._getFeedURLs);
        $('.settings-menu-item').on('click', settings.showSettings);
        $('.sources-menu-item').on('click', sources.showSources);
        $('.about-menu-item').on('click', about.showAbout);
        $('.menu-button').on('click', function() {
            $(".mdl-layout__drawer-button").click();
        });
        this.updateFontSize();
        this._initWorker();
        
        this._getFeedURLs();
    },
    render: function(e) {
        var self = this;
        this.currentCategory = e || self.getFirstFeedCategory();
        this._updateCurrentView();
    },
    getFirstFeedCategory: function() {
        var selectedCategory = 'top'
        if( typeof this.feeds['top'] == "undefined") {
            for( first in app.feeds) break; 
            selectedCategory = first;
        }
        
        return selectedCategory;
    },
    _initWorker: function() {
        this.worker = new Worker("js/feedWorker.js");
        this.worker.onmessage = this._handleWorkerMessage;
    },
    _handleWorkerMessage: function(e) {
        var self = this;
        switch(e.data.type) {
            case "nav" :    app._updateDrawerLinks(e.data.categories);
                            break;
            case "feeds" :  app.feeds = e.data.feeds;
                            app._updateCurrentView(e.data.feeds);
                            break;
        }
    },
    _getFeedURLs: function() {
        var self = this;
        if(localStorage.getItem('sources')) {
            app.feedUrls = JSON.parse(localStorage.getItem('sources'));
            app._executeRequests();
        }
    },
    _executeRequests: function() {
        var self = this,
            totalFeeds = this.feedUrls.length,
            completedDownloading = 0;
        $('#loader').show();
        this.feedUrls.forEach( function(obj, index) {
            var builtURL = self.buildAndEncodeURL(obj.query);
            if(typeof fetch != "undefined") {
                fetch( builtURL )
                    .then( function (response) {
                        return response.json();
                    })
                    .then( function (body) {
                        self.worker.postMessage([body, obj.category]);
                        completedDownloading++;
                        if(completedDownloading >= totalFeeds-1) {
                            $('#loader').hide();
                        }
                        return body;
                    });
            } else {
                // Supporting ffos versions that dont have fetch implemented yet
                $.ajax({
                    url: builtURL,
                    method: "get",
                    dataType: "json",
                    success: function(body) {
                        self.worker.postMessage([body, obj.category]);
                        completedDownloading++;
                        if(completedDownloading >= totalFeeds-1) {
                            $('#loader').hide();
                        }
                    }
                });
            }
        });
    },
    buildAndEncodeURL: function(url) {
        return "https://query.yahooapis.com/v1/public/yql?q=" + 
            encodeURI(url) + 
            "&format=json&diagnostics=true&callback=";
    },
    _updateCurrentView: function(feeds) {
        
        var currentCategory = this.currentCategory || this.getFirstFeedCategory();;
        
        var directive = {
            imageurl: {
                src: function(params) {
                    return this.data != null ? ( this.data.img != null ? this.data.img : '' ) : '';
                }
            },
            link: {
                href: function(params) {
                    return this.link;
                },
                text: function() {
                    return "Read Article";
                }
            },
            description: {
                text: function() {
                    return this.data != null ? ( this.data.p != null ? this.data.p : '' ) : '';
                }
            }
        };
        $('.cards').render(this.feeds[currentCategory], directive);
    },
    _updateDrawerLinks: function(categories) {
        var self = this;
        var directive = {
            category: {
                html: function() {
                    return app.categoryName[this.value];
                },
                category: function() {
                    return this.value;
                }
            }
        };
        $('#links').render(categories, directive);
        $('#links a').off();
        $('#links a').on('click', function(e) {
            $('.mdl-layout__drawer').removeClass('is-visible');
            self.render(e.target.getAttribute('category'));
            
            //TODO :  FIX SCROLL TO TOP
            window.scrollTo(0,0);
        })
    },
    updateFontSize: function() {
        var fontSize = localStorage.getItem('fontsize');
        $('.mdl-card__title-text').css({
            "font-size": settings.fontSize[fontSize][0]
        });
        $('.mdl-card__supporting-text').css({
            "font-size": settings.fontSize[fontSize][1],
            "line-height": settings.fontSize[fontSize][2]
        });
    }
};