importScripts("libs/sugar.min.js")

var feeds = {},
    categories = [];

onmessage = function (e) {
    
    // get Data
    var category = e.data[1];
    
    if(e.data[0]) {
        var item = e.data[0].query.results.item;

        // Create new category
        self.feeds[category] = self.feeds[category] || new Array ;

        self.addToCategory(category);
        // Convert data into feed object
        item.forEach( function(item) {
            // Changing Date type to ISO
            item.pubDate = Date.create(item.pubDate).toISOString();
            
            if(typeof item.description == 'string') {
                item.description = self.parseDescription(item.description);
            } else if(!item.description) {
                item.description = {};
                item.description['p'] = "";
                item.description['img'] = "";
            }
            
            item.link = self.parseLink(item.link);

            var singleFeed = {
                heading: item.title,
                link: item.link,
                data: item.description,
                pubDate: item.pubDate
            }

            self.feeds[category].push(singleFeed);
            self.feeds[category] = self.removeDuplicates(self.feeds[category]);
        });
        self.feeds[category].sort(self.dateSort);
        self.addToFeeds();
    }
}

addToCategory = function(category) {
    var self = this;
    if( !self._hasCategory(category) ) {
        self.categories.push(category);
        self.categories.sort( function (a, b) {
                if (a > b) {
                    return 1;
                }
                if (a < b) {
                    return -1;
                }
                // a must be equal to b
                return 0;
            });
        postMessage({
            type: "nav",
            categories: self.categories
        });
    }
};

addToFeeds = function() {
    postMessage({
        type: "feeds",
        feeds: self.feeds
    });
}

_hasCategory = function (category) {
    return this.categories.find( function(el, index) {
        if(el == category) {
            return true;
        }
    });
};

 // Parses the HTML description
parseDescription = function (string) {

    var item = {};
    //check for rss thumbnail
    if(string.indexOf("rss_thumbnail") > -1) {
        // yes, it has rss thumbnail, we will need to extract description and thumbnail

        var earlyRemoval = string.substring(string.indexOf("rss_thumbnail"));
        var imgString = earlyRemoval.substring(earlyRemoval.indexOf("img"), earlyRemoval.indexOf("/>"));
        var imgSrc = imgString.substring(imgString.indexOf("src=\"")+5);
        var src = imgSrc.substring(0, imgSrc.indexOf("\""));

        item['img'] = src;

        var p = string.substring(string.indexOf("<p>")+3, string.indexOf("</p>"));

        item['p'] = p;
    } else if(string.indexOf("<img") == 0) {
        
        // this one is starting off from an image, must be comics
        
        var imgString = string.substring(0, string.indexOf(">"));
        var imgSrc = imgString.substring(imgString.indexOf("src=\"")+5);
        var src = imgSrc.substring(0, imgSrc.indexOf("\""));

        item['img'] = src;
        item['p'] = "";
    } else {
        var p = "";

        item['img'] = '';

        if(string.indexOf("<") != -1) {
            // the string has weird html tags  in it
            // we need to extract the first #text node from it
            var firstLocOfLTSign = string.indexOf("<");
            p = string.substring(0, firstLocOfLTSign);
        } else {
            // the string is pure text
            p = string;
        }

        item['p'] = p;
    }

    return item;
};

parseLink = function(link) {
    if(typeof link === "object") {
        link = link.href;
    }
    return link;
}

removeDuplicates = function(origArr) {
    var newArr = [],
        origLen = origArr.length,
        found,
        x = 0; y = 0;

    for ( x = 0; x < origLen; x++ ) {
        found = undefined;
        for ( y = 0; y < newArr.length; y++ ) {
            if ( origArr[x].heading === newArr[y].heading ) found = true;
        }
        if ( !found) newArr.push( origArr[x] );    
    }
   return newArr;
};

dateSort = function (a, b) {
    if (a.pubDate > b.pubDate) {
        return -1;
    }
    if (a.pubDate < b.pubDate) {
        return 1;
    }
    // a must be equal to b
    return 0;
};