var sources = {
    feedSources: [],
    
    /*
     * Initializes the sources window
     */
    init: function() {
        $(".sources-done-button-button").on("click", this.hideSources);
        $('.sources-search-list button').on("click", this.addFeedToList);
        $('#no-source-button').on("click", this.showSources);
        $("#search").on("keyup", this.searchSource)
        var feedSources = localStorage.getItem('sources');
        if(feedSources) {
            this.feedSources = JSON.parse(feedSources);
            if(this.feedSources.length == 0) {
                this.renderLonelyMessage();
            }
        } else {
            this.renderLonelyMessage();
        }
    },
    
    /*
     * Shows the sources window
     */
    showSources: function () {
        $(".sources-view").css('display', 'block');
        sources.render();
    },
    
    /*
     * Hides the sources window
     */
    hideSources: function () {
        $(".sources-view").css('display', 'none');
    },
    updateSources: function (source) {
        
        var isAlreadyAvailable = false;
        
        if(this.feedSources) {
            
            isAlreadyAvailable = this.feedSources.find( function(el, index) {
                if(source.category == el.category && source.name == el.name) {
                    return true;
                }
            });
        }
        if(!isAlreadyAvailable) {
            this.feedSources.push(source);
            this.feedSources.sort( function (a, b) {
                if (a.name > b.name) {
                    return 1;
                }
                if (a.name < b.name) {
                    return -1;
                }
                // a must be equal to b
                return 0;
            });
            localStorage.setItem('sources', JSON.stringify(this.feedSources));
            sources.render();
            alert(source.name + " ( " + source.category + " ) has been added to your Newstand.");
            
            $(".cards").css("display", "block");
            $(".empty-message").css("display", "none");
            app._getFeedURLs();
        } else {
            alert("You are already subscribed to " + source.name + " ( " + source.category + " ).")
        }
    },
    
    
    /*
     * This function get the sources {name and url} from the server
     */
    getFeedsFromSourceFromServer: function (query) {
        var url = "https://query.yahooapis.com/v1/public/yql?" +    
            "q=select%20json.name%2C%20json.rss%2C%20json.category" + 
            "%20from%20json%20" +
            "where%20url%3D'https%3A%2F%2Fprateekjadhwani.github.io%2Frss-collection%2Frss.json'" +
            "%20and%20json.name%20like%20'%25" +
            query +
            "%25'%20&format=json&diagnostics=true&callback=";
        if(typeof fetch != "undefined") {
            fetch(url)
                .then( function (response) {
                    return response.json();
                })
                .then( function (body) {
                    if(!body.query.results) {
                        $('.sources-search-list').render([]);
                    } else {
                        sources.updateSearchResults(body.query.results.json);
                    }
                    return body;
                });
        }  else {
            // Supporting ffos versions that dont have fetch implemented yet
            $.ajax({
                url: url,
                method: "get",
                dataType: "json",
                success: function(body) {
                    if(!body.query.results) {
                        $('.sources-search-list').render([]);
                    } else {
                        sources.updateSearchResults(body.query.results.json);
                    }
                }
            });
        }
    },
    
    render: function () {
        var directive = {
            sourceName: {
                html: function() {
                    return this.name + ' ( ' + this.category + ' ) ';
                }
            },
            sourcefor: {
                for: function() {
                    return $.trim(this.name + this.category);
                }
            },
            sourceid: {
                id: function() {
                    return $.trim(this.name + this.category);
                },
                sourceurl: function() {
                    return this.rss;
                }
            }
        };
        $('.sources-list').render(this.feedSources, directive);
        $('.sources-list .source-checkbox button').off();
        $('.sources-list .source-checkbox button').on("click", sources.deleteSource);
    },
    deleteSource: function(e) {
        var index = sources._getSourceIndex(e.target.sourceurl);
        var sourceName = sources.feedSources[index].name + " ( " + sources.feedSources[index].category + " ) ";
        alert(sourceName + " has been removed from your Newstand.");
        sources.feedSources.splice(index, 1);
        localStorage.setItem('sources', JSON.stringify(sources.feedSources));
        sources.render();
        app._getFeedURLs();
    },
    _getSourceIndex: function(url) {
        var returnIndex = null;
        $.each(this.feedSources, function(index, el) {
            if(el.rss == url) {
                returnIndex = index;
            }
        });
        return returnIndex;
    },
    searchSource: function (e) {
        if($.trim(e.target.value) != "") {
            sources.getFeedsFromSourceFromServer(e.target.value);
        } else {
            $('.sources-search-list').render([]);
            $('.sources-search-list').css("display", "none");
        }
    },
    updateSearchResults: function (data) {
        if(data) {
            if(data.length > 0) {
                $('.sources-search-list').css("display", "block");
            }
        }
        var directive = {
            searchResultName: {
                html: function() {
                    return this.json.name + ' ( ' + this.json.category + ' ) ';
                }
            },
            searchResultUrlData: {
                category: function() {
                    return $.trim(this.json.category);
                },
                sourceurl: function() {
                    return this.json.rss;
                },
                sourcename: function() {
                    return this.json.name;
                }
            }
        };
        $('.sources-search-list').render(data, directive);
        $('.sources-search-list button').off();
        $('.sources-search-list button').on("click", this.addFeedToList);
    },
    addFeedToList: function (e) {
        var newSource = {},
            el = e.target;
        
        newSource = {
            name: el.getAttribute("sourcename"),
            category: el.getAttribute("category"),
            rss: el.getAttribute("sourceurl"),
            query: "select pubDate,title, image, description, link from rss where url='" + el.getAttribute("sourceurl") + "'"
        }
        
        sources.updateSources(newSource);
    },
    renderLonelyMessage: function () {
        $(".cards").css("display", "none");
        $("#loader").hide();
        $(".empty-message").css("display", "block");
    }
};