/*
 * This events gets called when the DOM content has been loaded
 */
window.addEventListener('DOMContentLoaded', function() {

    'use strict';
    
    // Setting Transparency to accept only 'data-bind' as input
    Transparency.matcher = function(element, key) {
        return element.el.getAttribute('data-bind') == key;
    };
    
    // Updating Title and rending the app
    var initParams = {
        title: 'Newstand'
    };
    $('#page').render(initParams);
    
    // Initializing app params on startup
    app.init();
    settings.init();
    sources.init();
    about.init();
});