(function() {
  "user strict";

  angular
    .module('nHome')
    .controller('AddServer', ['dataRequest', '$q', '$scope', '$timeout', function(dataRequest, $q, $scope, $timeout) {
      var addServer = this;

      addServer.userInfo = JSON.parse(sessionStorage.userInfoData);
      addServer.newServerAdded = false;
      addServer.newServer = null;

      function scanServers() {
        var defer = $q.defer();
        dataRequest.getServers()
          .success(function(data, status, headers, config) {
            console.log(data);
            defer.resolve(data);
            addServer.foundServers = data;
          });
        return defer.promise;
      };
      scanServers();

      addServer.checkForServers = function() {
        scanServers()
          .then(function() {
            if (!addServer.foundServers.length) {
              addServer.noServersFound = true;
            } else {
              addServer.claimMe(addServer.foundServers[0]);
            }
          })
      };

      addServer.claimMe = function(server) {
        addServer.newServer = server;
      };

      addServer.claimServer = function(server, index) {
        console.log(server);
        dataRequest.claimServer(server.id)
          .then(function(response) {
            if (response.data) {
              var user = JSON.parse(sessionStorage.userInfoData);
              user.servers.push(server);
              sessionStorage.activeServer = JSON.stringify(server);
              sessionStorage.userInfoData = JSON.stringify(user);
              location.reload(true);
            }
          });
      };
    }]);
}());
