(function() {
    "use strict";

    angular
      .module('nHome')
      .controller('LoginCtrl', ['$state', 'dataRequest', 'dataService', '$stateParams', function($state, dataRequest, dataService, $stateParams) {

        var login = this;

        //login input data
        var loginEmail = document.getElementById('login-email');
        var loginPassword = document.getElementById('login-password');

        //register input data
        var registerPassword = document.getElementById('register-password');
        var registerRePassword = document.getElementById('register-rePassword');
        var registerUsername = document.getElementById('register-username');
        var registerEmail = document.getElementById('register-email');

        //forgot password input data
        var forgotPassEmail = document.getElementById('reset-email');

        /* login user */
        login.loginUser = function() {
          dataRequest.authUser({
              email: loginEmail.value,
              pass: loginPassword.value
            })
            .then(function(response) {
              response.data.email = loginEmail.value;
              console.log(response.data);

              sessionStorage.userInfoData = JSON.stringify(response.data);
              sessionStorage.activeServer = response.data.servers[0] ? JSON.stringify(response.data.servers[0]) : JSON.stringify({});

              if (response.data.servers.length) {
                $state.go('frame.dashboard', {
                  lastRoute: 'login'
                });
              } else {
                $state.go('frame.add-server');
              }
            })
            .catch(function(response) {
              login.incorrect = response.status === 403 ? true : false;
              console.log(response);
            })
        };

        /* register user */
        login.registerUser = function() {

          if (registerPassword.value === registerRePassword.value) {
            dataRequest.registerUser({
                user_name: registerUsername.value,
                email_address: registerEmail.value,
                password: registerPassword.value
              })
              .then(function(response) {

                if (response.data.errors) {
                  angular.forEach(data.errors, function(error) {
                    alert(error);
                  });
                } else if (response.data.success) {
                  login.regSuccess = true;
                  /* fill login data */
                  loginEmail.value = registerEmail.value;
                  loginPassword.value = '';

                  /* clear data */
                  registerUsername.value = '';
                  registerEmail.value = '';
                  registerPassword.value = '';
                  registerRePassword.value = '';

                  setTimeout(function() {
                    loginForm.style.animation = 'showForm 0.5s ease-in-out forwards';
                    registerForm.style.animation = 'hideForm 0.5s ease-in-out forwards';

                    setTimeout(function() {
                      loginForm.style.display = 'block';
                      registerForm.style.display = 'none';
                      login.regSuccess = false;
                    }, 500);
                  }, 3500);
                }
              })
          } else {
            return false;
          }
        };

        /* reset password */
        login.forgotPassword = function() {
          dataRequest.passReset({
              email_address: forgotPassEmail.value
            })
            .then(function(response) {

              login.passReset = response.data;
              if (response.data) {
                forgotPassEmail.value = '';

                setTimeout(function() {
                  loginForm.style.animation = 'showForm 0.5s ease-in-out forwards';
                  forgotPasswordForm.style.animation = 'hideForm 0.5s ease-in-out forwards';

                  setTimeout(function() {
                    loginForm.style.display = 'block';
                    forgotPasswordForm.style.display = 'none';
                  }, 500);
                }, 3500);
              }
            })
        };

        /* login form, toggle visibility */
        var registerToggleBtn = document.querySelector('.register-btn');
        var backToLoginBtn = document.querySelectorAll('.back-to-login-btn');
        var forgotPassBtn = document.querySelector('.forgot-password');

        /*  select visible button */
        if (window.innerWidth > '992') {
          backToLoginBtn = backToLoginBtn[0];
        } else {
          backToLoginBtn = backToLoginBtn[1];
        }

        var inputs = document.getElementsByTagName('input');

        angular.forEach(inputs, function(inp) {
          inp.oninput = function(e) {
            e.target.value = e.target.value.trim();
          };
        })
        var loginDescription = document.querySelector('.login-description');
        var loginForm = document.querySelector('.login-form');
        var registerForm = document.querySelector('.register-form');
        var forgotPasswordForm = document.querySelector('.forgot-password-form');


        if ($stateParams.register === 'register') {
          if (window.innerWidth >= '992') {
            loginDescription.style.width = '45%';
            loginDescription.style.transition = 'width ease 0.8s';
          }

          loginForm.style.animation = 'hideForm 0.5s ease-in-out forwards';
          registerForm.style.animation = 'showForm 0.6s ease-in-out forwards';
          forgotPasswordForm.style.animation = 'hideForm 0.5s ease-in-out forwards';

          setTimeout(function() {
            loginForm.style.display = 'none';
            registerForm.style.display = 'block';
            forgotPasswordForm.style.display = 'none';
          }, 500);
        }
        /* go to register form */
        registerToggleBtn.onclick = function(e) {
          e.preventDefault();

          if (window.innerWidth >= '992') {
            loginDescription.style.width = '45%';
            loginDescription.style.transition = 'width ease 0.8s';
          }

          loginForm.style.animation = 'hideForm 0.5s ease-in-out forwards';
          registerForm.style.animation = 'showForm 0.6s ease-in-out forwards';
          forgotPasswordForm.style.animation = 'hideForm 0.5s ease-in-out forwards';

          setTimeout(function() {
            loginForm.style.display = 'none';
            registerForm.style.display = 'block';
            forgotPasswordForm.style.display = 'none';
          }, 500);
        };

        /* return to login form */
        backToLoginBtn.onclick = function(e) {
          loginForm.style.animation = 'showForm 0.6s ease-in-out forwards';
          registerForm.style.animation = 'hideForm 0.5s ease-in-out forwards';

          setTimeout(function() {
            loginForm.style.display = 'block';
            registerForm.style.display = 'none';
          }, 400);

          if (window.innerWidth >= '992') {
            loginDescription.style.width = '60%';
            loginDescription.style.transition = 'width ease 0.8s 0.5s';
          }
        };

        /* go to password reset form */
        forgotPassBtn.onclick = function(e) {
          e.preventDefault();

          loginForm.style.animation = 'hideForm 0.5s ease-in-out forwards';
          forgotPasswordForm.style.animation = 'showForm 0.6s ease-in-out forwards';

          setTimeout(function() {
            loginForm.style.display = 'none';
            forgotPasswordForm.style.display = 'block';
          }, 400);
        };

        /* check if pass and repeat pass are same */
        registerRePassword.oninput = function(e) {
          if (registerRePassword.value === registerPassword.value) {
            registerRePassword.classList.remove('form-input-false');
            registerRePassword.classList.add('form-input-true');
          } else {
            registerRePassword.classList.add('form-input-false');
          }
        };



        //check for service worker and implement it
        if ('serviceWorker' in navigator) {
          // Set up a listener for messages posted from the service worker.
          // The service worker is set to post a message to all its clients once it's run its activation
          // handler and taken control of the page, so you should see this message event fire once.
          // You can force it to fire again by visiting this page in an Incognito window.
          navigator.serviceWorker.addEventListener('message', function(event) {
            alert('lLLLLLLLLLLLLLL', event);
          });

          navigator.serviceWorker.register('serviceWorker.js')
            .then(navigator.serviceWorker.ready)
            .then(function(reg) {
              reg.pushManager.subscribe({
                  userVisibleOnly: true
                })
                .then(function(sub) {
                  if (sub.endpoint) {
                    sessionStorage.GCMReg = sub.endpoint.slice(40);
                  }
                });
              // if (reg.active) {
              //   reg.addEventListener('message', function(event) {
              //     alert('lLLLLLLLLLLLLLL', event);
              //   });
              // }
            }).catch(function(err) {
              console.log(err);
            })
        }
      }]);
  }
  ());
