(function() {
  "use strict";

  angular
    .module('nHome')
    .controller('SettingsAccountCtrl', ['dataRequest', 'socket', '$rootScope', '$scope', function(dataRequest, socket, $rootScope, $scope) {

      var acc = this;

      /* get user data */
      socket.emit('getUserProfile', null, function(userProfile) {
        console.log(userProfile);
        acc.userProfile = userProfile;
        document.querySelector('.settings-user-avatar').style.backgroundImage = 'url(' + userProfile.avatar + ')';
      });
      /* offline notifications */
      socket.emit('getOfflineNotifications', null, function(data) {
        acc.offlineNotifications = data;
      });
      /* alarm notifications */
      socket.emit('getAlarmConfig', null, function(alarm) {
        acc.alarmNotification = alarm.method;
        if (alarm.recipients) {
          angular.forEach(alarm.recipients, function(recipient) {
            if (recipient === acc.userProfile.email) {
              acc.alarmNotifications = true;
            }
          });
        }
      });
      // toggle notifications when server goes offline
      acc.toggleOfflineNotifications = function() {
        if (acc.offlineNotifications) {
          socket.emit('enableOfflineNotifications');
        } else {
          socket.emit('disableOfflineNotifications');
        }
      };
      // toggle alarm notifications
      acc.toggleAlarmNotifications = function() {
        if (acc.alarmNotifications) {
          socket.emit('addAlarmRecipient', acc.userProfile.email)
        } else {
          socket.emit('removeAlarmRecipient', acc.userProfile.email)
        }
      };
      // toggle between gcm or email notifications
      acc.notificationsType = function(type) {
        if (type === 'gcm') {
          socket.emit('setAlarmMethod', 'gcm', function(response) {
            console.log(response);
          });
        } else if (type === 'email') {
          socket.emit('setAlarmMethod', 'email', function(response) {
            console.log(response);
          });
        }
      };
      // upload custom avatar
      $scope.uploadUserAvatar = function(avatar) {
        if (avatar[0].size > 2097152) {
          return false
        }
        var fd = new FormData();
        fd.append('avatar', avatar[0]);
        dataRequest.uploadAvatar(fd)
          .then(function(response) {
            if (response.data.success) {
              $rootScope.$broadcast('newAvatar', response.data.avatar);
              document.querySelector('.settings-user-avatar').style.backgroundImage = 'url(' + response.data.avatar + ')';
            }
          });
      };
      // update user profile
      acc.saveUserProfile = function() {
        var oldPass = document.getElementById('settings-old-pass');
        var newPass = document.getElementById('settings-new-pass');

        if (oldPass.value && newPass.value && oldPass.value !== newPass.value) {
          socket.emit3('setUserPassword', oldPass.value, newPass.value, function(data) {
            if (data) {
              oldPass.value = '';
              newPass.value = '';
            }
          });
        }
        socket.emit('setUserProfile', acc.userProfile, function(newProfile) {
          if (newProfile) {
            $rootScope.$broadcast('newUserProfile', acc.userProfile);
          }
        });
      };
    }]);
}());
