(function ( $ ) {
 
    $.fn.jsonTable = function( options ) {
        var settings = $.extend({
            head: [],
            json:[],
            id: ""
        }, options );
        this.data("settings",settings);
        $(this.selector + ' thead').empty();
        var thead = $(this.selector + ' thead').append("<tr></tr>\n");
        for(var i = 0; i < settings.head.length; i++){
             $(this.selector + ' thead tr').append("<th class='ui-bar-d' style='text-align:center;' >"+settings.head[i]+"</th>\n")
        }
        return this;
    };

    $.fn.jsonTableUpdate = function( options ){
        var opt = $.extend({
            source: undefined,
            rowClass: undefined,
            callback: undefined
        }, options );
        var settings = this.data("settings");
        var sel = this.selector;
        $(this.selector + ' tbody > tr').remove();
        if(typeof opt.source == "string")
        {
            $.get(opt.source, function(data) {
                $.fn.updateFromObj(data,settings,sel, opt.rowClass, opt.callback);
            });
        }
        else if(typeof opt.source == "object")
        {
            $.fn.updateFromObj(opt.source,settings,sel, opt.rowClass, opt.callback);
        }
    }

    $.fn.updateFromObj = function(obj,settings,selector, rowClass, callback){
        $.each(obj, function(arrIndex,obj) {
            var dataRow = this;
            var tableRow = $("<tr></tr>").addClass(rowClass).attr({ "data-value": dataRow[settings.id] });
            
            $.each(settings.json, function() {
                if(this == '*') {
                    tableRow.append($("<td style='text-align:center;'>"+(arrIndex+1)+"</td>"));
                }
                else {
                    tableRow.append($("<td style='text-align:center;'>" + dataRow[this] + "</td>"));
                }
            });
            $(selector + '> tbody:last').append(tableRow);
        });
        
        
        if (typeof callback === "function") {
            callback();
        }
        
        $(window).trigger('resize'); // trigger the resize event to reposition dialog once all the data is loaded
    }
 
}( jQuery ));


function loadTable(timi, sourcePart){
$(timi).jsonTable({
   // head : ['Bus Stop'], // Goes on the <thead>
    json : ['stop'] //json identities from the loaded json object
});

$.get("data.json",
   function(data) {
    var options = {
   source : data[sourcePart] ,
   callback : function() {}
}
$(timi).jsonTableUpdate(options);
}, "json");
}

function loadTable2(timi, sourcePart){
$(timi).jsonTable({
    head : ['Mon-Fri','Saturday','Sunday'], // Goes on the <thead>
    json : ['Monday','Saturday','Sunday'] //json identities from the loaded json object
});

$.get("timetable.json",
   function(data) {
    var options = {
   source : data[sourcePart] ,
   callback : function() {}
}
$(timi).jsonTableUpdate(options);
}, "json");
}
loadTable("#table100","bus100");
loadTable2("#bus100s","bus100");
loadTable2("#bus100f","bus100f");
loadTable("#table106","bus106");
loadTable2("#bus106s","bus106");
loadTable2("#bus106f","bus106f");
loadTable("#table107","bus107");
loadTable2("#bus107s","bus107");
loadTable2("#bus107f","bus107f");
loadTable("#table110","bus110");
loadTable2("#bus110s","bus110");
loadTable2("#bus110f","bus110f");
loadTable("#table112","bus112");
loadTable2("#bus112s","bus112");
loadTable2("#bus112f","bus112f");
loadTable("#table114","bus114");
loadTable2("#bus114s","bus114");
loadTable2("#bus114f","bus114f");
loadTable("#table115","bus115");
loadTable2("#bus115s","bus115");
loadTable2("#bus115f","bus115f");
loadTable("#table116","bus116");
loadTable2("#bus116s","bus116");
loadTable2("#bus116f","bus116f");
loadTable("#table119","bus119");
loadTable2("#bus110s","bus119");
loadTable2("#bus119f","bus119f");
loadTable("#table121","bus121");
loadTable2("#bus121s","bus121");
loadTable2("#bus121f","bus121f");
loadTable("#table123","bus123");
loadTable2("#bus123s","bus123");
loadTable2("#bus123f","bus123f");
loadTable("#table126","bus126");
loadTable2("#bus126s","bus126");
loadTable2("#bus126f","bus126f");
loadTable("#table127","bus127");
loadTable2("#bus127s","bus127");
loadTable2("#bus127f","bus127f");
loadTable("#table140","bus140");
loadTable2("#bus140s","bus140");
loadTable2("#bus140f","bus140f");
loadTable("#table148","bus148");
loadTable2("#bus148s","bus148");
loadTable2("#bus148f","bus148f");
loadTable("#table150","bus150");
loadTable2("#bus150s","bus150");
loadTable2("#bus150f","bus150f");
loadTable("#table157","bus157");
loadTable2("#bus157s","bus157");
loadTable2("#bus157f","bus157f");
loadTable("#table158","bus158");
loadTable2("#bus158s","bus158");
loadTable2("#bus158f","bus158f");
loadTable("#table160","bus160");
loadTable2("#bus160s","bus160");
loadTable2("#bus160f","bus160f");
loadTable("#table200","bus200");
loadTable2("#bus200s","bus200");
loadTable2("#bus200f","bus200f");
loadTable("#table211","bus211");
loadTable2("#bus211s","bus211");
loadTable2("#bus211f","bus211f");
loadTable("#table214","bus214");
loadTable2("#bus214s","bus214");
loadTable2("#bus214f","bus214f");
loadTable("#table215","bus215");
loadTable2("#bus215s","bus215");
loadTable2("#bus215f","bus215f");
loadTable("#table250","bus250");
loadTable2("#bus250s","bus250");
loadTable2("#bus250f","bus250f");
loadTable("#table259","bus259");
loadTable2("#bus259s","bus259");
loadTable2("#bus259f","bus259f");