var button = document.querySelectorAll('.pawn');
var lists = document.getElementsByTagName('ul');
var resetBtn = document.getElementById('reset');
var playerMarker = document.getElementsByClassName('player-marker');

for (var i = 0; i < button.length; i++) {
	addAttr(i);
}

//Disable buttons
function addAttr(i) {
	button[i].addEventListener('click', function() {
		this.setAttribute('disabled', 'true');
		this.setAttribute('class', 'pawn disabled');

		var parentId = this.parentNode.getAttribute('class');
		var listId = parentId.substring(0, 4);		
		disableRows(listId, lists);
		lost('Thou hadst been defeated!');

	}, false);
}

//Check if element has a class
function hasClass(elem, klass) {
	return (" " + elem.className + " ").indexOf(" " + klass + " ") > -1;
}

//Swap active player marker
function swapWrapperBg() {	
	for(var i=0;i<playerMarker.length; i++){
		var isActive = hasClass(playerMarker[i], 'is-active');
	if (isActive) {
		playerMarker[i].classList.remove('is-active');
	} else {
		playerMarker[i].classList.add('is-active');
	}	
	}
};

//Disable rows while selecting
function disableRows(listId, lists) {
	for (var j = 0; j < lists.length; j++) {
		if (lists[j].getAttribute('id') !== listId) {
			lists[j].setAttribute('class', 'visually-hidden');
		}
	}
};

//Change turn
var turnBtn = document.getElementById("done");
turnBtn.addEventListener('click', function() {
	swapWrapperBg();
	makeVisible(lists);
});

//Make elements visible
function makeVisible(elem) {
	for (var k = 0; k < elem.length; k++) {
		elem[k].removeAttribute('class');
	}
};

//Reset game
function reset() {
	button = document.querySelectorAll('.pawn');			
	for (var l = 0; l < button.length; l++) {		
		button[l].removeAttribute('disabled');
		button[l].classList.remove('disabled');
	}
	makeVisible(lists);
};
resetBtn.addEventListener('click', reset);


//Check if all buttosn are disabled and show the message
function lost(lostMessage) {
	var disabledBtns = document.querySelectorAll('li >.disabled').length;
	var btns = document.querySelectorAll('#wrapper li').length;		 

	btns === disabledBtns ? alert(lostMessage) : false;
	btns === disabledBtns ? playAgain() : false;

}

function playAgain() {
	var startAnew = confirm('Start again?');
	if(startAnew) { reset();}
}

//Toggle rules
var closeBtn = document.querySelectorAll('.js-close')[0];
var rulesBtn = document.getElementById('rules');


rulesBtn.addEventListener('click',function(){
	toggleClass('.flyout','is-visible');
},false);

closeBtn.addEventListener('click',function(){
	toggleClass('.flyout','is-visible');
},false);


//Toggle function
function toggleClass(element,targetClass){
	var target = document.querySelectorAll(element)[0];
	if(target.classList.contains(targetClass)){
		target.classList.remove(targetClass);
	} else {
		target.classList.add(targetClass);
	}
}


//TODODb data set
		/*var nimFirebase = new Firebase("");	
			
		nimFirebase.child('winner').on('value',function(snapshot) {			
			alert(snapshot.val());
			var winnerList = document.querySelectorAll('.winner-list')[0];
			
		});
		*/
	

