/**
 * Strong Cocoa: Application
 * 
 * @version 1.0.0.0
 * @copyright Copyright (C) 2013 TagDam. All rights reserved.
 */
(function(window, undefined) {
	
	/**
	 * Page Query
	 * 
	 * @var {jQuery}
	 */
	var __pageQuery = jQuery;
	
	/**
	 * Page Query
	 * 
	 * @returns {jQuery}
	 */
	var pageQuery = function() {
		return (0 == arguments.length) ? __pageQuery : __pageQuery.apply(this, arguments);
	};
	
	/**
	 * Strong Cocoa: App: Abstract
	 * 
	 * @constructor
	 * @augments {StrongCocoa_App_Abstract}
	 * @extends {StrongCocoa_Abstract}
	 */
	var StrongCocoa_App_Abstract = function() {};
	StrongCocoa_App_Abstract.prototype = new strongCocoa.classes.StrongCocoa_Abstract();
	strongCocoa.classes.StrongCocoa_Classes.prototype.StrongCocoa_App_Abstract = StrongCocoa_App_Abstract;
	
	/**
	 * Strong Cocoa: App: Model: Abstract
	 * 
	 * @constructor
	 * @augments {StrongCocoa_App_Model_Abstract}
	 * @extends {StrongCocoa_App_Abstract}
	 */
	var StrongCocoa_App_Model_Abstract = function() {};
	StrongCocoa_App_Model_Abstract.prototype = new StrongCocoa_App_Abstract();
	strongCocoa.classes.StrongCocoa_Classes.prototype.StrongCocoa_App_Model_Abstract = StrongCocoa_App_Model_Abstract;
	
	/**
	 * Strong Cocoa: App: View: Abstract
	 * 
	 * @constructor
	 * @augments {StrongCocoa_App_View_Abstract}
	 * @extends {StrongCocoa_App_Abstract}
	 */
	var StrongCocoa_App_View_Abstract = function() {};
	StrongCocoa_App_View_Abstract.prototype = new StrongCocoa_App_Abstract();
	strongCocoa.classes.StrongCocoa_Classes.prototype.StrongCocoa_App_View_Abstract = StrongCocoa_App_View_Abstract;
	
	/**
	 * Strong Cocoa: App: Controller: Abstract
	 * 
	 * @constructor
	 * @augments {StrongCocoa_App_Controller_Abstract}
	 * @extends {StrongCocoa_App_Abstract}
	 */
	var StrongCocoa_App_Controller_Abstract = function() {};
	StrongCocoa_App_Controller_Abstract.prototype = new StrongCocoa_App_Abstract();
	strongCocoa.classes.StrongCocoa_Classes.prototype.StrongCocoa_App_Controller_Abstract = StrongCocoa_App_Controller_Abstract;
	
	/**
	 * Strong Cocoa: App: Controller: Page Handler
	 * 
	 * @constructor
	 * @augments {StrongCocoa_App_Controller_PageHandler}
	 * @extends {StrongCocoa_App_Controller_Abstract}
	 */
	var StrongCocoa_App_Controller_PageHandler = function() {};
	StrongCocoa_App_Controller_PageHandler.prototype = new StrongCocoa_App_Controller_Abstract();
	strongCocoa.classes.StrongCocoa_Classes.prototype.StrongCocoa_App_Controller_PageHandler = StrongCocoa_App_Controller_PageHandler;
	
	/**
	 * Strong Cocoa: App: Common: Abstract
	 * 
	 * @extends {StrongCocoa_App_Abstract}
	 */
	var StrongCocoa_App_Common_Abstract = function() {};
	StrongCocoa_App_Common_Abstract.prototype = new StrongCocoa_App_Abstract();
	strongCocoa.classes.StrongCocoa_Classes.prototype.StrongCocoa_App_Common_Abstract = StrongCocoa_App_Common_Abstract;
	
	/**
	 * Strong Cocoa: Storage Abstract
	 * 
	 * @constructor
	 * @augments StrongCocoa_App_Abstract
	 * @extends {StrongCocoa_App_Common_Abstract}
	 */
	var StrongCocoa_App_Common_Storage_Abstract = function() {};
	StrongCocoa_App_Common_Storage_Abstract.prototype = new StrongCocoa_App_Common_Abstract();
	strongCocoa.classes.StrongCocoa_Classes.prototype.StrongCocoa_App_Common_Storage_Abstract = StrongCocoa_App_Common_Storage_Abstract;
	
	/**
	 * Strong Cocoa: Storage: Local Storage
	 * 
	 * @constructor
	 * @augments {StrongCocoa_App_Common_Storage_Abstract}
	 */
	var StrongCocoa_App_Common_Storage_LocalStorage = function() {};
	StrongCocoa_App_Common_Storage_LocalStorage.prototype = new StrongCocoa_App_Common_Storage_Abstract();
	strongCocoa.classes.StrongCocoa_Classes.prototype.StrongCocoa_App_Common_Storage_LocalStorage = StrongCocoa_App_Common_Storage_LocalStorage;
	
	/**
	 * Local Storage
	 * 
	 * @var {StrongCocoa_App_Common_Storage_LocalStorage}
	 */
	var _localStorage = new StrongCocoa_App_Common_Storage_LocalStorage();
	
	/**
	 * Strong Cocoa: Language
	 * 
	 * @extends {StrongCocoa_App_Common_Abstract}
	 */
	var StrongCocoa_App_Common_Language = function() {};
	StrongCocoa_App_Common_Language.prototype = new StrongCocoa_App_Common_Abstract();
	strongCocoa.classes.StrongCocoa_Classes.prototype.StrongCocoa_App_Common_Language = StrongCocoa_App_Common_Language;
	
	/**
	 * Strong Cocoa: App: Common: Translate
	 * 
	 * @extends {StrongCocoa_App_Common_Abstract}
	 */
	var StrongCocoa_App_Common_Translate = function() {};
	StrongCocoa_App_Common_Translate.prototype = new StrongCocoa_App_Common_Abstract();
	strongCocoa.classes.StrongCocoa_Classes.prototype.StrongCocoa_App_Common_Translate = StrongCocoa_App_Common_Translate;
	
	/**
	 * Valid PhoneGap
	 * 
	 * var {Boolean}
	 */
	StrongCocoa_App_Abstract.prototype.validPhoneGap = false;
	
	/**
	 * Translate
	 * 
	 * @var {StrongCocoa_App_Common_Translate}
	 */
	StrongCocoa_App_Abstract.prototype.translate = new StrongCocoa_App_Common_Translate();
	
	/**
	 * Language
	 * 
	 * @var {StrongCocoa_App_Common_Language}
	 */
	StrongCocoa_App_Abstract.prototype.language = new StrongCocoa_App_Common_Language();
	
	/**
	 * StrongCocoa Cordova
	 * 
	 * @var {StrongCocoa_Cordova}
	 */
	StrongCocoa_App_Model_Abstract.prototype._cordova = null;
	
	/**
	 * StrongCocoa Cordova
	 * 
	 * @returns {StrongCocoa_Cordova}
	 */
	StrongCocoa_App_Model_Abstract.prototype.cordova = function() {
		return this.utility.notEmpty(this._cordova) ? this._cordova : (this._cordova = new this.classes.StrongCocoa_Cordova());
	};
	
	/**
	 * Update the Device Language
	 * 
	 * @returns void
	 */
	StrongCocoa_App_Model_Abstract.prototype.updateDeviceLanguage = function() {
		if (this.cordova().globalization().available()) {
			var that = this;
			this.cordova().globalization().localeName(function(localeName) {
				that.language.deviceLanguage(localeName.value);
			});
		}
	};
	
	/**
	 * Local Storage
	 * 
	 * @var {StrongCocoa_App_Common_Storage_LocalStorage}
	 */
	StrongCocoa_App_Model_Abstract.prototype.localStorage = _localStorage;
	
	/**
	 * Page Query
	 * 
	 * @returns {jQuery}
	 */
	StrongCocoa_App_View_Abstract.prototype.pageQuery = pageQuery;
	
	/**
	 * Containers
	 * 
	 * @var {Object}
	 */
	StrongCocoa_App_View_Abstract.prototype._containers = null;
	
	/**
	 * Containers
	 * 
	 * @reutnrs {Object}
	 */
	StrongCocoa_App_View_Abstract.prototype.containers = function() {
		return this.utility.notEmpty(this._containers) ? this._containers : (this._containers = {});
	};
	
	/**
	 * Get the Container
	 * 
	 * @param {String} [selector]
	 * @returns {jQuery}
	 */
	StrongCocoa_App_View_Abstract.prototype._get = function(selector) {
		var container = this.containers()[selector];
		if (this.utility.isEmpty(container) || (0 == container.length)) {
			container = this.pageQuery(selector);
			this._containers[selector] = container;
		}
		return container;
	};
	
	/**
	 * Get the Container by ID
	 * 
	 * @param {String} [id]
	 * @return {jQuery}
	 */
	StrongCocoa_App_View_Abstract.prototype.getById = function(id) {
		return this._get('#' + id);
	};
	
	/**
	 * Translate of Page
	 * 
	 * @param {jQuery|String} [target] Selector is string or jQuery Object.
	 * @param {String} [language]
	 * @returns void
	 */
	StrongCocoa_App_View_Abstract.prototype.translateOfPage = function(target, language) {
		var that = this;
		var pageLangAttrName = 'data-text-lang';
		var textIdAttrName = 'data-text-id';
		var i18nAttrName = 'data-i18n-attr';
		var translateForJQueryMobileUiSelectors = [
		                                           '.ui-btn-inner>.ui-btn-text',
		                                           '.ui-btn-inner>.ui-btn-text>span',
		                                           '.ui-title'
		                                           ];
		if (this.utility.isEmpty(language)) {
			language = this.language.val();
		}
		if (this.utility.isString(target)) {
			target = this._get(target);
		}
		if (0 < target.filter('[data-role="page"]').length) {
			target.attr(pageLangAttrName, language);
		}
		if ((this.utility.notEmpty(target.attr(textIdAttrName)))
				&& ('page' == target.attr('data-role')
				&& !this.utility.isUndefined(target.attr('data-title')))) {
			target.attr('data-title', this.translate._(target.attr(textIdAttrName), language));
		}
		target.find('[' + textIdAttrName + ']').each(function() {
			var container = that.pageQuery(this);
			var textId = container.attr(textIdAttrName);
			if (0 < container.find(translateForJQueryMobileUiSelectors.join(',')).length) {
				container = container.find(translateForJQueryMobileUiSelectors.join(',')).first();
			}
			container.text(that.translate._(textId, language));
			if (container.is('option')) {
				container.attr('label', that.translate._(textId, language));
			}
		});
		target.find('[' + i18nAttrName + ']').each(function() {
			var container = that.pageQuery(this);
			var values = container.attr(i18nAttrName).split(' ');
			console.log(values);
			for (var i = 0, ___len = values.length; i < (___len - 1); i++) {
				container.attr(values[i++], that.translate._(values[i], language));
			}
		});
		target.find('select[data-native-menu="false"]').each(function() {
			var select =that.pageQuery(this);
			try {
				switch (select.attr('data-role')) {
				case 'slider':
					select.slider('refresh');
					break;
				default:
					select.selectmenu('refresh');
				}
			} catch (e) {
			}
		});
		target.find('select[data-native-menu="false"][data-role="slider"].ui-slider-switch').each(function() {
			var select = that.pageQuery(this);
			var options = select.children();
			if (2 == options.length) {
				var sliders = select.next().filter('.ui-slider.ui-slider-switch.ui-slider-track.ui-shadow-inset.ui-bar-inherit.ui-corner-all[role="application"]').find('.ui-slider-label');
				if (2 == sliders.length) {
					sliders.eq(1).text(options.eq(0).text());
					sliders.eq(0).text(options.eq(1).text());
				}
			}
		});
	};
	
	/**
	 * Translate of Page by Page ID
	 * 
	 * @param {String} [pageId]
	 * @param {String} [language]
	 * @returns void
	 */
	StrongCocoa_App_View_Abstract.prototype.translateOfPageByPageId = function(pageId, language) {
		this.translateOfPage(('#' + pageId), language);
	};
	
	/**
	 * Page Query
	 * 
	 * @ver {jQuery}
	 */
	StrongCocoa_App_Controller_Abstract.prototype.pageQuery = pageQuery;
	
	/**
	 * Page Handler
	 * 
	 * @ver {StrongCocoa_App_Controller_PageHandler}
	 */
	StrongCocoa_App_Controller_Abstract.prototype._pageHandler = null;
	
	/**
	 * Page Handler
	 * 
	 * @returns {StrongCocoa_App_Controller_PageHandler}
	 */
	StrongCocoa_App_Controller_Abstract.prototype.pageHandler = function() {
		return this.utility.notEmpty(this._pageHandler) ? this._pageHandler : (this._pageHandler = new StrongCocoa_App_Controller_PageHandler())
	};
	
	/**
	 * Active Page
	 * 
	 * @returns {jQuery}
	 */
	StrongCocoa_App_Controller_Abstract.prototype.activePage = function() {
		return this.pageQuery().mobile.activePage;
//		return this.pageQuery().mobile.pagecontainer('getActivePage');
	};
	
	/**
	 * Active Page ID
	 * 
	 * @returns {String}
	 */
	StrongCocoa_App_Controller_Abstract.prototype.activePageId = function() {
		return this.activePage().attr('id');
	};
	
	/**
	 * Change Page
	 * 
	 * @param {String} [pageId] Page ID
	 * @returns void
	 */
	StrongCocoa_App_Controller_Abstract.prototype.changePage = function(pageId) {
		this.pageQuery().mobile.changePage('#' + pageId);
	};
	
	/**
	 * Handlers
	 * 
	 * @var {Object}
	 */
	StrongCocoa_App_Controller_PageHandler.prototype._handlers = {};
	
	/**
	 * Page Handlers
	 * 
	 * @returns {Object}
	 */
	StrongCocoa_App_Controller_PageHandler.prototype.get = function() {
		return this._handlers;  // TODO
//		return this.utility.notEmpty(this._handlers) ? this._handlers : (this._handlers = {});
	};
	
	/**
	 * Set the Page Handler
	 * 
	 * @param {String} [pageId] Page ID
	 * @param {String} [event]
	 * @param {Function} [handler]
	 * @returns void
	 */
	StrongCocoa_App_Controller_PageHandler.prototype.set = function(pageId, event, handler) {
		var pageHandlers = this.get();
		if (!this.utility.isObject(pageHandlers[event])) {
			pageHandlers[event] = {};
		}
		pageHandlers[event][pageId] = handler;
		this.standbyPageHandler();
	};
	
	/**
	 * Set the Handler of Page Before Change
	 * 
	 * @param {String} [pageId] Page ID
	 * @param {Function} [handler]
	 */
	StrongCocoa_App_Controller_PageHandler.prototype.setPageBeforeChangeHandler = function(pageId, handler) {
		this.set(pageId, 'pagebeforechange', handler);
	};
	
	/**
	 * Set the Handler of Page Before Create
	 * 
	 * @param {String} [pageId] Page ID
	 * @param {Function} [handler]
	 */
	StrongCocoa_App_Controller_PageHandler.prototype.setPageBeforeCreateHandler = function(pageId, handler) {
		this.set(pageId, 'pagebeforecreate', handler);
	};
	
	/**
	 * Set the Handler of Page Create
	 * 
	 * @param {String} [pageId] Page ID
	 * @param {Function} [handler]
	 */
	StrongCocoa_App_Controller_PageHandler.prototype.setPageCreateHandler = function(pageId, handler) {
		this.set(pageId, 'pagecreate', handler);
	};
	
	/**
	 * Set the Handler of Page Init
	 * 
	 * @param {String} [pageId] Page ID
	 * @param {Function} [handler]
	 */
	StrongCocoa_App_Controller_PageHandler.prototype.setPageInitHandler = function(pageId, handler) {
		this.set(pageId, 'pageinit', handler);
	};
	
	/**
	 * Set the Handler of Page Before Show
	 * 
	 * @param {String} [pageId] Page ID
	 * @param {Function} [handler]
	 */
	StrongCocoa_App_Controller_PageHandler.prototype.setPageBeforeShowHandler = function(pageId, handler) {
		this.set(pageId, 'pagebeforeshow', handler);
	};
	
	/**
	 * Set the Handler of Page Show
	 * 
	 * @param {String} [pageId] Page ID
	 * @param {Function} [handler]
	 */
	StrongCocoa_App_Controller_PageHandler.prototype.setPageShowHandler = function(pageId, handler) {
		this.set(pageId, 'pageshow', handler);
	};
	
	/**
	 * Set the Handler of Page Before Hide
	 * 
	 * @param {String} [pageId] Page ID
	 * @param {Function} [handler]
	 */
	StrongCocoa_App_Controller_PageHandler.prototype.setPageBeforeHideHandler = function(pageId, handler) {
		this.set(pageId, 'pagebeforehide', handler);
	};
	
	/**
	 * Set the Handler of Page Hide
	 * 
	 * @param {String} [pageId] Page ID
	 * @param {Function} [handler]
	 */
	StrongCocoa_App_Controller_PageHandler.prototype.setPageHideHandler = function(pageId, handler) {
		this.set(pageId, 'pagehide', handler);
	};
	
	/**
	 * Set the Handler of Page Change
	 * 
	 * @param {String} [pageId] Page ID
	 * @param {Function} [handler]
	 */
	StrongCocoa_App_Controller_PageHandler.prototype.setPageChangeHandler = function(pageId, handler) {
		this.set(pageId, 'pagechange', handler);
	};
	
	/**
	 * Set the Handler of Popup Before Position
	 * 
	 * @param {String} [pageId] Page ID
	 * @param {Function} [handler]
	 */
	StrongCocoa_App_Controller_PageHandler.prototype.setPopupBeforePositionHandler = function(pageId, handler) {
		this.set(pageId, 'popupbeforeposition', handler);
	};
	
	/**
	 * Set the Handler of Popup After Open
	 * 
	 * @param {String} [pageId] Page ID
	 * @param {Function} [handler]
	 */
	StrongCocoa_App_Controller_PageHandler.prototype.setPopupAfterOpenHandler = function(pageId, handler) {
		this.set(pageId, 'popupafteropen', handler);
	};
	
	/**
	 * Set the Handler of Popup After Close
	 * 
	 * @param {String} [pageId] Page ID
	 * @param {Function} [handler]
	 */
	StrongCocoa_App_Controller_PageHandler.prototype.setPopupAfterCloseHandler = function(pageId, handler) {
		this.set(pageId, 'popupafterclose', handler);
	};
	
	/**
	 * Standbyed the Page Handlers
	 * 
	 * @var {Array}
	 */
	StrongCocoa_App_Controller_PageHandler.prototype._standbyedPageHandlers = [];
	
	/**
	 * Standby the Page Handler
	 * 
	 * @returns void
	 */
	StrongCocoa_App_Controller_PageHandler.prototype.standbyPageHandler = function() {
		var pageHandlers = this.get();
		for (var eventType in pageHandlers) {
			if (0 <= this.utility.inArray(eventType, this._standbyedPageHandlers)) {
				continue;
			}
			var that = this;
			this._standbyedPageHandlers[this._standbyedPageHandlers.length] = eventType;
			this.pageQuery(document).on(eventType, function(event, data) {
				var pageHandler = pageHandlers[event.type][jQuery(event.target).attr('id')];
				if (that.utility.isFunction(pageHandler)) {
					pageHandler();
				}
			});
		}
	};
	
	/**
	 * Local Storage
	 * 
	 * @var {Any}
	 */
	StrongCocoa_App_Common_Abstract.prototype.localStorage = _localStorage;
	
	/**
	 * Storage
	 * 
	 * @var {Any}
	 */
	StrongCocoa_App_Common_Storage_LocalStorage.prototype._storage = localStorage;
	
	/**
	 * Save
	 * 
	 * @param {String} key
	 * @param {Any} value
	 * @returns void
	 */
	StrongCocoa_App_Common_Storage_LocalStorage.prototype.save = function(key, value) {
		this._storage.setItem(key, JSON.stringify(value));
	};
	
	/**
	 * Get
	 * 
	 * @param {String} key
	 * @returns void
	 */
	StrongCocoa_App_Common_Storage_LocalStorage.prototype.get = function(key) {
		return JSON.parse(this._storage.getItem(key));
	};
	
	/**
	 * Remove
	 * 
	 * @param {String} key
	 * @returns void
	 */
	StrongCocoa_App_Common_Storage_LocalStorage.prototype.remove = function(key) {
		return this._storage.removeItem(key);
	};
	
	/**
	 * Clear
	 * 
	 * @returns void
	 */
	StrongCocoa_App_Common_Storage_LocalStorage.prototype.clear = function() {
		return this._storage.clear();
	};
	
	/**
	 * Initialized
	 * 
	 * @var {Boolean}
	 */
	StrongCocoa_App_Common_Language.prototype._initialized = false;
	
	/**
	 * Default Language
	 * 
	 * @var {String}
	 */
	StrongCocoa_App_Common_Language.prototype._defaultLanguage = 'en-US';
	
	/**
	 * Default Language
	 * 
	 * @param {String} [defaultLanguage] (Option)
	 * @returns {String}
	 */
	StrongCocoa_App_Common_Language.prototype.defaultLanguage = function(defaultLanguage) {
		if (this.utility.notEmpty(defaultLanguage)) {
			return (this._defaultLanguage = defaultLanguage);
		}
		return this._defaultLanguage;
	};
	
	/**
	 * Device Language
	 * 
	 * @var {String}
	 */
	StrongCocoa_App_Common_Language.prototype._deviceLanguage = null;
	
	/**
	 * Device Language
	 * 
	 * @param {String} [deviceLanguage] Device Language
	 * @returns {String}
	 */
	StrongCocoa_App_Common_Language.prototype.deviceLanguage = function(deviceLanguage) {
		if (this.utility.notEmpty(deviceLanguage)) {
			return (this._deviceLanguage = deviceLanguage);
		} else if (this.utility.isEmpty(this._deviceLanguage)) {
			return this.defaultLanguage();
		}
		return this._deviceLanguage;
	};
	
	/**
	 * Language
	 * 
	 * @var {String}
	 */
	StrongCocoa_App_Common_Language.prototype._language = null;
	
	/**
	 * Get or Set the Language
	 * 
	 * @param {String} [language] (Option)
	 * @returns {String}
	 */
	StrongCocoa_App_Common_Language.prototype.val = function(language) {
		if (this.utility.notEmpty(language)) {
			this._initialized = true;
			this._language = language;
			this.localStorage.save(this.key(), language);
		} else if (!this._initialized){
			this._initialized = true;
			language = this.localStorage.get(this.key());
			if (this.utility.isEmpty(language)) {
				language = this.deviceLanguage();
			}
			this._language = language;
		} else {
			language = this._language;
		}
		return language;
	};
	
	/**
	 * Key
	 * 
	 * @var {String}
	 */
	StrongCocoa_App_Common_Language.prototype._key = 'StrongCocoa_App_Common_Language';
	
	/**
	 * Key
	 * 
	 * @param {String} [key] (Option)
	 * @returns {String}
	 */
	StrongCocoa_App_Common_Language.prototype.key = function(key) {
		if (this.utility.notEmpty(key)) {
			return (this._key = key);
		}
		return this._key;
	};
	
	/**
	 * Translate
	 * 
	 * @param {String} [id]
	 * @param {String} language (Option)
	 * @returns {String}
	 */
	StrongCocoa_App_Common_Translate.prototype.translate = StrongCocoa_App_Common_Translate.prototype._ = function(id, language) {
		return strongCocoa.translate._(id, this.language.val(language));
	};
	
//	strongCocoa.utility.setGlobalVariable(StrongCocoa_App_Abstract, 'StrongCocoa_App_Abstract');
//	strongCocoa.utility.setGlobalVariable(StrongCocoa_App_Model_Abstract, 'StrongCocoa_App_Model_Abstract');
//	strongCocoa.utility.setGlobalVariable(StrongCocoa_App_View_Abstract, 'StrongCocoa_App_View_Abstract');
//	strongCocoa.utility.setGlobalVariable(StrongCocoa_App_Controller_Abstract, 'StrongCocoa_App_Controller_Abstract');
//	strongCocoa.utility.setGlobalVariable(StrongCocoa_App_Common_Abstract, 'StrongCocoa_App_Common_Abstract');
})(this);
