/**
 * Strong Cocoa: Cordova
 * 
 * @version 1.0.0.0
 * @copyright Copyright (C) 2013 TagDam. All rights reserved.
 */
(function(window, undefined) {
	
	/**
	 * Strong Cocoa: Cordova: Abstract
	 * 
	 * @constructor
	 * @extends {StrongCocoa_Abstract}
	 */
	var StrongCocoa_Cordova_Abstract = function() {};
	StrongCocoa_Cordova_Abstract.prototype = new strongCocoa.classes.StrongCocoa_Abstract();
	strongCocoa.classes.StrongCocoa_Classes.prototype.StrongCocoa_Cordova_Abstract = StrongCocoa_Cordova_Abstract;
	
	/**
	 * Strong Cocoa: Cordova
	 * 
	 * @constructor
	 * @extends {StrongCocoa_Cordova_Abstract}
	 */
	var StrongCocoa_Cordova = function() {};
	StrongCocoa_Cordova.prototype = new StrongCocoa_Cordova_Abstract();
	strongCocoa.classes.StrongCocoa_Classes.prototype.StrongCocoa_Cordova = StrongCocoa_Cordova;
	
	/**
	 * Strong Cocoa: Cordova: Globalization
	 * 
	 * @constructor
	 * @extends {StrongCocoa_Cordova_Abstract}
	 */
	var StrongCocoa_Cordova_Globalization = function() {};
	StrongCocoa_Cordova_Globalization.prototype = new StrongCocoa_Cordova_Abstract();
	strongCocoa.classes.StrongCocoa_Classes.prototype.StrongCocoa_Cordova_Globalization = StrongCocoa_Cordova_Globalization;
	
	/**
	 * Strong Cocoa: Cordova: Notification
	 * 
	 * @constructor
	 * @extends {StrongCocoa_Cordova_Abstract}
	 */
	var StrongCocoa_Cordova_Notification = function() {};
	StrongCocoa_Cordova_Notification.prototype = new StrongCocoa_Cordova_Abstract();
	strongCocoa.classes.StrongCocoa_Classes.prototype.StrongCocoa_Cordova_Notification = StrongCocoa_Cordova_Notification;
	
	/**
	 * Globalization
	 * 
	 * @var {StrongCocoa_Cordova_Globalization}
	 */
	StrongCocoa_Cordova_Abstract.prototype._globalization = null;
	
	/**
	 * Globalization
	 * 
	 * @returns {StrongCocoa_Cordova_Globalization}
	 */
	StrongCocoa_Cordova_Abstract.prototype.globalization = function() {
		return this.utility.notEmpty(this._globalization) ? this._globalization : (this._globalization = new StrongCocoa_Cordova_Globalization());
	};
	
	/**
	 * Notification
	 * 
	 * @var {StrongCocoa_Cordova_Notification}
	 */
	StrongCocoa_Cordova_Abstract.prototype._notification = null;
	
	/**
	 * Notification
	 * 
	 * @returns {StrongCocoa_Cordova_Notification}
	 */
	StrongCocoa_Cordova_Abstract.prototype.notification = function() {
		return this.utility.notEmpty(this._notification) ? this._notification : (this._notification = new StrongCocoa_Cordova_Notification());
	};
	
	/**
	 * Globalization
	 * 
	 * @var {Object}
	 */
	StrongCocoa_Cordova_Globalization.prototype._globalization = null;
	
	/**
	 * Globalization
	 * 
	 * @returns {Object}
	 */
	StrongCocoa_Cordova_Globalization.prototype.globalization = function() {
		return this.utility.notEmpty(this._globalization) ? this._globalization : (this._globalization = navigator.globalization);
	};
	
	/**
	 * Available
	 * 
	 * @returns {Boolean}
	 */
	StrongCocoa_Cordova_Globalization.prototype.available = function() {
		return this.utility.notEmpty(this.globalization());
	};
	
	/**
	 * Locale Name
	 * 
	 * @param {Function} [successCallback] Success Callback
	 * @param {Function} [errorCallback] Error Callback
	 * @returns void
	 */
	StrongCocoa_Cordova_Globalization.prototype.localeName = function(successCallback, errorCallback) {
		return this.globalization().getLocaleName(successCallback, errorCallback);
	};
	
	/**
	 * Notification
	 * 
	 * @var {Object}
	 */
	StrongCocoa_Cordova_Notification.prototype._notification = null;
	
	/**
	 * Notification
	 * 
	 * @returns {Object}
	 */
	StrongCocoa_Cordova_Notification.prototype.notification = function() {
		return this.utility.notEmpty(this._otification) ? this._notification : (this._notification = navigator.notification);
	};
	
	/**
	 * Available
	 * 
	 * @param {Boolean} [available]
	 * @param {Function} [api]
	 * @param {Function} [availableCallback]
	 * @param {Function} [invalidityCallback]
	 * @returns void
	 */
	StrongCocoa_Cordova_Notification.prototype._available = function(available, api, availableCallback, invalidityCallback) {
		if (available) {
			if (this.utility.isFunction(api)) {
				api();
			}
			if (this.utility.isFunction(availableCallback)) {
				availableCallback();
			}
		} else if (this.utility.isFunction(invalidityCallback)) {
			invalidityCallback();
		};;
	};
	
	/**
	 * Available Beep
	 * 
	 * @param {Function} [availableCallback]
	 * @param {Function} [invalidityCallback]
	 * @returns void
	 */
	StrongCocoa_Cordova_Notification.prototype.availableBeep = function(availableCallback, invalidityCallback) {
		this.beep(0, availableCallback, invalidityCallback);
	};
	
	/**
	 * Beep
	 * 
	 * @param {Number} [times]
	 * @param {Function} [availableCallback]
	 * @param {Function} [invalidityCallback]
	 * @returns void
	 */
	StrongCocoa_Cordova_Notification.prototype.beep = function(times, availableCallback, invalidityCallback) {
		var that = this;
		this._available(this.utility.notEmpty(this.notification()) && this.utility.isFunction(this.notification().beep), function() {
			if (0 <times) {
				that.notification().beep(times);
			}
		}, availableCallback, invalidityCallback);
	};
	
	/**
	 * Available Vibrate
	 * 
	 * @param {Function} [availableCallback]
	 * @param {Function} [invalidityCallback]
	 * @returns void
	 */
	StrongCocoa_Cordova_Notification.prototype.availableVibrate = function(availableCallback, invalidityCallback) {
		this.vibrate(null, availableCallback, invalidityCallback);
	};
	
	/**
	 * Vibrate
	 * 
	 * @param {Number|Array} [milliseconds] Milliseconds or milliseconds array.
	 * @param {Function} [availableCallback]
	 * @param {Function} [invalidityCallback]
	 * @returns void
	 */
	StrongCocoa_Cordova_Notification.prototype.vibrate = function(milliseconds, availableCallback, invalidityCallback) {
//		var that = this;
//		this._available(this.utility.notEmpty(this.notification()) && this.utility.isFunction(this.notification().vibrate), function() {
//			if (0 <milliseconds) {
//				that.notification().vibrate(milliseconds);
//			}
//		}, availableCallback, invalidityCallback);

		var that = this;
		this._available(this.utility.notEmpty(this.notification()) && this.utility.isFunction(this.notification().vibrate), function() {
			var pattern = [];
			if (that.utility.isNumeric(milliseconds)) {
				pattern[pattern.length] = milliseconds;
			} else if (that.utility.isArray(milliseconds)) {
				for (var i = 0, ___len = milliseconds.length; i < ___len; i++) {
					if (that.utility.isNumeric(milliseconds[i])) {
						pattern[pattern.length] = milliseconds[i];
					}
				}
			}
			if (0 < pattern.length) {
				var vibrate = function(pattern) {
//					that.notification().vibrate(pattern.shift());
					navigator.vibrate(pattern.shift());
					if (2 <= pattern.length) {
						window.setTimeout(function() {
							vibrate(pattern);
						}, pattern.shift());
					}
				};
				vibrate(pattern);
			}
		}, availableCallback, invalidityCallback);
	};
	
})(this);
