/**
 * Card Rock-Paper-Scissors: Main
 * 
 * @version 1.0.0.0
 * @copyright Copyright (C) 2013 TagDam.com. All rights reserved.
 */
;(function(window, undefined) {
	var config = {};
	
	var validCordova = true;
//	validCordova = false;
	
	var paths = {};
	var shim = {};
	var modules = [];
	
	/**
	 * Add the Module
	 * 
	 * @param {String} [name] Module Name
	 * @returns {Number} Module Index
	 */
	var addModule = function(name) {
		modules[modules.length] = name;
		return (modules.length - 1);
	};
	if (validCordova) {
		paths['cordova'] = '../cordova';
//		paths['adMobPlugin'] = '../common/js/AdMobPlugin';
		shim['cordova'] = {
				exports: 'cordova'
		};
		addModule('cordova');
//		addModule('adMobPlugin');
	}
	paths['globalize'] = '../common/js/globalize';
	paths['jQuery'] = '../common/js/jquery-2.1.1';
	paths['jQuery.mobile'] = '../common/js/jquery.mobile-1.4.5.min';
	paths['strongCocoa'] = '../common/js/strongcocoa';
	paths['strongCocoa.cordova'] = '../common/js/strongcocoa.cordova';
	paths['strongCocoa.app'] = '../common/js/strongcocoa.app';
	paths['globalize.common.culture.en-US'] = '../common/cultures/common.culture.en-US';
	paths['globalize.common.culture.es'] = '../common/cultures/common.culture.es';
	paths['globalize.common.culture.ja'] = '../common/cultures/common.culture.ja';
	paths['globalize.pelmanism-nine-ball.culture.en-US'] = '../cultures/pelmanism-nine-ball.culture.en-US';
	paths['globalize.pelmanism-nine-ball.culture.es'] = '../cultures/pelmanism-nine-ball.culture.es';
	paths['globalize.pelmanism-nine-ball.culture.ja'] = '../cultures/pelmanism-nine-ball.culture.ja';
	paths['strongCocoa.app.tagdam.pelmanism-nine-ball'] = 'pelmanism-nine-ball';
	shim['globalize'] = {
			exports: 'Globalize'
	};
	shim['jQuery'] = {
			exports: 'jQuery'
	};
	shim['jQuery.mobile'] = {
			deps: ['jQuery'],
			exports: 'jQueryMobile'
	};
	shim['strongCocoa'] = {
			exports: 'strongCocoa'
	};
	shim['strongCocoa.cordova'] = {
			deps: ['strongCocoa'],
			exports: 'strongCocoa'
	};
	shim['strongCocoa.app'] = {
			deps: ['jQuery', 'strongCocoa'],
			exports: 'strongCocoa'
	};
	shim['globalize.common.culture.en-US'] = {
			deps: ['globalize'],
			exports: 'Globalize'
	};
	shim['globalize.common.culture.es'] = {
			deps: ['globalize'],
			exports: 'Globalize'
	};
	shim['globalize.common.culture.ja'] = {
			deps: ['globalize'],
			exports: 'Globalize'
	};
	shim['globalize.pelmanism-nine-ball.culture.en-US'] = {
			deps: ['globalize'],
			exports: 'Globalize'
	};
	shim['globalize.pelmanism-nine-ball.culture.es'] = {
			deps: ['globalize'],
			exports: 'Globalize'
	};
	shim['globalize.pelmanism-nine-ball.culture.ja'] = {
			deps: ['globalize'],
			exports: 'Globalize'
	};
	shim['strongCocoa.app.tagdam.pelmanism-nine-ball'] = {
			deps: ['jQuery', 'strongCocoa'],
			exports: 'strongCocoa'
	};
	addModule('globalize');
	var jQueryModuleIndex = addModule('jQueryModule');
	addModule('strongCocoa');
	addModule('strongCocoa.cordova');
	addModule('strongCocoa.app');
	addModule('globalize.common.culture.en-US');
	addModule('globalize.common.culture.es');
	addModule('globalize.common.culture.ja');
	addModule('globalize.pelmanism-nine-ball.culture.en-US');
	addModule('globalize.pelmanism-nine-ball.culture.es');
	addModule('globalize.pelmanism-nine-ball.culture.ja');
	var appModuleIndex = addModule('strongCocoa.app.tagdam.pelmanism-nine-ball');
	
	config = {
			baseUrl: 'js',
			paths: paths,
			shim: shim
	};
	require.config(config);
	
	define('jQueryModule', ['jQuery'], function(jQuery) {
		return {
			main: jQuery
		};
	});
	define('jQueryMobileModule', ['jQuery.mobile'], function(jQueryMobile) {
		return {
			main: jQueryMobile
		};
	});
	define('main', modules, function() {
		return {
			jQuery: arguments[jQueryModuleIndex].main,
			controller: arguments[appModuleIndex].classes.TagDam_App_Controller_PelmanismNineBall
		};
	});
	require(['main'], function(main) {
		var readiedCordova = false;
		var readiedJQuery = false;
		var callback = function() {
			if (readiedCordova && readiedJQuery) {
				require(['jQueryMobileModule'], function(jQueryMobileModule) {
					var controller = new main.controller(validCordova);
					controller.start();
					main.jQuery.mobile.initializePage();
				});
			}
		};
		if (!validCordova) {
			readiedCordova = true;
			callback();
		} else {
			document.addEventListener('deviceready', function() {
//				if (validCordova) {
//					app.addBanner();
//				}
				readiedCordova = true;
				callback();
			}, false);
		}
		main.jQuery(document).on('mobileinit', function() {
			main.jQuery.mobile.autoInitializePage = false;
		});
		main.jQuery(function() {
			readiedJQuery = true;
			callback();
		});
	});
	return config;
})(this);









































///*
// * Licensed to the Apache Software Foundation (ASF) under one
// * or more contributor license agreements.  See the NOTICE file
// * distributed with this work for additional information
// * regarding copyright ownership.  The ASF licenses this file
// * to you under the Apache License, Version 2.0 (the
// * "License"); you may not use this file except in compliance
// * with the License.  You may obtain a copy of the License at
// *
// * http://www.apache.org/licenses/LICENSE-2.0
// *
// * Unless required by applicable law or agreed to in writing,
// * software distributed under the License is distributed on an
// * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
// * KIND, either express or implied.  See the License for the
// * specific language governing permissions and limitations
// * under the License.
// */
//var app = {
//    // Application Constructor
//    initialize: function() {
//        this.bindEvents();
//    },
//    // Bind Event Listeners
//    //
//    // Bind any events that are required on startup. Common events are:
//    // 'load', 'deviceready', 'offline', and 'online'.
//    bindEvents: function() {
//        document.addEventListener('deviceready', this.onDeviceReady, false);
//    },
//    // deviceready Event Handler
//    //
//    // The scope of 'this' is the event. In order to call the 'receivedEvent'
//    // function, we must explicity call 'app.receivedEvent(...);'
//    onDeviceReady: function() {
//        app.receivedEvent('deviceready');
//    },
//    // Update DOM on a Received Event
//    receivedEvent: function(id) {
//        app.addBanner();
//        
//        var parentElement = document.getElementById(id);
//        var listeningElement = parentElement.querySelector('.listening');
//        var receivedElement = parentElement.querySelector('.received');
//        
//        listeningElement.setAttribute('style', 'display:none;');
//        receivedElement.setAttribute('style', 'display:block;');
//        
//        console.log('Received Event: ' + id);
//    }, 
//    
//    addBanner: function() {
//        var successCreateBannerView = function() { console.log("addBanner Success"); admob.requestAd({'isTesting': true},success,error); };
//        var success = function() { console.log("requestAd Success"); };
//        var error = function(message) { console.log("Oopsie! " + message); };
//        
//        var options = {
//            'publisherId': 'ca-app-pub-4533801972518280/5233056539',
//            'adSize': admob.AD_SIZE.BANNER
//        }
//        admob.createBannerView(options,successCreateBannerView,error);
//    },
//    
//    addInterstitial: function() {
//        var successCreateBannerView = function() { console.log("addInterstitial Success"); admob.requestAd({'isTesting': true},success,error); };
//        var success = function() { console.log("requestAd Success"); };
//        var error = function(message) { console.log("Oopsie! " + message); };
//        
//        var options = {
//            'publisherId': 'ca-app-pub-4533801972518280/5233056539'
//        }
//        admob.createInterstitialView(options,successCreateBannerView,error);
//    },
//    
//    killAd: function() {
//        var success = function() { console.log("killAd Success"); };
//        var error = function(message) { console.log("Oopsie! " + message); };
//        admob.killAd(success,error);
//    }
//};
