/**
 * Card Rock-Paper-Scissors
 * 
 * @version 1.0.0.0
 * @copyright Copyright (C) 2013 TagDam. All rights reserved.
 */
;(function(window, undefined) {
	
	var utility = strongCocoa.utility;
	
	/**
	 * TagDam: App: Model: Pelmanism 9 Ball
	 */
	var TagDam_App_PelmanismNineBall = function() {};
	TagDam_App_PelmanismNineBall.prototype = new strongCocoa.classes.StrongCocoa_App_Abstract();
	
	/**
	 * TagDam: App: Model: Pelmanism 9 Ball: Abstract
	 * 
	 * @extends {StrongCocoa_App_Model_Abstract}
	 */
	var TagDam_App_Model_PelmanismNineBall_Abstract = function() {};
	TagDam_App_Model_PelmanismNineBall_Abstract.prototype = new strongCocoa.classes.StrongCocoa_App_Model_Abstract();
	
	/**
	 * TagDam: App: Model: Pelmanism 9 Ball
	 * 
	 * @extends {TagDam_App_Model_PelmanismNineBall_Abstract}
	 */
	var TagDam_App_Model_PelmanismNineBall = function() {};
	TagDam_App_Model_PelmanismNineBall.prototype = new TagDam_App_Model_PelmanismNineBall_Abstract();
	
	/**
	 * TagDam: App: Model: Pelmanism 9 Ball: Settings: Abstract
	 * 
	 * @extends {TagDam_App_Model_PelmanismNineBall_Abstract}
	 */
	var TagDam_App_Model_PelmanismNineBall_Settings_Abstract = function() {};
	TagDam_App_Model_PelmanismNineBall_Settings_Abstract.prototype = new TagDam_App_Model_PelmanismNineBall_Abstract();
	
	/**
	 * TagDam: App: Model: Pelmanism 9 Ball: Settings
	 * 
	 * @extends {TagDam_App_Model_PelmanismNineBall}
	 */
	var TagDam_App_Model_PelmanismNineBall_Settings = function() {};
	TagDam_App_Model_PelmanismNineBall_Settings.prototype = new TagDam_App_Model_PelmanismNineBall_Settings_Abstract();
	
	/**
	 * TagDam: App: Model: Pelmanism 9 Ball: Settings: Vibration
	 * 
	 * @extends {TagDam_App_Model_PelmanismNineBall_Abstract}
	 */
	var TagDam_App_Model_PelmanismNineBall_Settings_Vibration = function() {};
	TagDam_App_Model_PelmanismNineBall_Settings_Vibration.prototype = new TagDam_App_Model_PelmanismNineBall_Settings_Abstract();
	
	/**
	 * TagDam: App: Model: Pelmanism 9 Ball: Settings: Theme
	 * 
	 * @extends {TagDam_App_Model_PelmanismNineBall_Abstract}
	 */
	var TagDam_App_Model_PelmanismNineBall_Settings_Theme = function() {};
	TagDam_App_Model_PelmanismNineBall_Settings_Theme.prototype = new TagDam_App_Model_PelmanismNineBall_Settings_Abstract();
	
	/**
	 * TagDam: App: Model: Pelmanism 9 Ball: Game: Abstract
	 * 
	 * @extends {TagDam_App_Model_PelmanismNineBall_Abstract}
	 */
	var TagDam_App_Model_PelmanismNineBall_Game_Abstract = function() {};
	TagDam_App_Model_PelmanismNineBall_Game_Abstract.prototype = new TagDam_App_Model_PelmanismNineBall_Abstract();
	
	/**
	 * TagDam: App: Model: Pelmanism 9 Ball: Game: Manager
	 * 
	 * @extends {TagDam_App_Model_PelmanismNineBall_Game_Abstract}
	 */
	var TagDam_App_Model_PelmanismNineBall_Game_Manager = function() {};
	TagDam_App_Model_PelmanismNineBall_Game_Manager.prototype = new TagDam_App_Model_PelmanismNineBall_Game_Abstract();
	
	/**
	 * TagDam: App: Model: Pelmanism 9 Ball: Game: Cards
	 * 
	 * @extends {TagDam_App_Model_PelmanismNineBall_Game_Abstract}
	 */
	var TagDam_App_Model_PelmanismNineBall_Game_Cards = function() {};
	TagDam_App_Model_PelmanismNineBall_Game_Cards.prototype = new TagDam_App_Model_PelmanismNineBall_Game_Abstract();
	
	/**
	 * TagDam: App: Model: Pelmanism 9 Ball: Game: Targets
	 * 
	 * @extends {TagDam_App_Model_PelmanismNineBall_Game_Abstract}
	 */
	var TagDam_App_Model_PelmanismNineBall_Game_Targets = function() {};
	TagDam_App_Model_PelmanismNineBall_Game_Targets.prototype = new TagDam_App_Model_PelmanismNineBall_Game_Abstract();
	
	/**
	 * TagDam: App: Model: Pelmanism 9 Ball: Game: Players
	 * 
	 * @extends {TagDam_App_Model_PelmanismNineBall_Game_Abstract}
	 */
	var TagDam_App_Model_PelmanismNineBall_Game_Players = function() {};
	TagDam_App_Model_PelmanismNineBall_Game_Players.prototype = new TagDam_App_Model_PelmanismNineBall_Game_Abstract();
	
	/**
	 * TagDam: App: Model: Pelmanism 9 Ball: Game: Player: Abstract
	 * 
	 * @param {String} [type] "User" or "Computer".
	 * @param {String} [name]
	 * @property {String} [_type]
	 * @property {String} [_name]
	 * @extends {TagDam_App_Model_PelmanismNineBall_Game_Abstract}
	 */
	var TagDam_App_Model_PelmanismNineBall_Game_Player_Abstract = function(type, name) {
		if (utility.isObject(type)) {
			name = type.name;
			type = type.type;
		}
		this._type = type;
		this._name = name;
	};
	TagDam_App_Model_PelmanismNineBall_Game_Player_Abstract.prototype = new TagDam_App_Model_PelmanismNineBall_Game_Abstract();
	
	/**
	 * TagDam: App: Model: Pelmanism 9 Ball: Game: Player: User
	 * 
	 * @param {String} [name]
	 * @property {String} [_type]
	 * @property {String} [_name]
	 * @extends {TagDam_App_Model_PelmanismNineBall_Game_Player_Abstract}
	 */
	var TagDam_App_Model_PelmanismNineBall_Game_Player_User = function(name) {
		TagDam_App_Model_PelmanismNineBall_Game_Player_Abstract.call(this, 'User', name);
	};
	TagDam_App_Model_PelmanismNineBall_Game_Player_User.prototype = new TagDam_App_Model_PelmanismNineBall_Game_Player_Abstract();
	
	/**
	 * TagDam: App: Model: Pelmanism 9 Ball: Game: Player: Computer: Abstract
	 * 
	 * @param {String} [name] Name
	 * @param {Number} [forgettingRate] Forgetting Rate
	 * @property {String} [_type]
	 * @property {String} [_name]
	 * @property {Number} [_forgettingRate] Forgetting Rate
	 * @extends {TagDam_App_Model_PelmanismNineBall_Game_Player_Abstract}
	 */
	var TagDam_App_Model_PelmanismNineBall_Game_Player_Computer_Abstract = function(name, forgettingRate) {
		TagDam_App_Model_PelmanismNineBall_Game_Player_Abstract.call(this, 'Computer', name);
		this._forgettingRate = forgettingRate;
	};
	TagDam_App_Model_PelmanismNineBall_Game_Player_Computer_Abstract.prototype = new TagDam_App_Model_PelmanismNineBall_Game_Player_Abstract();
	
	/**
	 * TagDam: App: Model: Pelmanism 9 Ball: Game: Player: Computer
	 * 
	 * @param {String} [name] Name
	 * @param {Number} [forgettingRate] Forgetting Rate
	 * @property {String} [_type]
	 * @property {String} [_name]
	 * @property {Number} [_forgettingRate] Forgetting Rate
	 * @extends {TagDam_App_Model_PelmanismNineBall_Game_Player_Computer_Abstract}
	 */
	var TagDam_App_Model_PelmanismNineBall_Game_Player_Computer = function(name, forgettingRate) {
		TagDam_App_Model_PelmanismNineBall_Game_Player_Computer_Abstract.call(this, name, forgettingRate);
	};
	TagDam_App_Model_PelmanismNineBall_Game_Player_Computer.prototype = new TagDam_App_Model_PelmanismNineBall_Game_Player_Computer_Abstract();
	
	/**
	 * TagDam: App: Model: Pelmanism 9 Ball: Game: Memory
	 * 
	 * @param {String} [name]
	 * @extends {TagDam_App_Model_PelmanismNineBall_Game_Abstract}
	 */
	var TagDam_App_Model_PelmanismNineBall_Game_Memory = function() {};
	TagDam_App_Model_PelmanismNineBall_Game_Memory.prototype = new TagDam_App_Model_PelmanismNineBall_Game_Abstract();
	
	/**
	 * TagDam: App: View: Pelmanism 9 Ball: Abstract
	 * 
	 * @property {Object} [container]
	 * @extends {StrongCocoa_App_View_Abstract}
	 */
	var TagDam_App_View_PelmanismNineBall_Abstract = function() {};
	TagDam_App_View_PelmanismNineBall_Abstract.prototype = new strongCocoa.classes.StrongCocoa_App_View_Abstract();
	
	/**
	 * TagDam: App: View: Pelmanism 9 Ball
	 * 
	 * @property {Object} [container]
	 * @extends {TagDam_App_View_PelmanismNineBall_Abstract}
	 */
	var TagDam_App_View_PelmanismNineBall = function() {};
	TagDam_App_View_PelmanismNineBall.prototype = new TagDam_App_View_PelmanismNineBall_Abstract();
	
	/**
	 * TagDam: App: View: Pelmanism 9 Ball: Index
	 * 
	 * @property {Object} [container]
	 * @extends {TagDam_App_View_PelmanismNineBall_Abstract}
	 */
	var TagDam_App_View_PelmanismNineBall_Index = function() {};
	TagDam_App_View_PelmanismNineBall_Index.prototype = new TagDam_App_View_PelmanismNineBall_Abstract();
	
	/**
	 * TagDam: App: View: Pelmanism 9 Ball: Settings
	 * 
	 * @property {Object} [container]
	 * @extends {TagDam_App_View_PelmanismNineBall_Abstract}
	 */
	var TagDam_App_View_PelmanismNineBall_Settings = function() {};
	TagDam_App_View_PelmanismNineBall_Settings.prototype = new TagDam_App_View_PelmanismNineBall_Abstract();
	
	/**
	 * TagDam: App: View: Pelmanism 9 Ball: Game: Abstract
	 * 
	 * @property {Object} [container]
	 * @extends {TagDam_App_View_PelmanismNineBall_Abstract}
	 */
	var TagDam_App_View_PelmanismNineBall_Game_Abstract = function() {};
	TagDam_App_View_PelmanismNineBall_Game_Abstract.prototype = new TagDam_App_View_PelmanismNineBall_Abstract();
	
	/**
	 * TagDam: App: View: Pelmanism 9 Ball: Game
	 * 
	 * @property {Object} [container]
	 * @extends {TagDam_App_View_PelmanismNineBall_Abstract}
	 */
	var TagDam_App_View_PelmanismNineBall_Game = function() {};
	TagDam_App_View_PelmanismNineBall_Game.prototype = new TagDam_App_View_PelmanismNineBall_Game_Abstract();
	
	/**
	 * TagDam: App: View: Pelmanism 9 Ball: Game: Players
	 * 
	 * @extends {TagDam_App_View_PelmanismNineBall_Game_Abstract}
	 */
	var TagDam_App_View_PelmanismNineBall_Game_Players = function() {};
	TagDam_App_View_PelmanismNineBall_Game_Players.prototype = new TagDam_App_View_PelmanismNineBall_Game_Abstract();
	
	/**
	 * TagDam: App: View: Pelmanism 9 Ball: Game: Cards
	 * 
	 * @property {Object} [container]
	 * @extends {TagDam_App_View_PelmanismNineBall_Game_Abstract}
	 */
	var TagDam_App_View_PelmanismNineBall_Game_Cards = function() {};
	TagDam_App_View_PelmanismNineBall_Game_Cards.prototype = new TagDam_App_View_PelmanismNineBall_Game_Abstract();
	
	/**
	 * TagDam: App: View: Pelmanism 9 Ball: Game: Targets
	 * 
	 * @property {Object} [container]
	 * @extends {TagDam_App_View_PelmanismNineBall_Game_Abstract}
	 */
	var TagDam_App_View_PelmanismNineBall_Game_Targets = function() {};
	TagDam_App_View_PelmanismNineBall_Game_Targets.prototype = new TagDam_App_View_PelmanismNineBall_Game_Abstract();
	
	/**
	 * TagDam: App: View: Pelmanism 9 Ball: Game: Judge
	 * 
	 * @property {Object} [container]
	 * @extends {TagDam_App_View_PelmanismNineBall_Game_Abstract}
	 */
	var TagDam_App_View_PelmanismNineBall_Game_Judge = function() {};
	TagDam_App_View_PelmanismNineBall_Game_Judge.prototype = new TagDam_App_View_PelmanismNineBall_Game_Abstract();
	
	/**
	 * TagDam: App: View: Pelmanism 9 Ball: Game: Single
	 * 
	 * @property {Object} [container]
	 * @extends {TagDam_App_View_PelmanismNineBall_Game_Abstract}
	 */
	var TagDam_App_View_PelmanismNineBall_Game_Single = function() {};
	TagDam_App_View_PelmanismNineBall_Game_Single.prototype = new TagDam_App_View_PelmanismNineBall_Game_Abstract();
	
	/**
	 * TagDam: App: View: Pelmanism 9 Ball: Game: Continue
	 * 
	 * @property {Object} [container]
	 * @extends {TagDam_App_View_PelmanismNineBall_Game_Abstract}
	 */
	var TagDam_App_View_PelmanismNineBall_Game_Continue = function() {};
	TagDam_App_View_PelmanismNineBall_Game_Continue.prototype = new TagDam_App_View_PelmanismNineBall_Game_Abstract();
	
	/**
	 * TagDam: App: View: Pelmanism 9 Ball: Game Over
	 * 
	 * @property {Object} [container]
	 * @extends {TagDam_App_View_PelmanismNineBall_Abstract}
	 */
	var TagDam_App_View_PelmanismNineBall_GameOver = function() {};
	TagDam_App_View_PelmanismNineBall_GameOver.prototype = new TagDam_App_View_PelmanismNineBall_Abstract();
	
	/**
	 * TagDam: App: Controller: Pelmanism 9 Ball: Abstract
	 * 
	 * @property {Object} [config]
	 * @extends {StrongCocoa_App_Controller_Abstract}
	 */
	var TagDam_App_Controller_PelmanismNineBall_Abstract = function() {};
	TagDam_App_Controller_PelmanismNineBall_Abstract.prototype = new strongCocoa.classes.StrongCocoa_App_Controller_Abstract();
	TagDam_App_PelmanismNineBall.prototype.classes.StrongCocoa_Classes.prototype.TagDam_App_Controller_PelmanismNineBall_Abstract = TagDam_App_Controller_PelmanismNineBall_Abstract;
	strongCocoa.classes.StrongCocoa_Classes.prototype.TagDam_App_Controller_PelmanismNineBall_Abstract = TagDam_App_Controller_PelmanismNineBall_Abstract;
	
	/**
	 * TagDam: App: Controller: Pelmanism 9 Ball: Game
	 * 
	 * @property {Object} [config]
	 * @extends {TagDam_App_Controller_PelmanismNineBall_Abstract}
	 */
	var TagDam_App_Controller_PelmanismNineBall_Game = function() {};
	TagDam_App_Controller_PelmanismNineBall_Game.prototype = new TagDam_App_Controller_PelmanismNineBall_Abstract();
	TagDam_App_PelmanismNineBall.prototype.classes.StrongCocoa_Classes.prototype.TagDam_App_Controller_PelmanismNineBall_Game = TagDam_App_Controller_PelmanismNineBall_Game;
	strongCocoa.classes.StrongCocoa_Classes.prototype.TagDam_App_Controller_PelmanismNineBall_Game = TagDam_App_Controller_PelmanismNineBall_Game;
	
	/**
	 * TagDam: App: Controller: Pelmanism 9 Ball: Settings
	 * 
	 * @property {Object} [config]
	 * @extends {TagDam_App_Controller_PelmanismNineBall_Abstract}
	 */
	var TagDam_App_Controller_PelmanismNineBall_Settings = function() {};
	TagDam_App_Controller_PelmanismNineBall_Settings.prototype = new TagDam_App_Controller_PelmanismNineBall_Abstract();
	TagDam_App_PelmanismNineBall.prototype.classes.StrongCocoa_Classes.prototype.TagDam_App_Controller_PelmanismNineBall_Settings = TagDam_App_Controller_PelmanismNineBall_Settings;
	strongCocoa.classes.StrongCocoa_Classes.prototype.TagDam_App_Controller_PelmanismNineBall_Settings = TagDam_App_Controller_PelmanismNineBall_Settings;
	
	/**
	 * TagDam: App: Controller: Pelmanism 9 Ball
	 * 
	 * @property {Object} [config]
	 * @extends {TagDam_App_Controller_PelmanismNineBall_Abstract}
	 */
	var TagDam_App_Controller_PelmanismNineBall = function() {};
	TagDam_App_Controller_PelmanismNineBall.prototype = new TagDam_App_Controller_PelmanismNineBall_Abstract();
	TagDam_App_PelmanismNineBall.prototype.classes.StrongCocoa_Classes.prototype.TagDam_App_Controller_PelmanismNineBall = TagDam_App_Controller_PelmanismNineBall;
	strongCocoa.classes.StrongCocoa_Classes.prototype.TagDam_App_Controller_PelmanismNineBall = TagDam_App_Controller_PelmanismNineBall;
	
	/**
	 * Settings
	 * 
	 * @var {TagDam_App_Model_PelmanismNineBall_Settings}
	 */
	TagDam_App_Model_PelmanismNineBall_Abstract.prototype._settings = new TagDam_App_Model_PelmanismNineBall_Settings();
	
	/**
	 * Settings
	 * 
	 * @returns {TagDam_App_Model_PelmanismNineBall_Settings}
	 */
	TagDam_App_Model_PelmanismNineBall_Abstract.prototype.settings = function() {
		return this._settings;
	};
	
	/**
	 * Available Vibrate
	 * 
	 * @param {Function} [availableCallback]
	 * @param {Function} [invalidityCallback]
	 * @returns void
	 */
	TagDam_App_Model_PelmanismNineBall_Abstract.prototype.availableVibrate = function(availableCallback, invalidityCallback) {
		this.cordova().notification().availableVibrate(availableCallback, invalidityCallback);
	};
	
	/**
	 * Vibrate
	 * 
	 * @param {Number|Array} [milliseconds] Milliseconds or milliseconds array.
	 * @param {Function} [availableCallback]
	 * @param {Function} [invalidityCallback]
	 * @returns void
	 */
	TagDam_App_Model_PelmanismNineBall_Abstract.prototype.vibrate = function(milliseconds, availableCallback, invalidityCallback) {
		if (this.settings().vibration().available()) {
			this.cordova().notification().vibrate(milliseconds, availableCallback, invalidityCallback);
		}
	};
	
	/**
	 * Single Play Model
	 * 
	 * @var {TagDam_App_Model_PelmanismNineBall_Game_Abstract}
	 */
	TagDam_App_Model_PelmanismNineBall.prototype._game = new TagDam_App_Model_PelmanismNineBall_Game_Abstract();
	
	/**
	 * Single Play Model
	 * 
	 * @returns {TagDam_App_Model_PelmanismNineBall_Game_Abstract}
	 */
	TagDam_App_Model_PelmanismNineBall.prototype.game = function() {
		return this._game;
	};
	
	/**
	 * Vibration
	 * 
	 * @var {TagDam_App_Model_PelmanismNineBall_Settings_Vibration}
	 */
	TagDam_App_Model_PelmanismNineBall_Settings.prototype._vibration = new TagDam_App_Model_PelmanismNineBall_Settings_Vibration();
	
	/**
	 * Vibration
	 * 
	 * @returns {TagDam_App_Model_PelmanismNineBall_Settings_Vibration}
	 */
	TagDam_App_Model_PelmanismNineBall_Settings.prototype.vibration = function() {
		return this._vibration;
	};
	
	/**
	 * Theme
	 * 
	 * @var {TagDam_App_Model_PelmanismNineBall_Settings_Theme}
	 */
	TagDam_App_Model_PelmanismNineBall_Settings.prototype._theme = new TagDam_App_Model_PelmanismNineBall_Settings_Theme();
	
	/**
	 * Theme
	 * 
	 * @returns {TagDam_App_Model_PelmanismNineBall_Settings_Theme}
	 */
	TagDam_App_Model_PelmanismNineBall_Settings.prototype.theme = function() {
		return this._theme;
	};
	
	/**
	 * Vibration
	 * 
	 * @var {Number}
	 */
	TagDam_App_Model_PelmanismNineBall_Settings_Vibration.prototype._val = null;
	
	/**
	 * Default Vibration
	 * 
	 * @var {Number}
	 */
	TagDam_App_Model_PelmanismNineBall_Settings_Vibration.prototype.defaultVal = function() {
		return 0;
	};
	
	/**
	 * Key of Vibration
	 * 
	 * @returns {String}
	 */
	TagDam_App_Model_PelmanismNineBall_Settings_Vibration.prototype.key = function() {
		return 'TagDam_App_Model_PelmanismNineBall_Settings_Vibration';
	};
	
	/**
	 * Vibration
	 * 
	 * @param {String} [vibration]
	 * @returns {String}
	 */
	TagDam_App_Model_PelmanismNineBall_Settings_Vibration.prototype.val = function(vibration) {
		if (this.utility.notEmpty(vibration) && this.utility.isString(vibration)) {
			this._val = vibration;
			this.localStorage.save(this.key(), vibration);
		} else if (this.utility.isEmpty(this._val)
				&& this.utility.isEmpty(this._val = this.localStorage.get(this.key()))) {
			this._val = this.defaultVal();
		}
		return this._val;
	};
	
	/**
	 * Available
	 * 
	 * @returns {Boolean}
	 */
	TagDam_App_Model_PelmanismNineBall_Settings_Vibration.prototype.available = function() {
		return (1 == this.val());
	};
	
	/**
	 * Theme
	 * 
	 * @var {String}
	 */
	TagDam_App_Model_PelmanismNineBall_Settings_Theme.prototype._val = null;
	
	/**
	 * Default Theme
	 * 
	 * @var {String}
	 */
	TagDam_App_Model_PelmanismNineBall_Settings_Theme.prototype.defaultVal = function() {
		return 'Default';
	};
	
	/**
	 * Key of Theme
	 * 
	 * @returns {String}
	 */
	TagDam_App_Model_PelmanismNineBall_Settings_Theme.prototype.key = function() {
		return 'TagDam_App_Model_PelmanismNineBall_Settings_Theme';
	};
	
	/**
	 * Theme
	 * 
	 * @param {String} [theme]
	 * @returns {String}
	 */
	TagDam_App_Model_PelmanismNineBall_Settings_Theme.prototype.val = function(theme) {
		if (this.utility.notEmpty(theme) && this.utility.isString(theme)) {
			this._val = theme;
			this.localStorage.save(this.key(), theme);
		} else if (this.utility.isEmpty(this._val)
				&& this.utility.isEmpty(this._val = this.localStorage.get(this.key()))) {
			this._val = this.defaultVal();
		}
		return this._val;
	};
	
	/**
	 * Manager
	 * 
	 * @var {TagDam_App_Model_PelmanismNineBall_Game_Manager}
	 */
	TagDam_App_Model_PelmanismNineBall_Game_Abstract.prototype._manager = new TagDam_App_Model_PelmanismNineBall_Game_Manager();
	
	/**
	 * Manager
	 * 
	 * @var {TagDam_App_Model_PelmanismNineBall_Game_Manager}
	 */
	TagDam_App_Model_PelmanismNineBall_Game_Abstract.prototype.manager = function() {
		return this._manager;
	};
	
	/**
	 * Cards
	 * 
	 * @var {TagDam_App_Model_PelmanismNineBall_Game_Cards}
	 */
	var cards = new TagDam_App_Model_PelmanismNineBall_Game_Cards();
	TagDam_App_Model_PelmanismNineBall_Game_Abstract.prototype._cards = cards;
	
	/**
	 * Cards
	 * 
	 * @returns {TagDam_App_Model_PelmanismNineBall_Game_Cards}
	 */
	TagDam_App_Model_PelmanismNineBall_Game_Abstract.prototype.cards = function() {
		return this._cards;
//		return this.utility.notEmpty(this._cards) ? this._cards : (this._cards = new TagDam_App_Model_PelmanismNineBall_Game_Cards());
	};
	
	/**
	 * Targets
	 * 
	 * @var {TagDam_App_Model_PelmanismNineBall_Game_Targets}
	 */
	var targets = new TagDam_App_Model_PelmanismNineBall_Game_Targets();
	TagDam_App_Model_PelmanismNineBall_Game_Abstract.prototype._targets = targets;
	
	/**
	 * Targets
	 * 
	 * @returns {TagDam_App_Model_PelmanismNineBall_Game_Targets}
	 */
	TagDam_App_Model_PelmanismNineBall_Game_Abstract.prototype.targets = function() {
		return this._targets;
//		return this.utility.notEmpty(this._targets) ? this._targets : (this._targets = new TagDam_App_Model_PelmanismNineBall_Game_Targets());
	};
	
	/**
	 * Number of Times
	 * 
	 * @var {Number}
	 */
	TagDam_App_Model_PelmanismNineBall_Game_Manager.prototype._numberOfTimes = 1;
	
	/**
	 * Number of Times
	 * 
	 * @returns {Number}
	 */
	TagDam_App_Model_PelmanismNineBall_Game_Manager.prototype.numberOfTimes = function() {
		return this._numberOfTimes;
	};
	
	/**
	 * Count
	 * 
	 * @returns {Number}
	 */
	TagDam_App_Model_PelmanismNineBall_Game_Manager.prototype.count = function() {
		if (this.players().notEmpty()) {
			this._numberOfTimes++;
		}
		return this._numberOfTimes;
	};
	
	/**
	 * Reset the Number of Times
	 * 
	 * @returns {Number}
	 */
	TagDam_App_Model_PelmanismNineBall_Game_Manager.prototype.resetNumberOfTimes = function() {
		return this._numberOfTimes = 1;
	};
	
	/**
	 * Players
	 * 
	 * @var {TagDam_App_Model_PelmanismNineBall_Game_Players}
	 */
	var players = new TagDam_App_Model_PelmanismNineBall_Game_Players();
	TagDam_App_Model_PelmanismNineBall_Game_Abstract.prototype._players = players;
	
	/**
	 * Players
	 * 
	 * @returns {TagDam_App_Model_PelmanismNineBall_Game_Players}
	 */
	TagDam_App_Model_PelmanismNineBall_Game_Abstract.prototype.players = function() {
		return this._players;
//		return this.utility.notEmpty(this._players) ? this._players : (this._players = new TagDam_App_Model_PelmanismNineBall_Game_Players());
	};
	
	/**
	 * Selectable Card Number
	 * 
	 * @var {Number}
	 */
	TagDam_App_Model_PelmanismNineBall_Game_Manager.prototype._selectableCardNumber = 2;
	
	/**
	 * Selectable Card Number
	 * 
	 * @returns {Number}
	 */
	TagDam_App_Model_PelmanismNineBall_Game_Manager.prototype.selectableCardNumber = function() {
		return this._selectableCardNumber;
	};
	
	/**
	 * Reset
	 * 
	 * @returns void
	 */
	TagDam_App_Model_PelmanismNineBall_Game_Abstract.prototype.reset = function() {
		this.players().reset();
		this.targets().reset();
		this.cards().reset();
		this.manager().resetNumberOfTimes();
	};
	
	/**
	 * Start
	 * 
	 * @param {Array} [players]
	 * @param {String} [key] (Option) Save Key
	 * @returns void
	 */
	TagDam_App_Model_PelmanismNineBall_Game_Abstract.prototype.start = function(players, key) {
		this.reset();
		this.players().setPlayers(players);
		this.manager().saveKey(key);
		this.manager().save();
	};
	
	/**
	 * Restart
	 * 
	 * @returns void
	 */
	TagDam_App_Model_PelmanismNineBall_Game_Abstract.prototype.restart = function() {
		var players = this.players().findAll();
		for (var i = 0, ___len = players.length; i < ___len; i++) {
			players[i].clear();
		}
		this.start(players);
	};
	
	/**
	 * Judge
	 * 
	 * @returns {Boolean} True is OK (Match).
	 */
	TagDam_App_Model_PelmanismNineBall_Game_Abstract.prototype.judge = function() {
		var judge = false;
		if (this.targets().hasCurrent() && !this.cards().needOpenCardMore()) {
			var currentTarget = this.targets().current();
			var indexes = this.cards().openCards();
			var value = this.cards().find(indexes[0]);
			if (currentTarget == value) {
				for (var i = 1, ___len = indexes.length; i < ___len; i++) {
					if (value !== this.cards().find(indexes[i])) {
						break;
					} else if (i === (___len - 1)) {
						this.cards().addUsedCards(indexes);
						this.targets().increment();
						if (!this.targets().hasNext()) {
							this.players().currentToWinner();
						}
						judge = true;
					}
				}
			}
			this.players().current().latestOpenedCards(indexes);
			if (!judge) {
				this.players().toNext();
			}
			this.cards().resetOpenCards();
			this.manager().save();
		}
		return judge;
	};
	
	/**
	 * Save Key of Latest Save Key
	 * 
	 * @var {String}
	 */
	TagDam_App_Model_PelmanismNineBall_Game_Manager.prototype._latestSaveKeySaveKey = 'TagDam_App_Model_PelmanismNineBall_Game_Abstract_SaveKey_LatestSaveKey';
	
	/**
	 * Save key of Latest Save Key
	 * 
	 * @returns {String}
	 */
	TagDam_App_Model_PelmanismNineBall_Game_Manager.prototype.latestSaveKeySaveKey = function() {
		return this._latestSaveKeySaveKey;
	};
	
	/**
	 * Latest Save Key
	 * 
	 * @returns {String}
	 */
	TagDam_App_Model_PelmanismNineBall_Game_Manager.prototype.latestSaveKey = function() {
		return this.localStorage.get(this.latestSaveKeySaveKey());
	};
	
	/**
	 * Save
	 * 
	 * @param {String} [key]
	 * @returns void
	 */
	TagDam_App_Model_PelmanismNineBall_Game_Manager.prototype.saveLatestSaveKey = function(key) {
		this.localStorage.save(this.latestSaveKeySaveKey(), key);
	};
	
	/**
	 * Remove
	 * 
	 * @returns void
	 */
	TagDam_App_Model_PelmanismNineBall_Game_Manager.prototype.removeLatestSaveKey = function() {
		this.localStorage.remove(this.latestSaveKeySaveKey());
	};
	
	/**
	 * Has the Latest Save Key
	 * 
	 * @returns {Boolean}
	 */
	TagDam_App_Model_PelmanismNineBall_Game_Manager.prototype.hasLatestSaveKey = function() {
		return this.utility.notEmpty(this.latestSaveKey());
	};
	
	/**
	 * Save Key
	 * 
	 * @var {String}
	 */
	TagDam_App_Model_PelmanismNineBall_Game_Manager.prototype._saveKey = 'TagDam_App_Model_PelmanismNineBall_Game_Abstract';
	
	/**
	 * Save Key
	 * 
	 * @param {String} [key] (Option) Save Key
	 * @returns {String}
	 */
	TagDam_App_Model_PelmanismNineBall_Game_Manager.prototype.saveKey = function(key) {
		if (this.utility.notEmpty(key)) {
			return (this._saveKey = key);
		}
		return this._saveKey;
//		var key = ['TagDam_App_Model_PelmanismNineBall_Game_Abstract'];
//		var players = this.players().findAll();
//		for (var i = 0, ___len = players.length; i < ___len; i++) {
//			key[key.length] = players[i].name();
//		}
//		return key.join('-').toString();
	};
	
	/**
	 * Save
	 * 
	 * @returns void
	 */
	TagDam_App_Model_PelmanismNineBall_Game_Manager.prototype.save = function() {
		var key = this.saveKey();
		this.localStorage.save(key, this.toObject());
//		this.localStorage.save(key, TagDam_App_Model_PelmanismNineBall_Game_Abstract.prototype.toObject.call(this));
		this.saveLatestSaveKey(key);
	};
	
	/**
	 * To the Object
	 * 
	 * @returns {Object}
	 */
	TagDam_App_Model_PelmanismNineBall_Game_Manager.prototype.toObject = function() {
		return {
			players: this.players().toObject(),
			targets: this.targets().toObject(),
			cards: this.cards().toObject(),
			numberOfTimes: this.numberOfTimes()
		};
	};
	
	/**
	 * Has the Save
	 * 
	 * @param {String} [key] (Option) Save Key.
	 * @returns {Boolean}
	 */
	TagDam_App_Model_PelmanismNineBall_Game_Manager.prototype.hasSave = function(key) {
		return this.utility.notEmpty(this.getSaveData(key));
	};
	
	/**
	 * Get the Save Data
	 * 
	 * @param {String} [key] (Option) Save Key.
	 * @returns {Array}
	 */
	TagDam_App_Model_PelmanismNineBall_Game_Manager.prototype.getSaveData = function(key) {
		return this.localStorage.get(this.utility.notEmpty(key) ? key : this.saveKey());
	};
	
	/**
	 * Clear the Save
	 * 
	 * @param {String} [key] (Option) Save Key.
	 * @returns {String}
	 */
	TagDam_App_Model_PelmanismNineBall_Game_Manager.prototype.clearSave = function(key) {
		this.removeLatestSaveKey();
		this.localStorage.remove(this.utility.notEmpty(key) ? key : this.saveKey());
	};
	
	/**
	 * Load
	 * 
	 * @param {String} [key] (Option) Save Key.
	 * @returns {Boolean} True is load success. False is reset.
	 */
	TagDam_App_Model_PelmanismNineBall_Game_Manager.prototype.load = function(key) {
		if (this.hasSave(key)) {
			this.reset();
			var data = this.getSaveData(this.saveKey(key));
			this.players().import(data.players);
			this.targets().import(data.targets);
			this.cards().import(data.cards);
			this._numberOfTimes = data.numberOfTimes;
			this.save();
			return true;
		}
		return false;
		
		
//		this.reset();
//		this.players().setPlayers(players);
//		this.manager().saveKey(key);
//		this.manager().save();
	};
	
	/**
	 * Has the Continue
	 * 
	 * @param {String} [key] (Option) Save Key
	 * @returns {Boolean}
	 */
	TagDam_App_Model_PelmanismNineBall_Game_Manager.prototype.hasContinue = function(key) {
		var game = new TagDam_App_Model_PelmanismNineBall_Game_Abstract();
		if (game.manager().load(this.utility.notEmpty(key) ? key : this.saveKey())
				&& game.targets().hasCurrent()
				&& ((0 < game.cards().openCards().length)
						|| (0 < game.players().latestOpenedCards().length))) {
			return true;
		}
		return false;
//		if (this.load(this.hasLatestSaveKey() ? this.latestSaveKey() : this.saveKey())
//				&& this.targets().hasCurrent()
//				&& ((0 < this.cards().openCards().length)
//						|| (0 < this.players().latestOpenedCards().length))) {
//			return true;
//		}
//		return false;
	};
	
	/**
	 * Is the End
	 * 
	 * @returns {Boolean}
	 */
	TagDam_App_Model_PelmanismNineBall_Game_Manager.prototype.isEnd = function() {
		return !this.targets().hasCurrent();
	};
	
	/**
	 * Deck
	 * 
	 * @var {Array} Index is Card Index, Value is Card Index.
	 */
	TagDam_App_Model_PelmanismNineBall_Game_Cards.prototype._deck = [];
	
	/**
	 * To the Object
	 * 
	 * @returns {Object}
	 */
	TagDam_App_Model_PelmanismNineBall_Game_Cards.prototype.toObject = function() {
		return {
			deck: this._deck,
			openCards: this._openCards,
			usedCards: this._usedCards
		};
	};
	
	/**
	 * Import
	 * 
	 * @param {Object} [data]
	 * @returns void
	 */
	TagDam_App_Model_PelmanismNineBall_Game_Cards.prototype.import = function(data) {
		this._deck = data.deck;
		this._openCards = data.openCards;
		this._usedCards = data.usedCards;
	};
	
	/**
	 * Shuffle of Cards
	 * 
	 * @param {Array} [cards] Card Values
	 * @returns {Array} Card Values
	 */
	TagDam_App_Model_PelmanismNineBall_Game_Cards.prototype.shuffle = function(cards) {
		var shuffledCards = [];
		for (var i = 0, ___len = cards.length; i < ___len; i++) {
			shuffledCards[i] = cards.splice(Math.floor(Math.random() * (cards.length)), 1)[0];
		}
		return shuffledCards;
	};
	
	/**
	 * Reset
	 * 
	 * @returns void
	 */
	TagDam_App_Model_PelmanismNineBall_Game_Cards.prototype.reset = function() {
		this.resetCards();
		this.resetOpenCards();
		this.resetUsedCards();
	};
	
	/**
	 * Reset of Cards
	 * 
	 * @returns {Array} Card Indexes
	 */
	TagDam_App_Model_PelmanismNineBall_Game_Cards.prototype.resetCards = function() {
		var cards = [];
		var targets = this.targets().findAll();
		for (var i = 0, ___len = this.manager().selectableCardNumber(); i < ___len; i++) {
			cards = cards.concat(targets);
		}
		return (this._deck = this.cards().shuffle(cards));
	};
	
	/**
	 * Find All
	 * 
	 * @returns {Array} Index is Card Index, Value is Card Index.
	 */
	TagDam_App_Model_PelmanismNineBall_Game_Cards.prototype.findAll = function() {
		return this._deck.concat([]);
	};
	
	/**
	 * Card
	 * 
	 * @param {Number} [index]
	 * @returns {Number} Card Value
	 */
	TagDam_App_Model_PelmanismNineBall_Game_Cards.prototype.find = function(index) {
		return this.findAll()[index];
	};
	
	/**
	 * Open Cards
	 * 
	 * @var {Array} Card Indexes
	 */
	TagDam_App_Model_PelmanismNineBall_Game_Cards.prototype._openCards = [];
	
	/**
	 * Open Cards
	 * 
	 * @returns {Array} Card Indexes
	 */
	TagDam_App_Model_PelmanismNineBall_Game_Cards.prototype.openCards = function() {
		return this._openCards.concat([]);
	};
	
	/**
	 * Add the Open Card
	 * 
	 * @param {Number} [indexes]
	 * @returns void
	 */
	TagDam_App_Model_PelmanismNineBall_Game_Cards.prototype.addOpenCard = function(index) {
//		var _indexes = this.utility.isNumeric(index) ? [index] : index;
		var _indexes = [index];
		var index;
		var value;
		var computers = this.players().computers();
		for (var i = 0, ___len = _indexes.length; i < ___len; i++) {
			index = _indexes[i];
			value = this.cards().find(index);
			this._openCards[this._openCards.length] = index;
			for (var j = 0, ____len = computers.length; j < ____len; j++) {
				computers[j].memory().save(value, index);
			}
		}
		this.manager().save();
	};
	
	/**
	 * Opened
	 * 
	 * @param {Number} [index]
	 * @returns {Boolean}
	 */
	TagDam_App_Model_PelmanismNineBall_Game_Cards.prototype.opened = function(index) {
		return (0 <= this.utility.inArray(index, this.openCards()));
	};
	
	/**
	 * Open the Card
	 * 
	 * @param {Number} [index]
	 * @returns {Number} Success is Card Value, Error is "-1".
	 */
	TagDam_App_Model_PelmanismNineBall_Game_Cards.prototype.openCard = function(index) {
		if (this.needOpenCardMore() && !this.opened(index) && !this.used(index)) {
			this.addOpenCard(index);
			return this.find(index);
		}
		return -1;
	};
	
	/**
	 * Reset the Open Cards
	 * 
	 * @returns void
	 */
	TagDam_App_Model_PelmanismNineBall_Game_Cards.prototype.resetOpenCards = function() {
		this._openCards = [];
		this.manager().count();
	};
	
	/**
	 * Need the Open Card More
	 * 
	 * @returns {Boolean}
	 */
	TagDam_App_Model_PelmanismNineBall_Game_Cards.prototype.needOpenCardMore = function() {
		return (this.manager().selectableCardNumber() > this.openCards().length);
	};
	
	/**
	 * Used Cards
	 * 
	 * @var {Array} Card Indexes
	 */
	TagDam_App_Model_PelmanismNineBall_Game_Cards.prototype._usedCards = [];
	
	/**
	 * Used Cards
	 * 
	 * @returns {Array} Card Indexes
	 */
	TagDam_App_Model_PelmanismNineBall_Game_Cards.prototype.usedCards = function() {
		return this._usedCards.concat([]);
	};
	
	/**
	 * Add the Used Cards
	 * 
	 * @param {Array} [indexes]
	 * @return void
	 */
	TagDam_App_Model_PelmanismNineBall_Game_Cards.prototype.addUsedCards = function(indexes) {
		this._usedCards = this._usedCards.concat(indexes);
	};
	
	/**
	 * Used
	 * 
	 * @param {Number} [index]
	 * @returns {Boolean}
	 */
	TagDam_App_Model_PelmanismNineBall_Game_Cards.prototype.used = function(index) {
		return (-1 !== this.utility.inArray(index, this.usedCards()));
	};
	
	/**
	 * Reset the Used Cards
	 * 
	 * @returns {Array} Card Indexes
	 */
	TagDam_App_Model_PelmanismNineBall_Game_Cards.prototype.resetUsedCards = function() {
		return (this._usedCards = []);
	};
	
	/**
	 * Targets
	 * 
	 * @var {Array} Card Values
	 */
	TagDam_App_Model_PelmanismNineBall_Game_Targets.prototype._data = [1, 2, 3, 4, 5, 6, 7, 8, 9];
	
	/**
	 * Current Target Index
	 * 
	 * @var {Number} Targets Index
	 */
	TagDam_App_Model_PelmanismNineBall_Game_Targets.prototype._current = 0;
	
	/**
	 * To the Object
	 * 
	 * @returns {Object}
	 */
	TagDam_App_Model_PelmanismNineBall_Game_Targets.prototype.toObject = function() {
		return {
			targets: this._data,
			current: this._current
		};
	};
	
	/**
	 * Import
	 * 
	 * @param {Object} [data]
	 * @returns void
	 */
	TagDam_App_Model_PelmanismNineBall_Game_Targets.prototype.import = function(data) {
		this._data = data.targets;
		this._current = data.current;
	};
	
	/**
	 * Find All
	 * 
	 * @returns {Array} Card Values
	 */
	TagDam_App_Model_PelmanismNineBall_Game_Targets.prototype.findAll = function() {
		return this._data.concat([]);
	};
	
	/**
	 * Find
	 * 
	 * @param {Number} [index]
	 * @returns {Number} Card Value
	 */
	TagDam_App_Model_PelmanismNineBall_Game_Targets.prototype.find = function(index) {
		return this.findAll()[index];
	};
	
	/**
	 * Reset the Current Target Index
	 * 
	 * @returns {Number} Current Target Index
	 */
	TagDam_App_Model_PelmanismNineBall_Game_Targets.prototype.reset = function() {
		return (this._current = 0);
	};
	
	/**
	 * Has the Current Target
	 * 
	 * @returns {Boolean}
	 */
	TagDam_App_Model_PelmanismNineBall_Game_Targets.prototype.hasCurrent = function() {
		return ((0 <= this._current) && (this._current < this.findAll().length));
//		return (this.findAll().length >= (this._current + 1));
	};
	
	/**
	 * Has the Next Target
	 * 
	 * @returns {Boolean}
	 */
	TagDam_App_Model_PelmanismNineBall_Game_Targets.prototype.hasNext = function() {
		return ((1 + this._current) < this.findAll().length);
	};
	
	/**
	 * Current Target
	 * 
	 * @returns {Number} Targets Index. Noting Current Target is return "-1".
	 */
	TagDam_App_Model_PelmanismNineBall_Game_Targets.prototype.current = function() {
		return this.hasCurrent() ? this.find(this._current) : -1;
	};
	
	/**
	 * Increment Target
	 * 
	 * @returns {Number} Increment Target Value. Noting nexte target is return "-1".
	 */
	TagDam_App_Model_PelmanismNineBall_Game_Targets.prototype.increment = function() {
		return this.hasNext() ? this._current++ : (this._current = -1);
	};
	
	/**
	 * Players
	 * 
	 * @var {Array}
	 */
	TagDam_App_Model_PelmanismNineBall_Game_Players.prototype._playerList = [];
	
	/**
	 * Find All
	 * 
	 * @returns {Array}
	 */
	TagDam_App_Model_PelmanismNineBall_Game_Players.prototype.findAll = function() {
		return this._playerList.concat([]);
	};
	
	/**
	 * Find
	 * 
	 * @param {Number} [index] Player Index
	 * @returns {TagDam_App_Model_PelmanismNineBall_Game_Player_Abstract}
	 */
	TagDam_App_Model_PelmanismNineBall_Game_Players.prototype.find = function(index) {
		return this.findAll()[index];
	};
	
	/**
	 * Computer Players
	 * 
	 * @returns {Array}
	 */
	TagDam_App_Model_PelmanismNineBall_Game_Players.prototype.computers = function() {
		var computers = [];
		var players = this.findAll();
		for (var i = 0, ___len = players.length; i < ___len; i++) {
			if (players[i].isComputer()) {
				computers[computers.length] = players[i];
			}
		}
		return computers;
	};
	
	/**
	 * Latest Opened Cards
	 * 
	 * @reutnrs {Array} Card Indexes
	 */
	TagDam_App_Model_PelmanismNineBall_Game_Players.prototype.latestOpenedCards = function() {
		var indexes = [];
		var currentPlayer = this.current();
		var players = this.findAll();
		for (var i = 0, ___len = players.length; i < ___len; i++) {
			if (!currentPlayer.equal(players[i])) {
				indexes = indexes.concat(players[i].latestOpenedCards());
			}
		}
		return indexes;
	};
	
	/**
	 * Is Empty
	 * 
	 * @returns void
	 */
	TagDam_App_Model_PelmanismNineBall_Game_Players.prototype.isEmpty = function() {
		return (0 == this.findAll().length);
	};
	
	/**
	 * Not Empty
	 * 
	 * @returns void
	 */
	TagDam_App_Model_PelmanismNineBall_Game_Players.prototype.notEmpty = function() {
		return !this.isEmpty();
	};
	
	/**
	 * Reset
	 * 
	 * @returns void
	 */
	TagDam_App_Model_PelmanismNineBall_Game_Players.prototype.reset = function() {
		this.clearPlayers();
		this._currentPlayerIndex = 0;
		this._winnerPlayerIndex = -1;
	};
	
	/**
	 * Clear the Players
	 * 
	 * @returns void
	 */
	TagDam_App_Model_PelmanismNineBall_Game_Players.prototype.clearPlayers = function() {
		this._playerList = [];
	};
	
	/**
	 * Set the Players
	 * 
	 * @param {Array} [players]
	 * @returns void
	 */
	TagDam_App_Model_PelmanismNineBall_Game_Players.prototype.setPlayers = function(players) {
		this._playerList = players;
	};
	
	/**
	 * Add the Player
	 * 
	 * @param {TagDam_App_Model_PelmanismNineBall_Game_Player_Abstract} [players]
	 * @returns void
	 */
	TagDam_App_Model_PelmanismNineBall_Game_Players.prototype.addPlayer = function(player) {
		this._playerList[this._playerList.length] = player;
	};
	
	/**
	 * Current Player Index
	 * 
	 * @var {Number}
	 */
	TagDam_App_Model_PelmanismNineBall_Game_Players.prototype._currentPlayerIndex = 0;
	
	/**
	 * Winner Player Index
	 * 
	 * @var {Number}
	 */
	TagDam_App_Model_PelmanismNineBall_Game_Players.prototype._winnerPlayerIndex = -1;
	
	/**
	 * Current Player
	 * 
	 * @returns {TagDam_App_Model_PelmanismNineBall_Game_Player_Abstract}
	 */
	TagDam_App_Model_PelmanismNineBall_Game_Players.prototype.current = function() {
		return this.find(this._currentPlayerIndex);
	};
	
	/**
	 * Is Winner
	 * 
	 * @returns {Boolean}
	 */
	TagDam_App_Model_PelmanismNineBall_Game_Players.prototype.isWinner = function() {
		return this.utility.notEmpty(this.find(this._winnerPlayerIndex));
	};
	
	/**
	 * Winner
	 * 
	 * @returns {TagDam_App_Model_PelmanismNineBall_Game_Player_Abstract}
	 */
	TagDam_App_Model_PelmanismNineBall_Game_Players.prototype.winner = function() {
		return this.find(this._winnerPlayerIndex);
	};
	
	/**
	 * Current to Winner
	 * 
	 * @returns void
	 */
	TagDam_App_Model_PelmanismNineBall_Game_Players.prototype.currentToWinner = function() {
		this._winnerPlayerIndex = this._currentPlayerIndex;
	};
	
	/**
	 * To the Next of Player
	 * 
	 * @returns {TagDam_App_Model_PelmanismNineBall_Game_Player_Abstract} Next player
	 */
	TagDam_App_Model_PelmanismNineBall_Game_Players.prototype.toNext = function() {
		if (this._currentPlayerIndex < (this._playerList.length - 1)) {
			this._currentPlayerIndex = (this._playerList.length - 1);
		} else {
			this._currentPlayerIndex = 0;
		}
		return this.current();
	};
	
	/**
	 * To Object
	 * 
	 * @returns {Object}
	 */
	TagDam_App_Model_PelmanismNineBall_Game_Players.prototype.toObject = function() {
		var players = [];
		for (var i = 0, ___len = this.findAll().length; i < ___len; i++) {
			players[players.length] = this.findAll()[i].toObject();
		}
		return {
			currentPlayerIndex: this._currentPlayerIndex,
			winnerPlayerIndex: this._winnerPlayerIndex,
			players: players
		};
	};
	
	/**
	 * Import
	 * 
	 * @param {Object} [data]
	 * @returns void
	 */
	TagDam_App_Model_PelmanismNineBall_Game_Players.prototype.import = function(data) {
		var players = [];
		var player;
		this._currentPlayerIndex = data.currentPlayerIndex;
		this._winnerPlayerIndex = data.winnerPlayerIndex;
		for (var i = 0, ___len = data.players.length; i < ___len; i++) {
			switch (data.players[i].type) {
			case 'User':
				player = new TagDam_App_Model_PelmanismNineBall_Game_Player_User(data.players[i].name);
				break;
			case 'Computer':
				player = new TagDam_App_Model_PelmanismNineBall_Game_Player_Computer(data.players[i].name, data.players[i].forgettingRate);
				break;
			default:
				player = new TagDam_App_Model_PelmanismNineBall_Game_Player_Abstract(data.players[i]);
				break;
			}
			player.import(data.players[i]);
			players[players.length] = player;
		}
		this.setPlayers(players);
	};
	
	/**
	 * Is User
	 * 
	 * @returns {Boolean}
	 */
	TagDam_App_Model_PelmanismNineBall_Game_Player_Abstract.prototype.isUser = function() {
		return ('User' == this.type());
	};
	
	/**
	 * Is Computer
	 * 
	 * @returns {Boolean}
	 */
	TagDam_App_Model_PelmanismNineBall_Game_Player_Abstract.prototype.isComputer = function() {
		return ('Computer' == this.type());
	};
	
	/**
	 * Type
	 * 
	 * @returns {String}
	 */
	TagDam_App_Model_PelmanismNineBall_Game_Player_Abstract.prototype.type = function() {
		return this._type;
	};
	
	/**
	 * Name
	 * 
	 * @returns {String}
	 */
	TagDam_App_Model_PelmanismNineBall_Game_Player_Abstract.prototype.name = function() {
		return this._name;
	};
	
	/**
	 * Latest Opened Cards
	 * 
	 * @var {Array}
	 */
	TagDam_App_Model_PelmanismNineBall_Game_Player_Abstract.prototype._latestOpenedCards = [];
	
	/**
	 * Latest Opened Cards
	 * 
	 * @param {Array} [indexes] (Option)
	 * @returns {Array}
	 */
	TagDam_App_Model_PelmanismNineBall_Game_Player_Abstract.prototype.latestOpenedCards = function(indexes) {
		if (this.utility.isArray(indexes)) {
			return (this._latestOpenedCards = indexes);
		}
		return this._latestOpenedCards;
	};
	
	/**
	 * Clear the Latest Opened Cards
	 * 
	 * @returns {Array}
	 */
	TagDam_App_Model_PelmanismNineBall_Game_Player_Abstract.prototype.clearLatestOpenedCards = function() {
		this.latestOpenedCards([]);
	};
	
	/**
	 * Clear
	 * 
	 * @retunrs void
	 */
	TagDam_App_Model_PelmanismNineBall_Game_Player_Abstract.prototype.clear = function() {
		this.clearLatestOpenedCards();
	};
	
	/**
	 * Equal
	 * 
	 * @param {TagDam_App_Model_PelmanismNineBall_Game_Player_Abstract} [player]
	 * @returns {Boolean}
	 */
	TagDam_App_Model_PelmanismNineBall_Game_Player_Abstract.prototype.equal = function(player) {
		if (this === player) {
			return true;
		}
		return false;
	};
	
	/**
	 * To Object
	 * 
	 * @returns {Object}
	 */
	TagDam_App_Model_PelmanismNineBall_Game_Player_Abstract.prototype.toObject = function() {
		return {
			type: this.type(),
			name: this.name(),
			latestOpenedCards: this.latestOpenedCards()
		};
	};
	
	/**
	 * Import
	 * 
	 * @param {Object} [data]
	 * @returns void
	 */
	TagDam_App_Model_PelmanismNineBall_Game_Player_Abstract.prototype.import = function(data) {
		this._type = data.type;
		this._name = data.name;
		this._latestOpenedCards = data.latestOpenedCards;
	};
	
	/**
	 * Forgetting Rate
	 * 
	 * @return {Number}
	 */
	TagDam_App_Model_PelmanismNineBall_Game_Player_Computer_Abstract.prototype.forgettingRate = function() {
		return this._forgettingRate;
	};
	
	/**
	 * Memory
	 * 
	 * @var {TagDam_App_Model_PelmanismNineBall_Game_Memory}
	 */
	TagDam_App_Model_PelmanismNineBall_Game_Player_Computer_Abstract.prototype._memory = null;
	
	/**
	 * Memory
	 * 
	 * @returns {TagDam_App_Model_PelmanismNineBall_Game_Memory}
	 */
	TagDam_App_Model_PelmanismNineBall_Game_Player_Computer_Abstract.prototype.memory = function() {
		return this.utility.notEmpty(this._memory) ? this._memory : (this._memory = new TagDam_App_Model_PelmanismNineBall_Game_Memory());
	};
	
	/**
	 * Clear
	 * 
	 * @returns void
	 */
	TagDam_App_Model_PelmanismNineBall_Game_Player_Computer_Abstract.prototype.clear = function() {
		TagDam_App_Model_PelmanismNineBall_Game_Player_Abstract.prototype.clear.call(this);
		this.memory().clear();
	};
	
	/**
	 * Select the Card
	 * 
	 * @returns {Number} Card Index
	 */
	TagDam_App_Model_PelmanismNineBall_Game_Player_Computer_Abstract.prototype.selectCard = function() {
		var index = -1;
		var number = this.manager().selectableCardNumber();
		var target = this.targets().current();
		var openCards = this.cards().openCards();
		var forgettingRate = this.forgettingRate();
		var indexes = this.memory().find(forgettingRate, target);
		if (number != indexes.length) {
			var latestOpenedCards = this.players().latestOpenedCards();
			for (var i = 0, ___len = latestOpenedCards.length; i < ___len; i++) {
				if ((-1 === this.utility.inArray(latestOpenedCards[i], indexes))
						&& (target == this.cards().find(latestOpenedCards[i]))) {
					indexes[indexes.length] = latestOpenedCards[i];
				}
			}
		}
		if (number == indexes.length) {
			for (var i = 0; i < number; i++) {
				if (-1 === this.utility.inArray(indexes[i], openCards)) {
					index = indexes[i];
					break;
				}
			}
		} else if (1 == (number - openCards.length)) {
			var targets = this.targets().findAll();
			var excludes = indexes.concat(openCards, this.cards().usedCards());
			var memory;
			for (var i = (targets.length - 1); 0 <= i; i--) {
				memory = this.memory().find(forgettingRate, targets[i]);
				for (var j = 0, ___len = memory.length; j < ___len; j++) {
					if (-1 === this.utility.inArray(memory[j], excludes)) {
						index = memory[j];
						break;
					}
				}
				if (this.utility.notEmpty(index)) {
					break;
				}
			}
		}
		return (0 <= index) ? index : this.selectCardByRandom();
	};
	
	/**
	 * Select the Card by Random
	 * 
	 * @returns {Number} Card Indexe
	 */
	TagDam_App_Model_PelmanismNineBall_Game_Player_Computer_Abstract.prototype.selectCardByRandom = function() {
		var indexes = [];
		var excludes = this.cards().usedCards().concat(this.cards().openCards());
		var targets = this.targets().findAll();
		var forgettingRate = this.forgettingRate();
		var latestOpenedCards = this.players().latestOpenedCards();
		var memory = [];
		for (var i = 0, ___len = targets.length; i < ___len; i++) {
			memory = memory.concat(this.memory().find(forgettingRate, targets[i]));
		}
		for (var i = 0, ___len = this.cards().findAll().length; i < ___len; i++) {
			if (-1 === this.utility.inArray(i, excludes.concat(memory, latestOpenedCards))) {
				indexes[indexes.length] = i;
			}
		}
		if (0 == indexes.length) {
			for (var i = 0, ___len = this.cards().findAll().length; i < ___len; i++) {
				if (-1 === this.utility.inArray(i, excludes)) {
					indexes[indexes.length] = i;
				}
			}
		}
		return indexes[Math.floor(Math.random() * indexes.length)];
	};
	
	/**
	 * Forget
	 * 
	 * @param {Number} [numberOfTimes]
	 * @returns {Boolean}
	 */
	TagDam_App_Model_PelmanismNineBall_Game_Player_Computer_Abstract.prototype.forget = function(numberOfTimes) {
		var forgettingRate = this.forgettingRate();
		if ((0 == forgettingRate)
				|| ((forgettingRate * 100) < Math.floor(Math.random() * 101))) {
			return false;
		}
		return true;
	};
	
	/**
	 * To Object
	 * 
	 * @returns {Object}
	 */
	TagDam_App_Model_PelmanismNineBall_Game_Player_Computer_Abstract.prototype.toObject = function() {
		var object = TagDam_App_Model_PelmanismNineBall_Game_Player_Abstract.prototype.toObject.call(this);
		object['forgettingRate'] = this.forgettingRate();
		object['memory'] = this.memory().toObject();
		return object;
	};
	
	/**
	 * To Object
	 * 
	 * @param {Object} [data]
	 * @returns void
	 */
	TagDam_App_Model_PelmanismNineBall_Game_Player_Computer_Abstract.prototype.import = function(data) {
		TagDam_App_Model_PelmanismNineBall_Game_Player_Abstract.prototype.import.call(this, data);
		this._forgettingRate = data.forgettingRate;
		this.memory().import(data.memory);
	};
	
	/**
	 * Cache
	 *   {
	 *     Number forgettingRate: {
	 *       Number cardValue: {
	 *         Number numberOfTimes: [
	 *           Number cardIndex
	 *         ]
	 *       }
	 *     }
	 *   }
	 * 
	 * @var {Object}
	 */
	TagDam_App_Model_PelmanismNineBall_Game_Memory.prototype._cache = {};
	
	/**
	 * Data
	 * 
	 * @var {Array}
	 */
	TagDam_App_Model_PelmanismNineBall_Game_Memory.prototype._data = [];
	
	/**
	 * Is Cache
	 * 
	 * @param {Number} [forgettingRate] Forgetting Rate
	 * @param {Number} [value] Card Value
	 * @returns {Boolean}
	 */
	TagDam_App_Model_PelmanismNineBall_Game_Memory.prototype.isCache = function(forgettingRate, value) {
		if (this.utility.isObject(this._cache[forgettingRate])
				&& this.utility.isObject(this._cache[forgettingRate][value])
				&& this.utility.isArray(this._cache[forgettingRate][value][this.manager().numberOfTimes()])
				&& (this._find(forgettingRate, value).length == this._cache[forgettingRate][value][this.manager().numberOfTimes()].length)) {
			return true;
		}
		return false;
	};
	
	/**
	 * Set the Cache
	 * 
	 * @param {Number} [forgettingRate] Forgetting Rate
	 * @param {Number} [value] Card Value
	 * @param {Array} [indexes] Card Indexes
	 * @returns void
	 */
	TagDam_App_Model_PelmanismNineBall_Game_Memory.prototype.setCache = function(forgettingRate, value, indexes) {
		if (0 < indexes.length) {
			if (!this.utility.isObject(this._cache[forgettingRate])) {
				this._cache[forgettingRate] = {};
				this._cache[forgettingRate][value] = {};
			} else if (!this.utility.isObject(this._cache[forgettingRate][value])) {
				this._cache[forgettingRate][value] = {};
			}
			this._cache[forgettingRate][value][this.manager().numberOfTimes()] = indexes;
		}
	};
	
	/**
	 * Get the Cache
	 * 
	 * @param {Number} [forgettingRate] Forgetting Rate
	 * @param {Number} [value] Card Value
	 * @returns {Array} Card Indexes
	 */
	TagDam_App_Model_PelmanismNineBall_Game_Memory.prototype.getCache = function(forgettingRate, value) {
		var indexes = [];
		if (this.isCache(forgettingRate, value)) {
			indexes = indexes.concat(this._cache[forgettingRate][value][this.manager().numberOfTimes()]);
		}
		return indexes;
	};
	
	/**
	 * Add the Memory
	 * 
	 * @param {Number} [value] Card Value
	 * @param {Number} [index] Card Index
	 * @returns void
	 */
	TagDam_App_Model_PelmanismNineBall_Game_Memory.prototype.save = function(value, index) {
		if (!this.utility.isObject(this._data[value])) {
			this._data[value] = {};
		}
		this._data[value][index] = this.manager().numberOfTimes();
	};
	
	/**
	 * Find
	 * 
	 * @param {Number} [forgettingRate] Forgetting Rate
	 * @param {Number} [value] Card Value
	 * @returns {Array} Card Indexes
	 */
	TagDam_App_Model_PelmanismNineBall_Game_Memory.prototype.find = function(forgettingRate, value) {
		if (!this.isCache(forgettingRate, value)) {
			var indexes = this._find(forgettingRate, value);
			this.setCache(forgettingRate, value, indexes);
			return indexes;
		}
		return this.getCache(forgettingRate, value);
	};
	
	/**
	 * Find
	 * 
	 * @param {Number} [forgettingRate] Forgetting Rate
	 * @param {Number} [value] Card Value
	 * @returns {Array} Card Indexes
	 */
	TagDam_App_Model_PelmanismNineBall_Game_Memory.prototype._find = function(forgettingRate, value) {
		var forget = function(numberOfTimes) {
			if ((0 == forgettingRate)
					|| ((forgettingRate * 100) < Math.floor(Math.random() * 101))) {
				return false;
			}
			return true;
		};
		var indexes = [];
		var memory = this._data[value];
		for (var index in memory) {
			if (!forget(memory[index])) {
				indexes[indexes.length] = Number(index);
			}
		}
		return indexes;
	};
	
	/**
	 * Clear
	 * 
	 * @returns void
	 */
	TagDam_App_Model_PelmanismNineBall_Game_Memory.prototype.clear = function() {
		this._data = [];
		this._cache = {};
	};
	
	/**
	 * To the Object
	 * 
	 * @returns {Array}
	 */
	TagDam_App_Model_PelmanismNineBall_Game_Memory.prototype.toObject = function() {
		return {
			data: this._data,
			cache: this._cache
		};
	};
	
	/**
	 * Import
	 * 
	 * @param {Object} [data]
	 * @returns void
	 */
	TagDam_App_Model_PelmanismNineBall_Game_Memory.prototype.import = function(data) {
		this._data = data.data;
		this._cache = data.cache;
	};
	
	/**
	 * Index
	 * 
	 * @var {TagDam_App_View_PelmanismNineBall_Index}
	 */
	TagDam_App_View_PelmanismNineBall_Abstract.prototype._index = new TagDam_App_View_PelmanismNineBall_Index();
	
	/**
	 * Index
	 * 
	 * @returns {TagDam_App_View_PelmanismNineBall_Index}
	 */
	TagDam_App_View_PelmanismNineBall_Abstract.prototype.index = function() {
		return this._index;
	};
	
	/**
	 * Settings
	 * 
	 * @var {TagDam_App_View_PelmanismNineBall_Settings}
	 */
	TagDam_App_View_PelmanismNineBall_Abstract.prototype._settings = new TagDam_App_View_PelmanismNineBall_Settings();
	
	/**
	 * Settings
	 * 
	 * @returns {TagDam_App_View_PelmanismNineBall_Settings}
	 */
	TagDam_App_View_PelmanismNineBall_Abstract.prototype.settings = function() {
		return this._settings;
	};
	
	/**
	 * Single Play
	 * 
	 * @var {TagDam_App_View_PelmanismNineBall_Game}
	 */
	TagDam_App_View_PelmanismNineBall_Abstract.prototype._game = new TagDam_App_View_PelmanismNineBall_Game();
	
	/**
	 * Game
	 * 
	 * @returns {TagDam_App_View_PelmanismNineBall_Game}
	 */
	TagDam_App_View_PelmanismNineBall_Abstract.prototype.game = function() {
		return this._game;
	};
	
	/**
	 * Game Over
	 * 
	 * @var {TagDam_App_View_PelmanismNineBall_GameOver}
	 */
	TagDam_App_View_PelmanismNineBall_Abstract.prototype._gameOver = new TagDam_App_View_PelmanismNineBall_GameOver();
	
	/**
	 * Game Over
	 * 
	 * @var {TagDam_App_View_PelmanismNineBall_GameOver}
	 */
	TagDam_App_View_PelmanismNineBall_Abstract.prototype.gameOver = function() {
		return this._gameOver;
	};
	
	/**
	 * Update the Theme
	 * 
	 * @param {String} [theme]
	 * @returns void
	 */
	TagDam_App_View_PelmanismNineBall.prototype.updateTheme = function(theme) {
		this.pageQuery('body').attr('data-app-theme', theme);
	};
	
	/**
	 * ID
	 * 
	 * @returns {String}
	 */
	TagDam_App_View_PelmanismNineBall_Index.prototype.id = function() {
		return 'index';
	};
	
	/**
	 * Index Page
	 * 
	 * @returns {jQuery}
	 */
	TagDam_App_View_PelmanismNineBall_Index.prototype.page = function() {
		return this.getById(this.id());
	};
	
	/**
	 * Menu Container
	 * 
	 * @returns {jQuery}
	 */
	TagDam_App_View_PelmanismNineBall_Index.prototype.menuContainer = function() {
		return this.page().find('.menu');
	};
	
	/**
	 * Menus
	 * 
	 * @returns {jQuery}
	 */
	TagDam_App_View_PelmanismNineBall_Index.prototype.menus = function() {
		return this.menuContainer().find('>li');
	};
	
	/**
	 * ID
	 * 
	 * @returns {String}
	 */
	TagDam_App_View_PelmanismNineBall_Settings.prototype.id = function() {
		return 'settings';
	};
	
	/**
	 * Optoins Page
	 * 
	 * @returns {jQuery}
	 */
	TagDam_App_View_PelmanismNineBall_Settings.prototype.page = function() {
		return this.getById(this.id());
	};
	
	/**
	 * Open
	 * 
	 * @returns void
	 */
	TagDam_App_View_PelmanismNineBall_Settings.prototype.open = function() {
		this.page().panel('open');
	};
	
	/**
	 * Close
	 * 
	 * @returns void
	 */
	TagDam_App_View_PelmanismNineBall_Settings.prototype.close = function() {
		this.page().panel('close');
	};
	
	/**
	 * Toggle
	 * 
	 * @returns void
	 */
	TagDam_App_View_PelmanismNineBall_Settings.prototype.toggle= function() {
		this.page().panel('toggle');
	};
	
	/**
	 * Language Field
	 * 
	 * @returns {jQuery}
	 */
	TagDam_App_View_PelmanismNineBall_Settings.prototype.languageField = function() {
		return this.page().find('[name="language"]');
	};
	
	/**
	 * Vibration Field
	 * 
	 * @returns {jQuery}
	 */
	TagDam_App_View_PelmanismNineBall_Settings.prototype.vibrationField = function() {
		return this.page().find('[name="vibration"]');
	};
	
	/**
	 * Theme Field
	 * 
	 * @returns {jQuery}
	 */
	TagDam_App_View_PelmanismNineBall_Settings.prototype.themeField = function() {
		return this.page().find('[name="theme"]');
	};
	
	/**
	 * Cards
	 * 
	 * @var {TagDam_App_View_PelmanismNineBall_Game_Cards}
	 */
	TagDam_App_View_PelmanismNineBall_Game_Abstract.prototype._cards = new TagDam_App_View_PelmanismNineBall_Game_Cards();
	
	/**
	 * Continue
	 * 
	 * @var {String}
	 */
	TagDam_App_View_PelmanismNineBall_Game_Abstract.prototype._continuePopup = new TagDam_App_View_PelmanismNineBall_Game_Continue();
	
	/**
	 * Page ID
	 * 
	 * @var {String}
	 */
	TagDam_App_View_PelmanismNineBall_Game_Abstract.prototype._id = 'game';
	
	/**
	 * Judge
	 * 
	 * @var {TagDam_App_View_PelmanismNineBall_Game_Judge}
	 */
	TagDam_App_View_PelmanismNineBall_Game_Abstract.prototype._judge = new TagDam_App_View_PelmanismNineBall_Game_Judge();
	
	/**
	 * Players
	 * 
	 * @var {TagDam_App_View_PelmanismNineBall_Game_Players}
	 */
	TagDam_App_View_PelmanismNineBall_Game_Abstract.prototype._players = new TagDam_App_View_PelmanismNineBall_Game_Players();
	
	/**
	 * Targets
	 * 
	 * @var {TagDam_App_View_PelmanismNineBall_Game_Targets}
	 */
	TagDam_App_View_PelmanismNineBall_Game_Abstract.prototype._targets = new TagDam_App_View_PelmanismNineBall_Game_Targets();
	
	/**
	 * Cards
	 * 
	 * @returns {TagDam_App_View_PelmanismNineBall_Game_Cards}
	 */
	TagDam_App_View_PelmanismNineBall_Game_Abstract.prototype.cards = function() {
		return this._cards;
	};
	
	/**
	 * Click to Home Button
	 * 
	 * @reutnrs void
	 */
	TagDam_App_View_PelmanismNineBall_Game_Abstract.prototype.clickToHomeButton = function() {
		this.pageQuery('a[href="#game-Popup-goTitlePage"]').trigger('click');
	};
	
	/**
	 * Continue
	 * 
	 * @returns {TagDam_App_View_PelmanismNineBall_Game_Continue}
	 */
	TagDam_App_View_PelmanismNineBall_Game_Abstract.prototype.continuePopup = function() {
		return this._continuePopup;
	};
	
	/**
	 * Page ID
	 * 
	 * @return {String}
	 */
	TagDam_App_View_PelmanismNineBall_Game_Abstract.prototype.id = function() {
		return this._id;
	};
	
	/**
	 * Judge
	 * 
	 * @returns {TagDam_App_View_PelmanismNineBall_Game_Judge}
	 */
	TagDam_App_View_PelmanismNineBall_Game_Abstract.prototype.judge = function() {
		return this._judge;
	};
	
	/**
	 * Single Play Page
	 * 
	 * @returns {jQuery}
	 */
	TagDam_App_View_PelmanismNineBall_Game_Abstract.prototype.page = function() {
		return this.getById(this.id());
	};
	
	/**
	 * Players
	 * 
	 * @returns {TagDam_App_View_PelmanismNineBall_Game_Players}
	 */
	TagDam_App_View_PelmanismNineBall_Game_Abstract.prototype.players = function() {
		return this._players;
	};
	
	/**
	 * Targets
	 * 
	 * @returns {TagDam_App_View_PelmanismNineBall_Game_Targets}
	 */
	TagDam_App_View_PelmanismNineBall_Game_Abstract.prototype.targets = function() {
		return this._targets;
	};
	
	/**
	 * Players Container
	 * 
	 * @returns {jQuery}
	 */
	TagDam_App_View_PelmanismNineBall_Game_Players.prototype.container = function() {
		return this.page().find('.players');
	};
	
	/**
	 * Initialize the Players
	 * 
	 * @param {Array} [players]
	 * @returns void
	 */
	TagDam_App_View_PelmanismNineBall_Game_Players.prototype.init = function(players) {
		var playerContainers = this.container().children();
		var name;
		for (var i = 0, ___len = players.length; i < ___len; i++) {
			name = players[i].name();
			playerContainers.eq(i).attr('data-text-id', name).text(this.translate._(name));
		}
	};
	
	/**
	 * Update the Players
	 * 
	 * @param {String} [name] Current player name
	 * @returns void
	 */
	TagDam_App_View_PelmanismNineBall_Game_Players.prototype.update = function(name) {
		var className = 'current';
		this.container().children().removeClass(className).filter('[data-text-id="' + name + '"]').addClass(className);
	};
	
	/**
	 * Container
	 * 
	 * @returns {jQuery}
	 */
	TagDam_App_View_PelmanismNineBall_Game_Cards.prototype.container = function() {
		return this.page().find('.cards');
	};
	
	/**
	 * Find All
	 * 
	 * @returns {jQuery}
	 */
	TagDam_App_View_PelmanismNineBall_Game_Cards.prototype.findAll = function() {
		return this.page().find('.cards>li');
	};
	
	/**
	 * Find the Cards
	 * 
	 * @param {Number|Array} [indexes] (Option)
	 * @returns {jQuery}
	 */
	TagDam_App_View_PelmanismNineBall_Game_Cards.prototype.find = function(indexes) {
		var cards = this.findAll();
		if (this.utility.isNumeric(indexes)) {
			cards = cards.eq(indexes);
		} else if (this.utility.isArray(indexes)) {
			var _cards = cards;
			cards = _cards.eq(indexes[0]);
			for (var i = 1, ___len = indexes.length; i < ___len; i++) {
				cards = cards.add(_cards.eq(indexes[i]));
			}
		}
		return cards;
	};
	
	/**
	 * Open the Card
	 * 
	 * @param {Number} [index]
	 * @param {Number} [value]
	 * @returns {jQuery}
	 */
	TagDam_App_View_PelmanismNineBall_Game_Cards.prototype.open = function(index, value) {
		return this.find(index).attr('data-status', 'open').attr('data-value', value);
	};
	
	/**
	 * Close the Cards
	 * 
	 * @param {Number|Array} [indexes]
	 * @returns {jQuery}
	 */
	TagDam_App_View_PelmanismNineBall_Game_Cards.prototype.close = function(indexes) {
		var that = this;
		return this.find(indexes).attr('data-status', 'close').each(function() {
			that.pageQuery(this).attr('data-value', null);
		});
	};
	
	/**
	 * Close the All Cards
	 * 
	 * @param {Number|Array} [indexes]
	 * @returns {jQuery}
	 */
	TagDam_App_View_PelmanismNineBall_Game_Cards.prototype.closeAll = function() {
		return this.close();
	};
	
	/**
	 * Use the Cards
	 * 
	 * @param {Number|Array} [indexes]
	 * @returns {jQuery}
	 */
	TagDam_App_View_PelmanismNineBall_Game_Cards.prototype.use = function(indexes) {
		return this.find(indexes).attr('data-status', 'used');
	};
	
	/**
	 * Show the Latest Opened Card
	 * 
	 * @param {Number} [index]
	 * @param {Number} [value]
	 * @returns {jQuery}
	 */
	TagDam_App_View_PelmanismNineBall_Game_Cards.prototype.showLatestOpenedCard = function(index, value) {
		return this.find(index).attr('data-status', 'latestOpened').attr('data-value', value);
	};
	
	/**
	 * Hide the Latest Opened Cards
	 * 
	 * @param {Number|Array} [indexes]
	 * @param {Array} [excludeIndexes]
	 * @returns {jQuery}
	 */
	TagDam_App_View_PelmanismNineBall_Game_Cards.prototype.hideLatestOpenedCards = function(indexes, excludeIndexes) {
		var that = this;
		var card;
		return this.find(indexes).filter('[data-status="latestOpened"]').each(function() {
			card = that.pageQuery(this);
			if (-1 === that.utility.inArray(card.index(), excludeIndexes)) {
				card.attr('data-status', 'close').attr('data-value', null);
			}
		});
	};
	
	/**
	 * Judge Container
	 * 
	 * @returns {jQuery}
	 */
	TagDam_App_View_PelmanismNineBall_Game_Judge.prototype.container = function() {
		return this.page().find('.judge');
	};
	
	/**
	 * Hide the Judges
	 * 
	 * @returns {jQuery}
	 */
	TagDam_App_View_PelmanismNineBall_Game_Judge.prototype.hide = function() {
		return this.container().children().hide();
	};
	
	/**
	 * Show the Judge of OK
	 * 
	 * @returns {jQuery}
	 */
	TagDam_App_View_PelmanismNineBall_Game_Judge.prototype.showOk = function() {
		return this.container().children().filter('[data-value="OK"]').addClass('animated pulse').show();
	};
	
	/**
	 * Show the Judge of Bad
	 * 
	 * @returns {jQuery}
	 */
	TagDam_App_View_PelmanismNineBall_Game_Judge.prototype.showBad = function() {
		return this.container().children().filter('[data-value="Bad"]').addClass('animated pulse').show();
	};
	
	/**
	 * Targets Container
	 * 
	 * @returns {jQuery}
	 */
	TagDam_App_View_PelmanismNineBall_Game_Targets.prototype.container = function() {
		return this.page().find('.targets');
	};
	
	/**
	 * Target
	 * 
	 * @param {Number} [target] Target Value
	 * @returns {jQuery}
	 */
	TagDam_App_View_PelmanismNineBall_Game_Targets.prototype.target = function(target) {
		return this.container().find('[data-value="' + target + '"]');
	};
	
	/**
	 * Update the Target
	 * 
	 * @param {Number} [target] Target Value
	 * @returns void
	 */
	TagDam_App_View_PelmanismNineBall_Game_Targets.prototype.update = function(target) {
		this.container().attr('data-target', target);
	};
	
	/**
	 * ID
	 * 
	 * @returns {String}
	 */
	TagDam_App_View_PelmanismNineBall_Game_Continue.prototype.id = function() {
		return 'play-continue';
	};
	
	/**
	 * Get the Popup
	 * 
	 * @returns {jQuery}
	 */
	TagDam_App_View_PelmanismNineBall_Game_Continue.prototype.popup = function() {
		return this.getById(this.id());
	};
	
	/**
	 * Open
	 * 
	 * @returns void
	 */
	TagDam_App_View_PelmanismNineBall_Game_Continue.prototype.open = function() {
		this.pageQuery('a[href="#' + this.id() + '"]').trigger('click');
//		this.popup().popup('open', {
//			positionTo: 'window'
//		});
	};
	
	/**
	 * Close
	 * 
	 * @returns void
	 */
	TagDam_App_View_PelmanismNineBall_Game_Continue.prototype.close = function() {
		this.popup().popup('close');
	};
	
	/**
	 * Buttons
	 * 
	 * @returns {jQuery}
	 */
	TagDam_App_View_PelmanismNineBall_Game_Continue.prototype.buttons = function() {
		return this.popup().find('[data-value]');
	};
	
	/**
	 * Continue Button
	 * 
	 * @returns {jQuery}
	 */
	TagDam_App_View_PelmanismNineBall_Game_Continue.prototype.buttonOfContinue = function() {
		return this.popup().find('a.continue');
	};
	
	/**
	 * New Button
	 * 
	 * @returns {jQuery}
	 */
	TagDam_App_View_PelmanismNineBall_Game_Continue.prototype.buttonOfNew = function() {
		return this.popup().find('a.new');
	};
	
	/**
	 * ID
	 * 
	 * @returns {String}
	 */
	TagDam_App_View_PelmanismNineBall_GameOver.prototype.id = function() {
		return 'gameOver';
	};
	
	/**
	 * Game Over Page
	 * 
	 * @returns {jQuery}
	 */
	TagDam_App_View_PelmanismNineBall_GameOver.prototype.page = function() {
		return this.getById(this.id());
	};
	
	/**
	 * Winner
	 * 
	 * @returns {jQuery}
	 */
	TagDam_App_View_PelmanismNineBall_GameOver.prototype.winner = function() {
		return this.page().find('.winner');
	};
	
	/**
	 * Update the Winner
	 * 
	 * @param {String} [name]
	 * @returns {jQuery}
	 */
	TagDam_App_View_PelmanismNineBall_GameOver.prototype.updateWinner = function(name) {
		var attrName = 'data-winner';
		this.winner().attr(attrName, this.translate._(name)).attr('data-i18n-attr', (attrName + ' ' + name));
	};
	
	/**
	 * Menus
	 * 
	 * @returns {jQuery}
	 */
	TagDam_App_View_PelmanismNineBall_GameOver.prototype.menus = function() {
		return this.page().find('.menu');
	};
	
	/**
	 * Show the Menus
	 * 
	 * @return void
	 */
	TagDam_App_View_PelmanismNineBall_GameOver.prototype.showMenus = function() {
		var that = this;
		window.setTimeout(function() {
			that.menus().show();
		}, 2000);
	};
	
	/**
	 * Hide the Menus
	 * 
	 * @return void
	 */
	TagDam_App_View_PelmanismNineBall_GameOver.prototype.hideMenus = function() {
		this.menus().hide();
	};
	
	/**
	 * Battle
	 * 
	 * @var {TagDam_App_Model_PelmanismNineBall}
	 */
	TagDam_App_Controller_PelmanismNineBall_Abstract.prototype._model = new TagDam_App_Model_PelmanismNineBall();
	
	/**
	 * Battle
	 * 
	 * @returns {TagDam_App_Model_PelmanismNineBall}
	 */
	TagDam_App_Controller_PelmanismNineBall_Abstract.prototype.model = function() {
		return this._model;
	};
	
	/**
	 * View
	 * 
	 * @var {TagDam_App_View_PelmanismNineBall}
	 */
	TagDam_App_Controller_PelmanismNineBall_Abstract.prototype._view = new TagDam_App_View_PelmanismNineBall();
	
	/**
	 * View
	 * 
	 * @returns {TagDam_App_View_PelmanismNineBall}
	 */
	TagDam_App_Controller_PelmanismNineBall_Abstract.prototype.view = function() {
		return this._view;
	};
	
	/**
	 * Play
	 * 
	 * @var {TagDam_App_Controller_PelmanismNineBall_Game}
	 */
	TagDam_App_Controller_PelmanismNineBall_Abstract.prototype._game = new TagDam_App_Controller_PelmanismNineBall_Game();
	
	/**
	 * Play
	 * 
	 * @returns {TagDam_App_Controller_PelmanismNineBall_Game}
	 */
	TagDam_App_Controller_PelmanismNineBall_Abstract.prototype.game = function() {
		return this._game;
	};
	
	/**
	 * Settings
	 * 
	 * @var {TagDam_App_Controller_PelmanismNineBall_Settings}
	 */
	TagDam_App_Controller_PelmanismNineBall_Abstract.prototype._settings = new TagDam_App_Controller_PelmanismNineBall_Settings();
	
	/**
	 * Settings
	 * 
	 * @returns {TagDam_App_Controller_PelmanismNineBall_Settings}
	 */
	TagDam_App_Controller_PelmanismNineBall_Abstract.prototype.settings = function() {
		return this._settings;
	};
	
	/**
	 * Show the Title Page
	 * 
	 * @returns void
	 */
	TagDam_App_Controller_PelmanismNineBall_Abstract.prototype.showTitlePage = function() {
		this.changePage(this.view().index().id());
	};
	
	/**
	 * Show the Battle Page
	 * 
	 * @returns void
	 */
	TagDam_App_Controller_PelmanismNineBall_Abstract.prototype.showBattlePage = function() {
		this.changePage(this.view().game().id());
	};
	
	/**
	 * Show the Game Over Page
	 * 
	 * @returns void
	 */
	TagDam_App_Controller_PelmanismNineBall_Abstract.prototype.showGameOverPage = function() {
		this.changePage(this.view().gameOver().id());
	};
	
	/**
	 * Initialized
	 * 
	 * @var {Boolean}
	 */
	TagDam_App_Controller_PelmanismNineBall.prototype._initialized = false;
	
	/**
	 * Init
	 * 
	 * @returns void
	 */
	TagDam_App_Controller_PelmanismNineBall.prototype.init = function() {
		this.model().updateDeviceLanguage();
		if (!this._initialized && (this._initialized = true)) {
			var that = this;
			this.language.key('TagDam_App_PelmanismNineBall_Language');
			this.pageQuery(document).on('pagebeforecreate', function(event) {
				that.view().translateOfPage(that.pageQuery(event.target));
			});
			this.pageQuery(document).on('pagebeforeshow', function(event) {
				that.view().translateOfPage(that.pageQuery(event.target));
			});
		}
	};
	
	/**
	 * Start Process
	 * 
	 * @returns void
	 */
	TagDam_App_Controller_PelmanismNineBall.prototype.start = function() {
		var that = this;
		this.init();
		this.indexAction();
		this.settings().indexAction();
		this.game().indexAction();
		this.game().continueAction();
//		this.battleContinueAction();
		this.gameOverAction();
		
		this.pageQuery('.pr').on('tap', 'a[href^="http"]', function() {
//			alert(that.pageQuery(this).attr('href'));
			window.open(that.pageQuery(this).attr('href'), '_blank', 'location=yes');
			return false;
		});
		
//		// TODO Remove
//		this.view().game().page().on('pagecontainerchangefailed', function() {
//			alert('エラーが発生しました！');
//		});
	};
	
	/**
	 * Index Action
	 * 
	 * @returns void
	 */
	TagDam_App_Controller_PelmanismNineBall.prototype.indexAction = function() {
//		this.view().translateOfPageByPageId('index');
		var that = this;
		var pageId = this.view().index().id();
//		var menuEventsName = 'vclick.pelmanismNineBall-title-menu';
		var menuOfComputerBattleEventsName = 'change.PelmanismNineBall-Title-Menu-ComputerBattle';
		var menuOfPlayersBattleEventsName = 'vclick.PelmanismNineBall-Title-Menu-PlayersBattle';
		this.pageHandler().setPageBeforeShowHandler(pageId, function() {
			that.view().index().menuContainer().on(
					menuOfComputerBattleEventsName,
					'#onePlayerVersusComputer,#computerVersusOnePlayer',
					function(event) {
				var item = that.pageQuery(this);
				that.game().start(item.attr('name'), item.val());
				item.val('').selectmenu('refresh');
			}).on(menuOfPlayersBattleEventsName, '#onePlayerVersusTwoPlayer-button', function(event) {
				event.preventDefault();
				that.game().start('onePlayerVersusTwoPlayer');
			});
//			that.view().index().menuContainer().on(menuEventsName, '[data-mode="1PlayerVersusComputer"],[data-mode="ComputerVersus1Player"],[data-mode="1PlayerVersus2Player"]', function(e) {
//				that.game().start(that.pageQuery(this).attr('data-mode'));
//			});
		});
		this.pageHandler().setPageBeforeHideHandler(pageId, function() {
			that.view().index().menuContainer().off(menuOfComputerBattleEventsName).off(menuOfPlayersBattleEventsName);
//			that.view().index().menuContainer().off(menuEventsName);
		});
	};
	
	/**
	 * Play Action
	 * 
	 * @returns void
	 */
	TagDam_App_Controller_PelmanismNineBall_Game.prototype.indexAction = function() {
		var that = this;
		var pageId = this.view().game().id();
		var navigateEventsName = 'navigate.pelmanismNineBall-play-navigate';
		var keydownEventsName = 'keydown.pelmanismNineBall-play-keydown';
		var backButtonEventsName = 'backbutton.pelmanismNineBall-play-keydown';
		var cardsEventsName = 'vmousedown.pelmanismNineBall-play-cards';
		var goToBackProcess = function(event) {
			event.preventDefault();
			that.view().game().clickToHomeButton();
		};
		this.pageHandler().setPageBeforeShowHandler(pageId, function() {
			
			that.pageQuery(window).on(navigateEventsName, function(event, data) {
				if ('back' == data.state.direction) {
					goToBackProcess(event);
				}
			});
			that.pageQuery(document).on(keydownEventsName, function(event) {
				if ((8 === event.keyCode)
						|| (event.altKey && (37 === event.keyCode))) {
					goToBackProcess(event);
				}
			});
			that.pageQuery(document).on(backButtonEventsName, goToBackProcess);
			
			if (!that.model().game().manager().hasLatestSaveKey()) {
				that.showTitlePage();
			} else {
				if (that.model().game().players().isEmpty()) {
					that.model().game().manager().load(that.model().game().manager().latestSaveKey());
				}
				if (that.model().game().manager().hasContinue()) {
					that.view().game().continuePopup().open();
				} else if (that.model().game().manager().isEnd()) {
					that.restart();
				} else {
					that.play();
				}
				that.view().game().cards().container().on(cardsEventsName, '[data-status="close"],[data-status="latestOpened"]', function() {
					if (that.availableOpenCard()) {
						that.openCardByUser(that.pageQuery(this).index());
					}
				});
			}
		});
		this.pageHandler().setPageBeforeHideHandler(pageId, function() {
			that.pageQuery(window).off(navigateEventsName);
			that.pageQuery(document).off(keydownEventsName);
			that.pageQuery(document).off(backButtonEventsName);
			that.view().game().cards().container().off(cardsEventsName);
		});
	};
	
	/**
	 * Play Continue Action
	 * 
	 * @returns void
	 */
	TagDam_App_Controller_PelmanismNineBall_Game.prototype.continueAction = function() {
		var that = this;
		var id = this.view().game().continuePopup().id();
		var buttonEvents = 'vclick.pelmanismNineBall-play-continue-buttons';
		this.pageHandler().setPopupBeforePositionHandler(id, function() {
			that.view().game().continuePopup().buttons().on(buttonEvents, function() {
				switch (that.pageQuery(this).attr('data-value')) {
				case 'Continue':
					that.continueGame();
					break;
				default:
					that.restart();
					break;
				}
			});
		});
		this.pageHandler().setPopupAfterCloseHandler(id, function() {
			that.view().game().continuePopup().buttons().off(buttonEvents);
		});
	};
	
	/**
	 * Available Open Card
	 * 
	 * @var {Boolean}
	 */
	TagDam_App_Controller_PelmanismNineBall_Game.prototype._availableOpenCard = false;
	
	/**
	 * Available Open Card
	 * 
	 * @returns {Boolean}
	 */
	TagDam_App_Controller_PelmanismNineBall_Game.prototype.availableOpenCard = function() {
		return (this._availableOpenCard && this.model().game().cards().needOpenCardMore());
	};
	
	/**
	 * To the Available Open Card
	 * 
	 * @returns {Boolean}
	 */
	TagDam_App_Controller_PelmanismNineBall_Game.prototype.toAvailableOpenCard = function() {
		this._availableOpenCard = true;
	};
	
	/**
	 * To the Not Available Open Card
	 * 
	 * @returns {Boolean}
	 */
	TagDam_App_Controller_PelmanismNineBall_Game.prototype.toNotAvailableOpenCard = function() {
		this._availableOpenCard = false;
	};
	
	/**
	 * Start the Game
	 * 
	 * @param {String} [mode]
	 * @param {String} [level] (Option) Computer Level
	 * @returns void
	 */
	TagDam_App_Controller_PelmanismNineBall_Game.prototype.start = function(mode, level) {
		var that = this;
		var playerOfPlayer = function(name) {
			return new TagDam_App_Model_PelmanismNineBall_Game_Player_User(name);
		};
		var playerOfComputer = function() {
			return new TagDam_App_Model_PelmanismNineBall_Game_Player_Computer(that.computerName(level), that.levelToForgettingRate(level));
		};
		var saveKey = null;
		var players = [];
		var continueGame = false;
		switch (mode) {
		case 'computerVersusOnePlayer':
			saveKey = ('TagDam_App_Controller_PelmanismNineBall_Game_CPU-1P-' + level);
			if (this.model().game().manager().hasContinue(saveKey)) {
				continueGame = true;
			} else {
				players[players.length] = playerOfComputer();
				players[players.length] = playerOfPlayer('PelmanismNineBall_Game_Player_Name_Player_One');
			}
			break;
		case 'onePlayerVersusTwoPlayer':
			saveKey = 'TagDam_App_Controller_PelmanismNineBall_Game_1P-2P';
			if (this.model().game().manager().hasContinue(saveKey)) {
				continueGame = true;
			} else {
				players[players.length] = playerOfPlayer('PelmanismNineBall_Game_Player_Name_Player_One');
				players[players.length] = playerOfPlayer('PelmanismNineBall_Game_Player_Name_Player_Two');
			}
			break;
		default:
			saveKey = ('TagDam_App_Controller_PelmanismNineBall_Game_1P-CPU-' + level);
			if (this.model().game().manager().hasContinue(saveKey)) {
				continueGame = true;
			} else {
				players[players.length] = playerOfPlayer('PelmanismNineBall_Game_Player_Name_Player_One');
				players[players.length] = playerOfComputer();
			}
			break;
		}
		if (continueGame) {
			this.model().game().manager().load(saveKey);
		} else {
			this.model().game().start(players, saveKey);
		}
		this.reset();
		this.showBattlePage();
	};
	
	/**
	 * Level to Forgetting Rate
	 * 
	 * @param {String} [level]
	 * @returns {Number}
	 */
	TagDam_App_Controller_PelmanismNineBall_Game.prototype.levelToForgettingRate = function(level) {
		var rate;
		switch (level) {
		case 'Light':
			rate = 0.3;
			break;
		case 'Middle':
			rate = 0.1;
			break;
		default:
			rate = 0;
			break;
		}
		return rate;
	};
	
	/**
	 * Computer Name
	 * 
	 * @param {String} [level]
	 * @returns {String}
	 */
	TagDam_App_Controller_PelmanismNineBall_Game.prototype.computerName = function(level) {
		var name = 'PelmanismNineBall_Game_Player_Name_Computer';
		switch (level) {
		case 'Light':
			name = 'PelmanismNineBall_Game_Player_Name_Computer_Light';
			break;
		case 'Middle':
			name = 'PelmanismNineBall_Game_Player_Name_Computer_Middle';
			break;
		case 'Heavy':
			name = 'PelmanismNineBall_Game_Player_Name_Computer_Heavy';
			break;
		default:
			break;
		}
		return name;
	};
	
	/**
	 * Reset
	 * 
	 * @returns void
	 */
	TagDam_App_Controller_PelmanismNineBall_Game.prototype.reset = function() {
		this.view().game().cards().closeAll();
		this.view().game().judge().hide();
		this.view().game().players().update(this.model().game().players().current().name());
		this.view().game().targets().update(this.model().game().targets().current());
		if (this.model().game().manager().hasContinue()) {
			this.updateLatestOpenedCards();
			this.continueOpenCards();
			this.continueUsedCards();
		}
	};
	
	/**
	 * Play
	 * 
	 * @returns void
	 */
	TagDam_App_Controller_PelmanismNineBall_Game.prototype.play = function() {
		this.view().game().players().init(this.model().game().players().findAll());
		this.reset();
		if (this.model().game().players().current().isComputer()) {
			var that = this;
			window.setTimeout(function() {
//				that.openCardByComputer();
				if (that.model().game().cards().needOpenCardMore()) {
					that.openCardByComputer();
				} else {
					that.judge();
				}
			}, 1500);
		} else {
			this.toAvailableOpenCard();
		}
	};
	
	/**
	 * Restart
	 * 
	 * @returns void
	 */
	TagDam_App_Controller_PelmanismNineBall_Game.prototype.restart = function() {
		this.model().game().restart();
		this.play();
	};
	
	/**
	 * Continue the Game
	 * 
	 * @returns void
	 */
	TagDam_App_Controller_PelmanismNineBall_Game.prototype.continueGame = function() {
		this.play();
	};
	
	/**
	 * Open the Card by User
	 * 
	 * @param {Number} [index] Card Index
	 * @returns void
	 */
	TagDam_App_Controller_PelmanismNineBall_Game.prototype.openCardByUser = function(index) {
		// TODO HTML操作によるカードのインデックス変更対策
		var value = this.model().game().cards().openCard(index);
		if (-1 !== value) {
			this.view().game().cards().hideLatestOpenedCards();
			this.view().game().cards().open(index, value);
			if (!this.availableOpenCard()) {
				this.toNotAvailableOpenCard();
				this.judge();
			}
		}
	};
	
	/**
	 * Open the Card by Computer
	 * 
	 * @reutnrs void
	 */
	TagDam_App_Controller_PelmanismNineBall_Game.prototype.openCardByComputer = function() {
		var that = this;
		var index = this.model().game().players().current().selectCard();
		var value = this.model().game().cards().openCard(index);
		if (-1 !== value) {
			this.view().game().cards().hideLatestOpenedCards();
			window.setTimeout(function() {
				that.view().game().cards().open(index, value);
				if (that.model().game().cards().needOpenCardMore()) {
					that.openCardByComputer();
				} else {
					window.setTimeout(function() {
						that.judge();
					}, 500);
				}
			}, 300);
		}
	};
	
	/**
	 * Judge Action
	 * 
	 * @returns void
	 */
	TagDam_App_Controller_PelmanismNineBall_Game.prototype.judge = function() {
		var that = this;
		var indexes = this.model().game().cards().openCards();
		var judge = this.model().game().judge();
		var player;
		if (judge) {
			this.model().vibrate(500);
			this.view().game().judge().showOk();
			this.view().game().cards().use(indexes);
			window.setTimeout(function() {
				that.view().game().judge().hide();
				if (that.model().game().targets().hasCurrent()) {
					player = that.model().game().players().current();
					that.view().game().targets().update(that.model().game().targets().current());
					if (player.isComputer()) {
						that.openCardByComputer();
					} else {
						that.toAvailableOpenCard();
					}
				} else {
					that.showGameOverPage();
				}
			}, 1000);
		} else {
			this.model().vibrate([50]);
			this.view().game().judge().showBad();
			window.setTimeout(function() {
				player = that.model().game().players().current();
				that.view().game().cards().close(indexes);
				that.view().game().judge().hide();
				that.view().game().players().update(player.name());
				that.updateLatestOpenedCards();
				if (player.isComputer()) {
					that.openCardByComputer();
				} else {
					that.toAvailableOpenCard();
				}
			}, 1000);
		}
	};
	
	/**
	 * Show the Latest Opened Cards
	 * 
	 * @returns void
	 */
	TagDam_App_Controller_PelmanismNineBall_Game.prototype.updateLatestOpenedCards = function() {
		var indexes = this.model().game().players().latestOpenedCards();
		this.view().game().cards().hideLatestOpenedCards(null, indexes);
		for (var i = 0, ___len = indexes.length; i < ___len; i++) {
			this.view().game().cards().showLatestOpenedCard(indexes[i], this.model().game().cards().find(indexes[i]));
		}
	};
	
	/**
	 * Continue the Game
	 * 
	 * @returns void
	 */
	TagDam_App_Controller_PelmanismNineBall_Game.prototype.continueOpenCards = function() {
		var openCards = this.model().game().cards().openCards();
		var card = null;
		for (var i = 0, ___len = openCards.length; i < ___len; i++) {
			card = openCards[i];
			this.view().game().cards().open(card, this.model().game().cards().find(card));
		}
	};
	
	/**
	 * Continue the Game
	 * 
	 * @returns void
	 */
	TagDam_App_Controller_PelmanismNineBall_Game.prototype.continueUsedCards = function() {
		var usedCards = this.model().game().cards().usedCards();
		var cards = [];
		var card = null;
		for (var i = 0, ___len = usedCards.length; i < ___len; i++) {
			card = usedCards[i];
			cards[cards.length] = card;
			this.view().game().cards().open(card, this.model().game().cards().find(card));
		}
		this.view().game().cards().use(cards);
	};
	
	/**
	 * Settings of Index Action
	 * 
	 * @returns void
	 */
	TagDam_App_Controller_PelmanismNineBall_Settings.prototype.indexAction = function() {
		var that = this;
		var id = this.view().settings().id();
		var navigateEventsName = 'navigate.pelmanismNineBall-play-navigate';
		var keydownEventsName = 'keydown.pelmanismNineBall-play-keydown';
		var backButtonEventsName = 'backbutton.pelmanismNineBall-play-keydown';
		var validOpenSettings = function() {
			return (0 === that.pageQuery('.ui-popup-container.ui-popup-active,.ui-panel.ui-panel-open').length);
		};
		
		this.pageQuery('#' + id).panel({
			create: function(event, ui) {
				that.settings().createHandler(event, ui)
			},
			beforeopen: function() {
				var closeProcess = function(event) {
					event.preventDefault();
					that.view().settings().close();
				};
				that.settings().showHandler()
				
				that.pageQuery(window).on(navigateEventsName, function(event, data) {
					if ('back' == data.state.direction) {
						closeProcess(event);
					}
				});
				that.pageQuery(document).on(keydownEventsName, function(event) {
					if ((8 === event.keyCode)
							|| (event.altKey && (37 === event.keyCode))) {
						closeProcess(event);
					}
				});
				that.pageQuery(document).on(backButtonEventsName, closeProcess);
			},
			close: function() {
				that.settings().hideHandler()
				that.pageQuery(window).off(navigateEventsName);
				that.pageQuery(document).off(keydownEventsName);
				that.pageQuery(document).off(backButtonEventsName);
			}
		}).enhanceWithin();
		this.pageQuery('.openSettings').on('click', function(event) {
			if (validOpenSettings()) {
				that.view().settings().open();
			}
		});
		this.pageQuery(document).on('swipeleft', function(event) {
			if (((that.pageQuery(window).innerWidth() - 50) <= event.swipestart.coords[0]) && validOpenSettings()) {
				that.view().settings().open();
			}
		});
		this.pageQuery(document).on('menubutton', function() {
			if (validOpenSettings()) {
				that.view().settings().toggle();
			}
		});
		
//		this.pageHandler().setPageBeforeCreateHandler(id, function() {
//			that.createHandler();
//		});
//		this.pageHandler().setPageBeforeShowHandler(id, function() {
//			that.showHandler();
//		});
//		this.pageHandler().setPageBeforeHideHandler(id, function() {
//			that.hideHandler();
//		});
	};
	
	/**
	 * Language Field Events
	 * 
	 * @reutnrs {String}
	 */
	TagDam_App_Controller_PelmanismNineBall_Settings.prototype.languageFieldEvents = function() {
		return 'change.pelmanismNineBall-settings-language';
	};
	
	/**
	 * Vibration Field Events
	 * 
	 * @reutnrs {String}
	 */
	TagDam_App_Controller_PelmanismNineBall_Settings.prototype.vibrationFieldEvents = function() {
		return 'change.pelmanismNineBall-settings-vibration';
	};
	
	/**
	 * Create Handler
	 * 
	 * @param {Event} [event]
	 * @param {Object} [ui]
	 * @reutnrs void
	 */
	TagDam_App_Controller_PelmanismNineBall_Settings.prototype.createHandler = function(event, ui) {
		var that = this;
//		this.view().settings().languageField().val(this.language.val());
		this.view().translateOfPage(this.pageQuery(event.target));
		this.view().settings().languageField().filter('[value="' + this.language.val() + '"]').attr('checked', 'checked');
		this.model().availableVibrate(function() {
			that.view().settings().vibrationField().attr('disabled', false);
			that.view().settings().vibrationField().val(that.model().settings().vibration().val());
		}, function() {
			var className = that.view().settings().vibrationField().parent().attr('class');
			that.view().settings().vibrationField().parent().parent().find('.' + className).hide();
		});
	};
	
	/**
	 * Show Handler
	 * 
	 * @reutnrs void
	 */
	TagDam_App_Controller_PelmanismNineBall_Settings.prototype.showHandler = function() {
		var that = this;
		this.view().settings().languageField().on(this.languageFieldEvents(), function() {
			var language = that.pageQuery(this).val();
			that.view().translateOfPageByPageId(that.view().settings().id(), that.language.val(language));
			that.view().translateOfPageByPageId(that.activePageId(), language);
//			that.activePage().trigger('pagecontainerload');
		});
		this.model().availableVibrate(function() {
			that.view().settings().vibrationField().on(that.vibrationFieldEvents(), function() {
				var vibration = that.pageQuery(this).val();
				that.model().settings().vibration().val(vibration);
			});
		});
	};
	
	/**
	 * Hide Handler
	 * 
	 * @reutnrs void
	 */
	TagDam_App_Controller_PelmanismNineBall_Settings.prototype.hideHandler = function() {
		var that = this;
		this.view().settings().languageField().off(this.languageFieldEvents());
		this.model().availableVibrate(function() {
			that.view().settings().vibrationField().off(that.vibrationFieldEvents());
		});
	};
	
	/**
	 * Index Action
	 * 
	 * @returns void
	 */
	TagDam_App_Controller_PelmanismNineBall.prototype.gameOverAction = function() {
		var that = this;
		var pageId = this.view().gameOver().id();
		this.pageHandler().setPageBeforeShowHandler(pageId, function() {
			if (!that.model().game().players().isWinner()) {
				that.showTitlePage();
			} else {
				that.view().gameOver().updateWinner(that.model().game().players().winner().name());
				that.view().gameOver().showMenus();
			}
		});
		this.pageHandler().setPageBeforeHideHandler(pageId, function() {
			that.view().gameOver().hideMenus();
		});
	};
	
})(this);
