/*********************************************
 * Tululoo Game Maker v1.3.0
 *
 * Creators 
 * Zoltan Percsich
 * Vadim "YellowAfterlife" Dyachenko
 *
 * (c) SilentWorks 2011 - 2013
 * All rights reserved.
 * www.tululoo.com
 *
 * Contributors:
 * Csaba Herbut
 ********************************************/

function tu_detect_audio(_type) {
	var _au = document.createElement('audio');
	return _au.canPlayType && _au.canPlayType(_type).replace(/no/, '');
}
//
var	__path__ = window.__path__ ? window.__path__ : '',
	// system variables:
	tu_gameloop = tu_canvas = tu_context = tu_room_to_go = null, tu_canvas_id = 'tululoocanvas',
	tu_canvas_css = 'background: rgb(42, 42, 42); border: 0;',
	tu_loading = tu_load_total = 0,
	var_override_ = (Object.defineProperty != undefined),
	// resources:
	tu_sprites = [], tu_audios = [], tu_backgrounds = [], tu_fonts = [], tu_scenes = [],
	// time:
	tu_frame_time = tu_frame_step = tu_frame_el = tu_frame_count = tu_elapsed = 0,
	tu_prev_cycle_time = tu_prev_frame_time = (new Date()).getTime(),
	// math:
	max = Math.max, min = Math.min, round = Math.round, floor = Math.floor, ceil = Math.ceil,
	sin = Math.sin, cos = Math.cos, sqrt = Math.sqrt, tan = Math.tan, rand = Math.random,
	arccos = Math.acos, arcsin = Math.asin, arctan = Math.atan, arctan2 = Math.atan2,
	tu_r2d = -180 / Math.PI, tu_d2r = Math.PI / -180, tu_2pi = Math.PI * 2,
	// i/o variables:
	mouse_x = mouse_y = 0, mouse_down = mouse_pressed = mouse_released = false,
	key_down = [], key_pressed = [], key_released = [], tu_vkeys = [],
	tu_keys_pressed = [], tu_keys_released = [],
	touch_x = [], touch_y = [], touch_count = 0,
	tu_unpausekey = 27, tu_paused = false, tu_modal = null, tu_modaldraw = true,
	// i/o constants:
	vk_0 = 48, vk_1 = 49, vk_2 = 50, vk_3 = 51, vk_4 = 52, vk_5 = 53, vk_6 = 54,
	vk_7 = 55, vk_8 = 56, vk_9 = 57, vk_a = 65, vk_add = 107, vk_alt = 18, vk_b = 66,
	vk_backspace = 8, vk_c = 67, vk_ctrl = 17, vk_d = 68, vk_decimal = 110, vk_delete = 46,
	vk_divide = 111, vk_down = 40, vk_e = 69, vk_end = 35, vk_enter = 13, vk_escape = 27,
	vk_f1 = 112, vk_f2 = 113, vk_f3 = 114, vk_f4 = 115, vk_f5 = 116, vk_f6 = 117,
	vk_f7 = 118, vk_f8 = 119, vk_f9 = 120, vk_f10 = 121, vk_f11 = 122, vk_f12 = 123,
	vk_g = 71, vk_h = 72, vk_home = 36, vk_f = 70, vk_i = 73, vk_insert = 45, vk_j = 74, vk_k = 75,
	vk_l = 76, vk_left = 37, vk_m = 77, vk_multiply = 106, vk_n = 78, vk_num0 = 96, vk_num1 = 97,
	vk_num2 = 98, vk_num3 = 99, vk_num4 = 100, vk_num5 = 101, vk_num6 = 102, vk_num7 = 103,
	vk_num8 = 104, vk_num9 = 105, vk_o = 79, vk_p = 80, vk_pagedown = 34, vk_pageup = 33,
	vk_pause = 19, vk_q = 81, vk_r = 82, vk_right = 39, vk_s = 83, vk_shift = 16, vk_space = 32,
	vk_subtract = 109, vk_t = 84, vk_tab = 9, vk_u = 85, vk_up = 38, vk_v = 86, vk_w = 87,
	vk_x = 88, vk_y = 89, vk_z = 90,
	// collisions:
	ct_null = 0, ct_point = 1, ct_box = 2, ct_circle = 3,
	// tiles:
	tu_tiles = [], tu_tilesi = [], tu_tilez = 256,
	// sound variables:
	tu_wav_supported = tu_detect_audio('audio/wav; codecs="1"'),
	tu_ogg_supported = tu_detect_audio('audio/ogg; codecs="vorbis"'),
	tu_mp3_supported = tu_detect_audio('audio/mpeg;'),
	// drawing:
	tu_draw_alpha = 1, tu_draw_color_red = tu_draw_color_green = tu_draw_color_blue = 0,
	tu_draw_font = "Arial 12px", tu_draw_halign = "left", tu_draw_valign = "top",
	tu_draw_font_ = { size: 12, family: 'Arial', bold: false, italic: false },
	tu_draw_color = "rgb(" + tu_draw_color_red + "," + 
	tu_draw_color_green + "," + tu_draw_color_blue + ")", 
	tu_redraw, tu_redraw_auto = true,
	tu_viewport_inst = null,
	// drawing constants:
	fa_left = "left", fa_center = "center", fa_right = "right",
	fa_top = "top", fa_middle = "middle", fa_bottom = "bottom",
	// system room variables:
	tu_depth = [], tu_depthi = [], tu_depthu = [], tu_types = [], tu_persist = [],
	// public room variables:
	room_current = null,
	room_speed = 30, fps = room_speed,
	room_background = null,
	room_width = 0, room_height = 0,
	room_background_color_show = true, room_background_color_red = 0, 
	room_background_color_green = 0, room_background_color_blue = 0,
	room_viewport_width = 0, room_viewport_height = 0,
	room_viewport_object = null,
	room_viewport_hborder = 0, room_viewport_vborder = 0,
	room_viewport_x = 0, room_viewport_y = 0,
	global = null;
// keyboard functions:
function keyboard_check(_key) { return key_down[_key]; }
function keyboard_check_pressed(_key) { return key_pressed[_key]; }
function keyboard_check_released(_key) { return key_released[_key]; }
// mouse functions:
function mouse_check() { return mouse_down; }
function mouse_check_pressed() { return mouse_pressed; }
function mouse_check_released() { return mouse_released; }
// virtual keys:
function vkey() {
	this.top = 0;
	this.left = 0;
	this.right = 0;
	this.bottom = 0;
	this.key = 0;
	this.down = false;
	this.active = true;
}
function vkey_add(_x, _y, _w, _h, _k) {
	var _v = new vkey();
	_v.left = _x;
	_v.top = _y;
	_v.right = _x + _w;
	_v.bottom = _y + _h;
	_v.width = _w;
	_v.height = _h;
	_v.key = _k;
	tu_vkeys.push(_v);
	return _v;
}
// misc:
function trace() { console.log.apply(console, arguments); }
function tu_idle() { } // left empty on purpose
// minimal math:
function abs(_value) { return _value < 0 ? -_value : _value; }
function sign(_value) { return _value > 0 ? 1 : _value < 0 ? -1 : 0; }
function choose() { return arguments[~~(Math.random() * arguments.length)]; }
function random(_value) { return Math.random() * _value; }
function irandom(_value) { return ~~(Math.random() * _value + 1); }
// trig functions:
function lengthdir_x(_length, _direction) { return _length * Math.cos(_direction * tu_d2r); }
function lengthdir_y(_length, _direction) { return _length * Math.sin(_direction * tu_d2r); }
function point_distance(_x1, _y1, _x2, _y2) { return Math.sqrt(Math.pow(( _x1 - _x2), 2) + Math.pow((_y1 - _y2), 2)); }
function point_direction(_x1, _y1, _x2, _y2) { return Math.atan2(_y2 - _y1, _x2 - _x1) * tu_r2d; }
function degtorad(_degree) { return _degree * tu_d2r; }
function radtodeg(_degree) { return _degree * tu_r2d; }
// sound functions:
function sound_mode(_sound, _mode) {
	if (_sound.audio.networkState == _sound.audio.NETWORK_NO_SOURCE) return;
	switch (_sound.type) {
	case "wav": if (!tu_wav_supported) return; break;
	case "ogg": if (!tu_ogg_supported) return; break;
	case "mp3": if (!tu_mp3_supported) return; break;
	}
	if (_mode != 3) {
		_sound.audio.pause();
		if (_mode != 0) {
			_sound.audio.currentTime = 0;
		} else return;
		_sound.audio.loop = _mode > 1;
	}
	_sound.audio.play();
}
function sound_play(_sound) { sound_mode(_sound, 1); }
function sound_loop(_sound) { sound_mode(_sound, 2); }
function sound_resume(_sound) { sound_mode(_sound, 3); }
function sound_stop(_sound) { sound_mode(_sound, 0); }
function sound_stop_all() { for ( var _s = 0; _s < tu_audios.length; _s++) sound_stop( tu_audios[_s] ); }
function sound_volume( _sound, _volume) {
	if (_sound.audio.networkState == _sound.audio.NETWORK_NO_SOURCE) return;
	_sound.audio.volume = _volume;
}
// draw sprite:
function draw_sprite(_sprite_index, _sub_image, _x, _y) {
	if (_sprite_index == null) return;
	if (_sub_image > _sprite_index.frames.length - 1) _sub_image = 0;
	tu_context.save();
	tu_context.translate(_x - room_viewport_x, _y - room_viewport_y);
	tu_context.globalAlpha = tu_draw_alpha;
	tu_context.drawImage(_sprite_index.frames[~~_sub_image], -_sprite_index.xoffset, -_sprite_index.yoffset);
	tu_context.restore();
}
function draw_sprite_part(_sprite_index, _sub_image, _left, _top, _width, _height, _x, _y) {
	if (_sprite_index == null) return;
	if (_sub_image >= _sprite_index.frames.length) _sub_image = _sub_image % _sprite_index.frames.length;
	tu_context.save();
	tu_context.translate(_x - room_viewport_x, _y - room_viewport_y);
	tu_context.globalAlpha = tu_draw_alpha;
	tu_context.drawImage(_sprite_index.frames[~~_sub_image], _left, _top, _width, _height, 0, 0, _width, _height);
	tu_context.restore();
}
function draw_sprite_ext(_sprite_index, _sub_image, _x, _y, _xscale, _yscale, _rotation, _alpha) {
	if (_sprite_index == null) return;
	if (_sub_image >= _sprite_index.frames.length) _sub_image = _sub_image % _sprite_index.frames.length;
	tu_context.save();
	tu_context.translate(_x - room_viewport_x, _y - room_viewport_y);
	tu_context.rotate(degtorad(_rotation));
	tu_context.scale(_xscale, _yscale);
	tu_context.globalAlpha = _alpha;
	tu_context.drawImage(_sprite_index.frames[~~_sub_image], -_sprite_index.xoffset , -_sprite_index.yoffset, _sprite_index.width, _sprite_index.height);
	tu_context.restore();
}
// draw text:
function draw_text(_x, _y, _text) {
	tu_context.font = tu_draw_font;
	tu_context.textAlign = tu_draw_halign;
	tu_context.textBaseline = tu_draw_valign;
	tu_context.fillStyle = tu_context.strokeStyle = "rgba(" + tu_draw_color + ", " + tu_draw_alpha + ")";
	tu_context.fillText( _text, _x - room_viewport_x, _y - room_viewport_y );
}
// draw shapes:
function draw_rectangle(_x1, _y1, _x2, _y2, _outline) {
	tu_context.fillStyle = tu_context.strokeStyle = "rgba(" + tu_draw_color + ", " + tu_draw_alpha + ")";
	tu_context.beginPath();
	if (_outline) tu_context.strokeRect( _x1- room_viewport_x, _y1 - room_viewport_y, _x2 - _x1, _y2 - _y1 );
	else tu_context.fillRect( _x1- room_viewport_x, _y1 - room_viewport_y, _x2 - _x1, _y2 - _y1 );
	tu_context.closePath();
}
function draw_circle(_x, _y, _r, _outline) {
	tu_context.fillStyle = tu_context.strokeStyle = "rgba(" + tu_draw_color + ", " + tu_draw_alpha + ")";
	tu_context.beginPath();
	tu_context.arc( _x - room_viewport_x, _y - room_viewport_y, _r, 0, tu_2pi, true );
	tu_context.closePath();
	!_outline ? tu_context.fill() : tu_context.stroke();
}

function draw_line(_x1, _y1, _x2, _y2) {
	tu_context.strokeStyle = "rgba(" + tu_draw_color + ", " + tu_draw_alpha + ")";
	tu_context.beginPath();
	tu_context.moveTo( _x1 - room_viewport_x, _y1 - room_viewport_y );
	tu_context.lineTo( _x2 - room_viewport_x, _y2 - room_viewport_y );
	tu_context.closePath();
	tu_context.stroke();	
}
// draw settings:
function draw_set_alpha(_alpha) {
	tu_draw_alpha = _alpha;
}
function draw_set_color( _r, _g, _b) {
	tu_draw_color_red = _r;
	tu_draw_color_green = _g;
	tu_draw_color_blue = _b;
	tu_draw_color = tu_draw_color_red + "," + tu_draw_color_green + "," + tu_draw_color_blue;
	tu_context.fillStyle = "rgba(" + tu_draw_color + ", " + tu_draw_alpha + ")";
	tu_context.strokeStyle = "rgb(" + tu_draw_color + ")";
}
function draw_set_linewidth(_width) { tu_context.lineWidth = _width; }
// draw settings - font:
function draw_set_font (_font) {
	tu_draw_font_ = _font;
	tu_draw_font = (_font.bold == 1 ? "bold" : "") + " " + (_font.italic == 1 ? "italic" : "") + " " + _font.size + "px " + _font.family;
	tu_context.font = tu_draw_font;
	tu_context.textAlign = tu_draw_halign;
	tu_context.textBaseline = tu_draw_valign;
}
function draw_set_halign(_halign) { tu_draw_halign = _halign; }
function draw_set_valign(_valign) { tu_draw_valign = _valign; }
// room translations:
function room_goto(_scene) {
	tu_viewport_inst = null;
	tu_room_to_go = _scene;
}
function room_goto_next() {
	var _ri = 0, _r;
	for (_r = 0; _r < tu_scenes.length; _r++) if (tu_scenes[_r] == room_current) _ri = _r;
	if (typeof tu_scenes[(_ri + 1)] == "object") room_goto(tu_scenes[_ri + 1]);
}
function room_goto_previous() {
	var _ri = 0, _r;
	for (_r = 0; _r < tu_scenes.length; _r++) if (tu_scenes[_r] == room_current) _ri = _r;
	if (typeof tu_scenes[(_ri - 1)] == "object") room_goto(tu_scenes[_ri - 1]);
}
function room_goto_first() { room_goto(tu_scenes[0]); }
function room_goto_last() { room_goto(tu_scenes[(tu_scenes.length - 1)]); }
function room_restart() { room_goto(room_current); }
// instance functions:
function instance_create_(_x, _y, _object) {
	var o = new _object.constructor;
	o.parameters = arguments.length > 3 ? Array.prototype.slice.call(arguments, 3) : [];
	o.object_index = _object;
	o.__instance = true;
	o.xstart = o.x = _x;
	o.ystart = o.y = _y;
	o._depth = o.depthstart;
	instance_activate(o);
	return o;
}
function instance_create(_x, _y, _object) {
	var o = instance_create_.apply(this, arguments);
	o.on_creation();
	return o;
}
function instance_number(_object) {
	return instance_list(_object).length;
}
function instance_first(_object) {
	var l = instance_list(_object);
	return l.length ? l[0] : null;
}
// BBox <> BBox
function collide_bbox_bbox(l1, t1, r1, b1, l2, t2, r2, b2) {
	return !(b1 <= t2 || t1 >= b2 || r1 <= l2 || l1 >= r2);
}
// BBox <> SpriteBox
// (left, top, right, bottom, instX, instY, scaleX, scaleY, sprite, ofsX, ofsY)
function collide_bbox_sbox(l1, t1, r1, b1, x2, y2, h2, v2, s2) {
	return
	!( b1 <= y2 + v2 * (s2.collision_top - s2.yoffset)
	|| t1 >= y2 + v2 * (s2.collision_bottom - s2.yoffset)
	|| r1 <= x2 + h2 * (s2.collision_left - s2.xoffset)
	|| l1 <= x2 + h2 * (s2.collision_right - s2.xoffset));
}
// SpriteBox <> BBox
function collide_sbox_point(x2, y2, h2, v2, s2, x1, y1) {
	return
	!( y1 <= y2 + v2 * (s2.collision_top - s2.yoffset)
	|| y1 >= y2 + v2 * (s2.collision_bottom - s2.yoffset)
	|| x1 <= x2 + h2 * (s2.collision_left - s2.xoffset)
	|| x1 <= x2 + h2 * (s2.collision_right - s2.xoffset));
}
// SpriteBox <> Circle
function collide_sbox_circle(x2, y2, h2, v2, s2, x1, y1, r1) {
	var u, v, dx, dy;
	u = x2 + h2 * (s2.collision_left - s2.xoffset);
	v = x2 + h2 * (s2.collision_right - s2.xoffset);
	dx = (x2 < u ? u : x2 > v ? v : x2) - x2;
	u = y2 + v2 * (s2.collision_top - s2.yoffset);
	v = y2 + v2 * (s2.collision_bottom - s2.yoffset);
	dy = (y2 < u ? u : y2 > v ? v : y2) - y2;
	return (dx * dx + dy * dy < r1 * r1);
}
// BBox <> Point
function collide_bbox_point(l1, t1, r1, b1, x2, y2) {
	return (x2 > l1 && x2 < r1 && y2 > t1 && y2 < b1);
}
// BBox <> Circle
function collide_bbox_circle(l1, t1, r1, b1, x2, y2, r2) {
	var dx = (x2 < l1 ? l1 : x2 > r1 ? r1 : x2) - x2, 
		dy = (y2 < t1 ? t1 : y2 > b1 ? b1 : y2) - y2;
	return (dx * dx + dy * dy < r2 * r2);
}
// Circle <> Range
function collide_circle_range(dx, dy, dr) {
	return (dx * dx + dy * dy < dr * dr);
}
// Circle <> Circle
function collide_circle_circle(x1, y1, r1, x2, y2, r2) {
	return collide_circle_range(x1 - x2, y1 - y2, r1 + r2);
}
// Circle <> Point
function collide_circle_point(x1, y1, r1, x2, y2) {
	return collide_circle_range(x1 - x2, y1 - y2, r1);
}
// instance collision checking:
function instance_position(_px, _py, _object, _mult) {
	var _x, _y, _ox, _oy, _sx, _sy, _o, _s, _i, _il, _r, _dx, _dy,
		_q = (_object.__instance ? [_object] : instance_list(_object)),
		_tm = (_mult) ? true : false;
	if (_tm) _ta = [];
	_il = _q.length;
	for (_i = 0; _i < _il; _i++) {
		_o = _q[_i];
		if (!_o.collision_checking) continue;
		_s = _o.sprite_index;
		if (!_s) continue;
		_x = _o.x; _sx = _o.image_xscale;
		_y = _o.y; _sy = _o.image_yscale;
		switch (_s.collision_shape)
		{
		case 0x2:
			if (_sx == 1 && _sy == 1) {
				_ox = _s.xoffset; _oy = _s.yoffset;
				if (!collide_bbox_point(_x + _s.collision_left - _ox, _y + _s.collision_top - _oy,
				_x + _s.collision_right - _ox, _y + _s.collision_bottom - _oy, _px, _py)) break;
			} else if (!collide_sbox_point(_x, _y, _sx, _sy, _s)) break;
			if (!_tm) return _o;
			_ta.push(_o);
			break;
		case 0x3:
			_r = _s.collision_radius * Math.max(_o.image_xscale, _o.image_yscale);
			_dx = _o.x + (_s.width / 2 - _s.xoffset) - _px;
			_dy = _o.y + (_s.height / 2 - _s.yoffset) - _py;
			if ((_dx * _dx) + (_dy * _dy) > _r * _r) break;
			if (!_tm) return _o;
			_ta.push(_o);
			break;
		}
	}
	return _tm ? _ta : null;
}
//
function __place_meeting__(nx, ny, what, many) {
	this.other = null;
	var i, l,
		// sprite, scale:
		ts = this.sprite_index,
		tsx, tsy, tfx, tfy, tst,
		// circle:
		tcx, tcy, tcr,
		// bbox:
		tbl, tbr, tbt, tbb,
		// instances, multiple, output, types:
		tz, tm, ct, ch, ra,
		// other:
		o, ox, oy, os, ost, osx, osy, ofx, ofy, ofr;
	if (ts == null) return false;
	tfx = ts.xoffset;
	tfy = ts.yoffset;
	tsx = this.image_xscale;
	tsy = this.image_yscale;
	tst = ts.collision_shape;
	// bbox:
	if (tst == 2) {
		tbl = nx + tsx * (ts.collision_left - tfx);
		tbr = nx + tsx * (ts.collision_right - tfx);
		tbt = ny + tsy * (ts.collision_top - tfy);
		tbb = ny + tsy * (ts.collision_bottom - tfy);
	}
	// circle:
	if (tst == 3) {
		tcr = ts.collision_radius * (tsx > tsy ? tsx : tsy);
		tcx = nx + tsx * (ts.width / 2 - tfx);
		tcy = ny + tsy * (ts.height / 2 - tfy);
	}
	//
	tz = (what.__instance ? [what] : instance_list(what));
	tm = many ? true : false;
	if (tm) ra = [];
	l = tz.length;
	for (i = 0; i < l; i++) {
		o = tz[i];
		if (!o.collision_checking) continue;
		os = o.sprite_index;
		if (os == null) continue;
		ox = o.x; osx = o.image_xscale;
		oy = o.y; osy = o.image_yscale;
		ost = os.collision_shape;
		ct = (tst << 4) | ost;
		ch = false;
		switch(ct) {
		case 0x22:
			if (osx == 1 && osy == 1) {
				ofx = os.xoffset; ofy = os.yoffset;
				if (!collide_bbox_bbox(tbl, tbt, tbr, tbb,
				ox + os.collision_left - ofx, oy + os.collision_top - ofy,
				ox + os.collision_right - ofx, oy + os.collision_bottom - ofy)) break;
			} else if (!collide_bbox_sbox(tbl, tbt, tbr, tbb, ox, oy, osx, osy, os)) break;
			ch = true;
			break;
		case 0x23:
			ofr = os.collision_radius * (osx > osy ? osx : osy);
			ofx = ox + osx * (os.width / 2 - os.xoffset);
			ofy = oy + osy * (os.height / 2 - os.yoffset);
			if (!collide_bbox_circle(tbl, tbt, tbr, tbb, ofx, ofy, ofr)) break;
			ch = true;
			break;
		case 0x32:
			if (osx == 1 && osy == 1) {
				ofx = os.xoffset; ofy = os.yoffset;
				if (!collide_bbox_circle(
				ox + os.collision_left - ofx, oy + os.collision_top - ofy,
				ox + os.collision_right - ofx, oy + os.collision_bottom - ofy,
				tcx, tcy, tcr)) break;
			} else if (!collide_sbox_circle(ox, oy, osx, osy, os, tcx, tcy, tcr)) break;
			ch = true;
			break;
		case 0x33:
			ofr = os.collision_radius * (osx > osy ? osx : osy);
			ofx = ox + osx * (os.width / 2 - os.xoffset);
			ofy = oy + osy * (os.height / 2 - os.yoffset);
			if (!collide_circle_circle(tcx, tcy, tcr, ofx, ofy, ofr)) break;
			ch = true;
			break;
		} if (!ch) continue;
		this.other = o;
		o.other = this;
		if (!tm) return (o);
		ra.push(o);
	} return ra;
}
function position_meeting(_x, _y, _object) {
	return instance_position(_x, _y, _object) != null;
}
function __move_towards_point__(_x, _y, _speed) {
	if (_speed == 0) return;
	if (this.x == _x && this.y == _y) return;
	var _dx = _x - this.x,
		_dy = _y - this.y,
		_dist = _dx * _dx + _dy * _dy;
	if (_dist < _speed * _speed) {
		this.x = _x;
		this.y = _y;
	} else {
		_dist = Math.sqrt(_dist);
		this.x += _dx * _speed / _dist;
		this.y += _dy * _speed / _dist;
	}
}

function __instance_destroy__() {
	tu_trash.push( this );
}
// web data:
function save_web_data(_name, _value) { if (window.localStorage) window.localStorage.setItem(_name, _value); }
function save_web_integer(_name, _value) { if (window.localStorage) window.localStorage.setItem("int_" + _name, _value); }
function save_web_float(_name, _value) { if (window.localStorage) window.localStorage.setItem("float_" + _name, _value); }
function save_web_string(_name, _value) { if (window.localStorage) window.localStorage.setItem("string_" + _name, _value); }
function load_web_data(_name) { if (window.localStorage) return window.localStorage.getItem(_name); }
function load_web_integer(_name) { if (window.localStorage) return parseInt(window.localStorage.getItem("int_" + _name)); }
function load_web_float(_name) { if (window.localStorage) return parseFloat(window.localStorage.getItem("float_" + _name)); }
function load_web_string(_name) { if (window.localStorage) return '' + window.localStorage.getItem("string_" + _name); }
function delete_web_data(_name) { if (window.localStorage) window.localStorage.removeItem(_name); }
function delete_web_integer(_name) { if (window.localStorage) window.localStorage.removeItem("int_" + _name); }
function delete_web_float(_name) { if (window.localStorage) window.localStorage.removeItem("float_" + _name); }
function delete_web_string(_name) { if (window.localStorage) window.localStorage.removeItem("string_" + _name); }
function clear_web_data() { if (window.localStorage) window.localStorage.clear(); }
function web_data_number() { if (window.localStorage) return window.localStorage.length; }
// misc functions:
function pause_game( _key) {
	tu_paused = true;
	tu_unpausekey = _key;
}
function modal_end() {
	if (tu_modal == null) return;
	tu_modal.instance_destroy();
	tu_modal = null;
}
function modal_start(_inst, _draw) {
	if (tu_modal != null) modal_end();
	tu_modal = _inst;
	tu_modaldraw = _draw;
}
//
function show_mouse() { tu_canvas.style.cursor = "default"; }
function hide_mouse() { tu_canvas.style.cursor = "none"; }
//
function tu_gettime() { return (new Date()).getTime(); }

/***********************************************************************
 * ENGINE
 ***********************************************************************/
 
function tu_global () { }
global = new tu_global();
//{ Events
function __keydownlistener__(e) {
	var r = true;
	if (!e) e = window.event;
	if (document.activeElement && document.activeElement == tu_canvas || document.activeElement == document.body) r = false;
	if (e.repeat) return;
	var keyCode = window.event ? e.which : e.keyCode;
	if (!key_down[keyCode]) {
		key_pressed[keyCode] = true;
		tu_keys_pressed.push(keyCode);
	}
	key_down[keyCode] = true;
	if (!r) e.preventDefault();
	return r;
};
function __keyuplistener__(e) {
	var r = true;
	if (!e) e = window.event;
	if (document.activeElement && document.activeElement == tu_canvas || document.activeElement == document.body) r = false;
	var keyCode = window.event ? e.which : e.keyCode;
	if (key_down[keyCode])
	{
		key_released[keyCode] = true;
		tu_keys_released.push(keyCode);
	}
	key_down[keyCode] = false;
	if (!r) e.preventDefault();
	return r;
};
function __touchsim__(_x, _y) {
	var r = [{}];
	r[0].pageX = tu_canvas.offsetLeft + _x;
	r[0].pageY = tu_canvas.offsetTop + _y;
	__touchvkey__(r);
}
function __mousemovelistener__(_e) {
	if (_e.pageX != undefined && _e.pageY != undefined) {
		mouse_x = _e.pageX;
		mouse_y = _e.pageY;
	} else {
		mouse_x = _e.clientX + document.body.scrollLeft + document.documentElement.scrollLeft;
		mouse_y = _e.clientY + document.body.scrollTop + document.documentElement.scrollTop;
	}
	if (room_current != null) {
		mouse_x -= tu_canvas.offsetLeft;
		mouse_y -= tu_canvas.offsetTop;			
	}
	if (mouse_down) __touchsim__(mouse_x, mouse_y);
};
function __mousedownlistener__(_e) {
	//if (!mouse_down) mouse_pressed = true;
	//mouse_down = true;
	__touchsim__(mouse_x, mouse_y);
};
function __mouseuplistener__(_e) {
	//if (mouse_down) mouse_released = true;
	//mouse_down = false;
	__touchvkey__([]);
};
function __touchvkey__(_t) {
	var _tx = 0, _ty = 0, _tc = 0, _tl = _t.length, _vl = tu_vkeys.length, _i, _j, _c, _k,
		_dx = tu_canvas.offsetLeft, _dy = tu_canvas.offsetTop, _mx = _my = 1;
	if (tu_canvas.style.width) _mx 
	touch_x = []; touch_y = []; touch_count = 0;
	for (_i = 0; _i < _vl; _i++) tu_vkeys[_i].count = 0;
	for (_i = 0; _i < _tl; _i++) {
		_c = 0;
		for (_j = 0; _j < _vl; _j++) {
			if (!tu_vkeys[_j].active) continue;
			if (_t[_i].pageX - _dx > tu_vkeys[_j].right) continue;
			if (_t[_i].pageX - _dx < tu_vkeys[_j].left) continue;
			if (_t[_i].pageY - _dy < tu_vkeys[_j].top) continue;
			if (_t[_i].pageY - _dy > tu_vkeys[_j].bottom) continue;
			tu_vkeys[_j].count++;
			if (!tu_vkeys[_j].down) {
				tu_vkeys[_j].down = true;
				_k = tu_vkeys[_j].key;
				if (!key_down[_k]) {
					key_down[_k] = true;
					key_pressed[_k] = true;
					tu_keys_pressed.push(_k);
				}
			}
			_c++;
		}
		if (_c == 0) {
			_tx += _t[_i].pageX;
			_ty += _t[_i].pageY;
			touch_x[_tc] = _t[_i].pageX - _dx;
			touch_y[_tc] = _t[_i].pageY - _dy;
			_tc++;
		}
	}
	for (_i = 0; _i < _vl; _i++) {
		if (tu_vkeys[_i].count != 0) continue;
		if (!tu_vkeys[_i].down) continue;
		tu_vkeys[_i].down = false;
		_k = tu_vkeys[_i].key;
		if (key_down[_k]) {
			key_down[_k] = false;
			key_released[_k] = true;
			tu_keys_released.push(_k);
		}
	}
	touch_count = _tc;
	if (_tc != 0) {
		mouse_x = (_tx / _tc) - _dx;
		mouse_y = (_ty / _tc) - _dy;
		if (!mouse_down) {
			mouse_down = true;
			mouse_pressed = true;
		}
	} else if (mouse_down) {
		mouse_down = false;
		mouse_released = true;
	}
};
function __touchlistener__(e) {
	e.preventDefault();
	__touchvkey__(e.targetTouches);
};
//}
function tu_init () {
	if (document.addEventListener) {
		document.addEventListener("keydown", __keydownlistener__, false);
		document.addEventListener("keyup", __keyuplistener__, false);
		document.addEventListener("mousemove", __mousemovelistener__, false);
		document.addEventListener("mousedown", __mousedownlistener__, false);
		document.addEventListener("mouseup", __mouseuplistener__, false);
		document.addEventListener("touchstart", __touchlistener__, false);
		document.addEventListener("touchend", __touchlistener__, false);
		document.addEventListener("touchmove", __touchlistener__, false);
		document.addEventListener("touchenter", __touchlistener__, false);
		document.addEventListener("touchleave", __touchlistener__, false);
		document.addEventListener("touchcancel", __touchlistener__, false);
	} else {
		document.attachEvent("onkeydown", __keydownlistener__);
		document.attachEvent("onkeyup", __keyuplistener__);
		document.attachEvent("onmousemove", __mousemovelistener__);
		document.attachEvent("onmousedown", __mousedownlistener__);
		document.attachEvent("onmouseup", __mouseuplistener__);
	}
	// initialize keycodes
	for (var _k = 0; _k < 256; _k++) {
		key_down[_k] = key_pressed[_k] = key_released[_k] = false;
	}
}

function tu_loading_inc() { tu_loading++; tu_load_total++; }
function tu_loading_dec() { tu_loading--; }

function _$_(_id_) {
	return document.getElementById( _id_ );
}

function var_override(_what, _svar, _fget, _fset) {
	if (var_override_) {
		if (_what.hasOwnProperty(_svar)) return;
		Object.defineProperty(_what, _svar, {
			get: _fget,
			set: _fset
		});
	} else {
		if (_what.__lookupGetter__(_svar) != undefined) return;
		_what.__defineGetter__(_svar, _fget);
		_what.__defineSetter__(_svar, _fset);
	}
}

//{ Depth
function _tu_depth_find(_d) {
	var _tl = tu_depthi.length, _td, _ti;
	for (_ti = 0; _ti < _tl; _ti++) {
		_td = tu_depthi[_ti];
		if (_d > _td) return _ti;
	}
	return _tl;
}
function _tu_depth_new(_d) {
	var _i = _tu_depth_find(_d), _o = [];
	tu_depth.splice(_i, 0, _o);
	tu_depthi.splice(_i, 0, _d);
	return _i;
}
function tu_depth_add(_d, _o) {
	var _t = tu_depthi.indexOf(_d);
	if (_t == -1) _t = _tu_depth_new(_d); // create array if none
	tu_depth[_t].push(_o);
}
function tu_depth_delete(_d, _o) {
	var _t = tu_depth[tu_depthi.indexOf(_d)], _ti = _t.indexOf(_o);
	if (_ti == -1) return;
	_t.splice(_ti, 1);
}
function tu_depth_update() {
	var i, l = tu_depthu.length, o;
	if (l == 0) return;
	for (i = 0; i < l; i++) {
		o = tu_depthu[i];
		if (o.instance_active && o._depth !== undefined) tu_depth_delete(o._depth, o);
		o._depth = o._depthn;
		if (o.instance_active && o._depth !== undefined) tu_depth_add(o._depth, o);
		o._depthu = false;
	}
	tu_depthu = [];
}
// Accessors:
function tu_depth_get() { return this._depth; }
function tu_depth_set(_d) {
	if (this._depth == _d) return; // don't change on depth match
	this._depthn = _d;
	if (this._depthu) return;
	this._depthu = true;
	tu_depthu.push(this);
}
//}
//{ Types
function instance_list(_o) {
	var _t = _o._object_index_;
	if (tu_types[_t] == undefined) tu_types[_t] = [];
	return tu_types[_t];
}
function tu_type_add(_d, _o) {
	instance_list(_d).push(_o);
}
function tu_type_delete(_o, _p) {
	var _d = tu_types[_p], _t = _d.indexOf(_o);
	_d.splice(_t, 1);
}
function tu_type_get() { return this._object_index; }
//}
//{ Tileset functions
function tile_layer_find(_d) {
	var _tl = tu_tilesi.length, _td, _ti;
	for (_ti = 0; _ti < _tl; _ti++) {
		_td = tu_tilesi[_ti];
		if (_d > _td) return _ti;
	}
	return _tl;
}
function tile_layer_add(_d) {
	var _i = tile_layer_find(_d), _o = [];
	tu_tiles.splice(_i, 0, _o);
	tu_tilesi.splice(_i, 0, _d);
	return _o;
}
function tile(_s, _x, _y, _l, _t, _w, _h) {
	this.source = _s;
	this.x = _x;
	this.y = _y;
	this.left = _l;
	this.top = _t;
	this.width = _w;
	this.height = _h;
	this.width2 = _w;
	this.height2 = _h;
	this.sectors = [];
}
function tile_add(_b, _l, _t, _w, _h, _x, _y, _z) {
	var	_tx1 = Math.floor(_x / tu_tilez),
		_ty1 = Math.floor(_y / tu_tilez),
		_tx2 = Math.floor((_x + _w) / tu_tilez),
		_ty2 = Math.floor((_y + _h) / tu_tilez),
		_tt = new tile(_b, _x, _y, _l, _t, _w, _h),
		_tx, _ty, _ts,
		_d, _e = tu_tilesi.indexOf(_z);
	if (_e != -1) _d = tu_tiles[_e];
	else _d = tile_layer_add(_z);
	for (_tx = _tx1; _tx <= _tx2; _tx++) {
		if (_d[_tx] == null) _d[_tx] = [];
		for (_ty = _ty1; _ty <= _ty2; _ty++) {
			if (_d[_tx][_ty] == null) _d[_tx][_ty] = [];
			_ts = _d[_tx][_ty];
			_ts.push(_tt);
			_tt.sectors.push(_ts);
		}
	}
	return _tt;
}
function tile_find(_x, _y, _w, _h, _d) {
	var _xw = _x + _w,
		_yh = _y + _h,
		_r = [],
		_tx, _ty, _ti, _tl, _ts, _tt, _ta,
		_tx1, _ty1, _tx2, _ty2;
	_ti = tu_tilesi.indexOf(_d);
	if (_ti == -1) return _r;
	_ta = tu_tiles[_ti];
	_tx1 = Math.floor(_x / tu_tilez);
	_ty1 = Math.floor(_y / tu_tilez);
	_tx2 = Math.floor((_x + _w) / tu_tilez);
	_ty2 = Math.floor((_y + _h) / tu_tilez);
	for (_tx = _tx1; _tx <= _tx2; _tx++) {
		if (_ta[_tx] == null) continue;
		for (_ty = _ty1; _ty <= _ty2; _ty++) {
			if (_ta[_tx][_ty] == null) continue;
			_ts = _ta[_tx][_ty];
			_tl = _ts.length;
			for (_ti = 0; _ti < _tl; _ti++) {
				_tt = _ts[_ti];
				if (_tt.x >= _xw) continue;
				if (_tt.y >= _yh) continue;
				if (_tt.x + _tt.width2 < _x) continue;
				if (_tt.y + _tt.height2 < _y) continue;
				_r.push(_tt);
			}
		}
	}
	return _r;
}
function tile_delete(_t) {
	var _ti, _tl, _ts;
	_tl = _t.sectors.length;
	for (_ti = 0; _ti < _tl; _ti++) {
		_ts = _t.sectors[_ti];
		_ts.splice(_ts.indexOf(_t), 1);
	}
}
function tile_srender(_s) {
	var _ti, _tt;
	for (_ti = 0; _ti < _s.length; _ti++) {
		if (_s[_ti] == null) continue;
		_tt = _s[_ti];
		if (_tt.source == null) continue;
		if (_tt.source.image == null) continue;
		tu_context.drawImage(_tt.source.image, _tt.left, _tt.top, _tt.width, _tt.height, _tt.x - room_viewport_x, _tt.y - room_viewport_y, _tt.width2, _tt.height2);
	}
}
function tile_lrender(_l) {
	var _tx, _ty,
		_tx1 = Math.floor(room_viewport_x / tu_tilez),
		_tx2 = Math.floor((room_viewport_x + room_viewport_width) / tu_tilez),
		_ty1 = Math.floor(room_viewport_y / tu_tilez),
		_ty2 = Math.floor((room_viewport_y + room_viewport_height) / tu_tilez);
	for (_tx = _tx1; _tx <= _tx2; _tx++) {
		if (_l[_tx] == null) continue;
		for (_ty = _ty1; _ty <= _ty2; _ty++) {
			if (_l[_tx][_ty] == null) continue;
			tile_srender(_l[_tx][_ty]);
		}
	}
}
//} /Tileset functions
//{ Some events & accessors
function tu_id_get() { return this; }
function tu_parent_get() { return this._parent_index; }
function image_single_get() { return (this.image_speed == 0 ? this.image_index : -1); }
function image_single_set(_o) { this.image_speed = 0; this.image_index = _o; }
// Handles object size & sprite updates. Should get rid of this in favor of accessors.
function __handle_sprite__(_object_) {
	if (_object_.sprite_index == null) return;
	_object_.sprite_width = _object_.sprite_index.width;
	_object_.sprite_height = _object_.sprite_index.height;
	_object_.sprite_xoffset = _object_.sprite_index.xoffset;
	_object_.sprite_yoffset = _object_.sprite_index.yoffset;
	_object_.image_number = _object_.sprite_index.frames.length;
	_object_.image_index += _object_.image_speed;
	if (_object_.image_index >= _object_.image_number) _object_.image_index = _object_.image_index % _object_.image_number;
	if (_object_.image_index < 0) _object_.image_index = _object_.image_number - 1 + (_object_.image_index % _object_.image_number);
}
function __draw_self__() {
	draw_sprite_ext(this.sprite_index, this.image_index, this.x, this.y, this.image_xscale, this.image_yscale, this.image_angle, this.image_alpha);
}
//}
//{ Inherited event lookup functions.
// There's also a way to do this with much shorter code.
function on_creation_i() {
	for (var o = this.parent; o; o = o.parent)
	if (o.on_creation !== on_creation_i)
	return o.on_creation.apply(this);
}
function on_destroy_i() {
	for (var o = this.parent; o; o = o.parent)
	if (o.on_destroy !== on_destroy_i)
	return o.on_destroy.apply(this);
}
function on_step_i() {
	for (var o = this.parent; o; o = o.parent)
	if (o.on_step !== on_step_i)
	return o.on_step.apply(this);
}
function on_end_step_i() {
	for (var o = this.parent; o; o = o.parent)
	if (o.on_end_step !== on_end_step_i)
	return o.on_end_step.apply(this);
}
function on_draw_d() {
	__handle_sprite__(this);
	__draw_self__.apply(this);
}
function on_draw_i() {
	for (var o = this.parent; o; o = o.parent)
	if (o.on_draw !== on_draw_i)
	return o.on_draw.apply(this);
	on_draw_d.apply(this);
}
function on_collision_i() {
	for (var o = this.parent; o; o = o.parent)
	if (o.on_collision !== on_collision_i)
	return o.on_collision.apply(this);
}
function on_animationend_i() {
	for (var o = this.parent; o; o = o.parent)
	if (o.on_animationend !== on_animationend_i)
	return o.on_animationend.apply(this);
}
function on_roomstart_i() {
	for (var o = this.parent; o; o = o.parent)
	if (o.on_roomstart !== on_roomstart_i)
	return o.on_roomstart.apply(this);
}
function on_roomend_i() {
	for (var o = this.parent; o; o = o.parent)
	if (o.on_roomend !== on_roomend_i)
	return o.on_roomend.apply(this);
}
//} /Inherited event handles

// instance_init(this, object_index, parent_index, visible, depth, sprite, collideable, inner index)
// Universal object constructor:
function __instance_init__(_this, _oi, _p, _v, _d, _si, _c, _io) {
	_this._object_index = undefined;
	_this._object_index_ = _io;
	_this._depth = undefined;
	_this._depthn = undefined;
	_this._depthu = false;
	var_override(_this, 'depth', tu_depth_get, tu_depth_set );
	var_override(_this, 'object_index', tu_type_get, tu_idle );
	var_override(_this, 'image_single', image_single_get, image_single_set );
	var_override(_this, 'id', tu_id_get, tu_idle);
	var_override(_this, 'parent', tu_parent_get, tu_idle);
	_this._object_index = _oi;
	_this._parent_index = _p;
	_this.xstart = _this.xprevious = _this.x = 0;
	_this.ystart = _this.yprevious = _this.y = 0;
	_this.depthstart = _d;
	_this.image_angle = _this.direction = 0;
	_this.visible = _v;
	_this.image_yscale = _this.image_xscale = 1;
	_this.image_alpha = 1;
	_this.image_index = 0;
	_this.image_speed = 1;
	_this.sprite_index = _si;
	_this.speed = 0;
	_this.other = null;
	_this.collision_checking = _c;
	_this.persistent = false;
	_this.instance_active = false;
	// Instance-specific functions:
	_this.place_meeting = __place_meeting__;
	_this.move_towards_point = __move_towards_point__;
	_this.instance_destroy = __instance_destroy__;
	_this.draw_self = __draw_self__;
}
// Universal sprite constructor:
function __sprite_init__(_this, _name, _width, _height, _xofs, _yofs, _cshape, _crad, _cl, _cr, _ct, _cb, _frames) {
	_this.frames = [];
	var _frame, _fi;
	for (_fi = 0; _fi < _frames.length; _fi++) {
		_frame = new Image();
		if (_frames[_fi]) {
			tu_loading_inc();
			_frame.onload = tu_loading_dec;
			_frame.onerror = tu_loading_dec;
			_frame.src = _frames[_fi];
		}
		_this.frames.push(_frame);
	}
	_this.width = _width;
	_this.height = _height;
	_this.xoffset = _xofs;
	_this.yoffset = _yofs;
	_this.collision_shape = (_cshape == 'Circle' ? ct_circle : _cshape == 'Box' ? ct_box : 0);
	_this.collision_radius = _crad;
	_this.collision_left = _cl;
	_this.collision_right = _cr;
	_this.collision_top = _ct;
	_this.collision_bottom = _cb;
	tu_sprites.push(_this);
}
// Universal audio constructor:
function __audio_init__(_this, _name, _wav, _mp3, _ogg) {
	var _src = '';
	_this.type = 'none';
	if (tu_ogg_supported && (_ogg != '')) {
		_this.type = 'ogg';
		_src = _ogg;
	} else if (tu_mp3_supported && (_mp3 != '')) {
		_this.type = 'mp3';
		_src = _mp3;
	} else if (tu_wav_supported && (_wav != '')) {
		_this.type = 'wav';
		_src = _wav;
	}
	if (_src != '') {
		_this.audio = document.createElement('audio');
		_this.audio.setAttribute('src', _src);
	}
	tu_audios.push(_this);
}

function __background_init__(_this, _name, _file) {
	_this.image = new Image();
	tu_loading_inc();
	_this.image.onload = tu_loading_dec;
	_this.image.onerror = tu_loading_dec;
	_this.image.src = _file;
	tu_backgrounds.push(_this);
}

function __font_init__(_this, _name, _family, _size, _bold, _italic) {
	_this.family = _family;
	_this.size = _size;
	_this.bold = _bold;
	_this.italic = _italic;
	tu_fonts.push(_this);
}

// (this, name, width, height, speed, back. red, back. green, back. blue, background, back. tilex, back. tiley, back. stretch, view width, view height, view object, view hborder, view vborder)
function __room_start__(_this, _name, _rw, _rh, _rs, _br, _bg, _bb, _bi, _bx, _by, _bs, _vw, _vh, _vo, _vx, _vy) {
	_$_('tululoogame').innerHTML = "<canvas id='" + tu_canvas_id + "' width='" + _vw + "' height='" + _vh + "' style='" + tu_canvas_css + "'></canvas>";
	tu_canvas = _$_(tu_canvas_id);
	tu_context = tu_canvas.getContext('2d');
	room_current = _this;
	// generic:
	room_speed = _rs;
	room_width = _rw;
	room_height = _rh;
	// background color:
	room_background_color_red = _br;
	room_background_color_green = _bg;
	room_background_color_blue = _bb;
	// background image:
	room_background = _bi;
	room_background_x = 0;
	room_background_y = 0;
	room_background_tile_x = _bx;
	room_background_tile_y = _by;
	room_background_tile_stretch = _bs;
	// view:
	room_viewport_width = _vw;
	room_viewport_height = _vh;
	room_viewport_x = room_viewport_y = 0;
	room_viewport_object = _vo;
	room_viewport_hborder = _vx;
	room_viewport_vborder = _vy;
	// tiles:
	var _l, _b, _t, _i, _il, _tls_, i, l, d, o, a;
	_tls_ = _this.tiles; tu_tiles = []; tu_tilesi = [];
	for (_l = 0; _l < _tls_.length; _l++)
	for (_b = 1; _b < _tls_[_l].length; _b++)
	for (_t = 1; _t < _tls_[_l][_b].length; _t++)
	tile_add(_tls_[_l][_b][0], _tls_[_l][_b][_t][0], _tls_[_l][_b][_t][1], _tls_[_l][_b][_t][2], _tls_[_l][_b][_t][3], _tls_[_l][_b][_t][4], _tls_[_l][_b][_t][5], _tls_[_l][0]);
	// objects:
	tu_depth = []; tu_depthi = []; tu_depthu = []; tu_types = [];
	a = _this.objects;
	l = a.length;
	for (i = 0; i < l; i++) {
		d = a[i];
		d = d[0]; // temp.fix for rc2
		if (d.o === undefined) continue;
		o = instance_create_(d.x, d.y, d.o);
		if (d.s !== undefined) o.sprite_index = d.s;
		if (d.d !== undefined) o.direction = d.d;
		if (d.a !== undefined) o.image_angle = d.a;
		if (d.u !== undefined) o.image_xscale = d.u;
		if (d.v !== undefined) o.image_yscale = d.v;
		if (d.c !== undefined) d.c.apply(o);
	}
	// persistent objects:
	_l = tu_persist.length
	for (_t = 0; _t < _l; _t++) instance_activate(tu_persist[_t]);
	instance_foreach(function(o) {
		if (tu_persist.indexOf(o) != -1) return;
		o.on_creation();
	});
	tu_persist = [];
	//
	instance_foreach(function(o) {
		o.on_roomstart();
	});
}

function tu_preloader() {
	var _w = Math.min(400, (tu_canvas.width * 0.6) >> 0), _h = 16,
		_x = (tu_canvas.width - _w) >> 1, _y = (tu_canvas.height - _h) >> 1,
		_p = (tu_load_total - tu_loading) / tu_load_total,
		_s = "Loading resources: " + (tu_load_total - tu_loading) + "/" + (tu_load_total);
	tu_canvas.width = tu_canvas.width;
	tu_canvas.height = tu_canvas.height;
	var splashscreen = document.getElementById('splashscreen');
	if (splashscreen) {
	tu_context.drawImage(splashscreen, 0, 0, tu_canvas.width, tu_canvas.height);
	};
	tu_canvas.style.backgroundColor = "rgb(142, 142, 142)";
	tu_context.font = "bold 12px Arial";
	tu_context.textAlign = "left";
	tu_context.textBaseline = "bottom";
	tu_context.fillStyle = tu_context.strokeStyle = "rgba(12, 12, 12, 1)";
	tu_context.fillRect(_x - 1, _y - 1, _w + 2, _h + 2);
	tu_context.fillStyle = tu_context.strokeStyle = "rgba(0, 0, 0, 1)";
	tu_context.fillRect(_x, _y, _w, _h);
	tu_context.fillStyle = tu_context.strokeStyle = "rgba(25, 25, 25, 1)";
	tu_context.fillRect(_x + 2, _y + 2, (_w - 4) * _p, _h - 4);
	tu_context.fillText(_s, _x, _y - 2);
	tu_context.font = "bold 34px Arial";
	//tu_context.textAlign = "center";
	if (typeof game_name !== 'undefined') {
	tu_context.fillText(game_name, _x, _y - 30);
	};
}

function tu_render_back() {
	if (room_background == null) return;
	if (room_background_tile_stretch) {
		tu_context.drawImage(room_background, 0 - room_viewport_x, 0 - room_viewport_y, room_width, room_height);
		return;
	}
	var _bw, _bh, _bx, _by, _vx, _vy, _vw, _vh, _x1, _x2, _y1, _y2, _ht, _vt;
	_bw = room_background.width;
	_bh = room_background.height;
	_bx = room_background_x;
	if (room_background_tile_x) { _bx = _bx < 0 ? _bw - _bx % _bw : _bx % _bw; }
	_by = room_background_y;
	if (room_background_tile_y) { _bx = _by < 0 ? _bh - _by % _bh : _by % _bh; }
	//
	_vx = room_viewport_x;
	_vy = room_viewport_y;
	_vw = room_viewport_width;
	_vh = room_viewport_height;
	//
	_x1 = room_background_tile_x ? Math.floor(_vx / _bw) * _bw - _bx : -_bx;
	_x2 = room_background_tile_x ? Math.floor((_vx + _vw + _bw) / _bw) * _bw : _x1 + _bw;
	_y1 = room_background_tile_y ? Math.floor(_vy / _bh) * _bh - _by : -_by;
	_y2 = room_background_tile_y ? Math.floor((_vy + _vh + _bh) / _bh) * _bh : _y1 + _bh;
	for (_ht = _x1; _ht < _x2; _ht += _bw)
	for (_vt = _y1; _vt < _y2; _vt += _bh)
	tu_context.drawImage(room_background, _ht - _vx, _vt - _vy);
}
// @1.2.6
function instance_activate(_i) {
	if (_i.instance_active) return;
	for (var o = _i._object_index; o; o = o.parent) tu_type_add(o, _i);
	//tu_type_add(_i._object_index, _i);
	//if (_i.parent != null) tu_type_add(_i.parent, _i);
	tu_depth_add(_i._depth, _i);
	_i.instance_active = true;
}
// @1.2.6
function instance_deactivate(_i) {
	if (!_i.instance_active) return;
	for (var o = _i._object_index; o; o = o.parent) tu_type_delete(o._object_index_, _i);
	//tu_type_delete(_i, _i._object_index_);
	//if (_i.parent != null) tu_type_delete(_i, _i.parent._object_index_);
	tu_depth_delete(_i._depth, _i);
	_i.instance_active = false;
}
// @1.2.6 Performs function for all instances
function instance_foreach(_function) {
	var _d, _l, _o;
	for (_d in tu_depth) {
		_l = tu_depth[_d];
		for (_o = 0; _o < _l.length; _o++) _function(_l[_o]);
	}
}
// @1.2.6 Performs function for all instances on specific depth
function instance_fordepth(_depth, _function) {
	var _o, _d = tu_depthc[_depth], _l;
	if (_d == null) return;
	_l = _d.length;
	for (_o = 0; _o < _l; _o++) _function(_d[_o]);
}
// @1.2.6 Actions performed on room switch
function tu_room_switchto_(_o) {
	_o.on_roomend();
	if (!_o.persistent) return;
	tu_persist.push(_o);
	instance_deactivate(_o);
}
function tu_room_switchto(_dest) {
	tu_persist = [];
	instance_foreach(tu_room_switchto_);
	room_current = _dest;
	tu_room_to_go = null;
	room_current.start();
}
// @1.0.0 Global step event
function tu_step() {
	// object step events:
	tu_trash = [];
	var tu_deptho, tu_depthl, _obj_, _objd_, _h, _v;
	for (tu_depthd in tu_depth) {
		tu_depthc = tu_depth[tu_depthd];
		tu_depthl = tu_depthc.length;
		for (tu_deptho = 0; tu_deptho < tu_depthl; tu_deptho++) {
			_obj_ = tu_depthc[tu_deptho];
			// is viewport object?
			if (room_viewport_object != null && tu_viewport_inst == null && (_obj_.object_index == room_viewport_object || _obj_.parent == room_viewport_object)) {
				tu_viewport_inst = _obj_;
			}
			// step events:
			_obj_.on_step();
			// move object:
			if (_obj_.speed != 0) {
				_objd_ = _obj_.direction * tu_d2r;
				_obj_.x += _obj_.speed * Math.cos(_objd_);
				_obj_.y += _obj_.speed * Math.sin(_objd_);
			}
			// post-step events:
			_obj_.on_collision();
			_obj_.on_end_step();
			// post:
			_obj_.xprevious = _obj_.x;
			_obj_.yprevious = _obj_.y;
		}
	}
	// follow object
	if (tu_viewport_inst != null) {
		_h = min(room_viewport_hborder, room_viewport_width / 2);
		_v = min(room_viewport_vborder, room_viewport_height / 2);
		// hborder:
		if (tu_viewport_inst.x < room_viewport_x + _h) room_viewport_x = tu_viewport_inst.x - _h;
		if (tu_viewport_inst.x > room_viewport_x + room_viewport_width - _h) room_viewport_x = tu_viewport_inst.x - room_viewport_width + _h;
		// vborder:
		if (tu_viewport_inst.y < room_viewport_y + _v) room_viewport_y = tu_viewport_inst.y - _v;
		if (tu_viewport_inst.y > room_viewport_y + room_viewport_height - _v) room_viewport_y = tu_viewport_inst.y - room_viewport_height + _v;
		// limits:
		room_viewport_x = Math.max(0, Math.min(room_viewport_x, room_width - room_viewport_width)) >> 0;
		room_viewport_y = Math.max(0, Math.min(room_viewport_y, room_height - room_viewport_height)) >> 0;
	}
}

function tu_draw() {
	// clear canvas:
	if (room_background_color_show) {
		tu_canvas.width = tu_canvas.width;
		tu_canvas.height = tu_canvas.height;
		// set background color:
		tu_canvas.style.backgroundColor = "rgb(" + room_background_color_red + "," + room_background_color_green + "," + room_background_color_blue + ")";
	}
	tu_render_back();
	tile_layer_last = 0;
	var tu_depthc, tu_depthv, tu_deptho, tu_depthl, _obj_;
	for (tu_depthd in tu_depth) {
		tu_depthc = tu_depth[tu_depthd];
		tu_depthv = tu_depthi[tu_depthd];
		for (; tu_tilesi[tile_layer_last] >= tu_depthv && tile_layer_last < tu_tiles.length; tile_layer_last++)
		{
			tile_lrender(tu_tiles[tile_layer_last]);
		}
		tu_depthl = tu_depthc.length;
		for (tu_deptho = 0; tu_deptho < tu_depthl; tu_deptho++) {
			_obj_ = tu_depthc[tu_deptho];
			if (_obj_.visible) _obj_.on_draw();
			_obj_.on_animationend();
		}
	}
	// render remaining tile layers:
	for (; tile_layer_last < tu_tiles.length; tile_layer_last++) {
		tile_lrender(tu_tiles[tile_layer_last]);
	}
}

function tu_prestep() {
	// clear mouse states and keypressed / keyrelesed statuses
	mouse_pressed = false;
	mouse_released = false;
	var _k, _r, _obj_;
	for (_k = 0; _k < tu_keys_pressed.length; _k++) key_pressed[tu_keys_pressed[_k]] = false;
	for (_k = 0; _k < tu_keys_released.length; _k++) key_released[tu_keys_released[_k]] = false;
	tu_keys_pressed = [];
	tu_keys_released = [];
	// remove objects from destroy stack
	for (_r = 0; _r < tu_trash.length; _r++) {
		_obj_ = tu_trash[_r];
		if (tu_modal == _obj_) tu_modal = null;
		_obj_.depth = undefined;
		tu_type_delete(_obj_, _obj_._object_index_);
		if (_obj_.parent != null) tu_type_delete(_obj_, _obj_.parent._object_index_);
		_obj_.on_destroy();
	}
}

function tu_loop() {
	// calculate render time
	tu_frame_time = tu_gettime();
	tu_elapsed = (tu_frame_time - tu_prev_frame_time);
	tu_frame_step += tu_elapsed;
	tu_frame_el += tu_elapsed;
	// continue game with the UN-Pause key
	if (tu_paused && keyboard_check_pressed(tu_unpausekey)) tu_paused = false;
	//
	if (tu_room_to_go != null && tu_canvas == null) tu_room_switchto(tu_room_to_go);
	// render game:
	if (tu_frame_step >= 1000 / room_speed && tu_loading == 0 && tu_canvas != null && !tu_paused) {
		tu_frame_count++;
		tu_elapsed = tu_frame_time - tu_prev_cycle_time;
		tu_prev_cycle_time = tu_frame_time;
		tu_frame_step -= 1000 / room_speed;
		if (tu_frame_step < 0 || tu_frame_step > 1024) tu_frame_step = 0;
		// start next room, if any:
		if (tu_room_to_go != null) tu_room_switchto(tu_room_to_go);
		//
		tu_redraw = tu_redraw_auto;
		if (tu_modal != null) {
			tu_modal.on_step();
			if (tu_modal != null) tu_modal.on_end_step();
		} else tu_step();
		tu_depth_update();
		if (tu_redraw) {
			if (tu_modal == null || tu_modaldraw) tu_draw();
			else tu_modal.on_draw();
		}
		tu_depth_update();
		tu_prestep();
		tu_depth_update();
	} else if (tu_loading > 0) tu_preloader();
	// calculate fps:
	if (tu_frame_el >= Math.floor(200 / room_speed) * 5 * room_speed)
	{
		fps = Math.ceil(tu_frame_count * 1000 / tu_frame_el);
		if (fps > room_speed) fps = room_speed;
		tu_frame_el = tu_frame_count = 0;
	}
	// repeat
	tu_prev_frame_time = tu_frame_time;
	setTimeout(tu_gameloop, 5);
}
tu_init();

/***********************************************************************
 * EXTENSIONS
 ***********************************************************************/




/* AutoScale by Bulow & ydk2 */

function canvas_set_style(key, value) {
	tu_canvas.style[key] = value;
}

function init_auto_scale() {
	canvas_set_style('position', 'absolute');
	if (window.innerWidth/room_viewport_width>window.innerHeight/room_viewport_height)
	{
		global.canvasWidth=room_viewport_width*(window.innerHeight/room_viewport_height);
		global.canvasHeight=window.innerHeight;
		global.canvasOffsetH=((window.innerWidth-(room_viewport_width*(window.innerHeight/room_viewport_height)))/2);
		global.canvasOffsetV=0;
	
		canvas_set_style('width', global.canvasWidth+'px');
		canvas_set_style('height', window.innerHeight+'px');
		canvas_set_style('left', global.canvasOffsetH+'px');
		canvas_set_style('top', '0px');
	}	
	else
	{
		global.canvasWidth=window.innerWidth;
		global.canvasHeight=room_viewport_height*(window.innerWidth/room_viewport_width);
		global.canvasOffsetH=0;
		global.canvasOffsetV=((window.innerHeight-(room_viewport_height*(window.innerWidth/room_viewport_width)))/2);
		
		canvas_set_style('width', window.innerWidth+'px');
		canvas_set_style('height', global.canvasHeight+'px');
		canvas_set_style('left', '0px');
		canvas_set_style('top', global.canvasOffsetV+'px');
	}

	window.onresize = function(event)
	{
		init_auto_scale();
	}
}

function mapx(x)
{
	return ((x)*room_viewport_width/global.canvasWidth);
}

function mapy(y)
{
	return ((y)*room_viewport_height/global.canvasHeight);
}

function mapw(w)
{
	return (Math.round((w)*global.canvasWidth/room_viewport_width));
}

function maph(h)
{
	return (Math.round((h)*global.canvasHeight/room_viewport_height));
}










/* ratio by ydk2 */

function __ratio() {
var w = (window.innerWidth/room_viewport_width);
var h = (window.innerHeight/room_viewport_height);
return ((w > h)? h : w);
}; 






/***********************************************************************
 * SPRITES
 ***********************************************************************/
function __sprite_2() { 
__sprite_init__(this, sprite_2, 74, 74, 0, 0, 'Box', 37, 0, 74, 20, 54, ['img/sprite_2_4.png']);
}; var sprite_2 = new __sprite_2();

function __sprite_3() { 
__sprite_init__(this, sprite_3, 74, 74, 0, 0, 'Box', 37, 0, 74, 80, 100, ['img/sprite_3_0.png']);
}; var sprite_3 = new __sprite_3();

function __sprite_25() { 
__sprite_init__(this, sprite_25, 60, 60, 30, 30, 'Circle', 20, 0, 60, 0, 60, ['img/sprite_25_0.png']);
}; var sprite_25 = new __sprite_25();

function __s_left() { 
__sprite_init__(this, s_left, 48, 48, 0, 0, 'Circle', 24, 0, 48, 0, 48, ['img/s_left_0.png']);
}; var s_left = new __s_left();

function __s_right() { 
__sprite_init__(this, s_right, 48, 48, 0, 0, 'Circle', 24, 0, 48, 0, 48, ['img/s_right_0.png']);
}; var s_right = new __s_right();

function __s_up() { 
__sprite_init__(this, s_up, 48, 48, 0, 0, 'Circle', 24, 0, 48, 0, 48, ['img/s_up_0.png']);
}; var s_up = new __s_up();

function __s_down() { 
__sprite_init__(this, s_down, 48, 48, 0, 0, 'Circle', 24, 0, 48, 0, 48, ['img/s_down_0.png']);
}; var s_down = new __s_down();

function __s_tap() { 
__sprite_init__(this, s_tap, 48, 48, 0, 0, 'Circle', 24, 0, 48, 0, 48, ['img/s_tap_0.png']);
}; var s_tap = new __s_tap();

function __s_jump() { 
__sprite_init__(this, s_jump, 48, 48, 0, 0, 'Circle', 24, 0, 48, 0, 48, ['img/s_jump_0.png']);
}; var s_jump = new __s_jump();

function __ludzik() { 
__sprite_init__(this, ludzik, 50, 100, 0, 0, 'Box', 25, 0, 50, 80, 100, ['img/ludzik_0.png','img/ludzik_1.png','img/ludzik_2.png','img/ludzik_3.png','img/ludzik_4.png','img/ludzik_5.png','img/ludzik_6.png','img/ludzik_7.png','img/ludzik_8.png','img/ludzik_9.png','img/ludzik_10.png','img/ludzik_11.png','img/ludzik_12.png','img/ludzik_13.png','img/ludzik_14.png','img/ludzik_15.png','img/ludzik_17.png','img/ludzik_18.png','img/ludzik_19.png','img/ludzik_20.png','img/ludzik_21.png','img/ludzik_22.png','img/ludzik_23.png','img/ludzik_24.png','img/ludzik_25.png','img/ludzik_26.png','img/ludzik_27.png','img/ludzik_28.png','img/ludzik_29.png']);
}; var ludzik = new __ludzik();

function __ludzik1() { 
__sprite_init__(this, ludzik1, 50, 100, 0, 0, 'Box', 25, 0, 50, 80, 100, ['img/ludzik1_0.png','img/ludzik1_1.png','img/ludzik1_2.png','img/ludzik1_3.png','img/ludzik1_4.png','img/ludzik1_5.png','img/ludzik1_6.png','img/ludzik1_7.png','img/ludzik1_8.png','img/ludzik1_9.png','img/ludzik1_10.png','img/ludzik1_11.png','img/ludzik1_12.png','img/ludzik1_13.png','img/ludzik1_14.png','img/ludzik1_15.png','img/ludzik1_16.png','img/ludzik1_17.png','img/ludzik1_18.png','img/ludzik1_19.png','img/ludzik1_20.png','img/ludzik1_21.png','img/ludzik1_22.png','img/ludzik1_23.png','img/ludzik1_24.png','img/ludzik1_25.png','img/ludzik1_26.png','img/ludzik1_27.png','img/ludzik1_28.png']);
}; var ludzik1 = new __ludzik1();

function __sciach() { 
__sprite_init__(this, sciach, 50, 100, 0, 0, 'Box', 25, 0, 50, 0, 100, ['img/sciach_2.png','img/sciach_3.png','img/sciach_4.png']);
}; var sciach = new __sciach();

function __sciachr() { 
__sprite_init__(this, sciachr, 50, 100, 0, 0, 'Box', 25, 0, 50, 0, 100, ['img/sciachr_1.png','img/sciachr_2.png','img/sciachr_3.png']);
}; var sciachr = new __sciachr();

function __sciach_dup() { 
__sprite_init__(this, sciach_dup, 50, 100, 0, 0, 'Box', 25, 0, 50, 0, 100, ['img/sciach_dup_0.png','img/sciach_dup_1.png','img/sciach_dup_2.png']);
}; var sciach_dup = new __sciach_dup();

function __sciachr_dup() { 
__sprite_init__(this, sciachr_dup, 50, 100, 0, 0, 'Box', 25, 0, 50, 0, 100, ['img/sciachr_dup_0.png','img/sciachr_dup_1.png','img/sciachr_dup_2.png']);
}; var sciachr_dup = new __sciachr_dup();

function __dol() { 
__sprite_init__(this, dol, 60, 60, 0, 0, 'Circle', 30, 0, 60, 0, 60, ['img/dol_0.png']);
}; var dol = new __dol();

function __gora() { 
__sprite_init__(this, gora, 60, 60, 0, 0, 'Circle', 30, 0, 60, 0, 60, ['img/gora_0.png']);
}; var gora = new __gora();

function __lewo() { 
__sprite_init__(this, lewo, 60, 60, 0, 0, 'Circle', 30, 0, 60, 0, 60, ['img/lewo_0.png']);
}; var lewo = new __lewo();

function __prawo() { 
__sprite_init__(this, prawo, 60, 60, 0, 0, 'Circle', 30, 0, 60, 0, 60, ['img/prawo_0.png']);
}; var prawo = new __prawo();

function __xbox() { 
__sprite_init__(this, xbox, 60, 60, 0, 0, 'Circle', 30, 0, 60, 0, 60, ['img/xbox_0.png']);
}; var xbox = new __xbox();

function __gwiazdka() { 
__sprite_init__(this, gwiazdka, 60, 60, 0, 0, 'Circle', 30, 0, 60, 0, 60, ['img/gwiazdka_0.png']);
}; var gwiazdka = new __gwiazdka();

function __kwadrat() { 
__sprite_init__(this, kwadrat, 60, 60, 0, 0, 'Circle', 30, 0, 60, 0, 60, ['img/kwadrat_0.png']);
}; var kwadrat = new __kwadrat();

function __sprite_paypal() { 
__sprite_init__(this, sprite_paypal, 200, 60, 0, 0, 'Box', 100, 0, 80, 0, 60, ['img/sprite_paypal_0.png']);
}; var sprite_paypal = new __sprite_paypal();

function __sprite_start() { 
__sprite_init__(this, sprite_start, 245, 66, 0, 0, 'Box', 122, 0, 245, 0, 66, ['img/sprite_start_0.png']);
}; var sprite_start = new __sprite_start();

function __sprite_about() { 
__sprite_init__(this, sprite_about, 245, 66, 0, 0, 'Box', 122, 0, 245, 0, 66, ['img/sprite_about_0.png']);
}; var sprite_about = new __sprite_about();

function __sprite_exit() { 
__sprite_init__(this, sprite_exit, 245, 66, 0, 0, 'Box', 122, 0, 245, 0, 66, ['img/sprite_exit_0.png']);
}; var sprite_exit = new __sprite_exit();

function __sprite_tree() { 
__sprite_init__(this, sprite_tree, 200, 200, 0, 200, 'Box', 100, 90, 110, 180, 200, ['img/sprite_tree_3.png','img/sprite_tree_4.png','img/sprite_tree_8.png']);
}; var sprite_tree = new __sprite_tree();



/***********************************************************************
 * SOUNDS
 ***********************************************************************/
function __sound1() { 
__audio_init__(this, sound1, 'aud/hit05.wav', '', '');
}; var sound1 = new __sound1();



/***********************************************************************
 * MUSICS
 ***********************************************************************/


/***********************************************************************
 * BACKGROUNDS
 ***********************************************************************/
function __background_5() { 
__background_init__(this, background_5, 'img/VID_0006.jpg')}; var background_5 = new __background_5();

function __background_1() { 
__background_init__(this, background_1, 'img/VID_0006.jpg')}; var background_1 = new __background_1();

function __background_2() { 
__background_init__(this, background_2, 'img/VID_0003.jpg')}; var background_2 = new __background_2();

function __background_3() { 
__background_init__(this, background_3, 'img/VID_0003.jpg')}; var background_3 = new __background_3();

function __background_4() { 
__background_init__(this, background_4, 'img/VID_0005.jpg')}; var background_4 = new __background_4();



/***********************************************************************
 * FONTS
 ***********************************************************************/
function __font_33() { 
__font_init__(this, font_33, 'Arial', 12, 1, 0)}; var font_33 = new __font_33();

function __font_99() { 
__font_init__(this, font_99, 'Arial', 20, 1, 0)}; var font_99 = new __font_99();



/***********************************************************************
 * OBJECTS
 ***********************************************************************/
function __enemy() {
__instance_init__(this, enemy, null, 1, 0, ludzik, 1, 0);
this.on_creation = function() {
with(this) {
this.depth = Math.round((room_height - this.y+this.sprite_index.height)/depth_x);
this.image_start = 0;    //the animation will cycle from this frame
this.image_end = 0;      //the animation will cycle to this frame
this.fullenergy = enemy_energy;
this.energy = fullenergy;
this.longs = 0;
this.depths = 0;
this.start_waits = 30;
this.waits = inrandom(start_waits,(start_waits*4));
this.atack = [0,0];
this.gow = [x,y];
this.start_attack = inrandom((waits*3),(waits*4));
this.attack = start_attack;
this.memove = 0;
this.alarm = "I am here";
this.players = null;
this.ihelp = [0,0];
//image_xscale = (this.y+this.sprite_index.width)/500;
//image_yscale = (this.y+this.sprite_index.height)/500;
}
};
this.on_destroy = function() {
with(this) {
killed = killed + 1;
//total_killed = total_killed + 1;
if(helps == this.id){
helps = 0;
}

/*
if(localStorage.getItem('killed') < total_killed){
localStorage.setItem('killed', total_killed);
}
*/
}
};
this.on_step = function() {
with(this) {
this.depth = Math.round((room_height - this.y+this.sprite_index.height)/depth_x);

this.other = place_meeting(x,y,enemy) || place_meeting(this.x,this.y,tree);

if (this.other != null) {
if(this.id != this.other.id){
if(this.depth <= this.other.depth+1 || this.depth >= this.other.depth - 1) {
if(direction==180){
image_start = 21;
image_end = 21;
}
if(direction==0){
image_start = 22;
image_end = 22;
}
	if(this.other.x > this.x){
		x = x-2;
	} else {
		x = x+2;
	}
	if(this.other.y > this.y){
		y = y-2;
	} else {
		y = y+2;
	}
}}
} else {

}

if(this.depth >= max_up ){
y = yprevious+2;
}

if ( x < 0 ) x = 0;
if ( x > room_width-(Math.round(this.sprite_index.width * image_xscale)) ) x = room_width-(Math.round(this.sprite_index.width * image_xscale));
if ( y < 0 ) y = 0;
if ( y > room_height-(Math.round(this.sprite_index.height * image_yscale)) ) y = room_height-(Math.round(this.sprite_index.height * image_yscale));
}
};
this.on_end_step = function() {
with(this) {
if((waits > 0 && waits < start_waits) || attack == 0) { //1

if (gow[0] != x && gow[1] != y){ //2
memove = 1;
if(gow[0]%2 && attack > 0){ //3
x = xprevious;
} else { //e3 // 3
x = (x > gow[0])? x-2:x+2;
} //3
if(gow[1]%2 && attack > 0){ //3
y = yprevious;
} else { //e3 // 3
y = (y > gow[1])? y-2:y+2;
} //3
if(gow[0] > x){ // 0
this.direction = 0;
} else {
this.direction = 180;
} //0
} else {
memove = 0;
} //2
} // 1

if(this.energy <= 0) {
memove = 3;
instance_destroy();
}

players = instance_first(player);
longs = instance_first(player).x - this.x;
depths = instance_first(player).depth - this.depth;
alarm = "";

if(((longs < 150 && longs >= 0) || (longs > -150 && longs <= 0)) && ((depths < 15 && depths >= 0) || (depths > -15 && depths <= 0))){
if(players.x > this.x) {
this.direction = 0;
} else {
this.direction = 180;
}
// attack

//memove = 4;
gow[0] = xprevious;
gow[1] = yprevious;
// attack
alarm = "?";
if(players.direction != direction){ // dir
alarm = "?";
memove = 1;
if(longs < 100 && longs >= 0){
x = x + 2;
} // 1
if(longs > -100 && longs <= 0){
x = x - 2;
} 

if(depths < 10 && depths >= 0){
y = y - 2;
} 
if(depths > -10 && depths <= 0){
y = y + 2;
}
} // dir

if(players.direction == direction){ //2
memove = 1;
alarm = "!";
	if(longs < 100 && longs >= 0){
		x = x + 2;
	} 
	if(longs > -100 && longs <= 0){
		x = x - 2;
	} 

	if(depths < 10 && depths >= 0){
		y = y - 2;
	} 
	if(depths > -10 && depths <= 0){
		y = y + 2;
	}
} //2

// defend
if((players.direction != direction && energy < (fullenergy/2))){ //3
memove = 1;
alarm = "Wrrr...";
	if(longs < 100 && longs >= 0){
		x = x - 2;
	} 
	if(longs > -100 && longs <= 0){
		x = x + 2;
	} 

	if(depths < 10 && depths >= 0){
		y = y + 2;
	} 
	if(depths > -10 && depths <= 0){
		y = y - 2;
	}
} //3

if(attack == 0){ // attack
memove = 1;
alarm = "?#™€ß !!!";
	if(longs < 150 && longs >= 0){
		x = x + 1;
	} 
	if(longs > -150 && longs <= 0){
		x = x - 1;
	} 

	if(depths < 15 && depths >= 0){
		y = y - 1;
	} 
	if(depths > -15 && depths <= 0){
		y = y + 1;
	}
} // attack

// defend
if((players.direction != direction && energy < Math.round(fullenergy/3)) && attack > 0){
memove = 1;

	if(longs < 150 && longs >= 0){
		x = x - 4;
	} 
	if(longs > -150 && longs <= 0){
		x = x + 4;
	} 

	if(depths < 15 && depths >= 0){
		y = y + 4;
	} 
	if(depths > -15 && depths <= 0){
		y = y - 4;
	}
	ihelp[0] = irandom(Math.round(waits/2));
	ihelp[1] = irandom(Math.round(waits/2));
	if(ihelp[0] == ihelp[1]){
	helps = this.id;
	} 
	alarm = "Auu ...";
	if(helps == this.id){
	alarm = "Help!!!";
		if('vibrate' in window.navigator) {
		// ... vibrate for a second
		window.navigator.vibrate([100,200,100.50]);
		}
	}
} 

if(helps != 0){
if(helps != this.id){
//alarm = "Hurra!!!";
attack = 0;
} else { // id
alarm = "Help !!!";
helpx =players.x;
helpy =players.y;
} // id
} // help
if(helps == 0) {
if(helps == this.id){
helps = 0;
alarm = "Uff...";
}
} // help

if(attack >= 0 || attack <= start_attack){
attack = attack - 1;
}

}  else {
if(helps == this.id){
helps = 0;
}
}

if(((longs < 150 && longs >= 0) || (longs > -150 && longs <= 0)) && ((depths < 15 && depths >= 0) || (depths > -15 && depths <= 0))){
//memove =4;

if((this.depth == players.depth) || (this.depth == players.depth+1) || (this.depth == players.depth-1)) {
if((longs < 50 && longs >= 0) || (longs > -50 && longs <= 0)){
atack[0] = irandom(5);
atack[1] = irandom(5);
if(atack[0] == atack[1]){
alarm = "Aaa!!!";
	memove = 4;
if(direction==180){
	miecz = instance_create(this.x-40,this.y,ciach_l_dup);
}
if(direction==0){
	miecz = instance_create(this.x+40,this.y,ciach_r_dup);
}
	miecz.image_start = 0;
	miecz.image_end = 2;
	miecz.depth = depth;
	miecz.direction = direction;
	attack = start_attack;
 
}
} else if((longs < 150 && longs >= 0) || (longs > -150 && longs <= 0)) {
atack[0] = irandom(10);
atack[1] = irandom(10);
if(atack[0] == atack[1]){
alarm = "Hmm...";
 memove = 4;
   bullet = instance_create(this.x+15,this.y + 50,ciach_dup);
   bullet.depth = depth;
   bullet.direction = direction;
   bullet.speed = 15;
   attack = start_attack;
}
}
}

} else {
//memove = 1;
waits = waits - 1;
if(waits == 0){
if(attack == 0){
gow[0] = players.x;
gow[1] = players.y;
} else {
gow[0] = irandom(room_width-this.sprite_index.width);
gow[1] = inrandom((room_height - (max_up * depth_x) + 50),room_height);
}
//memove = 1;
waits = inrandom(start_waits,(start_waits*4));
//(liczba%2)? "nieparzysta": "parzysta"
} //w=0
}

if(attack <= 0){
attack = 0;
memove = 1;
gow[0] = players.x;
gow[1] = players.y;
}

if(helps != this.id && helps != 0){
memove = 1;
gow[0] = helpx;
gow[1] = helpy;
}

if(memove > 0){

if(memove == 1){
if(direction==180){
image_start = 12 ;
image_end = 17;
}
if(direction==0){
image_start = 18;
image_end = 20;
}
}

if(memove == 2){
if(direction==180){
image_start = 0 ;
image_end = 5;
}
if(direction==0){
image_start = 6;
image_end = 12;
}
}

if(memove == 3){
if(direction==180){
image_start = 22 ;
image_end = 22;
}
if(direction==0){
image_start = 21;
image_end = 21;
}
}

if(memove == 4){
if(direction==180){
image_start = 23 ;
image_end = 25;
}
if(direction==0){
image_start = 26;
image_end = 28;
}
}

} else {
if(direction==0){
image_start = 0 ;
image_end = 5;
}
if(direction==180){
image_start = 6;
image_end = 12;
}
}

if(this.depth >= max_up ){
y = yprevious+2;
}

if ( x < 0 ) x = 0;
if ( x > room_width-(Math.round(this.sprite_index.width * image_xscale)) ) x = room_width-(Math.round(this.sprite_index.width * image_xscale));
if ( y < 0 ) y = 0;
if ( y > room_height-(Math.round(this.sprite_index.height * image_yscale)) ) y = room_height-(Math.round(this.sprite_index.height * image_yscale));
}
};
this.on_collision = on_collision_i;
this.on_roomstart = on_roomstart_i;
this.on_roomend = on_roomend_i;
this.on_animationend = on_animationend_i;
this.on_draw = function() {
if (this.visible == 1) {
__handle_sprite__(this);
with(this) {
//
//character animation based on forever increasing image_index
if(image_index < image_start || image_index > image_end) {
	image_index = image_start; //keeping the image_index in the required value
}

draw_sprite(sprite_index, image_index, x, y);
draw_set_color(0, 0, 0);
draw_set_halign(fa_center);
draw_set_valign(fa_middle);
if(alarm != "" ){
draw_set_font(font_99);
draw_text(x+20,y-40," "+alarm+" ");
}
draw_set_font(font_33);
draw_text(x+20,y-20," "+this.energy+" hp");

}
}
};
}; var enemy = new __enemy();

function __player() {
__instance_init__(this, player, null, 1, 0, ludzik1, 1, 1);
this.on_creation = function() {
with(this) {
myground =  irandom(5);
//room_background = eval("background_"+myground+".image");

this.depth = Math.round((room_height - this.y+this.sprite_index.height)/depth_x);

this.times = 0;
this.fullenergy = 100;
this.energy = player_energy+player_tmp;
this.memove = 0;
this.alarm = "";

if(direction==180){
this.image_start = 0;
this.image_end = 2;
}
if(direction==0){
this.image_start = 3;
this.image_end = 6;
}




}
};
this.on_destroy = function() {
with(this) {
killed = 0;


}
};
this.on_step = function() {
with(this) {
memove = 0;
alarm = "";
this.other = place_meeting(this.x,this.y,enemy) || place_meeting(this.x,this.y,tree);
if(jump == 0){
this.depth = Math.round((room_height - this.y+this.sprite_index.height)/depth_x);
}

if(direction==180){
image_start = 6;
image_end = 12;
}
if(direction==0){
image_start = 0;
image_end = 5;
}

if ( keyboard_check( vk_right ) || klik_r == true) {
direction = 0;
	x = x + 5;
	memove = 1;
	if (this.other != null  && jump == 0) {
if(this.depth <= this.other.depth+1 || this.depth >= this.other.depth - 1) {
	if(this.other.x > this.x){
		x = xprevious-1;
	} else {
		x = xprevious+1;
	}
	memove = 2;
}}
}

if ( keyboard_check( vk_left ) || klik_l == true) {
direction = 180;
	x = x - 5;
	memove = 1;
	if (this.other != null  && jump == 0 ) {
if(this.depth <= this.other.depth+1 || this.depth >= this.other.depth - 1) {
	if(this.other.x > this.x){
		x = xprevious-1;
	} else {
		x = xprevious+1;
	}
	memove = 2;
}}
}

if ( (keyboard_check( vk_up ) || klik_u == true) && jump == 0 ) {
	y = y - 5;
	memove = 1;
	if (this.other != null) {
if(this.depth <= this.other.depth+1 || this.depth >= this.other.depth - 1) {
	if(this.other.y > this.y){
		y = yprevious-1;
	} else {
		y = yprevious+1;
	}
	memove = 2;
}
}
}

if ( (keyboard_check( vk_down ) || klik_d== true)  && jump == 0 ) {
	y = y + 5;
	memove = 1;
	if (this.other != null) {
if(this.depth <= this.other.depth+1 || this.depth >= this.other.depth - 1) {
	if(this.other.y > this.y){
		y = yprevious-1;
	} else {
		y = yprevious+1;
	}
	memove = 2;
}
}
}

//direction = this.image_angle;
//image_xscale = (this.y+this.sprite_index.width)/500;
//image_yscale = (this.y+this.sprite_index.height)/500;
/**/

if ( (keyboard_check_pressed(vk_space) || klik_j == true)  && jump == 0 ) {
jump = 1;
memove = 3;
alarm = "Hooop";
times = setInterval(function(){
if (this.other != null &&  jump != 0) {
memove = 3;
if(this.depth <= this.other.depth+1 || this.depth >= this.other.depth - 1) {
	if(this.other.y > this.y){
		y = yprevious-1;
	} else {
		y = yprevious+1;
	}
}}
i += 1;
if(i < 20){
y -= 5;
}
if(i >= 20){
y += 5;
}
if(i == 38){
clearInterval(times);
times = 0;
jump = 0;
i = 0;
}}, 20);
i = 0;
alarm = "Bums";
memove = 3;
} 

if(this.depth >= max_up ){
y = yprevious+2;
}

if ((keyboard_check_pressed( vk_x ) || klik_x == true) && bum == 0) {
memove = 4;
alarm = "Hmm...";
   bullet = instance_create(this.x+15,this.y + 50,ciach);
   bullet.depth = depth;
   bullet.direction = direction;
   bullet.speed = 15;
}

if ((keyboard_check_pressed( vk_c ) || klik_c == true) && bum == 0) {
memove = 4;
alarm = "Aaaa !!!";
if(direction==180){
miecz = instance_create(this.x-40,this.y,ciach_l);
}
if(direction==0){
miecz = instance_create(this.x+40,this.y,ciach_r);
}
	miecz.image_start = 0;
	miecz.image_end = 2;
   miecz.depth = depth;
   miecz.direction = direction;
   //bullet.speed = 15;
}
if(jump != 0) {
alarm = "Uhuu !!!";
memove = 3;
}
if ( x < 0 ) x = 0;
if ( x > room_width-(Math.round(this.sprite_index.width * image_xscale)) ) x = room_width-(Math.round(this.sprite_index.width * image_xscale));
if ( y < 0 ) y = 0;
if ( y > room_height-(Math.round(this.sprite_index.height * image_yscale)) ) y = room_height-(Math.round(this.sprite_index.height * image_yscale));

}
};
this.on_end_step = function() {
with(this) {
if(memove > 0){

if(memove == 1){
if(direction==180){
image_start = 12 ;
image_end = 17;
}
if(direction==0){
image_start = 18;
image_end = 20;
}
}

if(memove == 2){
if(direction==180){
image_start = 0 ;
image_end = 5;
}
if(direction==0){
image_start = 6;
image_end = 12;
}
}

if(memove == 3){
if(direction==180){
image_start = 22 ;
image_end = 22;
}
if(direction==0){
image_start = 21;
image_end = 21;
}
}

if(memove == 4){
if(direction==180){
image_start = 23 ;
image_end = 25;
}
if(direction==0){
image_start = 26;
image_end = 28;
}
}

} else {
if(direction==0){
image_start = 0 ;
image_end = 5;
}
if(direction==180){
image_start = 6;
image_end = 12;
}
}

if (killed == tokilled){
total_killed = total_killed + killed;
tokilled = tokilled +1;
player_tmp = this.energy;
	if(load_web_integer(0)) {
		if(load_web_integer(0) < total_killed) {
			save_web_integer(0, total_killed);
		}
	}
killed = 0;
room_goto(room_current);
} 

if(this.energy <= 0) {
memmove = 3;
killed = 0;
		if('vibrate' in window.navigator) {
		// ... vibrate for a second
		window.navigator.vibrate([200,100,100]);
		}
instance_destroy();
room_goto(room_current);
}
}
};
this.on_collision = on_collision_i;
this.on_roomstart = on_roomstart_i;
this.on_roomend = on_roomend_i;
this.on_animationend = on_animationend_i;
this.on_draw = function() {
if (this.visible == 1) {
__handle_sprite__(this);
with(this) {
if(image_index < image_start || image_index > image_end) {
	image_index = image_start; //keeping the image_index in the required value
}

draw_sprite(sprite_index, image_index, x, y);
draw_set_color(0, 0, 255);
draw_set_halign(fa_center);
draw_set_valign(fa_middle);
if(alarm != "" ){
draw_set_font(font_99);
draw_text(x+20,y-40," "+alarm+" ");
}
draw_set_font(font_33);
draw_text(x+20,y-20," "+this.energy+" hp ");

}
}
};
}; var player = new __player();

function __ciach() {
__instance_init__(this, ciach, null, 1, 0, sprite_25, 1, 2);
this.on_creation = function() {
with(this) {
//this.depth = Math.round(room_height - this.y+this.sprite_index.height);
this.bums = 10;
this.obj2 = 0;
//if(a.image_index.width > 0) {sound_play(sound1);}
//sound_play(sound1);
}
};
this.on_destroy = function() {
with(this) {
this.bums = 0;
}
};
this.on_step = function() {
with(this) {
if (x < 0 || x > room_width) instance_destroy();

image_angle = image_angle + 20;

this.other = place_meeting(this.x,this.y+15,enemy) || place_meeting(this.x,this.y+15,tree);
//this.other1 = place_meeting(this.x,this.y,b);

if (this.other != null) {
if((this.depth == this.other.depth) || (this.depth == this.other.depth+1) || (this.depth == this.other.depth-1)) {
		this.other.energy -= 1;
		this.other.alarm = "Ai!";
		instance_destroy();
}
}

	bums = bums-1;
	if(bums == 0){
	instance_destroy();
	}



}
};
this.on_end_step = on_end_step_i;
this.on_collision = on_collision_i;
this.on_roomstart = on_roomstart_i;
this.on_roomend = on_roomend_i;
this.on_animationend = on_animationend_i;
this.on_draw = on_draw_i;
}; var ciach = new __ciach();

function __obj_l() {
__instance_init__(this, obj_l, null, 1, 0, lewo, 1, 3);
this.on_creation = function() {
with(this) {
//vkey_add(this.x,this.y,30,30,vk_space);
}
};
this.on_destroy = on_destroy_i;
this.on_step = function() {
with(this) {
/*
if(mouse_check() && position_meeting(mapx(mouse_x) + room_viewport_x, mapy(mouse_y) + room_viewport_y, this)) {
klik_l = true;
} else {
klik_l = false;
}
*/
this.x = room_viewport_x+lx;
this.y = room_viewport_y+ly;
}
};
this.on_end_step = on_end_step_i;
this.on_collision = on_collision_i;
this.on_roomstart = on_roomstart_i;
this.on_roomend = on_roomend_i;
this.on_animationend = on_animationend_i;
this.on_draw = on_draw_i;
}; var obj_l = new __obj_l();

function __obj_r() {
__instance_init__(this, obj_r, null, 1, 0, prawo, 1, 4);
this.on_creation = on_creation_i;
this.on_destroy = on_destroy_i;
this.on_step = function() {
with(this) {

this.x = room_viewport_x+rx;
this.y = room_viewport_y+ry;
}
};
this.on_end_step = on_end_step_i;
this.on_collision = on_collision_i;
this.on_roomstart = on_roomstart_i;
this.on_roomend = on_roomend_i;
this.on_animationend = on_animationend_i;
this.on_draw = on_draw_i;
}; var obj_r = new __obj_r();

function __obj_u() {
__instance_init__(this, obj_u, null, 1, 0, gora, 1, 5);
this.on_creation = on_creation_i;
this.on_destroy = on_destroy_i;
this.on_step = function() {
with(this) {

this.x = room_viewport_x+ux;
this.y = room_viewport_y+uy;
}
};
this.on_end_step = on_end_step_i;
this.on_collision = on_collision_i;
this.on_roomstart = on_roomstart_i;
this.on_roomend = on_roomend_i;
this.on_animationend = on_animationend_i;
this.on_draw = on_draw_i;
}; var obj_u = new __obj_u();

function __obj_d() {
__instance_init__(this, obj_d, null, 1, 0, dol, 1, 6);
this.on_creation = on_creation_i;
this.on_destroy = on_destroy_i;
this.on_step = function() {
with(this) {

this.x = room_viewport_x+dx;
this.y = room_viewport_y+dy;
}
};
this.on_end_step = on_end_step_i;
this.on_collision = on_collision_i;
this.on_roomstart = on_roomstart_i;
this.on_roomend = on_roomend_i;
this.on_animationend = on_animationend_i;
this.on_draw = on_draw_i;
}; var obj_d = new __obj_d();

function __obj_j() {
__instance_init__(this, obj_j, null, 1, 0, kwadrat, 1, 7);
this.on_creation = on_creation_i;
this.on_destroy = on_destroy_i;
this.on_step = function() {
with(this) {

this.x = room_viewport_x+jx;
this.y = room_viewport_y+jy;
//mouse_check_pressed
}
};
this.on_end_step = on_end_step_i;
this.on_collision = on_collision_i;
this.on_roomstart = on_roomstart_i;
this.on_roomend = on_roomend_i;
this.on_animationend = on_animationend_i;
this.on_draw = on_draw_i;
}; var obj_j = new __obj_j();

function __obj_x() {
__instance_init__(this, obj_x, null, 1, 0, gwiazdka, 1, 8);
this.on_creation = on_creation_i;
this.on_destroy = on_destroy_i;
this.on_step = function() {
with(this) {

this.x = room_viewport_x+xx;
this.y = room_viewport_y+xy;
}
};
this.on_end_step = on_end_step_i;
this.on_collision = on_collision_i;
this.on_roomstart = on_roomstart_i;
this.on_roomend = on_roomend_i;
this.on_animationend = on_animationend_i;
this.on_draw = on_draw_i;
}; var obj_x = new __obj_x();

function __logs() {
__instance_init__(this, logs, null, 1, 0, null, 1, 9);
this.on_creation = on_creation_i;
this.on_destroy = on_destroy_i;
this.on_step = function() {
with(this) {
this.x = room_viewport_x+20;
this.y = room_viewport_y+20;
}
};
this.on_end_step = on_end_step_i;
this.on_collision = on_collision_i;
this.on_roomstart = on_roomstart_i;
this.on_roomend = on_roomend_i;
this.on_animationend = on_animationend_i;
this.on_draw = function() {
if (this.visible == 1) {
__handle_sprite__(this);
with(this) {
draw_set_font(font_99);
draw_set_color(0, 0, 155);
draw_set_halign(fa_left);
draw_set_valign(fa_middle);
draw_text(x,y,"Result "+killed+" of "+tokilled);
draw_text(x,y+30,"Total "+(total_killed+killed)+" ");
}
}
};
}; var logs = new __logs();

function __ciach_dup() {
__instance_init__(this, ciach_dup, null, 1, 0, sprite_25, 1, 10);
this.on_creation = function() {
with(this) {
//this.depth = Math.round(room_height - this.y+this.sprite_index.height);
this.bums = 10;
this.obj2 = 0;
//if(a.image_index.width > 0) {sound_play(sound1);}
//sound_play(sound1);
}
};
this.on_destroy = function() {
with(this) {
this.bums = 0;
}
};
this.on_step = function() {
with(this) {
if (x < 0 || x > room_width) instance_destroy();

image_angle = image_angle - 20;


this.other = place_meeting(this.x,this.y+15,player) || place_meeting(this.x,this.y+15,tree);
//this.other1 = place_meeting(this.x,this.y,b);

if (this.other != null) {
if((this.depth == this.other.depth) || (this.depth == this.other.depth+1) || (this.depth == this.other.depth-1)) {
		this.other.alarm = "Ai!";
		this.other.energy -= 1;
		if('vibrate' in window.navigator) {
		// ... vibrate for a second
		window.navigator.vibrate([200]);
		}
		instance_destroy();
}
}

	bums = bums-1;
	if(bums == 0){
	instance_destroy();
	}



}
};
this.on_end_step = on_end_step_i;
this.on_collision = on_collision_i;
this.on_roomstart = on_roomstart_i;
this.on_roomend = on_roomend_i;
this.on_animationend = on_animationend_i;
this.on_draw = on_draw_i;
}; var ciach_dup = new __ciach_dup();

function __ciach_l() {
__instance_init__(this, ciach_l, null, 1, 0, sciach, 1, 11);
this.on_creation = function() {
with(this) {
//this.depth = Math.round(room_height - this.y+this.sprite_index.height);
this.bums = 5;
this.obj2 = 0;

this.image_start = 0;    //the animation will cycle from this frame
this.image_end = 2;      //the animation will cycle to this frame
this.image_speed = 6;
//if(a.image_index.width > 0) {sound_play(sound1);}
//sound_play(sound1);

}
};
this.on_destroy = function() {
with(this) {
this.bums = 0;
}
};
this.on_step = function() {
with(this) {
if (x < 0 || x > room_width) instance_destroy();

this.other = place_meeting(this.x,this.y+15,enemy);


image_start = 0;
image_end = 2;

if (this.other != null) {
if((this.depth == this.other.depth) || (this.depth == this.other.depth+1) || (this.depth == this.other.depth-1)) {
		this.other.alarm = "Uuu!";
		this.other.energy -= 5;
		if('vibrate' in window.navigator) {
		// ... vibrate for a second
		window.navigator.vibrate([200]);
		}
		instance_destroy();
}
}

	bums = bums-1;
	if(bums == 0){
	instance_destroy();
	}



}
};
this.on_end_step = on_end_step_i;
this.on_collision = on_collision_i;
this.on_roomstart = on_roomstart_i;
this.on_roomend = on_roomend_i;
this.on_animationend = function() {
if(this.image_index >= this.image_number - 1) {
with(this) {
instance_destroy();
}
}
};
this.on_draw = on_draw_i;
}; var ciach_l = new __ciach_l();

function __obj_c() {
__instance_init__(this, obj_c, null, 1, 0, xbox, 1, 12);
this.on_creation = on_creation_i;
this.on_destroy = on_destroy_i;
this.on_step = function() {
with(this) {

this.x = room_viewport_x+cx;
this.y = room_viewport_y+cy;
}
};
this.on_end_step = on_end_step_i;
this.on_collision = on_collision_i;
this.on_roomstart = on_roomstart_i;
this.on_roomend = on_roomend_i;
this.on_animationend = on_animationend_i;
this.on_draw = on_draw_i;
}; var obj_c = new __obj_c();

function __ciach_r() {
__instance_init__(this, ciach_r, null, 1, 0, sciachr, 1, 13);
this.on_creation = function() {
with(this) {
//this.depth = Math.round(room_height - this.y+this.sprite_index.height);
this.bums = 5;
this.obj2 = 0;

this.image_start = 0;    //the animation will cycle from this frame
this.image_end = 2;      //the animation will cycle to this frame
this.image_speed = 6;
//if(a.image_index.width > 0) {sound_play(sound1);}
//sound_play(sound1);

}
};
this.on_destroy = function() {
with(this) {
this.bums = 0;
}
};
this.on_step = function() {
with(this) {
if (x < 0 || x > room_width) instance_destroy();

this.other = place_meeting(this.x,this.y+15,enemy);

image_start = 0;
image_end = 2;

if (this.other != null) {
if((this.depth == this.other.depth) || (this.depth == this.other.depth+1) || (this.depth == this.other.depth-1)) {
		this.other.alarm = "Uuu!";
		this.other.energy -= 5;
		if('vibrate' in window.navigator) {
		// ... vibrate for a second
		window.navigator.vibrate([200]);
		}
		instance_destroy();
}
}

	bums = bums-1;
	if(bums == 0){
	instance_destroy();
	}



}
};
this.on_end_step = on_end_step_i;
this.on_collision = on_collision_i;
this.on_roomstart = on_roomstart_i;
this.on_roomend = on_roomend_i;
this.on_animationend = function() {
if(this.image_index >= this.image_number - 1) {
with(this) {
instance_destroy();
}
}
};
this.on_draw = on_draw_i;
}; var ciach_r = new __ciach_r();

function __ciach_l_dup() {
__instance_init__(this, ciach_l_dup, null, 1, 0, sciach_dup, 1, 14);
this.on_creation = function() {
with(this) {
//this.depth = Math.round(room_height - this.y+this.sprite_index.height);
this.bums = 5;
this.obj2 = 0;

this.image_start = 0;    //the animation will cycle from this frame
this.image_end = 2;      //the animation will cycle to this frame
this.image_speed = 6;
//if(a.image_index.width > 0) {sound_play(sound1);}
//sound_play(sound1);

}
};
this.on_destroy = function() {
with(this) {
this.bums = 0;
}
};
this.on_step = function() {
with(this) {
if (x < 0 || x > room_width) instance_destroy();

this.other = place_meeting(this.x,this.y+15,player);
//this.other1 = place_meeting(this.x,this.y,b);

image_start = 0;
image_end = 2;

if (this.other != null) {
if((this.depth == this.other.depth) || (this.depth == this.other.depth+1) || (this.depth == this.other.depth-1)) {
		this.other.alarm = "Uuu!";
		this.other.energy -= 5;
		if('vibrate' in window.navigator) {
		// ... vibrate for a second
		window.navigator.vibrate([200,100]);
		}
		instance_destroy();
}
}

	bums = bums-1;
	if(bums == 0){
	instance_destroy();
	}



}
};
this.on_end_step = on_end_step_i;
this.on_collision = on_collision_i;
this.on_roomstart = on_roomstart_i;
this.on_roomend = on_roomend_i;
this.on_animationend = function() {
if(this.image_index >= this.image_number - 1) {
with(this) {
instance_destroy();
}
}
};
this.on_draw = on_draw_i;
}; var ciach_l_dup = new __ciach_l_dup();

function __ciach_r_dup() {
__instance_init__(this, ciach_r_dup, null, 1, 0, sciachr_dup, 1, 15);
this.on_creation = function() {
with(this) {
//this.depth = Math.round(room_height - this.y+this.sprite_index.height);
this.bums = 5;
this.obj2 = 0;

this.image_start = 0;    //the animation will cycle from this frame
this.image_end = 2;      //the animation will cycle to this frame
this.image_speed = 6;
//if(a.image_index.width > 0) {sound_play(sound1);}
//sound_play(sound1);

}
};
this.on_destroy = function() {
with(this) {
this.bums = 0;
}
};
this.on_step = function() {
with(this) {
if (x < 0 || x > room_width) instance_destroy();

this.other = place_meeting(this.x,this.y+15,player);
//this.other1 = place_meeting(this.x,this.y,b);

image_start = 0;
image_end = 2;

if (this.other != null) {
if((this.depth == this.other.depth) || (this.depth == this.other.depth+1) || (this.depth == this.other.depth-1)) {
		this.other.alarm = "Uuu!";
		this.other.energy -= 5;
		if('vibrate' in window.navigator) {
		// ... vibrate for a second
		window.navigator.vibrate([200,100]);
		}
		instance_destroy();
}
}

	bums = bums-1;
	if(bums == 0){
	instance_destroy();
	}



}
};
this.on_end_step = on_end_step_i;
this.on_collision = on_collision_i;
this.on_roomstart = on_roomstart_i;
this.on_roomend = on_roomend_i;
this.on_animationend = function() {
if(this.image_index >= this.image_number - 1) {
with(this) {
instance_destroy();
}
}
};
this.on_draw = on_draw_i;
}; var ciach_r_dup = new __ciach_r_dup();

function __sky() {
__instance_init__(this, sky, null, 1, 0, null, 0, 16);
this.on_creation = function() {
with(this) {
this.depth = max_up + 1;
}
};
this.on_destroy = on_destroy_i;
this.on_step = on_step_i;
this.on_end_step = on_end_step_i;
this.on_collision = on_collision_i;
this.on_roomstart = on_roomstart_i;
this.on_roomend = on_roomend_i;
this.on_animationend = on_animationend_i;
this.on_draw = function() {
if (this.visible == 1) {
__handle_sprite__(this);
with(this) {
draw_set_color(0, 150, 255);
draw_rectangle(x, y, room_width, (room_height - (max_up * depth_x) + 200));
}
}
};
}; var sky = new __sky();

function __ground() {
__instance_init__(this, ground, null, 1, 0, null, 0, 17);
this.on_creation = function() {
with(this) {
this.depth = max_up+2;
}
};
this.on_destroy = on_destroy_i;
this.on_step = on_step_i;
this.on_end_step = on_end_step_i;
this.on_collision = on_collision_i;
this.on_roomstart = on_roomstart_i;
this.on_roomend = on_roomend_i;
this.on_animationend = on_animationend_i;
this.on_draw = function() {
if (this.visible == 1) {
__handle_sprite__(this);
with(this) {
//platform
// (room_height - (max_up * depth_x) + 50)
draw_set_color(100, 255, 0);
draw_rectangle(x, y, room_width, room_width);
//draw_set_color(200, 200, 200);
//draw_rectangle(0, 340, 640, 380);
}
}
};
}; var ground = new __ground();

function __paypal() {
__instance_init__(this, paypal, null, 1, 0, sprite_paypal, 1, 18);
this.on_creation = function() {
with(this) {

}
};
this.on_destroy = on_destroy_i;
this.on_step = function() {
with(this) {
if(mouse_check_pressed() && position_meeting(mapx(mouse_x) + room_viewport_x, mapy(mouse_y) + room_viewport_y, this)) {
//window.location.href="paypal.html";
document.getElementById("anchorID").submit();
//pause_game();
  /**
     if (!tu_paused) {
      //pause_game(vk_space);
      tu_paused=true;
      draw_text(50, 90,"GAME PAUSED");
   } else {
      tu_paused=false;
   }
**/
}
  this.x = room_viewport_x+20;
  this.y = room_viewport_y+60;

}
};
this.on_end_step = on_end_step_i;
this.on_collision = on_collision_i;
this.on_roomstart = on_roomstart_i;
this.on_roomend = on_roomend_i;
this.on_animationend = on_animationend_i;
this.on_draw = function() {
if (this.visible == 1) {
__handle_sprite__(this);
with(this) {
draw_sprite(sprite_index, image_index, x, y);
draw_set_color(255, 255, 0);
draw_set_halign(fa_center);
draw_set_valign(fa_middle);
draw_set_font(font_99);
draw_text(x+37,y+37," Donate ");
if(room_current == scene_start){
draw_sprite(ludzik, 0, x+10, y+100);
draw_sprite(ludzik1, 7, 400, y+100);
};
}
}
};
}; var paypal = new __paypal();

function __object_start() {
__instance_init__(this, object_start, null, 1, 0, sprite_start, 1, 19);
this.on_creation = on_creation_i;
this.on_destroy = on_destroy_i;
this.on_step = function() {
with(this) {
if(mouse_check_pressed() && position_meeting(mapx(mouse_x) + room_viewport_x, mapy(mouse_y) + room_viewport_y, this)) {
   room_goto_next();
   /*
   if(parameters[0] == undefined){
   room_goto(scene_count);
   } else {
   room_goto(parameters[0]);
   }
   */
}
}
};
this.on_end_step = on_end_step_i;
this.on_collision = on_collision_i;
this.on_roomstart = on_roomstart_i;
this.on_roomend = on_roomend_i;
this.on_animationend = on_animationend_i;
this.on_draw = on_draw_i;
}; var object_start = new __object_start();

function __object_about() {
__instance_init__(this, object_about, null, 1, 0, sprite_about, 1, 20);
this.on_creation = on_creation_i;
this.on_destroy = on_destroy_i;
this.on_step = function() {
with(this) {
if(mouse_check_pressed() && position_meeting(mapx(mouse_x) + room_viewport_x, mapy(mouse_y) + room_viewport_y, this)) {
   room_goto(scene_about);
   /*
   if(parameters[0] == undefined){
   room_goto(scene_count);
   } else {
   room_goto(parameters[0]);
   }
   */
}
}
};
this.on_end_step = on_end_step_i;
this.on_collision = on_collision_i;
this.on_roomstart = on_roomstart_i;
this.on_roomend = on_roomend_i;
this.on_animationend = on_animationend_i;
this.on_draw = on_draw_i;
}; var object_about = new __object_about();

function __object_exit() {
__instance_init__(this, object_exit, null, 1, 0, sprite_exit, 1, 21);
this.on_creation = on_creation_i;
this.on_destroy = on_destroy_i;
this.on_step = function() {
with(this) {
if(mouse_check_pressed() && position_meeting(mapx(mouse_x) + room_viewport_x, mapy(mouse_y) + room_viewport_y, this)) {
window.close();
}
}
};
this.on_end_step = on_end_step_i;
this.on_collision = on_collision_i;
this.on_roomstart = on_roomstart_i;
this.on_roomend = on_roomend_i;
this.on_animationend = on_animationend_i;
this.on_draw = on_draw_i;
}; var object_exit = new __object_exit();

function __object_menu() {
__instance_init__(this, object_menu, null, 1, 0, sciach, 1, 26);
this.on_creation = on_creation_i;
this.on_destroy = on_destroy_i;
this.on_step = function() {
with(this) {
this.x = room_viewport_x+420;
this.y = room_viewport_y+10;
image_index = 0;
if(mouse_check_pressed() && position_meeting(mapx(mouse_x) + room_viewport_x, mapy(mouse_y) + room_viewport_y, this)) {
   room_goto_first();
   /*
   if(parameters[0] == undefined){
   room_goto(scene_count);
   } else {
   room_goto(parameters[0]);
   }
   */
}
}
};
this.on_end_step = on_end_step_i;
this.on_collision = on_collision_i;
this.on_roomstart = on_roomstart_i;
this.on_roomend = on_roomend_i;
this.on_animationend = on_animationend_i;
this.on_draw = on_draw_i;
}; var object_menu = new __object_menu();

function __obj_back_create() {
__instance_init__(this, obj_back_create, null, 1, 0, null, 0, 27);
this.on_creation = on_creation_i;
this.on_destroy = on_destroy_i;
this.on_step = on_step_i;
this.on_end_step = on_end_step_i;
this.on_collision = on_collision_i;
this.on_roomstart = on_roomstart_i;
this.on_roomend = on_roomend_i;
this.on_animationend = on_animationend_i;
this.on_draw = function() {
if (this.visible == 1) {
__handle_sprite__(this);
with(this) {
depth = 1000;

draw_set_color( 129,  220,  240);
draw_rectangle(0, 0, room_width, 200);
var pole = room_width;
//while (  ){}
draw_set_color(0, 204, 0);
draw_rectangle(0, 200, room_width, room_height);
}
}
};
}; var obj_back_create = new __obj_back_create();

function __obj_about() {
__instance_init__(this, obj_about, null, 1, 0, null, 1, 28);
this.on_creation = on_creation_i;
this.on_destroy = on_destroy_i;
this.on_step = on_step_i;
this.on_end_step = on_end_step_i;
this.on_collision = on_collision_i;
this.on_roomstart = on_roomstart_i;
this.on_roomend = on_roomend_i;
this.on_animationend = on_animationend_i;
this.on_draw = function() {
if (this.visible == 1) {
__handle_sprite__(this);
with(this) {
draw_set_color(0, 0, 102);
draw_set_font(font_33);
draw_set_halign(fa_center);
draw_set_valign(fa_middle);
draw_text_ml(x, y, '"Ninja Survival"##This is testing game, it is fully playable,# but needs some customization,# Any suggestion are welcome, some donation too.#What in next version? You can decide.##How play?##arrows onscreen and keyboard = move,#onscreen squer/space key = jump,#onscreen star/x key = throw star,#onscreen x / c key = knife attack.## #Copyright ydk2#http://www.ydk2.tk', font_33.size);
}
}
};
}; var obj_about = new __obj_about();

function __enemy_dup() {
__instance_init__(this, enemy_dup, null, 1, 0, ludzik, 1, 31);
this.on_creation = function() {
with(this) {
this.depth = Math.round((room_height - this.y+this.sprite_index.height)/depth_x);
this.image_start = 0;    //the animation will cycle from this frame
this.image_end = 0;      //the animation will cycle to this frame
this.fullenergy = enemy_energy;
this.energy = fullenergy;
this.longs = 0;
this.depths = 0;
this.start_waits = 30;
this.waits = inrandom(start_waits,(start_waits*4));
this.atack = [0,0];
this.gow = [x,y];
this.start_attack = inrandom((waits*3),(waits*4));
this.attack = start_attack;
this.memove = 0;
this.alarm = "I am here";
this.players = null;
this.ihelp = [0,0];
//image_xscale = (this.y+this.sprite_index.width)/500;
//image_yscale = (this.y+this.sprite_index.height)/500;
}
};
this.on_destroy = function() {
with(this) {
killed = killed + 1;
//total_killed = total_killed + 1;
if(helps == this.id){
helps = 0;
}

/*
if(localStorage.getItem('killed') < total_killed){
localStorage.setItem('killed', total_killed);
}
*/
}
};
this.on_step = function() {
with(this) {
this.depth = Math.round((room_height - this.y+this.sprite_index.height)/depth_x);

this.other = place_meeting(x,y,enemy);

if (this.other != null) {
if(this.id != this.other.id){
if(this.depth <= this.other.depth+1 || this.depth >= this.other.depth - 1) {
if(direction==180){
image_start = 21;
image_end = 21;
}
if(direction==0){
image_start = 22;
image_end = 22;
}
	if(this.other.x > this.x){
		x = x-2;
	} else {
		x = x+2;
	}
	if(this.other.y > this.y){
		y = y-2;
	} else {
		y = y+2;
	}
}}
} else {

}

if(this.depth >= max_up ){
y = yprevious+2;
}

if ( x < 0 ) x = 0;
if ( x > room_width-(Math.round(this.sprite_index.width * image_xscale)) ) x = room_width-(Math.round(this.sprite_index.width * image_xscale));
if ( y < 0 ) y = 0;
if ( y > room_height-(Math.round(this.sprite_index.height * image_yscale)) ) y = room_height-(Math.round(this.sprite_index.height * image_yscale));
}
};
this.on_end_step = function() {
with(this) {
if((waits > 0 && waits < start_waits) || attack == 0) { //1

if (gow[0] != x && gow[1] != y){ //2
memove = 1;
if(gow[0]%2 && attack > 0){ //3
x = xprevious;
} else { //e3 // 3
x = (x > gow[0])? x-2:x+2;
} //3
if(gow[1]%2 && attack > 0){ //3
y = yprevious;
} else { //e3 // 3
y = (y > gow[1])? y-2:y+2;
} //3
if(gow[0] > x){ // 0
this.direction = 0;
} else {
this.direction = 180;
} //0
} else {
memove = 0;
} //2
} // 1

if(this.energy <= 0) {
memove = 3;
instance_destroy();
}

players = instance_first(paypal);
longs = instance_first(paypal).x - this.x;
depths = instance_first(paypal).depth - this.depth;
alarm = "";

if(((longs < 150 && longs >= 0) || (longs > -150 && longs <= 0)) && ((depths < 15 && depths >= 0) || (depths > -15 && depths <= 0))){
if(players.x > this.x) {
this.direction = 0;
} else {
this.direction = 180;
}
// attack

//memove = 4;
gow[0] = xprevious;
gow[1] = yprevious;
// attack
alarm = "?";
if(players.direction != direction){ // dir
alarm = "?";
memove = 1;
if(longs < 100 && longs >= 0){
x = x + 2;
} // 1
if(longs > -100 && longs <= 0){
x = x - 2;
} 

if(depths < 10 && depths >= 0){
y = y - 2;
} 
if(depths > -10 && depths <= 0){
y = y + 2;
}
} // dir

if(players.direction == direction){ //2
memove = 1;
alarm = "!";
	if(longs < 100 && longs >= 0){
		x = x + 2;
	} 
	if(longs > -100 && longs <= 0){
		x = x - 2;
	} 

	if(depths < 10 && depths >= 0){
		y = y - 2;
	} 
	if(depths > -10 && depths <= 0){
		y = y + 2;
	}
} //2

// defend
if((players.direction != direction && energy < (fullenergy/2))){ //3
memove = 1;
alarm = "Wrrr...";
	if(longs < 100 && longs >= 0){
		x = x - 2;
	} 
	if(longs > -100 && longs <= 0){
		x = x + 2;
	} 

	if(depths < 10 && depths >= 0){
		y = y + 2;
	} 
	if(depths > -10 && depths <= 0){
		y = y - 2;
	}
} //3

if(attack == 0){ // attack
memove = 1;
alarm = "?#™€ß !!!";
	if(longs < 150 && longs >= 0){
		x = x + 1;
	} 
	if(longs > -150 && longs <= 0){
		x = x - 1;
	} 

	if(depths < 15 && depths >= 0){
		y = y - 1;
	} 
	if(depths > -15 && depths <= 0){
		y = y + 1;
	}
} // attack

// defend
if((players.direction != direction && energy < Math.round(fullenergy/3)) && attack > 0){
memove = 1;

	if(longs < 150 && longs >= 0){
		x = x - 4;
	} 
	if(longs > -150 && longs <= 0){
		x = x + 4;
	} 

	if(depths < 15 && depths >= 0){
		y = y + 4;
	} 
	if(depths > -15 && depths <= 0){
		y = y - 4;
	}
	ihelp[0] = irandom(Math.round(waits/2));
	ihelp[1] = irandom(Math.round(waits/2));
	if(ihelp[0] == ihelp[1]){
	helps = this.id;
	} 
	alarm = "Auu ...";
	if(helps == this.id){
	alarm = "Help!!!";
		if('vibrate' in window.navigator) {
		// ... vibrate for a second
		window.navigator.vibrate([100,200,100.50]);
		}
	}
} 

if(helps != 0){
if(helps != this.id){
//alarm = "Hurra!!!";
attack = 0;
} else { // id
alarm = "Help !!!";
helpx =players.x;
helpy =players.y;
} // id
} // help
if(helps == 0) {
if(helps == this.id){
helps = 0;
alarm = "Uff...";
}
} // help

if(attack >= 0 || attack <= start_attack){
attack = attack - 1;
}

}  else {
if(helps == this.id){
helps = 0;
}
}

if(((longs < 150 && longs >= 0) || (longs > -150 && longs <= 0)) && ((depths < 15 && depths >= 0) || (depths > -15 && depths <= 0))){
//memove =4;

if((this.depth == players.depth) || (this.depth == players.depth+1) || (this.depth == players.depth-1)) {
if((longs < 50 && longs >= 0) || (longs > -50 && longs <= 0)){
atack[0] = irandom(5);
atack[1] = irandom(5);
if(atack[0] == atack[1]){
alarm = "Aaa!!!";
	memove = 4;
if(direction==180){
	miecz = instance_create(this.x-40,this.y,ciach_l_dup);
}
if(direction==0){
	miecz = instance_create(this.x+40,this.y,ciach_r_dup);
}
	miecz.image_start = 0;
	miecz.image_end = 2;
	miecz.depth = depth;
	miecz.direction = direction;
	attack = start_attack;
 
}
} else if((longs < 150 && longs >= 0) || (longs > -150 && longs <= 0)) {
atack[0] = irandom(10);
atack[1] = irandom(10);
if(atack[0] == atack[1]){
alarm = "Hmm...";
 memove = 4;
   bullet = instance_create(this.x+15,this.y + 50,ciach_dup);
   bullet.depth = depth;
   bullet.direction = direction;
   bullet.speed = 15;
   attack = start_attack;
}
}
}

} else {
//memove = 1;
waits = waits - 1;
if(waits == 0){
if(attack == 0){
gow[0] = players.x;
gow[1] = players.y;
} else {
gow[0] = irandom(room_width-this.sprite_index.width);
gow[1] = inrandom((room_height - (max_up * depth_x) + 50),room_height);
}
//memove = 1;
waits = inrandom(start_waits,(start_waits*4));
//(liczba%2)? "nieparzysta": "parzysta"
} //w=0
}

if(attack <= 0){
attack = 0;
memove = 1;
gow[0] = players.x;
gow[1] = players.y;
}

if(helps != this.id && helps != 0){
memove = 1;
gow[0] = helpx;
gow[1] = helpy;
}

if(memove > 0){

if(memove == 1){
if(direction==180){
image_start = 12 ;
image_end = 17;
}
if(direction==0){
image_start = 18;
image_end = 20;
}
}

if(memove == 2){
if(direction==180){
image_start = 0 ;
image_end = 5;
}
if(direction==0){
image_start = 6;
image_end = 12;
}
}

if(memove == 3){
if(direction==180){
image_start = 22 ;
image_end = 22;
}
if(direction==0){
image_start = 21;
image_end = 21;
}
}

if(memove == 4){
if(direction==180){
image_start = 23 ;
image_end = 25;
}
if(direction==0){
image_start = 26;
image_end = 28;
}
}

} else {
if(direction==0){
image_start = 0 ;
image_end = 5;
}
if(direction==180){
image_start = 6;
image_end = 12;
}
}

if(this.depth >= max_up ){
y = yprevious+2;
}

if ( x < 0 ) x = 0;
if ( x > room_width-(Math.round(this.sprite_index.width * image_xscale)) ) x = room_width-(Math.round(this.sprite_index.width * image_xscale));
if ( y < 0 ) y = 0;
if ( y > room_height-(Math.round(this.sprite_index.height * image_yscale)) ) y = room_height-(Math.round(this.sprite_index.height * image_yscale));
}
};
this.on_collision = on_collision_i;
this.on_roomstart = on_roomstart_i;
this.on_roomend = on_roomend_i;
this.on_animationend = on_animationend_i;
this.on_draw = function() {
if (this.visible == 1) {
__handle_sprite__(this);
with(this) {
//
//character animation based on forever increasing image_index
if(image_index < image_start || image_index > image_end) {
	image_index = image_start; //keeping the image_index in the required value
}

draw_sprite(sprite_index, image_index, x, y);
draw_set_color(0, 0, 0);
draw_set_halign(fa_center);
draw_set_valign(fa_middle);
if(alarm != "" ){
draw_set_font(font_99);
draw_text(x+20,y-40," "+alarm+" ");
}
draw_set_font(font_33);
draw_text(x+20,y-20," "+this.energy+" hp");

}
}
};
}; var enemy_dup = new __enemy_dup();

function __tree() {
__instance_init__(this, tree, null, 1, 0, sprite_tree, 1, 34);
this.on_creation = function() {
with(this) {
this.depth = Math.round((room_height - this.y+this.sprite_index.height)/depth_x);
var tree_i = inrandom(0,2);
this.image_start = tree_i;    //the animation will cycle from this frame
this.image_end = tree_i;      //the animation will cycle to this frame

//image_xscale = (this.y+this.sprite_index.width)/500;
//image_yscale = (this.y+this.sprite_index.height)/500;
}
};
this.on_destroy = on_destroy_i;
this.on_step = function() {
with(this) {
this.depth = Math.round((room_height - this.y+this.sprite_index.height)/depth_x);
/**
this.other = place_meeting(x,y,enemy) || place_meeting(this.x,this.y,player);

if (this.other != null) {
if(this.id != this.other.id){
if(this.depth <= this.other.depth+1 || this.depth >= this.other.depth - 1) {
if(direction==180){
image_start = 21;
image_end = 21;
}
if(direction==0){
image_start = 22;
image_end = 22;
}
	if(this.other.x > this.x){
		x = x-2;
	} else {
		x = x+2;
	}
	if(this.other.y > this.y){
		y = y-2;
	} else {
		y = y+2;
	}
}}
} else {

}
**/
if(this.depth >= max_up ){
y = yprevious+2;
}

if ( x < 0 ) x = 0;
if ( x > room_width-(Math.round(this.sprite_index.width * image_xscale)) ) x = room_width-(Math.round(this.sprite_index.width * image_xscale));
if ( y < 0 ) y = 0;
if ( y > room_height-(Math.round(this.sprite_index.height * image_yscale)) ) y = room_height-(Math.round(this.sprite_index.height * image_yscale));
}
};
this.on_end_step = on_end_step_i;
this.on_collision = on_collision_i;
this.on_roomstart = on_roomstart_i;
this.on_roomend = on_roomend_i;
this.on_animationend = on_animationend_i;
this.on_draw = function() {
if (this.visible == 1) {
__handle_sprite__(this);
with(this) {
//
//character animation based on forever increasing image_index
if(image_index < image_start || image_index > image_end) {
	image_index = image_start; //keeping the image_index in the required value
}

draw_sprite(sprite_index, image_index, x, y);

}
}
};
}; var tree = new __tree();



/***********************************************************************
 * SCENES
 ***********************************************************************/
function __scene_start() { 
this.tiles = [
];
this.objects = [
[{o:object_start, x:120, y:20}],
[{o:object_about, x:120, y:100}],
[{o:object_exit, x:120, y:180}],
[{o:paypal, x:20, y:20}]];
this.start = function() {
__room_start__(this, scene_start, 480, 320, 10, 0, 172, 228, null, 0, 0, 0, 480, 320, null, 50, 50);

while (tu_vkeys.length > 0) {
  tu_vkeys.pop();

}
var obj_lk = vkey_add( 1,1,50,50,vk_left);
var obj_rk = vkey_add( 1,1,50,50,vk_right);
var obj_dk = vkey_add( 1,1,50,50,vk_down);
var obj_uk = vkey_add( 1,1,50,50,vk_up);
var obj_xk = vkey_add( 1,1,50,50,vk_x);
var obj_ck = vkey_add( 1,1,50,50,vk_c);
var obj_jk = vkey_add( 1,1,50,50,vk_space);
/*
obl = instance_create(5,5,obj_l);
obr = instance_create(5,5,obj_r);
obd = instance_create(5,5,obj_d);
obu = instance_create(5,5,obj_u);
obx = instance_create(5,5,obj_x);
obc = instance_create(5,5,obj_c);
obj = instance_create(5,5,obj_j);
logso = instance_create(5,5,logs);


//instance_create(0,0,ground);
//instance_create(0,0,sky);

	if(load_web_integer(0)) {
		total_killed = load_web_integer(0);
	}
//total_killed = localStorage.getItem('killed');
 

instance_create(irandom(room_width),inrandom((room_height - (max_up * depth_x) + 50),room_height),player);
if(tokilled < 5){
total_killed = total_killed;
player_energy = player_tmp_energy+player_tmp;
}
for (var ai = 0; ai < tokilled; ai++) {
instance_create(irandom(room_width),inrandom((room_height - (max_up * depth_x) + 50),room_height),enemy);
}
enemy_energy = tmp_energy+(tokilled*2);
helps = 0;

init_auto_scale();
*/
init_auto_scale();

};
}
var scene_start = new __scene_start();
tu_scenes.push(scene_start);
function __scene_game() { 
this.tiles = [
];
this.objects = [
];
this.start = function() {
__room_start__(this, scene_game, 1000, 600, 15, 0, 0, 0, null, 0, 0, 0, 480, 320, player, 100, 100);

/*
obl = instance_create(5,5,obj_l);
obr = instance_create(5,5,obj_r);
obd = instance_create(5,5,obj_d);
obu = instance_create(5,5,obj_u);
obx = instance_create(5,5,obj_x);
obc = instance_create(5,5,obj_c);
obj = instance_create(5,5,obj_j);
logso = instance_create(5,5,logs);


//instance_create(0,0,ground);
//instance_create(0,0,sky);

	if(load_web_integer(0)) {
		total_killed = load_web_integer(0);
	}
//total_killed = localStorage.getItem('killed');
 

instance_create(irandom(room_width),inrandom((room_height - (max_up * depth_x) + 50),room_height),player);
if(tokilled < 5){
total_killed = total_killed;
player_energy = player_tmp_energy+player_tmp;
}
for (var ai = 0; ai < tokilled; ai++) {
instance_create(irandom(room_width),inrandom((room_height - (max_up * depth_x) + 50),room_height),enemy);
}
enemy_energy = tmp_energy+(tokilled*2);
helps = 0;

init_auto_scale();
*/
init_auto_scale();

/*
x = room_viewport_x+70;
y = room_viewport_y+260;
this.x = room_viewport_x+300;
this.y = room_viewport_y+260;
this.x = room_viewport_x+10;
this.y = room_viewport_y+260;
this.x = room_viewport_x+420;
this.y = room_viewport_y+260;
this.x = room_viewport_x+360;
this.y = room_viewport_y+260;
this.x = room_viewport_x+360;
this.y = room_viewport_y+200;
x1 = Math.round(x*__ratio());
y1 = Math.round(y*__ratio());
w1 = Math.round(sprite_index.width*__ratio());
h1 = Math.round(sprite_index.height*__ratio());
//tu_vkeys = tu_vkeys.filterValue(vk_x);
var key = vkey_add( x1 , y1, w1, h1,vk_x);

*/

/**/
instance_create(0,0,obj_back_create);
//instance_create(0,0,sky);

	if(load_web_integer(1) > 0) {
		vibrate_is =  false;
	} else {
		vibrate_is = true;
	}
	if(load_web_integer(2) > 0) {
		sound_is =  false;
	} else {
		sound_is = true;
	}
	if(load_web_integer(0)) {
		total_killed = load_web_integer(0);
	}
//total_killed = localStorage.getItem('killed');
	if(load_web_integer(3) > 0) {
		
		tokilled = load_web_integer(3);
	} else {
		tokilled = tokilled;
	}


instance_create(irandom(room_width),inrandom((room_height - (max_up * depth_x) + 50),room_height),player);
if(tokilled < 5){
total_killed = total_killed;
player_energy = player_tmp_energy+player_tmp;
}
for (var ai = 0; ai < tokilled; ai++) {
instance_create(irandom(room_width),inrandom((room_height - (max_up * depth_x) + 50),room_height),enemy);
}
enemy_energy = tmp_energy+(tokilled*2);
helps = 0;

for (var ai = 0; ai < inrandom(3,10); ai++) {
instance_create(irandom(room_width),inrandom((room_height - (max_up * depth_x) + 50),room_height),tree);
}

var obl = instance_create(lx,ly,obj_l);
var obd = instance_create(dx,dy,obj_d);
var obr = instance_create(rx,ry,obj_r);
var obu = instance_create(ux,uy,obj_u);
var obx = instance_create(xx,xy,obj_x);
var obc = instance_create(cx,cy,obj_c);
var obj = instance_create(jx,jy,obj_j);
var logso = instance_create(5,5,logs);
//var obp = instance_create(400,10,obj_pause);
/**/
instance_create(420,10,object_menu);
vkey_mod( Math.round((room_viewport_x+obl.x)*__ratio()) , Math.round((room_viewport_x+obl.y)*__ratio()), Math.round(obl.sprite_index.width*__ratio()), Math.round(obl.sprite_index.height*__ratio()),vk_left);
vkey_mod( Math.round((room_viewport_x+obr.x)*__ratio()) , Math.round((room_viewport_x+obr.y)*__ratio()), Math.round(obr.sprite_index.width*__ratio()), Math.round(obr.sprite_index.height*__ratio()),vk_right);
vkey_mod( Math.round((room_viewport_x+obd.x)*__ratio()) , Math.round((room_viewport_x+obd.y)*__ratio()), Math.round(obd.sprite_index.width*__ratio()), Math.round(obd.sprite_index.height*__ratio()),vk_down);
vkey_mod( Math.round((room_viewport_x+obu.x)*__ratio()) , Math.round((room_viewport_x+obu.y)*__ratio()), Math.round(obu.sprite_index.width*__ratio()), Math.round(obu.sprite_index.height*__ratio()),vk_up);
vkey_mod( Math.round((room_viewport_x+obx.x)*__ratio()) , Math.round((room_viewport_x+obx.y)*__ratio()), Math.round(obx.sprite_index.width*__ratio()), Math.round(obx.sprite_index.height*__ratio()),vk_x);
vkey_mod( Math.round((room_viewport_x+obc.x)*__ratio()) , Math.round((room_viewport_x+obc.y)*__ratio()), Math.round(obc.sprite_index.width*__ratio()), Math.round(obc.sprite_index.height*__ratio()),vk_c);
vkey_mod( Math.round((room_viewport_x+obj.x)*__ratio()) , Math.round((room_viewport_x+obj.y)*__ratio()), Math.round(obj.sprite_index.width*__ratio()), Math.round(obj.sprite_index.height*__ratio()),vk_space);
//var obpk = vkey_add( Math.round((room_viewport_x+obp.x)*__ratio()) , Math.round((room_viewport_x+obp.y)*__ratio()), Math.round(obp.sprite_index.width*__ratio()), Math.round(obp.sprite_index.height*__ratio()),vk_pause);
//var obpk = vkey_add( Math.round((room_viewport_x+obp.x)*__ratio()) , Math.round((room_viewport_x+obp.y)*__ratio()), Math.round(obp.sprite_index.width*__ratio()), Math.round(obp.sprite_index.height*__ratio()),vk_pause);
/*
window.onresize = function(event) {
while (tu_vkeys.length > 0) {
  tu_vkeys.pop();
}
var oblk = vkey_add( Math.round((room_viewport_x+obl.x)*__ratio()) , Math.round((room_viewport_x+obl.y)*__ratio()), Math.round(obl.sprite_index.width*__ratio()), Math.round(obl.sprite_index.height*__ratio()),vk_left);
var obrk = vkey_add( Math.round((room_viewport_x+obr.x)*__ratio()) , Math.round((room_viewport_x+obr.y)*__ratio()), Math.round(obr.sprite_index.width*__ratio()), Math.round(obr.sprite_index.height*__ratio()),vk_right);
var obdk = vkey_add( Math.round((room_viewport_x+obd.x)*__ratio()) , Math.round((room_viewport_x+obd.y)*__ratio()), Math.round(obd.sprite_index.width*__ratio()), Math.round(obd.sprite_index.height*__ratio()),vk_down);
var obuk = vkey_add( Math.round((room_viewport_x+obu.x)*__ratio()) , Math.round((room_viewport_x+obu.y)*__ratio()), Math.round(obu.sprite_index.width*__ratio()), Math.round(obu.sprite_index.height*__ratio()),vk_up);
var obxk = vkey_add( Math.round((room_viewport_x+obx.x)*__ratio()) , Math.round((room_viewport_x+obx.y)*__ratio()), Math.round(obx.sprite_index.width*__ratio()), Math.round(obx.sprite_index.height*__ratio()),vk_x);
var obck = vkey_add( Math.round((room_viewport_x+obc.x)*__ratio()) , Math.round((room_viewport_x+obc.y)*__ratio()), Math.round(obc.sprite_index.width*__ratio()), Math.round(obc.sprite_index.height*__ratio()),vk_c);
var objk = vkey_add( Math.round((room_viewport_x+obj.x)*__ratio()) , Math.round((room_viewport_x+obj.y)*__ratio()), Math.round(obj.sprite_index.width*__ratio()), Math.round(obj.sprite_index.height*__ratio()),vk_space);
//var obpk = vkey_add( Math.round((room_viewport_x+obp.x)*__ratio()) , Math.round((room_viewport_x+obp.y)*__ratio()), Math.round(obp.sprite_index.width*__ratio()), Math.round(obp.sprite_index.height*__ratio()),vk_pause);
};
*/

};
}
var scene_game = new __scene_game();
tu_scenes.push(scene_game);
function __scene_about() { 
this.tiles = [
];
this.objects = [
[{o:obj_about, x:240, y:120}],
[{o:object_menu, x:420, y:20}],
[{o:enemy_dup, x:20, y:200}],
[{o:paypal, x:380, y:240}]];
this.start = function() {
__room_start__(this, scene_about, 480, 320, 10, 0, 255, 0, null, 0, 0, 0, 480, 320, null, 50, 50);

init_auto_scale();

};
}
var scene_about = new __scene_about();
tu_scenes.push(scene_about);
function __scene_save() { 
this.tiles = [
];
this.objects = [
];
this.start = function() {
__room_start__(this, scene_save, 640, 480, 30, 0, 0, 0, null, 0, 0, 0, 640, 480, null, 50, 50);
};
}
var scene_save = new __scene_save();
tu_scenes.push(scene_save);
tu_room_to_go = scene_start;


/***********************************************************************
 * CUSTOM GLOBAL VARIABLES
 ***********************************************************************/
var jump = 0;
var i = 0;
var bum =0;
var klik_l =false;
var klik_r = false;
var klik_u = false;
var klik_d = false;
var klik_j = false;
var klik_x = false;
var klik_c = false;
var depth_x = 10;
var max_up = 60;
var killed = 0;
var tokilled = 5;
var total_killed = 0;
var enemy_energy = 20;
var tmp_energy = 20;
var player_energy = 100;
var player_tmp_energy = 100;
var player_tmp = 0;
var myground =  1;
var helpx = 0;
var helpy = 0;
var helps = 0;
var pause = 0;
var sound_is = true;
var sound_volume_is = 10;
var vibrate_is = true;
var is_load = false;
//var ratio = new __ratio();

var jx = 10;
var jy =  250;
var xx = 75;
var xy = 250;
var cx = 10;
var cy = 185;

var lx = 280;
var ly = 250;
var dx = 345; var ux = 345;
var dy =250; var uy = 185;
var rx = 410;
var ry = 250;



/***********************************************************************
 * CUSTOM GLOBAL FUNCTIONS
 ***********************************************************************/
function inrandom(min,max)
{
	return Math.floor(Math.random() * (max - min + 1)) + min;
}
var vkey_mod = function(_x, _y, _w, _h, _k) {
	var _v = { top: _y, left: _x, right: _x+_w, bottom: _y+_h, key: _k, down: false, active: true, width: _w, height: _h };
	for (var _a in tu_vkeys) {
		if (tu_vkeys[_a].key == _k) {
		tu_vkeys[_a] = _v;
		};
	};
	//return _v;
};
function draw_text_ml(x, y, text, vspacing) {
    var i, a = (text + '').split('#'),
        l = a.length, v = (vspacing ? vspacing : 0);
    if (tu_draw_valign == fa_bottom) y -= (l - 1) * v;
    if (tu_draw_valign == fa_middle) y -= (l - 1) * v / 2;
    for (i = 0; i < l; i++) {
        draw_text(x, y, a[i]);
        y += v;
    }
}

function executeFunctionByName(functionName, context /*, args */) {
  var args = [].slice.call(arguments).splice(2);
  var namespaces = functionName.split(".");
  var func = namespaces.pop();
  for(var i = 0; i < namespaces.length; i++) {
    context = context[namespaces[i]];
  }
  return context[func].apply(this, args);
}
/*
function tu_preloader() {
	var _w = Math.min(400, (tu_canvas.width * 0.6) >> 0), _h = 16,
		_x = (tu_canvas.width - _w) >> 1, _y = (tu_canvas.height - _h) >> 1,
		_p = (tu_load_total - tu_loading) / tu_load_total,
		_s = "Loading resources: " + (tu_load_total - tu_loading) + "/" + (tu_load_total);
	tu_canvas.width = tu_canvas.width;
	tu_canvas.height = tu_canvas.height;
	var splashscreen = document.getElementById('splashscreen');
	if (splashscreen) {
	tu_context.drawImage(splashscreen, 0, 0, tu_canvas.width, tu_canvas.height);
	};
	tu_canvas.style.backgroundColor = "rgb(142, 142, 142)";
	tu_context.font = "bold 12px Arial";
	tu_context.textAlign = "left";
	tu_context.textBaseline = "bottom";
	tu_context.fillStyle = tu_context.strokeStyle = "rgba(12, 12, 12, 1)";
	tu_context.fillRect(_x - 1, _y - 1, _w + 2, _h + 2);
	tu_context.fillStyle = tu_context.strokeStyle = "rgba(0, 0, 0, 1)";
	tu_context.fillRect(_x, _y, _w, _h);
	tu_context.fillStyle = tu_context.strokeStyle = "rgba(25, 25, 25, 1)";
	tu_context.fillRect(_x + 2, _y + 2, (_w - 4) * _p, _h - 4);
	tu_context.fillText(_s, _x, _y - 2);
	tu_context.font = "bold 34px Arial";
	//tu_context.textAlign = "center";
	tu_context.fillText(game_name, _x, _y - 30);
}
*/


tu_gameloop = tu_loop;
tu_loop();
