BasicGame = {
    system: {
        music: null,
        se_oh: null,
        se_bom: null,
        se_get: null,
        se_jump: null,
        se_logo: null,
        se_on: null,
        se_out: null,
        se_pow: null,
        se_tap: null,
        se_coin: null,
        vo_ato: null,
        vo_ganbare: null,
        vo_ome: null,
        vo_sikkari: null,
        orientated: false,
    },
    const: {
        CANVAS_WIDTH: 375,
        CANVAS_HEIGHT: 667,
        MAX_WORLD_HEIGHT: 20000,
    },
    data: {
        exp: 0,
        score: 0,
        hiScore: 0,
        level: 1,
        continueLevel: 0,
        isNinvader: false,
    },
    getRandomInt: function(max) {
        return Math.floor(Math.random() * max);
    },
    getRandomBool: function() {
        return (Math.floor(Math.random() * 2) === 1) ? true : false;
    }
};

BasicGame.Boot = function(game) {};

BasicGame.Boot.prototype = {

    init: function() {

        this.input.maxPointers = 1;
        this.stage.disableVisibilityChange = true;

        if (this.game.device.desktop) {
            this.scale.scaleMode = Phaser.ScaleManager.SHOW_ALL;
            // this.scale.setMinMax(480, 260, 1024, 768);
            this.scale.pageAlignHorizontally = true;
            this.scale.pageAlignVertically = true;
            this.scale.setScreenSize(true);
            this.scale.refresh();
        } else {
            this.scale.scaleMode = Phaser.ScaleManager.SHOW_ALL;
            // this.scale.setMinMax(480, 260, 1024, 768);
            this.scale.pageAlignHorizontally = true;
            this.scale.pageAlignVertically = true;
            this.scale.forceOrientation(true, false);
            this.scale.setResizeCallback(this.gameResized, this);
            this.scale.enterIncorrectOrientation.add(this.enterIncorrectOrientation, this);
            this.scale.leaveIncorrectOrientation.add(this.leaveIncorrectOrientation, this);
            this.scale.setScreenSize(true);
            this.scale.refresh();
        }

    },

    preload: function() {

        // 画面の初期化
        var r = 50;
        var g = 150;
        var b = 220;
        this.game.stage.backgroundColor = Phaser.Color.getColor(r, g, b);
        this.physics.startSystem(Phaser.Physics.ARCADE);

        // プログレス画像の読み込み
        this.load.image('preloaderBar', 'images/system/preloadr_bar.png');
        this.load.image('preloaderBase', 'images/system/preloadr_base.png');
    },

    create: function() {

        this.state.start('Preloader');

    },

    gameResized: function(width, height) {

        //  This could be handy if you need to do any extra processing if the game resizes.
        //  A resize could happen if for example swapping orientation on a device or resizing the browser window.
        //  Note that this callback is only really useful if you use a ScaleMode of RESIZE and place it inside your main game state.

    },

    enterIncorrectOrientation: function() {

        BasicGame.system.orientated = false;

        // blockにするとその方向は不可になる
        // document.getElementById('orientation').style.display = 'block';
        document.getElementById('orientation').style.display = 'none';

    },

    leaveIncorrectOrientation: function() {

        BasicGame.system.orientated = true;

        document.getElementById('orientation').style.display = 'none';

    }

};
