BasicGame.Game = function(game) {
    this.objects = {
        bg: null,
        clouds: null,
        floors: null,
        items: null,
        kens: null,
        shots: null,
        spikes: null,
        invaders: null,
        ufos: null,
        bom: null,
        emitter: null,
        ninja: null,
        ground: null,
        scoreLabel: null,
        expLabel: null,
    };
    this.data = {
        nextFloor: 0,
        nextCloud: 0,
        isBoost: false,
        fpsSkip: false,
        isUfo: false,
        ufoLife: 0,
        isClear: false,
        clearCameraY: 0,
    };
};

BasicGame.Game.prototype = {
    preload: function() {
        //fps
        // this.game.time.advancedTiming = true;
    },

    create: function() {
        // 画面サイズ変更
        this.world.setBounds(0, 0, BasicGame.const.CANVAS_WIDTH, BasicGame.const.MAX_WORLD_HEIGHT);

        // BGM
        BasicGame.system.music = this.add.audio('game');
        BasicGame.system.music.play('', 0, 1, true);

        // INPUT
        this.cursor = this.input.keyboard.createCursorKeys();

        // 背景
        this.objects.bg = this.add.sprite(0, this.world.height - 80, 'sprite', 'bg.png');
        this.objects.bg.anchor.setTo(0, 1);

        // 雲
        this.objects.clouds = this.add.group();
        this.objects.clouds.createMultiple(10, 'sprite', 'kumo_01.png');
        this.physics.arcade.enable(this.objects.clouds);
        this.objects.clouds.setAll('outOfBoundsKill', true);

        // 床
        this.objects.floors = this.add.group();
        this.objects.floors.createMultiple(80, 'sprite', 'yuka_01.png');
        this.physics.arcade.enable(this.objects.floors);
        // 動きを固定
        this.objects.floors.setAll('body.immovable', true);
        // 当たり判定をなくす
        this.objects.floors.setAll('body.checkCollision.down', false);
        this.objects.floors.setAll('body.checkCollision.right', false);
        this.objects.floors.setAll('body.checkCollision.left', false);

        // 巻物
        this.objects.items = this.add.group();
        this.objects.items.createMultiple(20, 'sprite', 'item_dash.png');
        this.physics.arcade.enable(this.objects.items);

        // 吊り天井
        this.objects.spikes = this.add.group();
        this.objects.spikes.createMultiple(6, 'sprite', 'yuka_02.png');
        this.physics.arcade.enable(this.objects.spikes);

        /// 爆発
        this.objects.bom = this.add.emitter(0, 0, 400);
        this.objects.bom.makeParticles('sprite', 'dot.png');
        this.objects.bom.setYSpeed(-120, 120);
        this.objects.bom.setXSpeed(-120, 120);
        this.objects.bom.gravity = 0;

        // 忍ベーダー、鳥
        this.objects.ninvaders = this.add.group();
        this.objects.ninvaders.createMultiple(6, 'sprite', 'bird_01.png');
        this.objects.ninvaders.callAll('animations.add', 'animations', 'bird_l', ['bird_04.png', 'bird_08.png'], 4, true);
        this.objects.ninvaders.callAll('animations.add', 'animations', 'bird_r', ['bird_02.png', 'bird_06.png'], 4, true);
        this.objects.ninvaders.callAll('animations.add', 'animations', 'vader_l', ['ninvader_04.png', 'ninvader_08.png'], 4, true);
        this.objects.ninvaders.callAll('animations.add', 'animations', 'vader_r', ['ninvader_02.png', 'ninvader_06.png'], 4, true);
        this.physics.arcade.enable(this.objects.ninvaders);

        // パーティクル
        this.objects.emitter = this.add.emitter(0, 0, 200);
        this.objects.emitter.makeParticles('sprite', 'kira.png');
        this.objects.emitter.gravity = 20;
        this.objects.emitter.setAlpha(0.5, 1, 2000);
        this.objects.emitter.setScale(0.4, 1, 0.4, 1, 1000, Phaser.Easing.Quintic.Out);
        this.objects.emitter.start(false, 2000, 15, 0);
        this.objects.emitter.width = 40;
        this.objects.emitter.on = false;

        // UFO
        this.objects.ufos = this.add.group();
        this.objects.ufos.createMultiple(1, 'sprite', 'ufo_02_1.png');
        this.objects.ufos.callAll('animations.add', 'animations', 'ufo_r1', ['ufo_02_1.png', 'ufo_06_1.png'], 4, true);
        this.objects.ufos.callAll('animations.add', 'animations', 'ufo_l1', ['ufo_04_1.png', 'ufo_08_1.png'], 4, true);
        this.objects.ufos.callAll('animations.add', 'animations', 'ufo_r2', ['ufo_02_1.png', 'ufo_06_1.png', 'ufo_02_2.png', 'ufo_06_2.png'], 3, true);
        this.objects.ufos.callAll('animations.add', 'animations', 'ufo_l2', ['ufo_04_1.png', 'ufo_08_1.png', 'ufo_04_2.png', 'ufo_08_2.png'], 3, true);
        this.objects.ufos.callAll('animations.add', 'animations', 'ufo_r3', ['ufo_02_1.png', 'ufo_06_1.png', 'ufo_02_3.png', 'ufo_06_3.png'], 2, true);
        this.objects.ufos.callAll('animations.add', 'animations', 'ufo_l3', ['ufo_04_1.png', 'ufo_08_1.png', 'ufo_04_3.png', 'ufo_08_3.png'], 2, true);
        this.physics.arcade.enable(this.objects.ufos);

        // 忍者
        this.objects.ninja = this.add.sprite(this.world.centerX + 100, this.world.height - 200, 'sprite', 'ninja_03.png');
        this.objects.ninja.anchor.setTo(0.5, 1);
        this.physics.arcade.enable(this.objects.ninja);
        this.objects.ninja.body.gravity.y = 300;
        this.objects.ninja.animations.add('up', ['ninja_01.png', 'ninja_06.png'], 4, true);
        this.objects.ninja.animations.add('right', ['ninja_02.png'], 8);
        this.objects.ninja.animations.add('down', ['ninja_03.png'], 8);
        this.objects.ninja.animations.add('left', ['ninja_04.png'], 8);
        this.objects.ninja.animations.add('out', ['ninja_05.png', 'ninja_10.png'], 4, true);
        this.objects.ninja.play('down');

        // 剣
        this.objects.kens = this.add.group();
        this.objects.kens.createMultiple(60, 'sprite', 'ken.png');
        this.physics.arcade.enable(this.objects.kens);

        // 手裏剣
        this.objects.shots = this.add.group();
        this.objects.shots.createMultiple(8, 'sprite', 'shuriken_01.png');
        this.objects.shots.callAll('animations.add', 'animations', 'shot', ['shuriken_01.png', 'shuriken_02.png'], 8, true);
        this.physics.arcade.enable(this.objects.shots);
        this.objects.shots.outOfBoundsKill = true;

        // 地面
        this.objects.ground = this.add.sprite(0, this.world.height, 'sprite', 'ground.png');
        this.objects.ground.anchor.setTo(0, 1);
        this.physics.arcade.enable(this.objects.ground);
        this.objects.ground.body.immovable = true;

        // ✕カメラを設定
        // this.camera.follow(this.objects.ninja, Phaser.Camera.FOLLOW_PLATFORMER);
        // // game.camera.deadzone = new Phaser.Rectangle(100, 100, 600, 400);

        // 手動でカメラを動かす
        this.camera.bounds = null;
        this.camera.y = BasicGame.const.MAX_WORLD_HEIGHT - BasicGame.const.CANVAS_HEIGHT;

        // 得点
        if (BasicGame.data.score > BasicGame.data.hiScore) {
            BasicGame.data.hiScore = BasicGame.data.score;
        }
        BasicGame.data.score = 0;
        this.objects.scoreLabel = this.add.text(10, 10, "", {
            font: '18px Hiragino Kaku Gothic Pro',
            fill: '#fff'
        });
        // オーバーレイ
        this.objects.scoreLabel.fixedToCamera = true;
        this.objects.scoreLabel.cameraOffset.setTo(10, 10);

        BasicGame.data.exp = 0;
        this.objects.expLabel = this.add.text(10, 10, "", {
            font: '18px Hiragino Kaku Gothic Pro',
            align: 'right',
            fill: '#fff',
        });
        this.objects.expLabel.anchor.setTo(1, 0);
        // オーバーレイ
        this.objects.expLabel.fixedToCamera = true;
        this.objects.expLabel.cameraOffset.setTo(BasicGame.const.CANVAS_WIDTH - 10, 10);

        // 初期化
        BasicGame.data.level = 1;
        this.data.isBoost = false;
        this.data.isUfo = false;
        this.data.ufoLife = 100;
        this.data.isClear = false;

        this.data.nextFloor = this.world.height - 300;
        this.data.nextCloud = 0;

        if (BasicGame.data.continueLevel === 0) {
            this.setFloor(0, 0, false, ["カーソルキーで\n忍者を左右に動かそう", "画面のはじをタップ！\n忍者を左右に動かそう"]);
            this.addCloud(this.data.nextFloor);
            this.setFloor(1, 0, false, null);
            this.setFloor(2, 0, false, ["下に落ちないように\nどんどんジャンプしてね！"]);
            this.setFloor(1, 0, false, null);
            this.setFloor(3, 0, false, ["コインを集めてスコアを競おう！"]);
            this.setFloor(0, 1, true, null);
            this.addCloud(this.data.nextFloor);
            this.setFloor(3, 1, true, null);
            this.setFloor(2, 1, true, null);
            this.setFloor(1, 0, false, ["巻物をとると忍術がつかえる！"]);
            this.setFloor(1, 2, true, null);
            this.addCloud(this.data.nextFloor);
            this.setFloor(2, 2, true, null);
            this.setFloor(3, 3, true, null);
            this.setFloor(1, 1, true, null);
            this.setFloor(0, 1, true, null);
            this.addCloud(this.data.nextFloor);
            this.setFloor(3, 1, true, null);
            this.setFloor(2, 2, true, null);
            this.setFloor(1, 1, true, null);
            this.setFloor(0, 1, true, null);
            this.addCloud(this.data.nextFloor);
            this.setFloor(3, 1, true, null);
            this.setFloor(1, 0, false, ["カラスに気をつけて！\nLET'S GO! GO! GO!"]);
            this.setFloor(1, 0, true, null);
            this.setFloor(2, 1, true, null);
            this.setFloor(1, 0, true, null);
        } else {
            this.setFloor(1, 0, false, ["LET'S GO! GO! GO!"]);
            this.setFloor(1, 0, false, null);
            this.addCloud(this.data.nextFloor);
            this.setFloor(2, 0, false, null);
            this.setFloor(1, 0, false, null);
        }

        this.data.nextCloud = this.data.nextFloor - 200 - BasicGame.getRandomInt(300);

    },

    update: function() {
        if (this.data.fpsSkip) {
            this.data.fpsSkip = !this.data.fpsSkip;
            return;
        }

        // 物理演算
        if (this.objects.ninja.alive) {
            this.physics.arcade.collide(this.objects.ninja, this.objects.floors);
            this.physics.arcade.collide(this.objects.ninja, this.objects.ground);
        }
        // 忍者移動
        this.ninjaMove();

        // 下に落ちたら死亡
        if (this.data.isClear === false) {
            if (this.objects.ninja.y > this.camera.y + BasicGame.const.CANVAS_HEIGHT + this.objects.ninja.height) {
                this.quitGame();
                return;
            }
        }

        // 当たり判定
        if (this.objects.ninja.alive) {
            this.physics.arcade.overlap(this.objects.ninja, this.objects.items, this.getItem, null, this);
            this.physics.arcade.overlap(this.objects.ninja, this.objects.spikes, this.hitSpike, null, this);
            this.physics.arcade.overlap(this.objects.ninja, this.objects.ninvaders, this.hitNinvaders, null, this);
        }
        // ショット
        if (this.objects.ninja.alive) {
            this.physics.arcade.overlap(this.objects.shots, this.objects.spikes, this.shotEnemy, null, this);
            this.physics.arcade.overlap(this.objects.shots, this.objects.ninvaders, this.shotEnemy, null, this);
            this.physics.arcade.overlap(this.objects.kens, this.objects.spikes, this.shotEnemy, null, this);
            this.physics.arcade.overlap(this.objects.kens, this.objects.ninvaders, this.shotEnemy, null, this);
            this.physics.arcade.overlap(this.objects.kens, this.objects.ufos, this.shotUfo, null, this);
        }

        // カメラの移動
        var boader = this.camera.y + (BasicGame.const.CANVAS_HEIGHT / 2);
        if (boader > this.objects.ninja.y) {
            var n = (boader - this.objects.ninja.y);
            this.camera.y = this.camera.y - n;

            // 床生成
            if (this.data.isClear === false) {
                this.generateStage();
            }
        }
        // クリアならカメラ固定
        if (this.data.isClear) {
            if (this.camera.y < this.data.clearCameraY) {
                this.camera.y = this.data.clearCameraY;
            }
        }



        // スコア加算
        var exp = Math.floor((BasicGame.const.MAX_WORLD_HEIGHT - this.objects.ninja.y) / 40);
        if (BasicGame.data.exp < exp) {
            BasicGame.data.exp = exp;
            BasicGame.data.level = Math.floor(BasicGame.data.exp / 25) + 1 + BasicGame.data.continueLevel;
            if (BasicGame.data.level > 50) {
                BasicGame.data.level = 50;
            }
            this.setScoreLabel();

            var r = 50 - BasicGame.data.level;
            var g = 150 - BasicGame.data.level;
            var b = 220 - BasicGame.data.level;
            this.game.stage.backgroundColor = Phaser.Color.getColor(r, g, b);
        }

        // アップデート
        this.objects.floors.forEachAlive(this.updateFloor, this);
        this.objects.spikes.forEachAlive(this.updateFloor, this);
        this.objects.ninvaders.forEachAlive(this.updateNinvaders, this);
        this.objects.items.forEachAlive(this.updateFloor, this);
        this.objects.kens.forEachAlive(this.updateKen, this);
        this.objects.shots.forEachAlive(this.updateShot, this);
        this.objects.ufos.forEachAlive(this.updateUfo, this);
        this.objects.clouds.forEachAlive(this.updateCloud, this);
    },

    setScoreLabel: function() {
        this.objects.scoreLabel.text = "とくてん " + BasicGame.data.score;
        // this.objects.expLabel.text = BasicGame.data.exp + " m" + "(" + BasicGame.data.level + ")";
        this.objects.expLabel.text = BasicGame.data.exp + " m";
    },

    generateStage: function() {
        // 床を生成
        if (this.data.nextFloor > (this.camera.y - 100)) {

            // UFO処理
            if (BasicGame.data.level === 50) {
                if (this.data.isUfo === false) {
                    this.data.isUfo = true;
                    var ux = BasicGame.const.CANVAS_WIDTH / 2;
                    var uy = this.data.nextFloor;
                    this.addUfo(ux, uy, 200);

                    BasicGame.system.music.stop();
                    BasicGame.system.music = this.add.audio('boss');
                    BasicGame.system.music.play('', 0, 1, true);
                }
            }

            var types = [];
            // levelに合わせて床のタイプを決定
            // 0:はなれ２個床
            // 1:くっつき２個床
            // 2:１個床
            // 3:動く床
            // 4:とげ
            // 5:動く床＋とげ
            // 99:DASHアイテム

            var items = [];
            // 0:なにもなし
            // 1:コイン
            // 2:手裏剣
            // 3:DASH
            // 4:ひてん
            // 5:敵
            // 6:コイン＋敵
            // 7:手裏剣＋敵
            // 8:DASH＋敵
            // 9:ひてん＋敵

            // 基本
            if (BasicGame.data.level < 20) {
                types = [0, 0, 1, 1, 2, 3, 4, 4];
                items = [0, 1, 1, 1, 2, 2, 3, 7, 8, 8, 8];
            } else if (BasicGame.data.level < 30) {
                types = [0, 1, 1, 2, 2, 3, 3, 4, 5];
                items = [0, 1, 1, 1, 2, 3, 4, 5, 7, 7, 7, 8, 8, 8, 9, 9];
            } else if (BasicGame.data.level < 40) {
                types = [0, 1, 2, 3, 3, 4, 4, 5, 5];
                items = [0, 1, 1, 1, 2, 3, 4, 5, 6, 7, 7, 7, 8, 8, 9, 9];
            } else if (BasicGame.data.level < 50) {
                types = [0, 2, 3, 4, 4, 5, 5];
                items = [0, 1, 2, 3, 4, 5, 5, 6, 6, 7, 7, 8, 8, 9, 9];
            } else {
                types = [99];
                items = [0, 4, 4, 5, 9, 9];
            }

            // 特殊
            switch (BasicGame.data.level) {
                case 15:
                    types = [3];
                    items = [1];
                    break;
                case 25:
                    types = [4];
                    items = [3];
                    break;
                case 35:
                    types = [5];
                    items = [9];
                    break;
                case 45:
                    types = [3];
                    items = [1];
                    break;
            }

            // 地形タイプ決定
            var type = types[BasicGame.getRandomInt(types.length)];
            var item = items[BasicGame.getRandomInt(items.length)];

            this.setFloor(type, item, true, null);
        }
    },

    setFloor: function(type, item, isCoin, msg) {
        // 定数っぽいやつ
        var FLOOR_WIDTH = 80;
        var FLOOR_SPEED = 80 + (2 * BasicGame.data.level);
        // 動く床＋刺は、ちょっと速度をずらす
        var SPIKE_SPEED = FLOOR_SPEED + BasicGame.getRandomInt(10) + 4;
        var SPIKE_HEIGHT = 60;
        var ITEM_SPEED = 80;
        // ninvaderの速度
        var VADER_SPEED = FLOOR_SPEED + 10;

        // 床生成
        var x = 0;
        var y = this.data.nextFloor;
        var velocity = 0;
        var f = null;
        switch (type) {
            case 0:
                // はなれ２個床
                x = BasicGame.getRandomInt(BasicGame.const.CANVAS_WIDTH / 2);
                this.addFloor(x, y, velocity);
                if (BasicGame.getRandomBool()) {
                    // 左右対称
                    x = BasicGame.const.CANVAS_WIDTH - x;
                } else {
                    // 同じの２個
                    x = x + (BasicGame.const.CANVAS_WIDTH / 2);
                }
                this.addFloor(x, y, velocity);
                break;
            case 1:
                // くっつき２個床
                x = BasicGame.getRandomInt(BasicGame.const.CANVAS_WIDTH - FLOOR_WIDTH);
                this.addFloor(x, y, velocity);
                x = x + FLOOR_WIDTH;
                this.addFloor(x, y, velocity);
                break;
            case 2:
                // １個床
                x = BasicGame.getRandomInt(BasicGame.const.CANVAS_WIDTH);
                this.addFloor(x, y, velocity);
                break;
            case 3:
                // 動く床
                x = BasicGame.getRandomInt(BasicGame.const.CANVAS_WIDTH);
                if (BasicGame.getRandomBool()) {
                    velocity = -FLOOR_SPEED;
                } else {
                    velocity = FLOOR_SPEED;
                }
                this.addFloor(x, y, velocity);
                break;
            case 4:
                // とげ
                x = BasicGame.getRandomInt(BasicGame.const.CANVAS_WIDTH);
                this.addFloor(x, y, velocity);
                this.addSpike(x, y + (SPIKE_HEIGHT / 2), velocity);
                break;
            case 5:
                // 動く床＋とげ
                x = BasicGame.getRandomInt(BasicGame.const.CANVAS_WIDTH);
                if (BasicGame.getRandomBool()) {
                    velocity = -SPIKE_SPEED;
                } else {
                    velocity = SPIKE_SPEED;
                }
                this.addFloor(x, y, velocity);
                this.addSpike(x, y + (SPIKE_HEIGHT / 2), velocity);
                break;
            case 99:
                // DASHアイテム
                x = BasicGame.getRandomInt(BasicGame.const.CANVAS_WIDTH - 80) + 40;
                this.addItem(x, y, 0, "item_dash.png");
                break;
            default:
                // 念のため
                x = BasicGame.getRandomInt(BasicGame.const.CANVAS_WIDTH / 2);
                this.addFloor(x, y, velocity);
                if (BasicGame.getRandomBool()) {
                    // 左右対称
                    x = BasicGame.const.CANVAS_WIDTH - x;
                } else {
                    // 同じの２個
                    x = x + (BasicGame.const.CANVAS_WIDTH / 2);
                }
                this.addFloor(x, y, velocity);
                break;
        }

        // 265が間隔の最大値
        var nextY = this.data.nextFloor - 150 - BasicGame.getRandomInt(100);

        // Item
        var itemX = BasicGame.getRandomInt((BasicGame.const.CANVAS_WIDTH - 80)) + 40;
        var itemX2 = BasicGame.const.CANVAS_WIDTH - itemX;
        if (Math.abs(itemX - itemX2) < 60) {
            isCoin = false;
        }

        var itemY = this.data.nextFloor - ((this.data.nextFloor - nextY) / 2);
        var itemVelocity = 0;
        if (BasicGame.getRandomInt(100) < BasicGame.data.level) {
            if (BasicGame.getRandomBool()) {
                itemVelocity = -ITEM_SPEED;
            } else {
                itemVelocity = ITEM_SPEED;
            }
        }

        if (msg !== null) {
            var helpText = "";
            if (msg.length == 1) {
                helpText = msg[0];
            } else {
                if (this.game.device.desktop) {
                    helpText = msg[0];
                } else {
                    helpText = msg[1];
                }
            }
            var tmpLabel = this.add.text(0, 0,
                helpText, {
                    font: '22px Hiragino Kaku Gothic Pro',
                    align: 'center',
                    fill: '#fff'
                });
            tmpLabel.anchor.setTo(0.5, 0.5);
            tmpLabel.x = this.world.centerX;
            tmpLabel.y = itemY;
        }

        // 0:なにもなし
        // 1:コイン
        // 2:手裏剣＋敵
        // 3:DASH
        // 4:ひてん
        // 5:敵
        // 6:コイン＋敵
        // 7:手裏剣＋敵
        // 8:DASH＋敵
        // 9:ひてん＋敵
        var isVader = false;
        switch (item) {
            case 0:
                isCoin = false;
                break;
            case 1:
                this.addItem(itemX, itemY, itemVelocity, "coin.png");
                break;
            case 2:
                this.addItem(itemX, itemY, itemVelocity, "item_shot.png");
                break;
            case 3:
                this.addItem(itemX, itemY, itemVelocity, "item_dash.png");
                break;
            case 4:
                this.addItem(itemX, itemY, itemVelocity, "item_hiten.png");
                break;
            case 5:
                isVader = true;
                break;
            case 6:
                this.addItem(itemX, itemY, itemVelocity, "coin.png");
                isVader = true;
                break;
            case 7:
                this.addItem(itemX, itemY, itemVelocity, "item_shot.png");
                isVader = true;
                break;
            case 8:
                this.addItem(itemX, itemY, itemVelocity, "item_dash.png");
                isVader = true;
                break;
            case 9:
                this.addItem(itemX, itemY, itemVelocity, "item_hiten.png");
                isVader = true;
                break;
        }
        if (isCoin) {
            this.addItem(itemX2, itemY, itemVelocity, "coin.png");
        }
        // 敵
        if (this.data.isUfo) {
            switch (this.ufoLevel()) {
                case 1:
                    isVader = false;
                    break;
                case 2:
                    if (BasicGame.getRandomInt(2) === 0) {
                        isVader = true;
                    } else {
                        isVader = false;
                    }
                    break;
                default:
                    isVader = true;
                    break;
            }

        }
        if (isVader) {
            BasicGame.data.isNinvader = (BasicGame.data.level > 35);
            x = BasicGame.getRandomInt(BasicGame.const.CANVAS_WIDTH);
            y = itemY - (40 - (BasicGame.getRandomInt(3) * 40));
            if (BasicGame.getRandomBool()) {
                velocity = -VADER_SPEED;
            } else {
                velocity = VADER_SPEED;
            }
            this.addNinvader(x, y, velocity);

        }

        // 次の出現位置
        this.data.nextFloor = nextY;

        // 雲を生成
        if (this.data.nextCloud > (this.camera.y - 200)) {
            this.addCloud(this.data.nextCloud);
            // 500が間隔の最大値
            this.data.nextCloud = this.data.nextCloud - 200 - BasicGame.getRandomInt(300);
        }
    },

    updateFloor: function(f) {
        // 移動床を移動
        if (f.body.velocity.x !== 0) {
            if (f.body.velocity.x > 0) {
                if (f.x > BasicGame.const.CANVAS_WIDTH) {
                    f.body.velocity.x = f.body.velocity.x * -1;
                }
            } else {
                if (f.x < 0) {
                    f.body.velocity.x = f.body.velocity.x * -1;
                }
            }
        }
        // 画面外は削除
        var boader = this.camera.y + BasicGame.const.CANVAS_HEIGHT;
        if ((f.y - f.height) > boader) {
            f.kill();
        }
    },

    updateKen: function(f) {
        // 画面外は削除
        var min = this.camera.y;
        var max = this.camera.y + BasicGame.const.CANVAS_HEIGHT + 100;
        if (min > f.y || max < f.y) {
            f.kill();
        }
    },

    updateShot: function(f) {
        // 画面外は削除
        var min = 0;
        var max = BasicGame.const.CANVAS_WIDTH;
        if (min > f.x || max < f.x) {
            f.kill();
        }
    },

    updateNinvaders: function(f) {
        if (f.body.velocity.x !== 0) {
            if (f.body.velocity.x > 0) {
                if (f.x > BasicGame.const.CANVAS_WIDTH) {
                    f.body.velocity.x = f.body.velocity.x * -1;
                    this.setNinvaderPlay(f);
                }
            } else {
                if (f.x < 0) {
                    f.body.velocity.x = f.body.velocity.x * -1;
                    this.setNinvaderPlay(f);
                }
            }
        }
        var boader = this.camera.y + BasicGame.const.CANVAS_HEIGHT;
        if ((f.y - f.height) > boader) {
            f.kill();
        }
    },

    updateCloud: function(f) {
        var boader = this.camera.y + BasicGame.const.CANVAS_HEIGHT;
        if ((f.y - f.height) > boader) {
            f.kill();
        }
    },

    ufoLevel: function() {
        if (this.data.ufoLife > 100) {
            return 1;
        } else if (this.data.ufoLife > 60) {
            return 2;
        }
        return 3;
    },

    updateUfo: function(f) {
        // クリアなら移動しない
        if (this.data.isClear) {
            return;
        }

        // 移動
        if (f.body.velocity.x !== 0) {
            if (f.body.velocity.x > 0) {
                if (f.x > BasicGame.const.CANVAS_WIDTH) {
                    f.body.velocity.x = f.body.velocity.x * -1;
                    f.play("ufo_l" + this.ufoLevel());
                }
            } else {
                if (f.x < 0) {
                    f.body.velocity.x = f.body.velocity.x * -1;
                    f.play("ufo_r" + this.ufoLevel());
                }
            }
        }

        // 縦移動
        f.y = this.camera.y + (f.height / 2) + 40;
    },

    addFloor: function(x, y, velocity) {
        var floor = this.objects.floors.getFirstExists(false);
        if (floor) {
            floor.anchor.setTo(0.5, 0.5);
            floor.reset(x, y);
            floor.body.velocity.x = velocity;
            return floor;
        } else {
            return null;
        }
    },

    addSpike: function(x, y, velocity) {
        var spike = this.objects.spikes.getFirstExists(false);
        if (spike) {
            spike.anchor.setTo(0.5, 0.5);
            spike.reset(x, y);
            spike.body.velocity.x = velocity;
            return spike;
        } else {
            return null;
        }
    },

    addUfo: function(x, y, velocity) {
        var ufo = this.objects.ufos.getFirstExists(false);
        if (ufo) {
            ufo.anchor.setTo(0.5, 0.5);
            ufo.reset(x, y);
            ufo.body.velocity.x = velocity;
            ufo.play("ufo_r1");
            return ufo;
        } else {
            return null;
        }
    },

    setNinvaderPlay: function(ninvader) {
        if (ninvader.body.velocity.x > 0) {
            if (BasicGame.data.isNinvader) {
                ninvader.play("vader_r");
            } else {
                ninvader.play("bird_r");
            }
        } else {
            if (BasicGame.data.isNinvader) {
                ninvader.play("vader_l");
            } else {
                ninvader.play("bird_l");
            }
        }
    },

    addNinvader: function(x, y, velocity) {
        var ninvader = this.objects.ninvaders.getFirstExists(false);
        if (ninvader) {
            ninvader.anchor.setTo(0.5, 0.5);
            ninvader.reset(x, y);
            ninvader.body.velocity.x = velocity;
            this.setNinvaderPlay(ninvader);
            return ninvader;
        } else {
            return null;
        }
    },

    addItem: function(x, y, velocity, frameName) {
        var item = this.objects.items.getFirstExists(false);
        if (item) {
            item.anchor.setTo(0.5, 0.5);
            item.reset(x, y);
            item.body.velocity.x = velocity;
            item.frameName = frameName;
            return item;
        } else {
            return null;
        }
    },

    addCloud: function(y) {
        var cloud = this.objects.clouds.getFirstExists(false);
        if (cloud) {
            cloud.reset(BasicGame.getRandomInt(this.world.width) - cloud.width, y);
            if (BasicGame.data.level % 2 == 1) {
                cloud.body.velocity.x = 8 + BasicGame.data.level;
                cloud.frameName = "kumo_01.png";
            } else {
                cloud.body.velocity.x = -8 - BasicGame.data.level;
                cloud.frameName = "kumo_02.png";
            }
        }
    },

    getItem: function(ninja, item) {
        // if (sound) this.heart_s.play('', 0, 0.2, false);
        var x, y;
        if (item.frameName === "item_dash.png") {
            this.objects.emitter.on = true;
            this.objects.ninja.body.velocity.y = -700;
            this.data.isBoost = true;
            this.objects.ninja.play('up');
            BasicGame.system.se_get.play();
        } else if (item.frameName === "item_shot.png") {
            var shot;
            x = item.x;
            y = item.y;
            shot = this.objects.shots.getFirstExists(false);
            if (shot) {
                shot.play("shot");
                shot.anchor.setTo(0.5, 0.5);
                shot.reset(x, y + 24);
                shot.body.velocity.x = 300;
            }
            shot = this.objects.shots.getFirstExists(false);
            if (shot) {
                shot.play("shot");
                shot.anchor.setTo(0.5, 0.5);
                shot.reset(x, y - 24);
                shot.body.velocity.x = 300;
            }
            shot = this.objects.shots.getFirstExists(false);
            if (shot) {
                shot.play("shot");
                shot.anchor.setTo(0.5, 0.5);
                shot.reset(x, y + 24);
                shot.body.velocity.x = -300;
            }
            shot = this.objects.shots.getFirstExists(false);
            if (shot) {
                shot.play("shot");
                shot.anchor.setTo(0.5, 0.5);
                shot.reset(x, y - 24);
                shot.body.velocity.x = -300;
            }
            BasicGame.system.se_pow.play();
        } else if (item.frameName === "item_hiten.png") {
            x = 28;
            y = this.camera.y + BasicGame.const.CANVAS_HEIGHT;
            for (var i = 0; i < 9; ++i) {
                var ken = this.objects.kens.getFirstExists(false);
                if (ken) {
                    ken.anchor.setTo(0.5, 0.5);
                    ken.reset(x, y);
                    ken.body.velocity.y = -1000;
                }
                x = x + 40;
            }
            BasicGame.system.se_pow.play();
        } else if (item.frameName === "coin.png") {
            BasicGame.data.score += 10;
            this.setScoreLabel();
            BasicGame.system.se_coin.play();
        }
        item.kill();
    },

    hitSpike: function(ninja, item) {
        // ブースト中は死なない
        if (this.data.isBoost === false) {
            // if (sound) this.hit_s.play('', 0, 0.4, false);
            // 忍者死亡フラグ
            this.objects.ninja.alive = false; // 落下
            this.objects.ninja.body.velocity.y = -250;
            this.objects.ninja.play('out');
            BasicGame.system.se_out.play();
        }
    },

    hitNinvaders: function(ninja, item) {
        // ブースト中は死なない
        if (this.data.isBoost === false) {
            // if (sound) this.hit_s.play('', 0, 0.4, false);
            // 忍者死亡フラグ
            this.objects.ninja.alive = false; // 落下
            this.objects.ninja.body.velocity.y = -250;
            this.objects.ninja.play('out');
            BasicGame.system.se_out.play();
            // 忍ベーダー停止
            item.body.velocity.x = 0;
            // item.kill();
        }
    },

    shotEnemy: function(shot, enemy) {
        this.objects.bom.x = enemy.x;
        this.objects.bom.y = enemy.y;
        this.objects.bom.start(true, 800, null, 30);

        BasicGame.data.score += 50;
        this.setScoreLabel();
        BasicGame.system.se_bom.play();
        enemy.kill();
    },

    shotUfo: function(shot, ufo) {
        // クリアしてたら処理しない
        if (this.data.isClear) {
            return;
        }

        this.data.ufoLife -= 1;

        if (this.data.ufoLife < 0) {
            BasicGame.data.score += 2000;
            this.setScoreLabel();

            this.data.clearCameraY = this.camera.y - (BasicGame.const.CANVAS_HEIGHT * 2);

            this.objects.emitter.on = true;
            this.objects.ninja.body.velocity.y = -12000;
            this.data.isBoost = true;
            this.data.isClear = true;
            this.objects.ninja.play('up');

            BasicGame.system.music.stop();

            var tween = this.add.tween(this.game.stage).to({
                backgroundColor: Phaser.Color.getColor(50, 150, 220)
            }, 2500, Phaser.Easing.Linear.None).start();
            tween.onComplete.add(function() {
                this.clearGame();
            }, this);
        }

        this.objects.bom.x = shot.x;
        this.objects.bom.y = shot.y - 80;
        this.objects.bom.start(true, 800, null, 30);

        BasicGame.data.score += 100;
        this.setScoreLabel();
        BasicGame.system.se_bom.play();

        shot.kill();
    },

    ninjaMove: function() {
        // 横移動
        this.objects.ninja.body.velocity.x = 0;
        if (this.objects.ninja.alive) {
            var touch = {
                right: (this.input.activePointer.isDown && this.input.activePointer.x > (BasicGame.const.CANVAS_WIDTH / 2)),
                left: (this.input.activePointer.isDown && this.input.activePointer.x < (BasicGame.const.CANVAS_WIDTH / 2)),
            };
            var stick = {
                right: (this.cursor.right.isDown || touch.right),
                left: (this.cursor.left.isDown || touch.left),
            };
            if (stick.left) {
                if (this.data.isBoost === false) {
                    this.objects.ninja.play('left');
                }
                this.objects.ninja.body.velocity.x = -300;
            } else if (stick.right) {
                if (this.data.isBoost === false) {
                    this.objects.ninja.play('right');
                }
                this.objects.ninja.body.velocity.x = 300;
            } else {
                if (this.data.isBoost === false) {
                    this.objects.ninja.play('down');
                }
            }
        }

        // 横に行き過ぎてたら補正
        if (this.objects.ninja.x < (this.objects.ninja.width / 2)) {
            this.objects.ninja.x = (this.objects.ninja.width / 2);
        } else if (this.objects.ninja.x > BasicGame.const.CANVAS_WIDTH - (this.objects.ninja.width / 2)) {
            this.objects.ninja.x = BasicGame.const.CANVAS_WIDTH - (this.objects.ninja.width / 2);
        }

        // ジャンプ
        if (this.objects.ninja.alive) {
            if (this.objects.ninja.body.touching.down && this.objects.ninja.scale.y == 1) {
                BasicGame.system.se_jump.play();
                var tween = this.add.tween(this.objects.ninja.scale).to({
                    y: 0.7,
                    x: 1.4
                }, 120, Phaser.Easing.Linear.None).start();
                tween.onComplete.add(function() {
                    this.objects.ninja.scale.setTo(1, 1);
                    this.objects.ninja.body.velocity.y = -400;
                }, this);
            }
        }

        // パーティクル
        if (this.objects.ninja.alive) {
            this.objects.emitter.x = this.objects.ninja.x;
            this.objects.emitter.y = this.objects.ninja.y;
            if (this.data.isBoost) {
                if (this.objects.ninja.body.velocity.y > -200) {
                    this.objects.emitter.on = false;
                    this.data.isBoost = false;
                    this.objects.ninja.play('down');
                }
            }
        } else {
            if (this.data.isBoost) {
                this.objects.emitter.on = false;
            }
        }
    },

    clearGame: function() {
        BasicGame.data.continueLevel = 0;
        this.state.start('GameClear');
    },

    quitGame: function(pointer) {
        //  Here you should destroy anything you no longer need.
        //  Stop music, delete sprites, purge caches, free resources, all that good stuff.
        // this.music_s.stop();
        BasicGame.system.se_oh.play();
        BasicGame.system.music.stop();
        BasicGame.data.continueLevel = 0;
        this.state.start('GameOver');
    },

    shutdown: function() {
        this.objects.bg = null;
        this.objects.clouds = null;
        this.objects.floors = null;
        this.objects.items = null;
        this.objects.kens = null;
        this.objects.shots = null;
        this.objects.spikes = null;
        this.objects.invaders = null;
        this.objects.ufos = null;
        this.objects.bom = null;
        this.objects.emitter = null;
        this.objects.ninja = null;
        this.objects.ground = null;
        this.objects.scoreLabel = null;
        this.objects.expLabel = null;
        this.data.nextFloor = null;
        this.data.nextCloud = null;
        this.data.isBoost = null;
        this.data.fpsSkip = null;
        this.data.isUfo = null;
        this.data.ufoLife = null;
        this.data.isClear = null;
        this.data.clearCameraY = null;
        this.world.removeAll();
    },

    render: function() {
        // fps
        // this.game.debug.text(this.game.time.fps || '--', 2, 14, "#00ff00");
        // var tg = this.game.debug;
        // this.objects.floors.forEach(function(item){
        //     tg.body(item);
        // });
        // this.game.debug.cameraInfo(this.game.camera, 0, 10);
        // this.game.debug.spriteCoords(this.objects.ninja, 0, 500);
        // this.game.debug.body(this.objects.clouds);
        // this.game.debug.body(this.objects.floors);
        // this.game.debug.body(this.objects.dashItems);
        // this.game.debug.body(this.objects.spikes);
        // this.game.debug.body(this.objects.emitter);
        // this.game.debug.body(this.objects.ninja);
        // this.game.debug.body(this.objects.ground);
        // this.game.debug.body(this.objects.scoreLabel);
    }

};
