BasicGame.GameClear = function(game) {
    this.objects = {
        title: null,
        bg: null,
        ninja: null,
        ground: null,
        staffLabel: null,
    };
};

BasicGame.GameClear.prototype = {

    create: function() {
        // サイズを変更
        // this.world.setBounds(0, 0, BasicGame.const.CANVAS_WIDTH, BasicGame.const.CANVAS_HEIGHT);
        this.world.setBounds(0, 0, BasicGame.const.CANVAS_WIDTH, BasicGame.const.MAX_WORLD_HEIGHT);

        // カメラ
        this.camera.bounds = null;
        this.camera.y = BasicGame.const.MAX_WORLD_HEIGHT - ((BasicGame.const.CANVAS_HEIGHT * 3) + BasicGame.const.CANVAS_HEIGHT / 2) - 300;
        var t = this.add.tween(this.camera).to({
            y: BasicGame.const.MAX_WORLD_HEIGHT - BasicGame.const.CANVAS_HEIGHT
        }, 1000 * 60).start();
        t.onComplete.add(function() {
            BasicGame.system.vo_ome.play();
            var spcKey = this.input.keyboard.addKey(Phaser.Keyboard.SPACEBAR);
            spcKey.onDown.addOnce(this.startGame, this);
            this.input.onDown.add(this.tapScreen, this);
        }, this);

        // 色を戻す
        var r = 50;
        var g = 150;
        var b = 220;
        this.game.stage.backgroundColor = Phaser.Color.getColor(r, g, b);

        // BGM
        BasicGame.system.music = this.add.audio('ending');
        BasicGame.system.music.play('', 0, 1, true);

        // 背景
        this.objects.bg = this.add.sprite(0, BasicGame.const.MAX_WORLD_HEIGHT - 80, 'sprite', 'bg.png');
        this.objects.bg.anchor.setTo(0, 1);

        // 地面
        this.objects.ground = this.add.sprite(0, this.world.height, 'sprite', 'ground.png');
        this.objects.ground.anchor.setTo(0, 1);
        this.physics.arcade.enable(this.objects.ground);
        this.objects.ground.body.immovable = true;

        // U R D L X
        // 1 2 3 4 5
        // 6 7 8 910
        // PLAYER
        this.objects.ninja = this.add.sprite(this.world.centerX, 0, 'sprite', 'ninja_03.png');
        this.objects.ninja.anchor.setTo(0.5, 1);
        this.physics.arcade.enable(this.objects.ninja);
        this.objects.ninja.body.gravity.y = 300;

        // STAFF
        var staffTxt = "";
        staffTxt += "\n";
        staffTxt += "\n";
        staffTxt += ":\n";
        staffTxt += "\n";
        staffTxt += "\n";
        staffTxt += "忍者飛翔\n";
        staffTxt += "- NINJA JUMP -\n";
        staffTxt += "\n";
        staffTxt += "\n";
        staffTxt += ":\n";
        staffTxt += "\n";
        staffTxt += "\n";
        staffTxt += "MISSION COMPLETED\n";
        staffTxt += "\n";
        staffTxt += "THE BATTLE IS OVER.\n";
        staffTxt += "VIVA NONNON.\n";
        staffTxt += "\n";
        staffTxt += "HAVE YOU FINISHED\n";
        staffTxt += "HOMEWORK?\n";
        staffTxt += "\n";
        staffTxt += "DON'T CATCH COLD.\n";
        staffTxt += "TAKE A BATH!\n";
        staffTxt += "\n";
        staffTxt += "\n";
        staffTxt += ":\n";
        staffTxt += "\n";
        staffTxt += "\n";
        staffTxt += "CONGRATULATIONS!\n";
        staffTxt += "\n";
        staffTxt += "NINJA JUMP IS OVER.\n";
        staffTxt += "\n";
        staffTxt += "PLEASE TRY AGAIN!\n";
        staffTxt += "YOU WILL BEABLE TO\n";
        staffTxt += "FIND MORE EXCITEMENT.\n";
        staffTxt += "\n";
        staffTxt += "\n";
        staffTxt += ":\n";
        staffTxt += "\n";
        staffTxt += "\n";
        staffTxt += "STAFF\n";
        staffTxt += "\n";
        staffTxt += "PROGRAMMER\n";
        staffTxt += "KANSUKE NISHIDA\n";
        staffTxt += "\n";
        staffTxt += "SOUND\n";
        staffTxt += "PANICPUMPKIN\n";
        staffTxt += "\n";
        staffTxt += "VOICE\n";
        staffTxt += "PEPPER(TONOSAMA LABO)\n";
        staffTxt += "\n";
        staffTxt += "WE ARE NOT SALARIED MEN\n";
        staffTxt += "OF TONOSAMA-LABO\n";
        staffTxt += "\n";
        staffTxt += "\n";
        staffTxt += ":\n";
        staffTxt += "\n";
        staffTxt += "\n";
        staffTxt += "\n";
        staffTxt += "\n";
        staffTxt += "\n";
        staffTxt += "\n";
        staffTxt += "\n";
        staffTxt += "\n";
        staffTxt += "\n";
        staffTxt += "\n";
        staffTxt += "\n";
        staffTxt += "\n";
        staffTxt += "\n";
        staffTxt += "\n";
        staffTxt += "\n";
        staffTxt += "THANK YOU FOR\n";
        staffTxt += "YOUR PLAYING\n";
        staffTxt += "\n";
        staffTxt += "\n";
        staffTxt += "(C)2014 tonosamart.\n";
        this.objects.staffLabel = this.add.text(this.world.centerX, BasicGame.const.MAX_WORLD_HEIGHT - (BasicGame.const.CANVAS_HEIGHT / 2) + 40, staffTxt, {
            font: '22px Hiragino Kaku Gothic Pro',
            align: 'center',
            fill: '#ffffff'
        });
        this.objects.staffLabel.anchor.setTo(0.5, 1);

        // LOGO
        this.objects.title = this.add.sprite(this.world.centerX, BasicGame.const.MAX_WORLD_HEIGHT - (BasicGame.const.CANVAS_HEIGHT / 2) - 200, 'sprite', 'logo.png');
        this.objects.title.anchor.setTo(0.5, 0.5);
    },

    update: function() {
        this.physics.arcade.collide(this.objects.ninja, this.objects.ground);

        if (this.objects.ninja.body.touching.down && this.objects.ninja.scale.y == 1) {
            var tween = this.add.tween(this.objects.ninja.scale).to({
                y: 0.7,
                x: 1.4
            }, 120, Phaser.Easing.Linear.None).start();
            tween.onComplete.add(function() {
                this.objects.ninja.scale.setTo(1, 1);
                this.objects.ninja.body.velocity.y = -300;
            }, this);
        }

    },

    tapScreen: function(pointer) {
        this.input.onDown.forget();
        this.startGame(pointer);
    },

    startGame: function(pointer) {
        BasicGame.system.music.stop();
        BasicGame.system.se_tap.play();
        this.state.start('MainMenu');
    },

    shutdown: function() {
        this.objects.title = null;
        this.objects.bg = null;
        this.objects.ninja = null;
        this.objects.ground = null;
        this.objects.staffLabel = null;
        this.world.removeAll();
    },

    render: function() {
        // this.game.debug.body(this.objects.title);
        // this.game.debug.body(this.objects.ninja);
        // this.game.debug.body(this.objects.floor);
    }

};
