BasicGame.GameOver = function(game) {
    this.objects = {
        title: null,
        ninja: null,
        startLabel: null,
        expLabel: null,
        scoreLabel: null,
    };
};

BasicGame.GameOver.prototype = {

    create: function() {
        // サイズを戻す
        this.world.setBounds(0, 0, BasicGame.const.CANVAS_WIDTH, BasicGame.const.CANVAS_HEIGHT);

        // // 色を戻す
        // var r = 50;
        // var g = 150;
        // var b = 220;
        // this.game.stage.backgroundColor = Phaser.Color.getColor(r, g, b);

        // BGM
        BasicGame.system.music = this.add.audio('over');
        BasicGame.system.music.play();

        // 得点
        this.objects.scoreLabel = this.add.text(10, 10, "", {
            font: '18px Hiragino Kaku Gothic Pro',
            fill: '#fff'
        });
        this.objects.scoreLabel.text = "とくてん " + BasicGame.data.score;
        this.objects.expLabel = this.add.text(BasicGame.const.CANVAS_WIDTH - 10, 10, "", {
            font: '18px Hiragino Kaku Gothic Pro',
            align: 'right',
            fill: '#fff',
        });
        this.objects.expLabel.anchor.setTo(1, 0);
        // this.objects.expLabel.text = BasicGame.data.exp + " m" + "(" + BasicGame.data.level + ")";
        this.objects.expLabel.text = BasicGame.data.exp + " m";

        // LOGO
        this.objects.title = this.add.text(this.world.centerX, 0, "GAME OVER", {
            font: '48px Hiragino Kaku Gothic Pro',
            fill: '#ffffff'
        });
        this.objects.title.anchor.setTo(0.5, 1);
        this.add.tween(this.objects.title).to({
            y: this.world.centerY - 120
        }, 2000, Phaser.Easing.Bounce.Out).start();

        // MESSAGE
        var startTxt = "";
        if (this.game.device.desktop) {
            startTxt = "スペースキーを押してください";
        } else {
            startTxt = "画面をタップしてください";
        }
        this.objects.startLabel = this.add.text(this.world.centerX, (this.world.height / 4 * 3), startTxt, {
            font: '22px Hiragino Kaku Gothic Pro',
            fill: '#ffffff'
        });
        this.objects.startLabel.anchor.setTo(0.5, 0.5);
        this.add.tween(this.objects.startLabel).to({
            alpha: 0
        }, 500).to({
            alpha: 1
        }, 500).loop().start();
        this.objects.startLabel.visible = false;

        // PLAYER
        this.objects.ninja = this.add.sprite(this.world.centerX, this.world.centerY - 20, 'sprite', 'ninja_03.png');
        this.objects.ninja.anchor.setTo(0.5, 0.5);
        this.objects.ninja.scale.y = -1;
        this.objects.ninja.animations.add('out', ['ninja_05.png', 'ninja_10.png'], 4, true);
        this.objects.ninja.play('out');

        // メッセージ
        var msgTxt = "";
        if (BasicGame.data.level < 10) {
            msgTxt = "しっかりしろよ!!";
            BasicGame.system.vo_sikkari.play();
        } else if (BasicGame.data.level < 40) {
            msgTxt = "がんばれよ!!";
            BasicGame.system.vo_ganbare.play();
        } else {
            msgTxt = "あとすこし!!";
            BasicGame.system.vo_ato.play();
        }
        this.objects.scoreLabel = this.add.text(0, this.world.centerY + 20, msgTxt, {
            font: '24px Hiragino Kaku Gothic Pro',
            fill: '#fff'
        });
        this.objects.scoreLabel.x = this.world.centerX - this.objects.scoreLabel.width / 2;
        var t = this.add.tween(this.objects.scoreLabel.scale).to({}, 4000).start();
        t.onComplete.add(function() {
            var spcKey = this.input.keyboard.addKey(Phaser.Keyboard.SPACEBAR);
            spcKey.onDown.addOnce(this.goMainMenu, this);
            this.input.onDown.add(this.tapScreen, this);

            BasicGame.system.se_on.play();
            this.objects.startLabel.visible = true;
        }, this);

    },

    update: function() {},

    tapScreen: function(pointer) {
        var isContinue = this.input.hitTest(this.objects.ninja, pointer, new Phaser.Point());
        if (isContinue === true) {
            BasicGame.data.continueLevel = BasicGame.data.level - 1;
            BasicGame.system.se_out.play();
            if (BasicGame.data.continueLevel > 48) {
                BasicGame.data.continueLevel = 48;
            }
        }
        this.input.onDown.forget();
        this.goMainMenu(pointer);
    },

    goMainMenu: function(pointer) {
        BasicGame.system.music.stop();
        BasicGame.system.se_tap.play();
        this.state.start('MainMenu');
    },

    shutdown: function() {
        this.objects.title = null;
        this.objects.ninja = null;
        this.objects.startLabel = null;
        this.objects.expLabel = null;
        this.objects.scoreLabel = null;
        this.world.removeAll();
    },

    render: function() {}

};
