BasicGame.MainMenu = function(game) {
    this.system = {
        objects: {
            muteButton: null,
        }
    };
    this.objects = {
        title: null,
        bg: null,
        ninja: null,
        ground: null,
        startLabel: null,
        expLabel: null,
        scoreLabel: null
    };
};

BasicGame.MainMenu.prototype = {

    create: function() {
        // サイズを戻す
        this.world.setBounds(0, 0, BasicGame.const.CANVAS_WIDTH, BasicGame.const.CANVAS_HEIGHT);

        // 色を戻す
        var r = 50;
        var g = 150;
        var b = 220;
        this.game.stage.backgroundColor = Phaser.Color.getColor(r, g, b);

        // BGM
        BasicGame.system.music = this.add.audio('title');
        BasicGame.system.music.play('', 0, 1, true);

        // 背景
        this.objects.bg = this.add.sprite(0, this.world.height - 80, 'sprite', 'bg.png');
        this.objects.bg.anchor.setTo(0, 1);

        // LOGO
        this.objects.title = this.add.sprite(this.world.centerX, 150, 'sprite', 'logo.png');
        this.objects.title.anchor.setTo(0.5, 0.5);
        this.objects.title.scale.x = 10;
        this.objects.title.scale.y = 10;
        BasicGame.system.se_logo.play();

        // 得点
        this.objects.scoreLabel = this.add.text(10, 10, "", {
            font: '18px Hiragino Kaku Gothic Pro',
            fill: '#fff'
        });
        this.objects.scoreLabel.text = "とくてん " + BasicGame.data.score;
        this.objects.expLabel = this.add.text(BasicGame.const.CANVAS_WIDTH - 10, 10, "", {
            font: '18px Hiragino Kaku Gothic Pro',
            align: 'right',
            fill: '#fff',
        });
        this.objects.expLabel.anchor.setTo(1, 0);
        // this.objects.expLabel.text = BasicGame.data.exp + " m" + "(" + BasicGame.data.level + ")";
        this.objects.expLabel.text = BasicGame.data.exp + " m";

        // MESSAGE
        var startTxt = "";
        if (this.game.device.desktop) {
            startTxt = "スペースキーを押してください";
        } else {
            startTxt = "画面をタップしてください";
        }
        this.objects.startLabel = this.add.text(this.world.centerX, (this.world.height / 4 * 2), startTxt, {
            font: '22px Hiragino Kaku Gothic Pro',
            fill: '#ffffff'
        });
        this.objects.startLabel.anchor.setTo(0.5, 0.5);
        this.add.tween(this.objects.startLabel).to({
            alpha: 0
        }, 500).to({
            alpha: 1
        }, 500).loop().start();
        // this.objects.startLabel.visible = false;

        // 地面
        this.objects.ground = this.add.sprite(0, this.world.height, 'sprite', 'ground.png');
        this.objects.ground.anchor.setTo(0, 1);

        // U R D L X
        // 1 2 3 4 5
        // 6 7 8 910
        // PLAYER
        this.objects.ninja = this.add.sprite(-80, this.world.height - this.objects.ground.height, 'sprite', 'ninja_03.png');
        this.objects.ninja.anchor.setTo(0.5, 1);
        this.objects.ninja.animations.add('right', ['ninja_02.png', 'ninja_07.png'], 4, true);
        this.objects.ninja.animations.add('down', ['ninja_03.png'], 8);
        this.objects.ninja.play('right');

        // MUTE
        this.system.muteButton = this.add.button(20, 40, 'muteButton', this.toggleSound, this);
        this.system.muteButton.input.useHandCursor = true;
        if (this.sound.mute) {
            this.system.muteButton.frame = 1;
        } else {
            this.system.muteButton.frame = 0;
        }

        // LOGO -> 忍者
        var t = this.add.tween(this.objects.title.scale).to({
            x: 1,
            y: 1
        }, 500, Phaser.Easing.Bounce.Out).start();
        t.onComplete.add(function() {
            var t = this.add.tween(this.objects.ninja).to({
                x: this.world.centerX
            }, 2000, Phaser.Easing.Bounce.Out).start();
            t.onComplete.add(function() {
                BasicGame.system.se_on.play();
                this.objects.startLabel.visible = true;
                this.objects.ninja.play('down');
            }, this);
        }, this);

        // START
        // http://docs.phaser.io/Phaser.Keyboard.html
        var spcKey = this.input.keyboard.addKey(Phaser.Keyboard.SPACEBAR);
        spcKey.onDown.addOnce(this.startGame, this);
        this.input.onDown.add(this.tapScreen, this);
    },

    update: function() {},

    toggleSound: function() {

        this.sound.mute = !this.sound.mute;
        if (this.sound.mute) {
            this.system.muteButton.frame = 1;
        } else {
            this.system.muteButton.frame = 0;
        }

    },

    tapScreen: function(pointer) {
        var isMuteButton = this.input.hitTest(this.system.muteButton, pointer, new Phaser.Point());
        if (isMuteButton === false) {
            this.input.onDown.forget();
            this.startGame(pointer);
        }
    },

    startGame: function(pointer) {
        BasicGame.system.music.stop();
        BasicGame.system.se_tap.play();
        this.state.start('Game');
    },

    shutdown: function() {
        this.world.removeAll();
    },

    render: function() {
        // this.game.debug.body(this.objects.title);
        // this.game.debug.body(this.objects.ninja);
        // this.game.debug.body(this.objects.floor);
    }

};
