BasicGame.Preloader = function(game) {
    this.system = {
        ready: false,
        audioNames: [],
        objects: {
            preloaderBar: null,
        }
    };
};

BasicGame.Preloader.prototype = {

    loadAsset: function() {
        // 読み込みたいアセットを追記

        // audio
        this.load.audio('boss', ['audio/boss.wav']);
        this.system.audioNames.push('boss');

        this.load.audio('ending', ['audio/ending.wav']);
        this.system.audioNames.push('ending');

        this.load.audio('game', ['audio/game.wav']);
        this.system.audioNames.push('game');

        this.load.audio('over', ['audio/over.wav']);
        this.system.audioNames.push('over');

        this.load.audio('title', ['audio/title.wav']);
        this.system.audioNames.push('title');

        // 効果音
        this.load.audio('se_on', ['audio/se_on.wav']);
        this.system.audioNames.push('se_on');
        BasicGame.system.se_on = this.add.sound('se_on');

        this.load.audio('se_oh', ['audio/se_oh.wav']);
        this.system.audioNames.push('se_oh');
        BasicGame.system.se_oh = this.add.sound('se_oh');

        this.load.audio('se_bom', ['audio/se_bom.wav']);
        this.system.audioNames.push('se_bom');
        BasicGame.system.se_bom = this.add.sound('se_bom');

        this.load.audio('se_get', ['audio/se_get.wav']);
        this.system.audioNames.push('se_get');
        BasicGame.system.se_get = this.add.sound('se_get');

        this.load.audio('se_jump', ['audio/se_jump.wav']);
        this.system.audioNames.push('se_jump');
        BasicGame.system.se_jump = this.add.sound('se_jump');

        this.load.audio('se_logo', ['audio/se_logo.wav']);
        this.system.audioNames.push('se_logo');
        BasicGame.system.se_logo = this.add.sound('se_logo');

        this.load.audio('se_out', ['audio/se_out.wav']);
        this.system.audioNames.push('se_out');
        BasicGame.system.se_out = this.add.sound('se_out');

        this.load.audio('se_pow', ['audio/se_pow.wav']);
        this.system.audioNames.push('se_pow');
        BasicGame.system.se_pow = this.add.sound('se_pow');

        this.load.audio('se_tap', ['audio/se_tap.wav']);
        this.system.audioNames.push('se_tap');
        BasicGame.system.se_tap = this.add.sound('se_tap');

        this.load.audio('se_coin', ['audio/se_coin.wav']);
        this.system.audioNames.push('se_coin');
        BasicGame.system.se_coin = this.add.sound('se_coin');

        // voice
        this.load.audio('vo_ato', ['audio/vo_ato.wav']);
        this.system.audioNames.push('vo_ato');
        BasicGame.system.vo_ato = this.add.sound('vo_ato');

        this.load.audio('vo_ganbare', ['audio/vo_ganbare.wav']);
        this.system.audioNames.push('vo_ganbare');
        BasicGame.system.vo_ganbare = this.add.sound('vo_ganbare');

        this.load.audio('vo_ome', ['audio/vo_ome.wav']);
        this.system.audioNames.push('vo_ome');
        BasicGame.system.vo_ome = this.add.sound('vo_ome');

        this.load.audio('vo_sikkari', ['audio/vo_sikkari.wav']);
        this.system.audioNames.push('vo_sikkari');
        BasicGame.system.vo_sikkari = this.add.sound('vo_sikkari');

        // image
        this.load.atlas('sprite', 'images/sprite.png', 'images/sprite.json');

        // ex
        // this.load.spritesheet('ninja', 'images/ninja_40x40.png', 40, 40);
        // this.load.audio('play', ['audio/play.wav']);
        // this.system.audioNames.push('play');

        // ex
        // this.load.image('titlepage', 'images/title.jpg');
        // this.load.atlas('playButton', 'images/play_button.png', 'images/play_button.json');
        // this.load.audio('titleMusic', ['audio/main_menu.mp3']);
        // this.audioArray.push('titleMusic');
        // this.load.bitmapFont('caslon', 'fonts/caslon.png', 'fonts/caslon.xml');
    },

    // -----

    preload: function() {

        var loadingLabel = this.add.text(
            this.world.width - 10,
            this.world.height - 10,
            'Now Loading..', {
                font: '16px Hiragino Kaku Gothic Pro',
                fill: '#ffffff'
            }
        );
        loadingLabel.anchor.setTo(0.5, 0.5);
        loadingLabel.x = loadingLabel.x - (loadingLabel.width / 2);
        loadingLabel.y = loadingLabel.y - (loadingLabel.height / 2);

        this.add.tween(loadingLabel.scale).to({
            x: 0.9,
            y: 0.9
        }, 250).to({
            x: 1,
            y: 1
        }, 250).to({
            x: 1.1,
            y: 1.1
        }, 250).to({
            x: 1,
            y: 1
        }, 250).loop().start();

        this.system.objects.preloaderBar = this.add.sprite(
            this.world.centerX,
            this.world.centerY,
            'preloaderBar'
        );
        this.system.objects.preloaderBar.anchor.setTo(0, 0);
        this.system.objects.preloaderBar.x = this.system.objects.preloaderBar.x - (this.system.objects.preloaderBar.width / 2);
        this.system.objects.preloaderBar.y = this.system.objects.preloaderBar.y - (this.system.objects.preloaderBar.height / 2);
        this.load.setPreloadSprite(this.system.objects.preloaderBar);

        var preloaderBase = this.add.sprite(
            this.world.centerX,
            this.world.centerY,
            'preloaderBase'
        );
        preloaderBase.anchor.setTo(0.5, 0.5);

        // 共通アセット読み込み
        this.load.spritesheet('muteButton', 'images/system/mute_button.png', 36, 36);

        // 個別アセット読み込み
        this.loadAsset();
    },

    create: function() {

        this.system.objects.preloaderBar.cropEnabled = false;

    },

    update: function() {

        var isAudioReady = true;
        for (var audioTitle in this.system.audioNames) {
            if (this.cache.isSoundDecoded(audioTitle) === false) {
                isAudioReady = false;
            }
        }
        if (isAudioReady && this.system.ready === false) {
            this.system.ready = true;
            this.state.start('MainMenu');
        }

    }

};
