var soundsRun = new Array();
var mute = false;

$(function(){

    $('#mainMenu a').click(function(){

        var input   = $(this).parent().parent().find('input');
        var idSound = input.attr('id');
        var volume  = input.val() / 10;

        if ($(this).hasClass('play'))
        {

            $(this).removeClass('play');
            $(this).addClass('stop');

        } else {

            $(this).removeClass('stop');
            $(this).addClass('play');

        }

        if(soundsRun.indexOf(idSound) === -1)
        {

            soundsRun.push(idSound);
            Crafty.audio.play(idSound, -1, volume);

        } else {

            var index = soundsRun.indexOf(idSound);
            soundsRun.splice(index, 1);
            Crafty.audio.stop(idSound);

        }

    });
    
    $('#title button').click(function(){
        
        if (!mute) 
        {
            
            $(this).addClass('active');
            mute = true;
            Crafty.audio.mute();
            
        } else {
            
            $(this).removeClass('active');
            mute = false;
            Crafty.audio.unmute();
            
        }
        
    });

    $('input[name="volume"]').change(function(){

        $(this).parent().parent().parent().find('.controls a').removeClass('play').addClass('stop');

        var idSound = $(this).attr('id');
        var volume = $(this).val() / 10;
        
        if(soundsRun.indexOf(idSound) === -1)
        {

            soundsRun.push(idSound);
            Crafty.audio.play(idSound, -1, volume);

        } else {

            var index = soundsRun.indexOf(idSound);
            soundsRun.splice(index, 1);
            Crafty.audio.stop(idSound);

        }

    });

});