var ultimaNota;     // id da última nota gravada
var notaVazia;      // Anotação inicial está vazia
var telaInicial;    // Guarda uma referencia da tela inicial
var telaNota;       // Guarda uma referencia da tela de anotação
var tituloNota;     // Texto com o título da anotação
var conteudoNota;   // Texto com o conteúdo
var campoNota;      // Guarda uma referencia do textarea
var campoTitulo;    // Guarda uma referencia do titulo da anotação na tela
var novaNota;       // Nova anotação?
var idNotaAtual;    // ID da nota selecioanda
var modoSelecao;    
var semNotas;       // Guarda uma referencia ao texto de nenhuma nota
var Tela = {        // Tipos de tela
    Inicial : 0,
    Anotacao : 1
};
var modoSelecaoClick = function() { ModoSelecao(true); };
var _ = navigator.mozL10n.get;

// Chama método Init após a tela ter recebido seus valores traduzidos
window.addEventListener("localized", Init, false);

// Inicialização
function Init() {
    semNotas = document.getElementById("nenhuma-nota");
    campoNota = document.getElementById("txt-nota");
    campoTitulo = document.getElementById("titulo-nota");
    telaInicial = document.getElementById("tela-inicial");
    telaNota = document.getElementById("nova-anotacao");
    document.getElementById("btn-voltar").addEventListener("click", TelaInicial, false);
    document.getElementById("btn-nova").addEventListener("click", NovaNota, false);
    document.getElementById("select-all-threads").addEventListener("click", function(){SelecionarTodas(true);}, false);
    document.getElementById("deselect-all-threads").addEventListener("click", function(){SelecionarTodas(false);}, false);
    document.getElementById("threads-delete-button").addEventListener("click", ExcluirNotas, false);
    document.getElementById("btn-editar").addEventListener("click", modoSelecaoClick, false);
    document.getElementById("threads-cancel-button").addEventListener("click", function(){ModoSelecao(false);}, false);
    campoNota.addEventListener("input", TituloNota, false);
    
    if (localStorage.idUltimaNota === undefined) {
        localStorage.idUltimaNota = "0";
    }
    ultimaNota = localStorage.idUltimaNota;
    AtualizaLista();
}

// Aumenta ou diminui o número de itens selecionados
function ContarSelecionadas() {
    var itensSelecionados = 0;

    for (var i = 0; i < document.getElementsByTagName("input").length; i++) {
        if (document.getElementsByTagName("input")[i].type === "checkbox" && document.getElementsByTagName("input")[i].checked) {
            itensSelecionados++;
        }
    }

    if (itensSelecionados >= 1) {
        if (itensSelecionados == document.getElementsByTagName("input").length) {
            document.getElementById("select-all-threads").classList.add("disabled");
        }
        else {
            document.getElementById("select-all-threads").classList.remove("disabled");
        }
        document.getElementById("deselect-all-threads").classList.remove("disabled");
        document.getElementById("threads-delete-button").classList.remove("disabled");
        document.getElementById("list-edit-title").innerHTML = _("selected", {n: itensSelecionados});
    }
    else {
        document.getElementById("select-all-threads").classList.remove("disabled");
        document.getElementById("deselect-all-threads").classList.add("disabled");
        document.getElementById("threads-delete-button").classList.add("disabled");
        document.getElementById("list-edit-title").innerHTML = _("editMode");
    }
}


// Seleciona (ou remove a seleção) de todas as notas
function SelecionarTodas(selecionar) {
    for (var i = 0; i < document.getElementsByTagName("input").length; i++) {
        if (document.getElementsByTagName("input")[i].type === "checkbox") {
            document.getElementsByTagName("input")[i].checked = selecionar;
        }
    }
    ContarSelecionadas();
}

// Define o título da anotação baseado no conteúdo sendo escrito
function TituloNota() {
    textAreaAdjust();

    if (campoNota.value.trim().indexOf("\n") !== -1) {
        tituloNota = campoNota.value.trim().substring(0, campoNota.value.trim().indexOf("\n"));
        conteudoNota = campoNota.value.substring(campoNota.value.indexOf(tituloNota) + tituloNota.length);
    }
    else {
        tituloNota = campoNota.value.trim();   
        conteudoNota = "";
    }

    notaVazia = tituloNota.length === 0;

    if (notaVazia) {
        tituloNota = _("nova-nota");
    }

    campoTitulo.innerHTML = tituloNota;
}

// Ajusta tamanho do textfield automaticamente baseado no conteúdo
function textAreaAdjust() {
    campoNota.style.height = "1px";
    campoNota.style.height = (campoNota.scrollHeight + 25) + "px";
}

// Muda pra tela para a criação de uma nova anotação
function NovaNota() {
    novaNota = notaVazia = true;
    campoNota.value = "";
    if (document.getElementById("titulo-nota").innerHTML != _("nova-nota")) {
        document.getElementById("titulo-nota").innerHTML = _("nova-nota");  
    }
    MudarTela(Tela.Anotacao);
}

// Troca pra tela especificada no parametro da função
function MudarTela(tela) {
    if (tela === Tela.Anotacao) {
        document.getElementById("caixa-principal").setAttribute("data-position", "left");
    }
    else {
        document.getElementById("caixa-principal").setAttribute("data-position", "right");   
    }
}

// Tira a animação o atributo style. Usado pra remover as animações definidas no método "MudarTela"
function LimparAtributos() {
    telaInicial.getElementsByTagName("header")[0].getElementsByTagName("h1")[0].removeAttribute("style");
    telaInicial.removeAttribute("style");
    telaNota.getElementsByClassName("campo-anotacao")[0].removeAttribute("style");
}

// Volta pra tela inicial do app
function TelaInicial() {
    if (novaNota) {
        SalvarNovaNota();
    }
    else {
        SalvarNota(idNotaAtual);
    }
    AtualizaLista();
    MudarTela(Tela.Inicial);
}


// Salva anotação
function SalvarNota(idNota) {
    if (!notaVazia) {
        localStorage.setItem("titNota" + String(idNota), tituloNota);
        localStorage.setItem("contNota" + String(idNota), conteudoNota);
    }
    else {
        utils.status.show(_("nota-vazia"), 3000);       
    }
}

// Salva como uma nova anotação
function SalvarNovaNota() {
    if (!notaVazia) {
        ultimaNota = String(parseInt(ultimaNota) + 1);
        localStorage.setItem("titNota" + String(ultimaNota), tituloNota);
        localStorage.setItem("contNota" + String(ultimaNota), conteudoNota);
        localStorage.setItem("idUltimaNota", ultimaNota);
    }
    else {
        utils.status.show(_("nota-vazia"), 3000);   
    }
}

// Atualiza lista de anotações
function AtualizaLista() {
    LimpaLista();
    var contador = 0;

    for (var i = 0; i < parseInt(ultimaNota) + 1; i++) {
        if (localStorage.getItem("titNota" + String(i)) != undefined) {
            AddItem(i, localStorage.getItem("titNota" + String(i)), localStorage.getItem("contNota" + String(i)));
            contador++;
        }
    }
    if (contador === 0) {
        semNotas.removeAttribute("style");
        document.getElementById("btn-editar").style.display = "none";
        document.getElementById("nome-app").getElementsByTagName("em")[0].innerHTML = "";
    }
    else {
        semNotas.style.display = "none";
        document.getElementById("btn-editar").style.display = "block";
        document.getElementById("nome-app").getElementsByTagName("em")[0].innerHTML = "(" + String(contador) + ")";
    }
}

// Limpa lista de notas
function LimpaLista() {
    document.getElementById("lista-notas").innerHTML = "";
}

// Adiciona nota na página inicial
function AddItem(idNota, titNota, contNota) {
    var li = document.createElement("li");
    var a = document.createElement("a");
    var titulo = document.createElement("p");
    var conteudo = document.createElement("p");

    a.setAttribute("href","#");
    a.setAttribute("idNota",idNota);
    a.addEventListener("click", function(){NotaListaClick(idNota);}, false);
    //a.addEventListener("contextmenu", function(){MenuNota(idNota);}, false);
    titulo.innerHTML = titNota;

    if (contNota.trim().indexOf("\n") !== -1) {
        conteudo.innerHTML = contNota.trim().substring(0, contNota.trim().indexOf("\n") + 1);
    }
    else {
        conteudo.innerHTML = contNota.trim();
    }

    a.appendChild(titulo);
    if (contNota != "") {
        a.appendChild(conteudo);  
    }
    li.appendChild(a);

    if (document.getElementById("lista-notas").firstChild != undefined) {
        document.getElementById("lista-notas").insertBefore(li,document.getElementById("lista-notas").firstChild);
    }
    else {
        document.getElementById("lista-notas").appendChild(li);
    }
}

function MenuNota(idNota) {
    document.getElementById("context-menu").className = "fade-in";
}

// Verifica se o modo de seleção de notas está ativo e seleciona ou mostra a nota se for o caso
function NotaListaClick(idNota) {
    if (modoSelecao) {
        var checkboxNota = getElementByAttributeValue("idNota", idNota).parentNode.getElementsByTagName("input")[0];
        checkboxNota.checked = !checkboxNota.checked;
        ContarSelecionadas();
    }
    else {
        MostraNota(idNota);
    }
}

// Mostra a anotação selecionada anteriormente
function MostraNota(idNota) {
    idNotaAtual = idNota;
    novaNota = notaVazia = false;
    tituloNota = localStorage.getItem("titNota" + String(idNota));
    conteudoNota = localStorage.getItem("contNota" + String(idNota));
    document.getElementById("titulo-nota").innerHTML = tituloNota;
    campoNota.value = tituloNota + conteudoNota;
    textAreaAdjust();
    MudarTela(Tela.Anotacao);
}

// http://www.stephanmuller.nl/element-attribute-plain-javascript/
function getElementByAttributeValue(attribute, value) {
    var allElements = document.getElementsByTagName('*');
    for (var i = 0; i < allElements.length; i++) {
        if (allElements[i].getAttribute(attribute) == value) {
            return allElements[i];
        }
    }
}

// Mostra menu superior e inferior do modo de seleção
function ModoSelecao(ativar) {
    if (ativar) {
        document.getElementById("btn-editar").removeEventListener("click", modoSelecaoClick, false);
        document.getElementById("list-edit-title").innerHTML = _("editMode");
        CriarCheckBoxes();
        document.getElementById("threads-edit-form").getElementsByTagName("menu")[1].classList.add("move-cima");
        document.getElementById("threads-edit-form").getElementsByTagName("section")[0].classList.add("move-baixo");
        document.getElementById("select-all-threads").classList.remove("disabled");
        document.getElementById("deselect-all-threads").classList.add("disabled");
        document.getElementById("threads-delete-button").classList.add("disabled"); 
        document.getElementById("lista-notas").style.marginBottom = "69px";
    }
    else {
        RemoverCheckBoxes();
        document.getElementById("threads-edit-form").getElementsByTagName("menu")[1].classList.remove("move-cima");
        document.getElementById("threads-edit-form").getElementsByTagName("section")[0].classList.remove("move-baixo");
        document.getElementById("btn-editar").addEventListener("click", modoSelecaoClick, false);
        document.getElementById("lista-notas").removeAttribute("style");
    }

    modoSelecao = ativar;
}

// Cria checkboxes para a seleção das notas
// Chamado quando: o botão "X" no modo de seleção de notas é clicado
function RemoverCheckBoxes() {
    for (var i = 0; i < document.getElementById("lista-notas").childNodes.length; i++) {
        document.getElementById("lista-notas").childNodes[i].removeChild(document.getElementById("lista-notas").childNodes[i].getElementsByTagName("aside")[0]);
    }
}

// Cria checkboxes para a seleção das notas
// Chamado quando: o botão ao lado do de criar uma nova nota é clicado
function CriarCheckBoxes() {
    var aside;
    var label;
    var span;
    var inputElement;

    for (var i = 0; i < document.getElementById("lista-notas").childNodes.length; i++) {
        aside = document.createElement("aside");
        label = document.createElement("label");
        span = document.createElement("span");
        inputElement = document.createElement("input");
        inputElement.type = "checkbox";
        label.classList.add("pack-checkbox");
        label.classList.add("danger");
        inputElement.addEventListener("change", ContarSelecionadas, false);
        label.appendChild(inputElement);
        label.appendChild(span);
        aside.appendChild(label);
        document.getElementById("lista-notas").childNodes[i].insertBefore(aside, document.getElementById("lista-notas").childNodes[i].firstChild);
    }
}


// Exclui as notas selecionadas
function ExcluirNotas() {
    for (var i = 0; i < document.getElementsByTagName("input").length; i++) {
        if (document.getElementsByTagName("input")[i].type === "checkbox" && document.getElementsByTagName("input")[i].checked === true) {
            var id = document.getElementsByTagName("input")[i].parentNode.parentNode.parentNode.childNodes[1].getAttribute("idNota");
            localStorage.removeItem("titNota" + id);
            localStorage.removeItem("contNota" + id);
        }
    }
    ModoSelecao(false);
    AtualizaLista();
}