$(document).ready(function(){
	//Set title
	$('#list-title').html("Note list ("+localStorage.length+")");
	   
	$("#btnAddNote").click(function(){
		  //Change to the add-notes
		  $("#noteTitle").val("");
		  $("#noteDetails").val("");
		  $("#noteTitle").focus();
		  $.mobile.changePage ($("#add-notes"));
	});

	$("#btnViewNotes").click(function(){
	  	//Change to the add-notes
          	$.mobile.changePage ($("#view-notes"));
		//get list
	  	getList();
    	});
		
	//Click Handlers for Add Notes page
	$("#btnSaveNote").click(function(){
 		 var now = new Date();
		 var data = {
		 	"desc" : $("#noteDetails").val(),
		 	"date" : now
	         }
		 noteTitle   = $("#noteTitle").val();
		 //Save it in local storage
		 if (window.localStorage) {
		      localStorage.setItem(noteTitle, JSON.stringify(data));
		      alert("Your note has been saved");
		 }
		 //empty values
		 $("#noteTitle").val("");
		 $("#noteDetails").val("");
		 $("#noteTitle").focus();
		 //change page
		 $.mobile.changePage ($("#view-notes"));
		 //get list		  
		 getList();
	});
	
	//clear form values	
	$("#btnClearNotes").click(function(){
		//clear values
		$("#noteTitle").val("");
		$("#noteDetails").val("");
		$("#noteTitle").focus();
	});

	//Clear individual item
	$("#btnClearNote").click(function(){
		var item = $("#noteTitle").val();
		if(confirm('Are you sure you want to delete this note?') === true) {
			 window.localStorage.removeItem(item);
			 $.mobile.changePage ($("#view-notes"));
			 getList();
		}	   
	});

	//Send by email
	$("#btnMailNote").click(function(){
		var title = $("#noteTitle").val();
		var desc  = $("#noteDetails").val();
		var createEmail = new MozActivity({
		  name: "new",
		  data: {
		    type : "mail",
		    url: "mailto:?subject=Firefox Note remember&body=" + title + "%20" + desc,
		  }
		});	   
	});
});

function getList() {
	//Empty the list first
	$("#note-list").html("");
	//Set title
	$('#list-title').html("Note list ("+localStorage.length+")");
	//Read the notes
	for (i=0; i<=localStorage.length-1; i++)  
	{  
		var key  = localStorage.key(i);  
		var data = JSON.parse(localStorage.getItem(key));
		var noteElement = '<li data-corners="false" data-shadow="false" data-iconshadow="true" data-wrapperels="div" data-icon="arrow-r" data-iconpos="right" data-theme="c" class="ui-btn ui-btn-icon-right ui-li-has-arrow ui-li-has-count ui-li ui-first-child ui-btn-up-c"><div class="ui-btn-inner ui-li ui-overlay-a"><div class="ui-btn-text"><a href="#" onclick="editNote('+i+');" class="ui-link-inherit">'+key+'<span class="ui-li-count">'+data["date"]+'</span></a></div><span class="ui-icon ui-icon-arrow-r ui-icon-shadow">&nbsp;</span></div></li>';
		$("#note-list").append(noteElement);
	}  
	$('div[data-role=collapsible]').collapsible({refresh:true});
}

//edit note
function editNote(i){
    	var key  = localStorage.key(i);  
	var data = JSON.parse(localStorage.getItem(key));
	$("#noteTitle").val(key);
	$("#noteDetails").val(data['desc']);
	$.mobile.changePage ($("#add-notes"));
}
