/**
 * This is a simple Memo app for Firefox OS
 */

var listView, detailView, currentMemo, deleteMemoDialog, imgFundo;

/**
 * Switches from the list view displaying the memo titles to the detail view that
 * allows the user to edit/view a chosen memo.
 * @param inMemo
 */
function showMemoDetail(inMemo) {
    currentMemo = inMemo;
    displayMemo();
    listView.classList.add("hidden");
    detailView.classList.remove("hidden");
}

/**
 * This function is used to share the current memo using email.
 */
function shareMemo() {
    var shareActivity = new MozActivity({
        name: "new",
        data: {
            type: "mail",
            body: currentMemo.content,
            url: "mailto:?body=" + encodeURIComponent(currentMemo.content) + "&subject=" + encodeURIComponent(currentMemo.title)

        }
    });
    shareActivity.onerror = function (e) {
        console.log("can't share memo", e);
    };
}

/**
 * This function is used to pick the current memo data and insert it into the DOM elements.
 */
function displayMemo() {
    document.getElementById("memo-title").value = currentMemo.title;
    document.getElementById("memo-content").value = currentMemo.content;
}

/**
 * This function is called by the text change event. It picks the data from the DOM elements holding the
 * memo data and save it to the indexedDB database.
 * @param e
 */
function tamanho(){
    document.getElementById("memo-content").style.height="100px";

}

function normal(){
       document.getElementById("memo-content").style.height="270px";

}

function textChanged(e) {
    currentMemo.title = document.getElementById("memo-title").value;
    currentMemo.content = document.getElementById("memo-content").value;
    saveMemo(currentMemo, function (err, succ) {
        console.log("save memo callback ", err, succ);
        if (!err) {
            currentMemo.id = succ;
        }
    });
}

function newMemo() {
    var newMemo = new Memo();
    showMemoDetail(newMemo);
    console.log("new note created");
}

function requestDeleteConfirmation() {
    deleteMemoDialog.classList.remove("hidden");
}



function closeDeleteMemoDialog() {
    deleteMemoDialog.classList.add("hidden");
}

function deleteCurrentMemo() {
    closeDeleteMemoDialog();
    deleteMemo(currentMemo.id, function (err, succ) {
        console.log("callback from delete", err, succ);
        if (!err) {
    listView.classList.remove("hidden");
    detailView.classList.add("hidden");
    refreshMemoList();
        }
    })
}

function showMemoList() {
    currentMemo.title = document.getElementById("memo-title").value;
    currentMemo.content = document.getElementById("memo-content").value;
    if (!document.getElementById("memo-title").value==""||!document.getElementById("memo-content").value==""){
    saveMemo(currentMemo, function (err, succ) {
        console.log("save memo callback ", err, succ);
        if (!err) {
            currentMemo.id = succ;
        }
    });
    listView.classList.remove("hidden");
    detailView.classList.add("hidden");
    refreshMemoList();}
    else{
        console.log("nota sem titulo ou conteudo, nao salva, retornando a lista");
        listView.classList.remove("hidden");
    detailView.classList.add("hidden");
    refreshMemoList();}

}


function refreshMemoList() {
    if (!db) {
        // HACK:
        // this condition may happen upon first time use when the
        // indexDB storage is under creation and refreshMemoList()
        // is called. Simply waiting for a bit longer before trying again
        // will make it work.
        console.warn("Database is not ready yet");
        setTimeout(refreshMemoList, 1000);
        return;
    }
    console.log("Refreshing memo list");

    var memoListContainer = document.getElementById("memoList");


    while (memoListContainer.hasChildNodes()) {
        memoListContainer.removeChild(memoListContainer.lastChild);
    }

    var memoList = document.createElement("ul");
    memoListContainer.appendChild(memoList);

    listAllMemoTitles(function (err, value) {
        var memoItem = document.createElement("li");
        var memoP = document.createElement("p");
        var memoPdate = document.createElement("div");
        memoPdate.setAttribute("id","datas");
        memoP.setAttribute("class","titulo-index");
        var memoTitle = document.createTextNode(value.title);
        var memoDate = document.createTextNode(value.created);
        
         var dataVariavel = localStorage.getItem('dataVetor');

    if (!dataVariavel==""){
dataVariavel=dataVariavel;

    }
        else{
                 localStorage.setItem('dataVetor','sim');

        }
        
        if (dataVariavel=="sim"){
           
     memoPdate.setAttribute("class","visible");
        
    var mostrardata=document.getElementById("mostrar-data");
         mostrardata.setAttribute("checked","true");
            
    }
    else{
     memoPdate.setAttribute("class","hidden");
 var mostrardata=document.getElementById("mostrar-data");
         mostrardata.removeAttribute("checked","true");
    } 

        memoItem.addEventListener("click", function (e) {
            console.log("clicked memo #" + value.id);
            showMemoDetail(value);

        });

        memoP.appendChild(memoTitle);
        memoPdate.appendChild(memoDate);
        memoItem.appendChild(memoP);
        memoItem.appendChild(memoPdate);
        memoList.appendChild(memoItem);


    });
}

function openConfigs() {
    document.getElementById("configuracao").classList.remove("hidden");
}


function exibirData(){
localStorage.setItem('dataVetor','sim');
var dataVariavel = localStorage.getItem('dataVetor');
    
 var mostrardata=document.getElementById("mostrar-data");
         mostrardata.setAttribute("checked","true");
    
     document.getElementById("configuracao").classList.add("hidden");
    refreshMemoList();


}
function esconderData(){
localStorage.setItem('dataVetor','nao');
var dataVariavel = localStorage.getItem('dataVetor');
        
    var mostrardata=document.getElementById("mostrar-data");
         mostrardata.removeAttribute("checked","true");
    

    
     document.getElementById("configuracao").classList.add("hidden");
        refreshMemoList();


}
function fundo(){


                        var a = "fundo";
                        var b = "url('/style/ui/fundo.png')";
                        localStorage.setItem(a,b);
                        var tamanho = localStorage.length;
                        
                        for(var c = 0; c < tamanho;c++){
						chave = localStorage.key(c);
						valorok = localStorage.getItem(chave);
                        document.getElementById("memo-list").style.backgroundImage=valorok;
                        document.getElementById("memo-detail").style.backgroundImage=valorok;
                                    document.querySelector("body").style.backgroundImage=valorok;

                    
                        }
                        document.getElementById("configuracao").classList.add("hidden");

}
function fundo2(){
                        var a = "fundo";
        				var b = "url('/style/ui/fundo2.png')";
                        localStorage.setItem(a,b);
                        var tamanho = localStorage.length;
                        
                        for(var c = 0; c < tamanho;c++){
						chave = localStorage.key(c);
						valorok = localStorage.getItem(chave);
                        document.getElementById("memo-list").style.backgroundImage=valorok;
                        document.getElementById("memo-detail").style.backgroundImage=valorok;
                                    document.querySelector("body").style.backgroundImage=valorok;

                        
                        }
                        document.getElementById("configuracao").classList.add("hidden");

}
function fundook(){
    
    var valor = localStorage.getItem('fundo');

    
    if (!valor==""){
                  
            valorok=valor;

    }
    else{
        var b="url('/style/ui/fundo2.png')";    
        localStorage.setItem('fundo',b);
        valorok=valor;

    } 
        document.getElementById("memo-list").style.backgroundImage=valorok;
    document.getElementById("memo-detail").style.backgroundImage=valorok;
        document.querySelector("body").style.backgroundImage=valorok;

                        

}

function dataok(){

    var dataVariavel = localStorage.getItem('dataVetor');

    if (dataVariavel=="sim"){
           
                    
    
     memoPdate.setAttribute("class","visible");


    }
    else{
     //document.getElementById("corpo").classList.add("hidden");
     memoPdate.setAttribute("class","hidden");


    } 
    
                        

}

function fundo3(){
                        var a = "fundo";
        				var b = "url('/style/ui/fundo3.png')";
                        localStorage.setItem(a,b);
                        var tamanho = localStorage.length;
                        
                        for(var c = 0; c < tamanho;c++){
						chave = localStorage.key(c);
						valorok = localStorage.getItem(chave);
                        document.getElementById("memo-list").style.backgroundImage=valorok;
                        document.getElementById("memo-detail").style.backgroundImage=valorok;
                                    document.querySelector("body").style.backgroundImage=valorok;

                        
                        }
                        document.getElementById("configuracao").classList.add("hidden");

}
function fundo4(){
                        var a = "fundo";
        				var b = "url('/style/ui/fundo4.png')";
                        localStorage.setItem(a,b);
                        var tamanho = localStorage.length;
                        
                        for(var c = 0; c < tamanho;c++){
						chave = localStorage.key(c);
						valorok = localStorage.getItem(chave);
                        document.getElementById("memo-list").style.backgroundImage=valorok;
                        document.getElementById("memo-detail").style.backgroundImage=valorok;
                                    document.querySelector("body").style.backgroundImage=valorok;

                        
                        }
                        document.getElementById("configuracao").classList.add("hidden");

}
function closeConfigs(){
    if (document.getElementById("mostrar-data").checked==true){
        exibirData();
    }
    else{
        esconderData();
    }
}
function closeApp(){
            window.close();
}
window.onload = function abrir() {
    // elements that we're going to reuse in the code
    listView = document.getElementById("memo-list");
    detailView = document.getElementById("memo-detail");
    deleteMemoDialog = document.getElementById("delete-memo-dialog");
    refreshMemoList();
    fundook();
    
    // All the listeners for the interface buttons and for the input changes
    document.getElementById("back-to-list").addEventListener("click", showMemoList);
    document.getElementById("new-memo").addEventListener("click", newMemo);
    document.getElementById("share-memo").addEventListener("click", shareMemo);
    document.getElementById("delete-memo").addEventListener("click", requestDeleteConfirmation);
    document.getElementById("confirm-delete-action").addEventListener("click", deleteCurrentMemo);
    document.getElementById("cancel-delete-action").addEventListener("click", closeDeleteMemoDialog);
    //document.getElementById("memo-content").addEventListener("input", textChanged);
    //document.getElementById("memo-title").addEventListener("input", textChanged);
    document.getElementById("memo-content").addEventListener("click", tamanho);
    document.getElementById("memo-content").addEventListener("blur", normal);
    document.getElementById("configs").addEventListener("click", openConfigs);
    document.getElementById("fundo").addEventListener("click", fundo);
    document.getElementById("fundo2").addEventListener("click", fundo2);
    document.getElementById("fundo3").addEventListener("click", fundo3);
    document.getElementById("fundo4").addEventListener("click", fundo4);
    document.getElementById("close-configs").addEventListener("click", closeConfigs);
    document.getElementById("close-app").addEventListener("click", closeApp);
    // the entry point for the app is the following command

}
//que os jogos comecem