var Diarios = {};

Diarios.Modelo = Backbone.Model
		.extend({
			defaults : {
				id : null,
				nombre : null,
				icono : null,
				feedCompleto : null,
				categoria : null,
				secciones: {
					seccion: null,
					feed: null,
					selectorTexto: null,
					selectorImagen: null
				}
			},

			initialize : function() {
				_.bindAll(this, "obtenerNoticias", 'añadirCacheBuster');
			},

			obtenerNoticias : function(noticias, seccion, success, error) {
				/* Añade el cache buster a la Url del feed */
				this.añadirCacheBuster(seccion);

				/* Obtengo el feed utilizando el plugin JGFeed */
				$
						.jGFeed(
								this.get("secciones")[seccion].feed,

								function(feeds) {
									if (!feeds) {
										error
												.call(this,
														"Problemas de conexión con el diario seleccionado.");
										return false;
									}

									if (feeds.entries.length === 0) {
										error
												.call(
														this,
														"La conexión se realizó de forma exitosa, pero el diario elegido todavía no tiene noticias.");
										return false;
									}

									for ( var i = 0; i < feeds.entries.length; i++) {
										var entry = feeds.entries[i];
										noticias.add(entry);
									}

									success.call(this, null);

								}, 100);
			},

			añadirCacheBuster : function(seccion) {
				var urlDiario;
								
				if (this.get("secciones")[seccion].feed.split('?')[1] != undefined)
					urlDiario = this.get("secciones")[seccion].feed + '&cachebuster='
							+ (Math.round(jQuery.now() / (1000 * 60 * 5)));
				else
					urlDiario = this.get("secciones")[seccion].feed + '?cachebuster='
							+ (Math.round(jQuery.now() / (1000 * 60 * 5)));

				//this.set("feed", urlDiario);
				this.get("secciones")[seccion].feed = urlDiario;
				
			}

		});

Diarios.Coleccion = Backbone.Collection.extend({
	model : Diarios.Modelo,
	url : "diarios.json",

	initialize : function() {
		this.fetch({
			async : false
		});
	}
});

var Noticias = {};

Noticias.Modelo = Backbone.Model.extend({
	defaults : {
		title : null,
		link : null,
		author : null,
		publishedDate : null,
		contentSnippet : null,
		content : null
	},

	initialize : function() {
		if (this.get("link").indexOf('www.cronista.com') >= 0) {
			this.set("link", this.get("link").replace("www.cronista.com","m.cronista.com/Mobile/nota.html?URI="));
		}
	}

});

Noticias.Coleccion = Backbone.Collection.extend({
	model : Noticias.Modelo,

	initialize : function() {
	},

});