atras = false;

var Router = Backbone.Router.extend({
	routes : {
		"" : "home",
		"home" : "home",
		"listaNoticias/:idDiario" : "listaCategorias",
		"listaNoticias/:idDiario/:idSeccion" : "listaNoticias",
		"lanoticia/:idDiario/:idNoticia" : "lanoticia",
	},

	initialize : function() {
		_.bindAll(this, 'home', 'listaNoticias', 'lanoticia', 'changePage');
		// Handle back button throughout the application
		($('a[data-rel="back"]')).live('click', function() {
			atras = true;
			window.history.back();
		});

		$('div[data-role="page"]').live('pagehide', function(event, ui) {
			$(event.currentTarget).remove();
		});

		$("div[data-role='header'] h1").live("tap", function(e) {
			$('body,html').animate({
				scrollTop : '0px'
			}, 500, function() {
				$('body').clearQueue();
			});
		});

		document.addEventListener("backbutton", function(e) {
			atras = true;
			if (!Backbone.history.fragment
					|| Backbone.history.fragment === "home") {
				e.preventDefault();
				navigator.app.exitApp();
			} else {
				window.history.back();
			}
		});

		$.ajaxSetup( {
    xhr: function() {return new window.XMLHttpRequest({mozSystem: true});}
});

		this.firstPage = true;
	},

	home : function() {
		var vista = new VistaHome(diarios);
		this.changePage(vista.render());
	},

	listaNoticias : function(idDiario, seccion) {
		var diario = diarios.get(idDiario);
		
		if (idDiario === ultimoDiario && seccion === ultimaSeccion) {
			vista = new VistaNoticias(noticias, diario);
			this.changePage(vista.render());
		} else {
			$.mobile.showPageLoadingMsg("a", "Cargando listado de noticias");

			var funcionCambio = this.changePage;

			noticias.reset();

			diario.obtenerNoticias(noticias, seccion, function() {
				ultimoDiario = idDiario;
				ultimaSeccion = seccion;
				$.mobile.hidePageLoadingMsg();
				var vista = new VistaNoticias(noticias, diario);
				vista.render();
				funcionCambio(vista);
			}, function(mensaje) {
				ultimoDiario = null;
				window.history.back();
				$.mobile.hidePageLoadingMsg();
				alert(mensaje);
			});
		}
	},

	lanoticia : function(idDiario, idNoticia) {
		var noticia = noticias.at(idNoticia);

		var vista = new VistaNoticia(idDiario, noticia);

		vista.render();
		this.changePage(vista);
	},
	
	listaCategorias: function(idDiario) {
		var diario = diarios.get(idDiario);
				
		vista = new VistaCategorias(diario);
		this.changePage(vista.render());
	},

	changePage : function(page) {
		$('body').append($(page.el));
		var transition = $.mobile.defaultPageTransition;
		if (this.firstPage) {
			transition = 'none';
			this.firstPage = false;
		}
		$.mobile.changePage($(page.el), {
			changeHash : false,
			transition : transition,
			reverse : atras
		});
		if( atras ) 
			$.mobile.silentScroll( posicionAnterior.pop() );
		else {
			posicionAnterior.push( window.pageYOffset );
			$.mobile.silentScroll( 0 );
		}
		atras = false;
	}

});