var VistaHome = Backbone.View.extend({
	tagName : "div",

	attributes : {
		"data-role" : "page",
	},

	initialize : function(coleccion) {
		this.collection = coleccion;
	},

	render : function() {

		//Template de la Home compilado
		var template = function(obj){
			var __t,__p='',__j=Array.prototype.join,print=function(){__p+=__j.call(arguments,'');};
			with(obj||{}){
				__p+='<div data-role="header" class="header" data-theme="b" data-position="fixed" data-tap-toggle="false"><h1>Últimas Noticias</h1></div><div data-role="content"><ul data-role="listview">';
				for (var i=0;i < listaDiarios.length;i++){
					__p+='';
					var diario=listaDiarios[i];
					__p+='';
					if (i===0 || diario.categoria !=listaDiarios[i -1].categoria ){
						__p+='<li data-role="list-divider">'+
						((__t=(diario.categoria ))==null?'':__t)+
						'</li>';
					};
					__p+='';
					if(diario.secciones.length===1){
						__p+='<li><a href="#listaNoticias/'+
						((__t=(diario.id ))==null?'':__t)+
						'/0"><img src="'+
						((__t=(diario.icono ))==null?'':__t)+
						'"class="ui-li-icon">'+
						((__t=(diario.nombre ))==null?'':__t)+
						'</a></li>';
					}else{
						__p+='<li><a href="#listaNoticias/'+
						((__t=(diario.id ))==null?'':__t)+
						'"><img src="'+
						((__t=(diario.icono ))==null?'':__t)+
						'"class="ui-li-icon">'+
						((__t=(diario.nombre ))==null?'':__t)+
						'</a></li>';
					}
					__p+='';
				}
				__p+='</ul></div>';
			}
			return __p;
		};

		$(this.el).html(template( {listaDiarios : diarios.toJSON()}));
		return this;
	}
});

var VistaCategorias = Backbone.View.extend({
	tagName : "div",

	attributes : {
		"data-role" : "page",
	},

	initialize : function(modelo) {
		this.model = modelo;
	},

	render : function() {
		var template = function(obj){
			var __t,__p='',__j=Array.prototype.join,print=function(){__p+=__j.call(arguments,'');};
			with(obj||{}){
				__p+=' <div data-role="header" class="header" data-theme="b" data-position="fixed" data-tap-toggle="false"><a data-role="button" data-icon="back" class="ui-btn-left" data-rel="back">&nbsp</a><h1>Últimas Noticias</h1></div><div data-role="content"><ul data-role="listview"><li data-role="list-divider">'+
				((__t=(diario.nombre ))==null?'':__t)+
				'</li>';
				for (var k=0;k < diario.secciones.length;k++){
					__p+='';
					var seccion=diario.secciones[k];
					__p+='<li><a href="#listaNoticias/'+
					((__t=(diario.id ))==null?'':__t)+
					'/'+
					((__t=(k ))==null?'':__t)+
					'"><img src="'+
					((__t=(diario.icono ))==null?'':__t)+
					'" class="ui-li-icon">'+
					((__t=(seccion.seccion ))==null?'':__t)+
					'</a></li>';
				}
				__p+='</ul></div>';
			}
			return __p;
		};

		$(this.el).html(template({
			diario : this.model.toJSON()
		}));
		return this;
	}
});

var VistaNoticias = Backbone.View.extend({
	tagName : "div",

	attributes : {
		"data-role" : "page",
	},

	events : {
		"tap #recargar" : "recargar"
	},

	initialize : function(coleccion, diario) {
		_.bindAll(this, 'recargar');
		this.collection = coleccion;
		this.model = diario;
	},

	render : function() {
		var template = function(obj){
			var __t,__p='',__j=Array.prototype.join,print=function(){__p+=__j.call(arguments,'');};
			with(obj||{}){
				__p+='<div data-role="header" class="header" id="tituloHeaderDiario" data-theme="b" data-position="fixed" data-tap-toggle="false"><a data-role="button" data-icon="back" class="ui-btn-left" data-rel="back">&nbsp</a><h1>'+
				((__t=(diario.nombre ))==null?'':__t)+
				'</h1><a data-role="button" data-icon="refresh" id="recargar" data-iconpos="right" class="ui-btn-right">&nbsp</a></div><div data-role="content"><ul id="listadoNoticias" data-role="listview" data-filter="true" data-filter-placeholder="Buscar noticias...">';
				for (var i=0;i < listaNoticias.length;i++){
					__p+='';
					var noticia=listaNoticias[i];
					__p+='<li><a href="#lanoticia/'+
					((__t=(diario.id ))==null?'':__t)+
					'/'+
					((__t=(i ))==null?'':__t)+
					'">'+
					((__t=(noticia.title ))==null?'':__t)+
					'</a></li>';
				}
				__p+='</ul></div>';
			}
			return __p;
		};

		$(this.el).html(template({
			diario : this.model.toJSON(),
			listaNoticias : this.collection.toJSON()
		}));
		return this;
	},

	recargar : function() {
		ultimoDiario = 0;
		Backbone.history.loadUrl(Backbone.history.fragment);
	}
});

var VistaNoticia = Backbone.View
		.extend({
			tagName : "div",

			attributes : {
				"data-role" : "page",

			},
			events : {
				"tap #leerMas" : "cargarCompleta",
				"tap #textoNoticia img" : "abrirImagen",
				"tap #imagenNoticia img" : "abrirImagen",
				"tap #textoNoticia a" : "abrirNavegador",
				"tap #enlaceOriginal" : "abrirNavegador"
			},
			initialize : function(idDiario, modelo) {
				_.bindAll(this, "cargarCompleta");
				this.model = modelo;
				this.model.set("idDiario", idDiario);
			},
			render : function() {
				var diario = diarios.get(this.model.get("idDiario"));
				
				var template =function(obj){
					var __t,__p='',__j=Array.prototype.join,print=function(){__p+=__j.call(arguments,'');};
					with(obj||{}){
						__p+='<div data-role="header" class="header" id="headerNoticia" data-position="fixed" data-tap-toggle="false" data-theme="b"><a data-role="button" data-icon="back" class="ui-btn-left" data-rel="back">&nbsp</a><h1>'+
						((__t=(diario.nombre ))==null?'':__t)+
						'</h1></div><div data-role="content"><h3>'+
						((__t=(noticia.title ))==null?'':__t)+
						'</h3><div id="imagenNoticia"></div><div id="textoNoticia">'+
						((__t=(noticia.content ))==null?'':__t)+
						'</div><div id="laBolita"><img src="estilo/images/loading.gif"/></div>';
						if(!diario.feedCompleto){
							__p+='<button id="leerMas">Cargar noticia completa</button>';
						}
						__p+='<a href="'+
						((__t=(noticia.link ))==null?'':__t)+
						'" rel="external" data-role="button" id="enlaceOriginal">Ver en navegador</a></div>';
					}
					return __p;
				};
				$(this.el).html(template({
					noticia : this.model.toJSON(),
					diario : diario.toJSON()
				}));
				return this;
			},
			cargarCompleta : function() {
				$("#laBolita").show();
				var link = this.model.get("link");
				var diario = diarios.get(this.model.get("idDiario"));

				var selectorTexto = diario.get("secciones")[ultimaSeccion].selectorTexto;

				/* Fixes para Infobae */
				if (link.indexOf('http://teleshow.infobae.com') >= 0
						|| link.indexOf('librosypeliculas.infobae') >= 0) {
					selectorTexto = '#interior-nota';
				}

				if (link.indexOf('http://playfutbol.infobae.com') >= 0) {
					selectorTexto = '.interior-noticia';
				}

				/* Fixes para La Nación */

				if (diario.id === 1) {
					link = link + "?sitio=desktop";
				}

				$("#textoNoticia").load(
						link + " " + selectorTexto,
						function(response, status, xhr) {
							if (status == "error") {
								var msg = "Error al obtener la noticia: ";
								navigator.notification.alert(msg + xhr.status
										+ " " + xhr.statusText, // message
								null, // callback
								'Problema al obtener datos', // title
								'Aceptar' // buttonName
								);
							}
							$('body,html').animate({
								scrollTop : '0px'
							}, 500, function() {
								$('body').clearQueue();
							});
							$("#laBolita").hide();
							$("#leerMas").button("disable");
							$("#textoNoticia img").remove();
						});

				if (diario.get("secciones")[ultimaSeccion].selectorImagen) {

					var selectorImagen = diario.get("secciones")[ultimaSeccion].selectorImagen;

					$("#imagenNoticia")
							.load(
									link + " " + selectorImagen,
									function(response, status, xhr) {
										if (status == "error") {
											var msg = "Error al obtener la noticia: ";
											$("#error").html(
													msg + xhr.status + " "
															+ xhr.statusText);
										}

										var urlImg = $("#imagenNoticia img")
												.attr("src");
										if ($.mobile.path.isRelativeUrl(urlImg)) {
											var dominio = $.mobile.path
													.parseUrl(link).domain;

											switch (diario.id) {
											case 3:
												$("#imagenNoticia img").attr(
														"src",
														"http://movil.clarin.com"
																+ urlImg);
												break;
											case 15:
												$("#imagenNoticia img").attr(
														"src",
														"http://mobile.ole.com.ar"
																+ urlImg);
												break;
											default:
												$("#imagenNoticia img").attr(
														"src",
														dominio + '/' + urlImg);
											}

										}
									});
				}
			},
			abrirImagen : function(evento) {
				evento.preventDefault();

				var activity = new MozActivity({
					name: "view",
					data: {
						type: "url",
						url: $(evento.currentTarget).attr("src")
					}
			    });

			},

			abrirNavegador : function(evento) {
				evento.preventDefault();

				var activity = new MozActivity({
					name: "view",
					data: {
						type: "url",
						url: $(evento.currentTarget).attr("href")
					}
			    });
			}
		});
