angular.module('NumberGameApp',['ngAnimate']);

angular.module('NumberGameApp').controller('NumberGameController',['$scope', function($scope){
    $scope.appName = "Number Guess";
    $scope.oldGuesses=[];
    $scope.userGuess=0;
    $scope.invalidGuess=false;
    $scope.minGuess=1;
    $scope.maxGuess=100;
    $scope.tobeGuessed=Math.floor((Math.random() * $scope.maxGuess) + $scope.minGuess);
    $scope.retryMessage="";
    $scope.guessed=false;
    $scope.numberOfGuesses=0;
    $scope.numberOfGames=1;

    function doesThisExist(val){
        for(i=0; i<$scope.oldGuesses.length; i++){
            if(val==$scope.oldGuesses[i]){
                return true;
            }
        }
        return false;
    };

    $scope.clicked = function(num){
        var tempGuess=$scope.userGuess;
        if(num > -1){
            if($scope.userGuess != 0){
                tempGuess=tempGuess + "" + num;
                if(tempGuess > $scope.maxGuess){
                    $scope.invalidGuess = true;
                }else{
                    $scope.userGuess = $scope.userGuess + "" + num;
                }
            }else{
                $scope.userGuess = "" + num;
            }
        }else if(num == -1){
            tempGuess = $scope.userGuess.slice(0,-1);
            if(tempGuess){
                $scope.userGuess = tempGuess;
            }else{
                $scope.userGuess = 0;
            }
            $scope.invalidGuess = false;
        }else if(num == -100){
            $scope.resetGuess();
        }
    };

    $scope.verifyGuess = function(newGuess){
        if(newGuess && (newGuess>=$scope.minGuess && newGuess<=$scope.maxGuess)){
            $scope.guessed=false;
            if(doesThisExist(newGuess)){
                $scope.retryMessage="Try a different number, you have tried this";
            }
            else if(newGuess>$scope.tobeGuessed){
                $scope.retryMessage="Try a smaller number";
            }else if(newGuess<$scope.tobeGuessed){
                $scope.retryMessage="Try a bigger number";
            }else{
                $scope.retryMessage="Success!!!!! Hit + for new Game";
                $scope.guessed=true;
            }
            $scope.oldGuesses.push(newGuess);
            $scope.invalidGuess=false;
            $scope.userGuess=0;
            $scope.numberOfGuesses=$scope.numberOfGuesses+1;
        }else{
            $scope.invalidGuess=true;
        }
    };

    $scope.resetGuess = function(){
        $scope.tobeGuessed=Math.floor((Math.random() * $scope.maxGuess) + $scope.minGuess);
        $scope.oldGuesses=[];
        $scope.guessed=false;
        $scope.invalidGuess=false;
        $scope.retryMessage="";
        $scope.userGuess = 0;
        $scope.numberOfGuesses=0;
        $scope.numberOfGames=$scope.numberOfGames+1;
    };
}]);