// Bubble Pop Configuration File


// Datatypes
// ------------------------------------------------------------------
//
// Boolean
// Booleans have two possible values true or false.
//     Example:
//         value: true
// Number
// Numbers can be represented as whole numbers or decimals.
//     Example:
//         x: -20
//         alpha: 0.4
//
// String
// String are described with quotes surrounding zero or more characters.
//     Example:
//         filename: "image1.png"
//
// Object 
// Objects are described with curly brackets surrounding 'name: value' pairs delimited by commas.
//     Example:
//         {
//             name1: value1,
//             name2: value2
//         }
//
// Array
// Arrays are described with square brackets surrounding values delimited by commas.
//     Example:
//         [
//             value1,
//             value2
//         ]

// Framework Properties
// ------------------------------------------------------------------
//
// View Properties
//     type (String)
//     filename (String): The url of image of the view is defined by the resourcePath and the filename.
//     x (Number): Location of view relative to the left of the viewport.
//     y (Number): Location of view relative to the top of the viewport.
//     offsetX (Number): Distance in pixels the image is shifted right.
//     offsetY (Number): Distance in pixels the image is shifted down.
//     numFrames (Number): Number of frames of animation. If this property is set and greater than one, the view will be a sprite.
//     frameRate (Number): Delay between frames of animation (in 1 / 60 second increments).
//         Example:
//              frameRate: 60 // The delay between frames is one second
//              frameRate: 10 // The delay between frames is on 10 / 60 or 0.6 seconds
//     loop (Boolean): If true the animation will continue to play indefinitely after started until stopped.
//     states (Array): Array of views that describe specific states of the view.
//         Example:
//             states: [
//					{
//						type: "ON",
//						filename: "light-switch-on.png"
//					},{
//						type: "OFF",
//						filename: "light-switch-off.png"
//					}
//				]
//
// Audio Properties
//     states (Array): Array of audio sprites.
//         State Properties:
//             name (String): Type of audio state. 
//             startTime (Number): Start time of the state in seconds.
//             duration (Number): The duration of the state in seconds.
//             loop (Boolean): If true the state will loop.
//         Example:
//             states: [
//                 {
//                     type: "intro", 
//                     startTime: 0,
//                     duration: 3
//                 },
//  
// Game Properties
//     element (HTML Element): The HTML element in which the game will be populated. Usually a div element.
//         Example:
//              element: window.document.getElementById("game"),
//     device (String): What device the game is launched in (e.g. "IPHONE", "IPAD").
//     resourcePath (String): The url where all resources are relative to. Note the "/" is required.
//         Example:
//             resourcePath: "resources/"
//.    deviceOffset (Object):
//         Example:
//             deviceOffset: {
//.                iPhone: {x: -32, y: -64}
//.            }
//     rounds (Array): An array of objects containing each round's properties.
//	   startImageFilename (String): The url of image title card show at the beginning of the game.
//     audioEnabled (Boolean): If false audio will not be loaded or played.
//     audioFilename (String): The url of the audio file.

// Bubble Pop Specific Properties
// ------------------------------------------------------------------
//
// Game Properties
//
//     hud
//         Properties:
//             sidebar: Displays the number of targets found for the current round.
//                 Available States:
//                     DEFAULT: Only currently supported state.
//     audio
//         Available States:
//             INTRO: Played at the beginning of each round.
//             PAYOFF: Played after the required number of bubbles for the round have been popped and eating by the catcher.
//             MUSIC: Loops in the background.
//			   CORRECT_HIT: Plays when a bubble with a target item is touched.
//         
// Round Properties
//
//     numBubbles: Maximum number of bubbles visible on the screen at once.
//     background
//         Properties:
//            filename: Filename of the background image.
//     bubbleHighlight: Displayed behind the bubble when it is highlighted.
//     bubblePopAnimation: Displayed when a bubble is touched.
//     emptyBubble
//         Properties:
//             filename: Filename of the emoty bubble image.
//     catcher: A character would catches items that fall out of bubbles which are popped.
//         Available States:
//             WAIT: Displayed when the catcher is not active.
//             WAVE: Displayed at the beginning of each round.
//             MOVE: Displayed when the catcher is moving.
//             JUMP: Displayed when a popped bubble has dropped in range of the catcher.
//     target: A random item is selected at the start of each round to be the correct item.
//         Properties:
//             unpopped
//                 Properties:
//                     filename: Filename of the image displayed if the bubble has not been touched.
//             popped
//                 Properties:
//                     filename: Filename of the image displayed after bubble has been touched.
//             label
//                 Available States:
//                     NOTFOUND: Initial state of the label.
//                     FOUND: Displayed after the item is found.
//     distractors (Array): Array of objects that will be displayed with target bubbles that just pop when touch
//         Properties:
//             filename: Filename of the distractor image.

WM.config = {
	resourcePath: "resources/",
	deviceOffset: { //chopping of the BG image to iPhone size specs. Image BG must be 1024x768
		iPhone: {
			x: -32,
			y: -64
		}
	},
	gameIcon: "icon-bubblePop-numbers.png",
	audioEnabled: true,
	loadingImageWhiteFilename: "loading-white.png",
	loadingImageColorFilename: "loading-color.png",
	landscapeOnlyFilename: "landscape-only.png",
	exitButtonFilename: "exit-button.png",
	startImageFilename: "startImage-bubblePop-numbers.jpg",
	audioFilename: "audio-bubblePop-numbers.mp3", //all audio including intro, payoff, and music is in one file found here
	audio: {
		states: [
			{
				name: "music", 
				startTime: 201,
				duration: 13,
				loop: true
			}
		]
	},
	hud: {
		sidebar: {
			type: "SIDEBAR",
			states: [
				{
					type: "Default",
					filename: "sidebar.png",
					numFrames: 12,
					autoStart: false
				}
			]
		}
	},
	rounds: [
		{
			numBubbles: 6, //the number of bubbles on the screen at one time
			audio: { //audio for the first item
				states: [
					{
						name: "intro",
						startTime: 0,
						duration: 2.5
					}, {
						name: "payoff",
						startTime: 3.5,
						duration: 5
					}
				]
			},
			background: {
				filename: "background-numbers.png"
			},
			bubbleHighlight: {
				type: "Highlight",
				filename: "bubble-highlight.png",
				offsetX: 0,
				offsetY: 0
			},
			bubblePopAnimation: {
				type: "Pop",
				filename: "bubble-pop.png",
				numFrames: 10,
				frameRate: 3,
				offsetX: -66,
				offsetY: -66
			},
			catcher: { //the thing at the bottom of the screen catching the items falling from the bubbles
				type: "Catcher",
				states: [
					{
						type: "Wait",
						filename: "cookie-monster-wait.png"
					},{
						type: "Wave",
						filename: "cookie-monster-wave.png",
						numFrames: 8,
						offsetX: -280,
						offsetY: -48
					},{
						type: "Move",
						filename: "cookie-monster-google-eyes.png",
						numFrames: 6,
						loop: true
					},{
						type: "Jump",
						filename: "cookie-monster-jump.png",
						numFrames: 10,
						offsetX: -280,
						offsetY: -8
					}
				]
			},
			emptyBubble: {
				filename: "bubble.png"
			},
			target: {
				unpopped: {
					filename: "1-in-bubble.png"
				},
				popped: {
					filename: "number-1.png"
				},
				label: { //items that go in the side bar
					type: "Label",
					states: [
						{
							type: "NotFound",
							filename: "label-number-1.png"
						},{
							type: "Found",
							filename: "label-number-1-found.png"
						}
					]
				}
			},
			distractors: [
				{
					filename: "2-in-bubble.png"
				}, {
					filename: "3-in-bubble.png"
				}, {
					filename: "4-in-bubble.png"
				}, {
					filename: "5-in-bubble.png"
				}, {
					filename: "6-in-bubble.png"
				}, {
					filename: "7-in-bubble.png"
				}, {
					filename: "8-in-bubble.png"
				}, {
					filename: "9-in-bubble.png"
				}, {
					filename: "10-in-bubble.png"
				}, {
					filename: "11-in-bubble.png"
				}, {
					filename: "12-in-bubble.png"
				}, {
					filename: "13-in-bubble.png"
				}, {
					filename: "14-in-bubble.png"
				}, {
					filename: "15-in-bubble.png"
				}, {
					filename: "16-in-bubble.png"
				}, {
					filename: "17-in-bubble.png"
				}, {
					filename: "18-in-bubble.png"
				}, {
					filename: "19-in-bubble.png"
				}, {
					filename: "20-in-bubble.png"
				}
			]
		}, {
			numBubbles: 6, //the number of bubbles on the screen at one time
			audio: { //audio for the second item
				states: [
					{
						name: "intro",
						startTime: 9,
						duration: 4.5
					}, {
						name: "payoff",
						startTime: 14,
						duration: 4.5
					}
				]
			},
			background: {
				filename: "background-numbers.png"
			},
			bubbleHighlight: {
				type: "Highlight",
				filename: "bubble-highlight.png",
				offsetX: 0,
				offsetY: 0
			},
			bubblePopAnimation: {
				type: "Pop",
				filename: "bubble-pop.png",
				numFrames: 10,
				frameRate: 3,
				offsetX: -66,
				offsetY: -66
			},
			catcher: { //the thing at the bottom of the screen catching the items falling from the bubbles
				type: "Catcher",
				states: [
					{
						type: "Wait",
						filename: "cookie-monster-wait.png"
					},{
						type: "Wave",
						filename: "cookie-monster-wave.png",
						numFrames: 8,
						offsetX: -280,
						offsetY: -48
					},{
						type: "Move",
						filename: "cookie-monster-google-eyes.png",
						numFrames: 6,
						loop: true
					},{
						type: "Jump",
						filename: "cookie-monster-jump.png",
						numFrames: 10,
						offsetX: -280,
						offsetY: -8
					}
				]
			},
			emptyBubble: {
				filename: "bubble.png"
			},
			target: {
				unpopped: {
					filename: "2-in-bubble.png"
				},
				popped: {
					filename: "number-2.png"
				},
				label: { //items that go in the side bar
					type: "Label",
					states: [
						{
							type: "NotFound",
							filename: "label-number-2.png"
						},{
							type: "Found",
							filename: "label-number-2-found.png"
						}
					]
				}
			},
			distractors: [
				{
					filename: "1-in-bubble.png"
				}, {
					filename: "3-in-bubble.png"
				}, {
					filename: "4-in-bubble.png"
				}, {
					filename: "5-in-bubble.png"
				}, {
					filename: "6-in-bubble.png"
				}, {
					filename: "7-in-bubble.png"
				}, {
					filename: "8-in-bubble.png"
				}, {
					filename: "9-in-bubble.png"
				}, {
					filename: "10-in-bubble.png"
				}, {
					filename: "11-in-bubble.png"
				}, {
					filename: "12-in-bubble.png"
				}, {
					filename: "13-in-bubble.png"
				}, {
					filename: "14-in-bubble.png"
				}, {
					filename: "15-in-bubble.png"
				}, {
					filename: "16-in-bubble.png"
				}, {
					filename: "17-in-bubble.png"
				}, {
					filename: "18-in-bubble.png"
				}, {
					filename: "19-in-bubble.png"
				}, {
					filename: "20-in-bubble.png"
				}
			]
		}, {
			numBubbles: 6, //the number of bubbles on the screen at one time
			audio: {
				states: [
					{
						name: "intro",
						startTime: 20,
						duration: 3.5
					}, {
						name: "payoff",
						startTime: 24,
						duration: 4.5
					}
				]
			},
			background: {
				filename: "background-numbers.png"
			},
			bubbleHighlight: {
				type: "Highlight",
				filename: "bubble-highlight.png",
				offsetX: 0,
				offsetY: 0
			},
			bubblePopAnimation: {
				type: "Pop",
				filename: "bubble-pop.png",
				numFrames: 10,
				frameRate: 3,
				offsetX: -66,
				offsetY: -66
			},
			catcher: { //the thing at the bottom of the screen catching the items falling from the bubbles
				type: "Catcher",
				states: [
					{
						type: "Wait",
						filename: "cookie-monster-wait.png"
					},{
						type: "Wave",
						filename: "cookie-monster-wave.png",
						numFrames: 8,
						offsetX: -280,
						offsetY: -48
					},{
						type: "Move",
						filename: "cookie-monster-google-eyes.png",
						numFrames: 6,
						loop: true
					},{
						type: "Jump",
						filename: "cookie-monster-jump.png",
						numFrames: 10,
						offsetX: -280,
						offsetY: -8
					}
				]
			},
			emptyBubble: {
				filename: "bubble.png"
			},
			target: {
				unpopped: {
					filename: "3-in-bubble.png"
				},
				popped: {
					filename: "number-3.png"
				},
				label: { //items that go in the side bar
					type: "Label",
					states: [
						{
							type: "NotFound",
							filename: "label-number-3.png"
						},{
							type: "Found",
							filename: "label-number-3-found.png"
						}
					]
				}
			},
			distractors: [
				{
					filename: "1-in-bubble.png"
				}, {
					filename: "2-in-bubble.png"
				}, {
					filename: "4-in-bubble.png"
				}, {
					filename: "5-in-bubble.png"
				}, {
					filename: "6-in-bubble.png"
				}, {
					filename: "7-in-bubble.png"
				}, {
					filename: "8-in-bubble.png"
				}, {
					filename: "9-in-bubble.png"
				}, {
					filename: "10-in-bubble.png"
				}, {
					filename: "11-in-bubble.png"
				}, {
					filename: "12-in-bubble.png"
				}, {
					filename: "13-in-bubble.png"
				}, {
					filename: "14-in-bubble.png"
				}, {
					filename: "15-in-bubble.png"
				}, {
					filename: "16-in-bubble.png"
				}, {
					filename: "17-in-bubble.png"
				}, {
					filename: "18-in-bubble.png"
				}, {
					filename: "19-in-bubble.png"
				}, {
					filename: "20-in-bubble.png"
				}
			]
		}, {
			numBubbles: 6, //the number of bubbles on the screen at one time
			audio: {
				states: [
					{
						name: "intro",
						startTime: 30,
						duration: 2.8
					}, {
						name: "payoff",
						startTime: 34,
						duration: 4.5
					}
				]
			},
			background: {
				filename: "background-numbers.png"
			},
			bubbleHighlight: {
				type: "Highlight",
				filename: "bubble-highlight.png",
				offsetX: 0,
				offsetY: 0
			},
			bubblePopAnimation: {
				type: "Pop",
				filename: "bubble-pop.png",
				numFrames: 10,
				frameRate: 3,
				offsetX: -66,
				offsetY: -66
			},
			catcher: { //the thing at the bottom of the screen catching the items falling from the bubbles
				type: "Catcher",
				states: [
					{
						type: "Wait",
						filename: "cookie-monster-wait.png"
					},{
						type: "Wave",
						filename: "cookie-monster-wave.png",
						numFrames: 8,
						offsetX: -280,
						offsetY: -48
					},{
						type: "Move",
						filename: "cookie-monster-google-eyes.png",
						numFrames: 6,
						loop: true
					},{
						type: "Jump",
						filename: "cookie-monster-jump.png",
						numFrames: 10,
						offsetX: -280,
						offsetY: -8
					}
				]
			},
			emptyBubble: {
				filename: "bubble.png"
			},
			target: {
				unpopped: {
					filename: "4-in-bubble.png"
				},
				popped: {
					filename: "number-4.png"
				},
				label: { //items that go in the side bar
					type: "Label",
					states: [
						{
							type: "NotFound",
							filename: "label-number-4.png"
						},{
							type: "Found",
							filename: "label-number-4-found.png"
						}
					]
				}
			},
			distractors: [
				{
					filename: "1-in-bubble.png"
				}, {
					filename: "2-in-bubble.png"
				}, {
					filename: "3-in-bubble.png"
				}, {
					filename: "5-in-bubble.png"
				}, {
					filename: "6-in-bubble.png"
				}, {
					filename: "7-in-bubble.png"
				}, {
					filename: "8-in-bubble.png"
				}, {
					filename: "9-in-bubble.png"
				}, {
					filename: "10-in-bubble.png"
				}, {
					filename: "11-in-bubble.png"
				}, {
					filename: "12-in-bubble.png"
				}, {
					filename: "13-in-bubble.png"
				}, {
					filename: "14-in-bubble.png"
				}, {
					filename: "15-in-bubble.png"
				}, {
					filename: "16-in-bubble.png"
				}, {
					filename: "17-in-bubble.png"
				}, {
					filename: "18-in-bubble.png"
				}, {
					filename: "19-in-bubble.png"
				}, {
					filename: "20-in-bubble.png"
				}
			]
		}, {
			numBubbles: 6, //the number of bubbles on the screen at one time
			audio: {
				states: [
					{
						name: "intro",
						startTime: 40,
						duration: 3.5
					}, {
						name: "payoff",
						startTime: 44,
						duration: 5.5
					}
				]
			},
			background: {
				filename: "background-numbers.png"
			},
			bubbleHighlight: {
				type: "Highlight",
				filename: "bubble-highlight.png",
				offsetX: 0,
				offsetY: 0
			},
			bubblePopAnimation: {
				type: "Pop",
				filename: "bubble-pop.png",
				numFrames: 10,
				frameRate: 3,
				offsetX: -66,
				offsetY: -66
			},
			catcher: { //the thing at the bottom of the screen catching the items falling from the bubbles
				type: "Catcher",
				states: [
					{
						type: "Wait",
						filename: "cookie-monster-wait.png"
					},{
						type: "Wave",
						filename: "cookie-monster-wave.png",
						numFrames: 8,
						offsetX: -280,
						offsetY: -48
					},{
						type: "Move",
						filename: "cookie-monster-google-eyes.png",
						numFrames: 6,
						loop: true
					},{
						type: "Jump",
						filename: "cookie-monster-jump.png",
						numFrames: 10,
						offsetX: -280,
						offsetY: -8
					}
				]
			},
			emptyBubble: {
				filename: "bubble.png"
			},
			target: {
				unpopped: {
					filename: "5-in-bubble.png"
				},
				popped: {
					filename: "number-5.png"
				},
				label: { //items that go in the side bar
					type: "Label",
					states: [
						{
							type: "NotFound",
							filename: "label-number-5.png"
						},{
							type: "Found",
							filename: "label-number-5-found.png"
						}
					]
				}
			},
			distractors: [
				{
					filename: "1-in-bubble.png"
				}, {
					filename: "2-in-bubble.png"
				}, {
					filename: "3-in-bubble.png"
				}, {
					filename: "4-in-bubble.png"
				}, {
					filename: "6-in-bubble.png"
				}, {
					filename: "7-in-bubble.png"
				}, {
					filename: "8-in-bubble.png"
				}, {
					filename: "9-in-bubble.png"
				}, {
					filename: "10-in-bubble.png"
				}, {
					filename: "11-in-bubble.png"
				}, {
					filename: "12-in-bubble.png"
				}, {
					filename: "13-in-bubble.png"
				}, {
					filename: "14-in-bubble.png"
				}, {
					filename: "15-in-bubble.png"
				}, {
					filename: "16-in-bubble.png"
				}, {
					filename: "17-in-bubble.png"
				}, {
					filename: "18-in-bubble.png"
				}, {
					filename: "19-in-bubble.png"
				}, {
					filename: "20-in-bubble.png"
				}
			]
		}, {
			numBubbles: 6, //the number of bubbles on the screen at one time
			audio: {
				states: [
					{
						name: "intro",
						startTime: 50,
						duration: 4.5
					}, {
						name: "payoff",
						startTime: 55,
						duration: 4.5
					}
				]
			},
			background: {
				filename: "background-numbers.png"
			},
			bubbleHighlight: {
				type: "Highlight",
				filename: "bubble-highlight.png",
				offsetX: 0,
				offsetY: 0
			},
			bubblePopAnimation: {
				type: "Pop",
				filename: "bubble-pop.png",
				numFrames: 10,
				frameRate: 3,
				offsetX: -66,
				offsetY: -66
			},
			catcher: { //the thing at the bottom of the screen catching the items falling from the bubbles
				type: "Catcher",
				states: [
					{
						type: "Wait",
						filename: "cookie-monster-wait.png"
					},{
						type: "Wave",
						filename: "cookie-monster-wave.png",
						numFrames: 8,
						offsetX: -280,
						offsetY: -48
					},{
						type: "Move",
						filename: "cookie-monster-google-eyes.png",
						numFrames: 6,
						loop: true
					},{
						type: "Jump",
						filename: "cookie-monster-jump.png",
						numFrames: 10,
						offsetX: -280,
						offsetY: -8
					}
				]
			},
			emptyBubble: {
				filename: "bubble.png"
			},
			target: {
				unpopped: {
					filename: "6-in-bubble.png"
				},
				popped: {
					filename: "number-6.png"
				},
				label: { //items that go in the side bar
					type: "Label",
					states: [
						{
							type: "NotFound",
							filename: "label-number-6.png"
						},{
							type: "Found",
							filename: "label-number-6-found.png"
						}
					]
				}
			},
			distractors: [
				{
					filename: "1-in-bubble.png"
				}, {
					filename: "2-in-bubble.png"
				}, {
					filename: "3-in-bubble.png"
				}, {
					filename: "4-in-bubble.png"
				}, {
					filename: "5-in-bubble.png"
				}, {
					filename: "7-in-bubble.png"
				}, {
					filename: "8-in-bubble.png"
				}, {
					filename: "9-in-bubble.png"
				}, {
					filename: "10-in-bubble.png"
				}, {
					filename: "11-in-bubble.png"
				}, {
					filename: "12-in-bubble.png"
				}, {
					filename: "13-in-bubble.png"
				}, {
					filename: "14-in-bubble.png"
				}, {
					filename: "15-in-bubble.png"
				}, {
					filename: "16-in-bubble.png"
				}, {
					filename: "17-in-bubble.png"
				}, {
					filename: "18-in-bubble.png"
				}, {
					filename: "19-in-bubble.png"
				}, {
					filename: "20-in-bubble.png"
				}
			]
		}, {
			numBubbles: 6, //the number of bubbles on the screen at one time
			audio: {
				states: [
					{
						name: "intro",
						startTime: 61,
						duration: 3.5
					}, {
						name: "payoff",
						startTime: 65,
						duration: 4.5
					}
				]
			},
			background: {
				filename: "background-numbers.png"
			},
			bubbleHighlight: {
				type: "Highlight",
				filename: "bubble-highlight.png",
				offsetX: 0,
				offsetY: 0
			},
			bubblePopAnimation: {
				type: "Pop",
				filename: "bubble-pop.png",
				numFrames: 10,
				frameRate: 3,
				offsetX: -66,
				offsetY: -66
			},
			catcher: { //the thing at the bottom of the screen catching the items falling from the bubbles
				type: "Catcher",
				states: [
					{
						type: "Wait",
						filename: "cookie-monster-wait.png"
					},{
						type: "Wave",
						filename: "cookie-monster-wave.png",
						numFrames: 8,
						offsetX: -280,
						offsetY: -48
					},{
						type: "Move",
						filename: "cookie-monster-google-eyes.png",
						numFrames: 6,
						loop: true
					},{
						type: "Jump",
						filename: "cookie-monster-jump.png",
						numFrames: 10,
						offsetX: -280,
						offsetY: -8
					}
				]
			},
			emptyBubble: {
				filename: "bubble.png"
			},
			target: {
				unpopped: {
					filename: "7-in-bubble.png"
				},
				popped: {
					filename: "number-7.png"
				},
				label: { //items that go in the side bar
					type: "Label",
					states: [
						{
							type: "NotFound",
							filename: "label-number-7.png"
						},{
							type: "Found",
							filename: "label-number-7-found.png"
						}
					]
				}
			},
			distractors: [
				{
					filename: "1-in-bubble.png"
				}, {
					filename: "2-in-bubble.png"
				}, {
					filename: "3-in-bubble.png"
				}, {
					filename: "4-in-bubble.png"
				}, {
					filename: "5-in-bubble.png"
				}, {
					filename: "6-in-bubble.png"
				}, {
					filename: "8-in-bubble.png"
				}, {
					filename: "9-in-bubble.png"
				}, {
					filename: "10-in-bubble.png"
				}, {
					filename: "11-in-bubble.png"
				}, {
					filename: "12-in-bubble.png"
				}, {
					filename: "13-in-bubble.png"
				}, {
					filename: "14-in-bubble.png"
				}, {
					filename: "15-in-bubble.png"
				}, {
					filename: "16-in-bubble.png"
				}, {
					filename: "17-in-bubble.png"
				}, {
					filename: "18-in-bubble.png"
				}, {
					filename: "19-in-bubble.png"
				}, {
					filename: "20-in-bubble.png"
				}
			]
		}, {
			numBubbles: 6, //the number of bubbles on the screen at one time
			audio: {
				states: [
					{
						name: "intro",
						startTime: 71,
						duration: 3.5
					}, {
						name: "payoff",
						startTime: 75,
						duration: 4.5
					}
				]
			},
			background: {
				filename: "background-numbers.png"
			},
			bubbleHighlight: {
				type: "Highlight",
				filename: "bubble-highlight.png",
				offsetX: 0,
				offsetY: 0
			},
			bubblePopAnimation: {
				type: "Pop",
				filename: "bubble-pop.png",
				numFrames: 10,
				frameRate: 3,
				offsetX: -66,
				offsetY: -66
			},
			catcher: { //the thing at the bottom of the screen catching the items falling from the bubbles
				type: "Catcher",
				states: [
					{
						type: "Wait",
						filename: "cookie-monster-wait.png"
					},{
						type: "Wave",
						filename: "cookie-monster-wave.png",
						numFrames: 8,
						offsetX: -280,
						offsetY: -48
					},{
						type: "Move",
						filename: "cookie-monster-google-eyes.png",
						numFrames: 6,
						loop: true
					},{
						type: "Jump",
						filename: "cookie-monster-jump.png",
						numFrames: 10,
						offsetX: -280,
						offsetY: -8
					}
				]
			},
			emptyBubble: {
				filename: "bubble.png"
			},
			target: {
				unpopped: {
					filename: "8-in-bubble.png"
				},
				popped: {
					filename: "number-8.png"
				},
				label: { //items that go in the side bar
					type: "Label",
					states: [
						{
							type: "NotFound",
							filename: "label-number-8.png"
						},{
							type: "Found",
							filename: "label-number-8-found.png"
						}
					]
				}
			},
			distractors: [
				{
					filename: "1-in-bubble.png"
				}, {
					filename: "2-in-bubble.png"
				}, {
					filename: "3-in-bubble.png"
				}, {
					filename: "4-in-bubble.png"
				}, {
					filename: "5-in-bubble.png"
				}, {
					filename: "6-in-bubble.png"
				}, {
					filename: "7-in-bubble.png"
				}, {
					filename: "9-in-bubble.png"
				}, {
					filename: "10-in-bubble.png"
				}, {
					filename: "11-in-bubble.png"
				}, {
					filename: "12-in-bubble.png"
				}, {
					filename: "13-in-bubble.png"
				}, {
					filename: "14-in-bubble.png"
				}, {
					filename: "15-in-bubble.png"
				}, {
					filename: "16-in-bubble.png"
				}, {
					filename: "17-in-bubble.png"
				}, {
					filename: "18-in-bubble.png"
				}, {
					filename: "19-in-bubble.png"
				}, {
					filename: "20-in-bubble.png"
				}
			]
		}, {
			numBubbles: 6, //the number of bubbles on the screen at one time
			audio: {
				states: [
					{
						name: "intro",
						startTime: 81,
						duration: 3.5
					}, {
						name: "payoff",
						startTime: 85,
						duration: 4.5
					}
				]
			},
			background: {
				filename: "background-numbers.png"
			},
			bubbleHighlight: {
				type: "Highlight",
				filename: "bubble-highlight.png",
				offsetX: 0,
				offsetY: 0
			},
			bubblePopAnimation: {
				type: "Pop",
				filename: "bubble-pop.png",
				numFrames: 10,
				frameRate: 3,
				offsetX: -66,
				offsetY: -66
			},
			catcher: { //the thing at the bottom of the screen catching the items falling from the bubbles
				type: "Catcher",
				states: [
					{
						type: "Wait",
						filename: "cookie-monster-wait.png"
					},{
						type: "Wave",
						filename: "cookie-monster-wave.png",
						numFrames: 8,
						offsetX: -280,
						offsetY: -48
					},{
						type: "Move",
						filename: "cookie-monster-google-eyes.png",
						numFrames: 6,
						loop: true
					},{
						type: "Jump",
						filename: "cookie-monster-jump.png",
						numFrames: 10,
						offsetX: -280,
						offsetY: -8
					}
				]
			},
			emptyBubble: {
				filename: "bubble.png"
			},
			target: {
				unpopped: {
					filename: "9-in-bubble.png"
				},
				popped: {
					filename: "number-9.png"
				},
				label: { //items that go in the side bar
					type: "Label",
					states: [
						{
							type: "NotFound",
							filename: "label-number-9.png"
						},{
							type: "Found",
							filename: "label-number-9-found.png"
						}
					]
				}
			},
			distractors: [
				{
					filename: "1-in-bubble.png"
				}, {
					filename: "2-in-bubble.png"
				}, {
					filename: "3-in-bubble.png"
				}, {
					filename: "4-in-bubble.png"
				}, {
					filename: "5-in-bubble.png"
				}, {
					filename: "6-in-bubble.png"
				}, {
					filename: "7-in-bubble.png"
				}, {
					filename: "8-in-bubble.png"
				}, {
					filename: "10-in-bubble.png"
				}, {
					filename: "11-in-bubble.png"
				}, {
					filename: "12-in-bubble.png"
				}, {
					filename: "13-in-bubble.png"
				}, {
					filename: "14-in-bubble.png"
				}, {
					filename: "15-in-bubble.png"
				}, {
					filename: "16-in-bubble.png"
				}, {
					filename: "17-in-bubble.png"
				}, {
					filename: "18-in-bubble.png"
				}, {
					filename: "19-in-bubble.png"
				}, {
					filename: "20-in-bubble.png"
				}
			]
		}, {
			numBubbles: 6, //the number of bubbles on the screen at one time
			audio: {
				states: [
					{
						name: "intro",
						startTime: 91,
						duration: 3.5
					}, {
						name: "payoff",
						startTime: 95,
						duration: 4.5
					}
				]
			},
			background: {
				filename: "background-numbers.png"
			},
			bubbleHighlight: {
				type: "Highlight",
				filename: "bubble-highlight.png",
				offsetX: 0,
				offsetY: 0
			},
			bubblePopAnimation: {
				type: "Pop",
				filename: "bubble-pop.png",
				numFrames: 10,
				frameRate: 3,
				offsetX: -66,
				offsetY: -66
			},
			catcher: { //the thing at the bottom of the screen catching the items falling from the bubbles
				type: "Catcher",
				states: [
					{
						type: "Wait",
						filename: "cookie-monster-wait.png"
					},{
						type: "Wave",
						filename: "cookie-monster-wave.png",
						numFrames: 8,
						offsetX: -280,
						offsetY: -48
					},{
						type: "Move",
						filename: "cookie-monster-google-eyes.png",
						numFrames: 6,
						loop: true
					},{
						type: "Jump",
						filename: "cookie-monster-jump.png",
						numFrames: 10,
						offsetX: -280,
						offsetY: -8
					}
				]
			},
			emptyBubble: {
				filename: "bubble.png"
			},
			target: {
				unpopped: {
					filename: "10-in-bubble.png"
				},
				popped: {
					filename: "number-10.png"
				},
				label: { //items that go in the side bar
					type: "Label",
					states: [
						{
							type: "NotFound",
							filename: "label-number-10.png"
						},{
							type: "Found",
							filename: "label-number-10-found.png"
						}
					]
				}
			},
			distractors: [
				{
					filename: "1-in-bubble.png"
				}, {
					filename: "2-in-bubble.png"
				}, {
					filename: "3-in-bubble.png"
				}, {
					filename: "4-in-bubble.png"
				}, {
					filename: "5-in-bubble.png"
				}, {
					filename: "6-in-bubble.png"
				}, {
					filename: "7-in-bubble.png"
				}, {
					filename: "8-in-bubble.png"
				}, {
					filename: "9-in-bubble.png"
				}, {
					filename: "11-in-bubble.png"
				}, {
					filename: "12-in-bubble.png"
				}, {
					filename: "13-in-bubble.png"
				}, {
					filename: "14-in-bubble.png"
				}, {
					filename: "15-in-bubble.png"
				}, {
					filename: "16-in-bubble.png"
				}, {
					filename: "17-in-bubble.png"
				}, {
					filename: "18-in-bubble.png"
				}, {
					filename: "19-in-bubble.png"
				}, {
					filename: "20-in-bubble.png"
				}
			]
		}, {
			numBubbles: 6, //the number of bubbles on the screen at one time
			audio: {
				states: [
					{
						name: "intro",
						startTime: 101,
						duration: 3.5
					}, {
						name: "payoff",
						startTime: 105,
						duration: 4.5
					}
				]
			},
			background: {
				filename: "background-numbers.png"
			},
			bubbleHighlight: {
				type: "Highlight",
				filename: "bubble-highlight.png",
				offsetX: 0,
				offsetY: 0
			},
			bubblePopAnimation: {
				type: "Pop",
				filename: "bubble-pop.png",
				numFrames: 10,
				frameRate: 3,
				offsetX: -66,
				offsetY: -66
			},
			catcher: { //the thing at the bottom of the screen catching the items falling from the bubbles
				type: "Catcher",
				states: [
					{
						type: "Wait",
						filename: "cookie-monster-wait.png"
					},{
						type: "Wave",
						filename: "cookie-monster-wave.png",
						numFrames: 8,
						offsetX: -280,
						offsetY: -48
					},{
						type: "Move",
						filename: "cookie-monster-google-eyes.png",
						numFrames: 6,
						loop: true
					},{
						type: "Jump",
						filename: "cookie-monster-jump.png",
						numFrames: 10,
						offsetX: -280,
						offsetY: -8
					}
				]
			},
			emptyBubble: {
				filename: "bubble.png"
			},
			target: {
				unpopped: {
					filename: "11-in-bubble.png"
				},
				popped: {
					filename: "number-11.png"
				},
				label: { //items that go in the side bar
					type: "Label",
					states: [
						{
							type: "NotFound",
							filename: "label-number-11.png"
						},{
							type: "Found",
							filename: "label-number-11-found.png"
						}
					]
				}
			},
			distractors: [
				{
					filename: "1-in-bubble.png"
				}, {
					filename: "2-in-bubble.png"
				}, {
					filename: "3-in-bubble.png"
				}, {
					filename: "4-in-bubble.png"
				}, {
					filename: "5-in-bubble.png"
				}, {
					filename: "6-in-bubble.png"
				}, {
					filename: "7-in-bubble.png"
				}, {
					filename: "8-in-bubble.png"
				}, {
					filename: "9-in-bubble.png"
				}, {
					filename: "10-in-bubble.png"
				}, {
					filename: "12-in-bubble.png"
				}, {
					filename: "13-in-bubble.png"
				}, {
					filename: "14-in-bubble.png"
				}, {
					filename: "15-in-bubble.png"
				}, {
					filename: "16-in-bubble.png"
				}, {
					filename: "17-in-bubble.png"
				}, {
					filename: "18-in-bubble.png"
				}, {
					filename: "19-in-bubble.png"
				}, {
					filename: "20-in-bubble.png"
				}
			]
		}, {
			numBubbles: 6, //the number of bubbles on the screen at one time
			audio: {
				states: [
					{
						name: "intro",
						startTime: 111,
						duration: 3.5
					}, {
						name: "payoff",
						startTime: 115,
						duration: 4.5
					}
				]
			},
			background: {
				filename: "background-numbers.png"
			},
			bubbleHighlight: {
				type: "Highlight",
				filename: "bubble-highlight.png",
				offsetX: 0,
				offsetY: 0
			},
			bubblePopAnimation: {
				type: "Pop",
				filename: "bubble-pop.png",
				numFrames: 10,
				frameRate: 3,
				offsetX: -66,
				offsetY: -66
			},
			catcher: { //the thing at the bottom of the screen catching the items falling from the bubbles
				type: "Catcher",
				states: [
					{
						type: "Wait",
						filename: "cookie-monster-wait.png"
					},{
						type: "Wave",
						filename: "cookie-monster-wave.png",
						numFrames: 8,
						offsetX: -280,
						offsetY: -48
					},{
						type: "Move",
						filename: "cookie-monster-google-eyes.png",
						numFrames: 6,
						loop: true
					},{
						type: "Jump",
						filename: "cookie-monster-jump.png",
						numFrames: 10,
						offsetX: -280,
						offsetY: -8
					}
				]
			},
			emptyBubble: {
				filename: "bubble.png"
			},
			target: {
				unpopped: {
					filename: "12-in-bubble.png"
				},
				popped: {
					filename: "number-12.png"
				},
				label: { //items that go in the side bar
					type: "Label",
					states: [
						{
							type: "NotFound",
							filename: "label-number-12.png"
						},{
							type: "Found",
							filename: "label-number-12-found.png"
						}
					]
				}
			},
			distractors: [
				{
					filename: "1-in-bubble.png"
				}, {
					filename: "2-in-bubble.png"
				}, {
					filename: "3-in-bubble.png"
				}, {
					filename: "4-in-bubble.png"
				}, {
					filename: "5-in-bubble.png"
				}, {
					filename: "6-in-bubble.png"
				}, {
					filename: "7-in-bubble.png"
				}, {
					filename: "8-in-bubble.png"
				}, {
					filename: "9-in-bubble.png"
				}, {
					filename: "10-in-bubble.png"
				}, {
					filename: "11-in-bubble.png"
				}, {
					filename: "13-in-bubble.png"
				}, {
					filename: "14-in-bubble.png"
				}, {
					filename: "15-in-bubble.png"
				}, {
					filename: "16-in-bubble.png"
				}, {
					filename: "17-in-bubble.png"
				}, {
					filename: "18-in-bubble.png"
				}, {
					filename: "19-in-bubble.png"
				}, {
					filename: "20-in-bubble.png"
				}
			]
		}, {
			numBubbles: 6, //the number of bubbles on the screen at one time
			audio: {
				states: [
					{
						name: "intro",
						startTime: 121,
						duration: 3.5
					}, {
						name: "payoff",
						startTime: 125,
						duration: 4.5
					}
				]
			},
			background: {
				filename: "background-numbers.png"
			},
			bubbleHighlight: {
				type: "Highlight",
				filename: "bubble-highlight.png",
				offsetX: 0,
				offsetY: 0
			},
			bubblePopAnimation: {
				type: "Pop",
				filename: "bubble-pop.png",
				numFrames: 10,
				frameRate: 3,
				offsetX: -66,
				offsetY: -66
			},
			catcher: { //the thing at the bottom of the screen catching the items falling from the bubbles
				type: "Catcher",
				states: [
					{
						type: "Wait",
						filename: "cookie-monster-wait.png"
					},{
						type: "Wave",
						filename: "cookie-monster-wave.png",
						numFrames: 8,
						offsetX: -280,
						offsetY: -48
					},{
						type: "Move",
						filename: "cookie-monster-google-eyes.png",
						numFrames: 6,
						loop: true
					},{
						type: "Jump",
						filename: "cookie-monster-jump.png",
						numFrames: 10,
						offsetX: -280,
						offsetY: -8
					}
				]
			},
			emptyBubble: {
				filename: "bubble.png"
			},
			target: {
				unpopped: {
					filename: "13-in-bubble.png"
				},
				popped: {
					filename: "number-13.png"
				},
				label: { //items that go in the side bar
					type: "Label",
					states: [
						{
							type: "NotFound",
							filename: "label-number-13.png"
						},{
							type: "Found",
							filename: "label-number-13-found.png"
						}
					]
				}
			},
			distractors: [
				{
					filename: "1-in-bubble.png"
				}, {
					filename: "2-in-bubble.png"
				}, {
					filename: "3-in-bubble.png"
				}, {
					filename: "4-in-bubble.png"
				}, {
					filename: "5-in-bubble.png"
				}, {
					filename: "6-in-bubble.png"
				}, {
					filename: "7-in-bubble.png"
				}, {
					filename: "8-in-bubble.png"
				}, {
					filename: "9-in-bubble.png"
				}, {
					filename: "10-in-bubble.png"
				}, {
					filename: "11-in-bubble.png"
				}, {
					filename: "12-in-bubble.png"
				}, {
					filename: "14-in-bubble.png"
				}, {
					filename: "15-in-bubble.png"
				}, {
					filename: "16-in-bubble.png"
				}, {
					filename: "17-in-bubble.png"
				}, {
					filename: "18-in-bubble.png"
				}, {
					filename: "19-in-bubble.png"
				}, {
					filename: "20-in-bubble.png"
				}
			]
		}, {
			numBubbles: 6, //the number of bubbles on the screen at one time
			audio: {
				states: [
					{
						name: "intro",
						startTime: 131,
						duration: 3.5
					}, {
						name: "payoff",
						startTime: 135,
						duration: 4.5
					}
				]
			},
			background: {
				filename: "background-numbers.png"
			},
			bubbleHighlight: {
				type: "Highlight",
				filename: "bubble-highlight.png",
				offsetX: 0,
				offsetY: 0
			},
			bubblePopAnimation: {
				type: "Pop",
				filename: "bubble-pop.png",
				numFrames: 10,
				frameRate: 3,
				offsetX: -66,
				offsetY: -66
			},
			catcher: { //the thing at the bottom of the screen catching the items falling from the bubbles
				type: "Catcher",
				states: [
					{
						type: "Wait",
						filename: "cookie-monster-wait.png"
					},{
						type: "Wave",
						filename: "cookie-monster-wave.png",
						numFrames: 8,
						offsetX: -280,
						offsetY: -48
					},{
						type: "Move",
						filename: "cookie-monster-google-eyes.png",
						numFrames: 6,
						loop: true
					},{
						type: "Jump",
						filename: "cookie-monster-jump.png",
						numFrames: 10,
						offsetX: -280,
						offsetY: -8
					}
				]
			},
			emptyBubble: {
				filename: "bubble.png"
			},
			target: {
				unpopped: {
					filename: "14-in-bubble.png"
				},
				popped: {
					filename: "number-14.png"
				},
				label: { //items that go in the side bar
					type: "Label",
					states: [
						{
							type: "NotFound",
							filename: "label-number-14.png"
						},{
							type: "Found",
							filename: "label-number-14-found.png"
						}
					]
				}
			},
			distractors: [
				{
					filename: "1-in-bubble.png"
				}, {
					filename: "2-in-bubble.png"
				}, {
					filename: "3-in-bubble.png"
				}, {
					filename: "4-in-bubble.png"
				}, {
					filename: "5-in-bubble.png"
				}, {
					filename: "6-in-bubble.png"
				}, {
					filename: "7-in-bubble.png"
				}, {
					filename: "8-in-bubble.png"
				}, {
					filename: "9-in-bubble.png"
				}, {
					filename: "10-in-bubble.png"
				}, {
					filename: "11-in-bubble.png"
				}, {
					filename: "12-in-bubble.png"
				}, {
					filename: "13-in-bubble.png"
				}, {
					filename: "15-in-bubble.png"
				}, {
					filename: "16-in-bubble.png"
				}, {
					filename: "17-in-bubble.png"
				}, {
					filename: "18-in-bubble.png"
				}, {
					filename: "19-in-bubble.png"
				}, {
					filename: "20-in-bubble.png"
				}
			]
		}, {
			numBubbles: 6, //the number of bubbles on the screen at one time
			audio: {
				states: [
					{
						name: "intro",
						startTime: 141,
						duration: 3.5
					}, {
						name: "payoff",
						startTime: 145,
						duration: 4.5
					}
				]
			},
			background: {
				filename: "background-numbers.png"
			},
			bubbleHighlight: {
				type: "Highlight",
				filename: "bubble-highlight.png",
				offsetX: 0,
				offsetY: 0
			},
			bubblePopAnimation: {
				type: "Pop",
				filename: "bubble-pop.png",
				numFrames: 10,
				frameRate: 3,
				offsetX: -66,
				offsetY: -66
			},
			catcher: { //the thing at the bottom of the screen catching the items falling from the bubbles
				type: "Catcher",
				states: [
					{
						type: "Wait",
						filename: "cookie-monster-wait.png"
					},{
						type: "Wave",
						filename: "cookie-monster-wave.png",
						numFrames: 8,
						offsetX: -280,
						offsetY: -48
					},{
						type: "Move",
						filename: "cookie-monster-google-eyes.png",
						numFrames: 6,
						loop: true
					},{
						type: "Jump",
						filename: "cookie-monster-jump.png",
						numFrames: 10,
						offsetX: -280,
						offsetY: -8
					}
				]
			},
			emptyBubble: {
				filename: "bubble.png"
			},
			target: {
				unpopped: {
					filename: "15-in-bubble.png"
				},
				popped: {
					filename: "number-15.png"
				},
				label: { //items that go in the side bar
					type: "Label",
					states: [
						{
							type: "NotFound",
							filename: "label-number-15.png"
						},{
							type: "Found",
							filename: "label-number-15-found.png"
						}
					]
				}
			},
			distractors: [
				{
					filename: "1-in-bubble.png"
				}, {
					filename: "2-in-bubble.png"
				}, {
					filename: "3-in-bubble.png"
				}, {
					filename: "4-in-bubble.png"
				}, {
					filename: "5-in-bubble.png"
				}, {
					filename: "6-in-bubble.png"
				}, {
					filename: "7-in-bubble.png"
				}, {
					filename: "8-in-bubble.png"
				}, {
					filename: "9-in-bubble.png"
				}, {
					filename: "10-in-bubble.png"
				}, {
					filename: "11-in-bubble.png"
				}, {
					filename: "12-in-bubble.png"
				}, {
					filename: "13-in-bubble.png"
				}, {
					filename: "14-in-bubble.png"
				}, {
					filename: "16-in-bubble.png"
				}, {
					filename: "17-in-bubble.png"
				}, {
					filename: "18-in-bubble.png"
				}, {
					filename: "19-in-bubble.png"
				}, {
					filename: "20-in-bubble.png"
				}
			]
		}, {
			numBubbles: 6, //the number of bubbles on the screen at one time
			audio: {
				states: [
					{
						name: "intro",
						startTime: 151,
						duration: 3.5
					}, {
						name: "payoff",
						startTime: 155,
						duration: 4.5
					}
				]
			},
			background: {
				filename: "background-numbers.png"
			},
			bubbleHighlight: {
				type: "Highlight",
				filename: "bubble-highlight.png",
				offsetX: 0,
				offsetY: 0
			},
			bubblePopAnimation: {
				type: "Pop",
				filename: "bubble-pop.png",
				numFrames: 10,
				frameRate: 3,
				offsetX: -66,
				offsetY: -66
			},
			catcher: { //the thing at the bottom of the screen catching the items falling from the bubbles
				type: "Catcher",
				states: [
					{
						type: "Wait",
						filename: "cookie-monster-wait.png"
					},{
						type: "Wave",
						filename: "cookie-monster-wave.png",
						numFrames: 8,
						offsetX: -280,
						offsetY: -48
					},{
						type: "Move",
						filename: "cookie-monster-google-eyes.png",
						numFrames: 6,
						loop: true
					},{
						type: "Jump",
						filename: "cookie-monster-jump.png",
						numFrames: 10,
						offsetX: -280,
						offsetY: -8
					}
				]
			},
			emptyBubble: {
				filename: "bubble.png"
			},
			target: {
				unpopped: {
					filename: "16-in-bubble.png"
				},
				popped: {
					filename: "number-16.png"
				},
				label: { //items that go in the side bar
					type: "Label",
					states: [
						{
							type: "NotFound",
							filename: "label-number-16.png"
						},{
							type: "Found",
							filename: "label-number-16-found.png"
						}
					]
				}
			},
			distractors: [
				{
					filename: "1-in-bubble.png"
				}, {
					filename: "2-in-bubble.png"
				}, {
					filename: "3-in-bubble.png"
				}, {
					filename: "4-in-bubble.png"
				}, {
					filename: "5-in-bubble.png"
				}, {
					filename: "6-in-bubble.png"
				}, {
					filename: "7-in-bubble.png"
				}, {
					filename: "8-in-bubble.png"
				}, {
					filename: "9-in-bubble.png"
				}, {
					filename: "10-in-bubble.png"
				}, {
					filename: "11-in-bubble.png"
				}, {
					filename: "12-in-bubble.png"
				}, {
					filename: "13-in-bubble.png"
				}, {
					filename: "14-in-bubble.png"
				}, {
					filename: "15-in-bubble.png"
				}, {
					filename: "17-in-bubble.png"
				}, {
					filename: "18-in-bubble.png"
				}, {
					filename: "19-in-bubble.png"
				}, {
					filename: "20-in-bubble.png"
				}
			]
		}, {
			numBubbles: 6, //the number of bubbles on the screen at one time
			audio: {
				states: [
					{
						name: "intro",
						startTime: 161,
						duration: 3.5
					}, {
						name: "payoff",
						startTime: 165,
						duration: 4.5
					}
				]
			},
			background: {
				filename: "background-numbers.png"
			},
			bubbleHighlight: {
				type: "Highlight",
				filename: "bubble-highlight.png",
				offsetX: 0,
				offsetY: 0
			},
			bubblePopAnimation: {
				type: "Pop",
				filename: "bubble-pop.png",
				numFrames: 10,
				frameRate: 3,
				offsetX: -66,
				offsetY: -66
			},
			catcher: { //the thing at the bottom of the screen catching the items falling from the bubbles
				type: "Catcher",
				states: [
					{
						type: "Wait",
						filename: "cookie-monster-wait.png"
					},{
						type: "Wave",
						filename: "cookie-monster-wave.png",
						numFrames: 8,
						offsetX: -280,
						offsetY: -48
					},{
						type: "Move",
						filename: "cookie-monster-google-eyes.png",
						numFrames: 6,
						loop: true
					},{
						type: "Jump",
						filename: "cookie-monster-jump.png",
						numFrames: 10,
						offsetX: -280,
						offsetY: -8
					}
				]
			},
			emptyBubble: {
				filename: "bubble.png"
			},
			target: {
				unpopped: {
					filename: "17-in-bubble.png"
				},
				popped: {
					filename: "number-17.png"
				},
				label: { //items that go in the side bar
					type: "Label",
					states: [
						{
							type: "NotFound",
							filename: "label-number-17.png"
						},{
							type: "Found",
							filename: "label-number-17-found.png"
						}
					]
				}
			},
			distractors: [
				{
					filename: "1-in-bubble.png"
				}, {
					filename: "2-in-bubble.png"
				}, {
					filename: "3-in-bubble.png"
				}, {
					filename: "4-in-bubble.png"
				}, {
					filename: "5-in-bubble.png"
				}, {
					filename: "6-in-bubble.png"
				}, {
					filename: "7-in-bubble.png"
				}, {
					filename: "8-in-bubble.png"
				}, {
					filename: "9-in-bubble.png"
				}, {
					filename: "10-in-bubble.png"
				}, {
					filename: "11-in-bubble.png"
				}, {
					filename: "12-in-bubble.png"
				}, {
					filename: "13-in-bubble.png"
				}, {
					filename: "14-in-bubble.png"
				}, {
					filename: "15-in-bubble.png"
				}, {
					filename: "16-in-bubble.png"
				}, {
					filename: "18-in-bubble.png"
				}, {
					filename: "19-in-bubble.png"
				}, {
					filename: "20-in-bubble.png"
				}
			]
		}, {
			numBubbles: 6, //the number of bubbles on the screen at one time
			audio: {
				states: [
					{
						name: "intro",
						startTime: 171,
						duration: 3.5
					}, {
						name: "payoff",
						startTime: 175,
						duration: 4.5
					}
				]
			},
			background: {
				filename: "background-numbers.png"
			},
			bubbleHighlight: {
				type: "Highlight",
				filename: "bubble-highlight.png",
				offsetX: 0,
				offsetY: 0
			},
			bubblePopAnimation: {
				type: "Pop",
				filename: "bubble-pop.png",
				numFrames: 10,
				frameRate: 3,
				offsetX: -66,
				offsetY: -66
			},
			catcher: { //the thing at the bottom of the screen catching the items falling from the bubbles
				type: "Catcher",
				states: [
					{
						type: "Wait",
						filename: "cookie-monster-wait.png"
					},{
						type: "Wave",
						filename: "cookie-monster-wave.png",
						numFrames: 8,
						offsetX: -280,
						offsetY: -48
					},{
						type: "Move",
						filename: "cookie-monster-google-eyes.png",
						numFrames: 6,
						loop: true
					},{
						type: "Jump",
						filename: "cookie-monster-jump.png",
						numFrames: 10,
						offsetX: -280,
						offsetY: -8
					}
				]
			},
			emptyBubble: {
				filename: "bubble.png"
			},
			target: {
				unpopped: {
					filename: "18-in-bubble.png"
				},
				popped: {
					filename: "number-18.png"
				},
				label: { //items that go in the side bar
					type: "Label",
					states: [
						{
							type: "NotFound",
							filename: "label-number-18.png"
						},{
							type: "Found",
							filename: "label-number-18-found.png"
						}
					]
				}
			},
			distractors: [
				{
					filename: "1-in-bubble.png"
				}, {
					filename: "2-in-bubble.png"
				}, {
					filename: "3-in-bubble.png"
				}, {
					filename: "4-in-bubble.png"
				}, {
					filename: "5-in-bubble.png"
				}, {
					filename: "6-in-bubble.png"
				}, {
					filename: "7-in-bubble.png"
				}, {
					filename: "8-in-bubble.png"
				}, {
					filename: "9-in-bubble.png"
				}, {
					filename: "10-in-bubble.png"
				}, {
					filename: "11-in-bubble.png"
				}, {
					filename: "12-in-bubble.png"
				}, {
					filename: "13-in-bubble.png"
				}, {
					filename: "14-in-bubble.png"
				}, {
					filename: "15-in-bubble.png"
				}, {
					filename: "16-in-bubble.png"
				}, {
					filename: "17-in-bubble.png"
				}, {
					filename: "19-in-bubble.png"
				}, {
					filename: "20-in-bubble.png"
				}
			]
		}, {
			numBubbles: 6, //the number of bubbles on the screen at one time
			audio: {
				states: [
					{
						name: "intro",
						startTime: 181,
						duration: 3.5
					}, {
						name: "payoff",
						startTime: 185,
						duration: 4.5
					}
				]
			},
			background: {
				filename: "background-numbers.png"
			},
			bubbleHighlight: {
				type: "Highlight",
				filename: "bubble-highlight.png",
				offsetX: 0,
				offsetY: 0
			},
			bubblePopAnimation: {
				type: "Pop",
				filename: "bubble-pop.png",
				numFrames: 10,
				frameRate: 3,
				offsetX: -66,
				offsetY: -66
			},
			catcher: { //the thing at the bottom of the screen catching the items falling from the bubbles
				type: "Catcher",
				states: [
					{
						type: "Wait",
						filename: "cookie-monster-wait.png"
					},{
						type: "Wave",
						filename: "cookie-monster-wave.png",
						numFrames: 8,
						offsetX: -280,
						offsetY: -48
					},{
						type: "Move",
						filename: "cookie-monster-google-eyes.png",
						numFrames: 6,
						loop: true
					},{
						type: "Jump",
						filename: "cookie-monster-jump.png",
						numFrames: 10,
						offsetX: -280,
						offsetY: -8
					}
				]
			},
			emptyBubble: {
				filename: "bubble.png"
			},
			target: {
				unpopped: {
					filename: "19-in-bubble.png"
				},
				popped: {
					filename: "number-19.png"
				},
				label: { //items that go in the side bar
					type: "Label",
					states: [
						{
							type: "NotFound",
							filename: "label-number-19.png"
						},{
							type: "Found",
							filename: "label-number-19-found.png"
						}
					]
				}
			},
			distractors: [
				{
					filename: "1-in-bubble.png"
				}, {
					filename: "2-in-bubble.png"
				}, {
					filename: "3-in-bubble.png"
				}, {
					filename: "4-in-bubble.png"
				}, {
					filename: "5-in-bubble.png"
				}, {
					filename: "6-in-bubble.png"
				}, {
					filename: "7-in-bubble.png"
				}, {
					filename: "8-in-bubble.png"
				}, {
					filename: "9-in-bubble.png"
				}, {
					filename: "10-in-bubble.png"
				}, {
					filename: "11-in-bubble.png"
				}, {
					filename: "12-in-bubble.png"
				}, {
					filename: "13-in-bubble.png"
				}, {
					filename: "14-in-bubble.png"
				}, {
					filename: "15-in-bubble.png"
				}, {
					filename: "16-in-bubble.png"
				}, {
					filename: "17-in-bubble.png"
				}, {
					filename: "18-in-bubble.png"
				}, {
					filename: "20-in-bubble.png"
				}
			]
		}, {
			numBubbles: 6, //the number of bubbles on the screen at one time
			audio: {
				states: [
					{
						name: "intro",
						startTime: 191,
						duration: 3.5
					}, {
						name: "payoff",
						startTime: 195,
						duration: 4.5
					}
				]
			},
			background: {
				filename: "background-numbers.png"
			},
			bubbleHighlight: {
				type: "Highlight",
				filename: "bubble-highlight.png",
				offsetX: 0,
				offsetY: 0
			},
			bubblePopAnimation: {
				type: "Pop",
				filename: "bubble-pop.png",
				numFrames: 10,
				frameRate: 3,
				offsetX: -66,
				offsetY: -66
			},
			catcher: { //the thing at the bottom of the screen catching the items falling from the bubbles
				type: "Catcher",
				states: [
					{
						type: "Wait",
						filename: "cookie-monster-wait.png"
					},{
						type: "Wave",
						filename: "cookie-monster-wave.png",
						numFrames: 8,
						offsetX: -280,
						offsetY: -48
					},{
						type: "Move",
						filename: "cookie-monster-google-eyes.png",
						numFrames: 6,
						loop: true
					},{
						type: "Jump",
						filename: "cookie-monster-jump.png",
						numFrames: 10,
						offsetX: -280,
						offsetY: -8
					}
				]
			},
			emptyBubble: {
				filename: "bubble.png"
			},
			target: {
				unpopped: {
					filename: "20-in-bubble.png"
				},
				popped: {
					filename: "number-20.png"
				},
				label: { //items that go in the side bar
					type: "Label",
					states: [
						{
							type: "NotFound",
							filename: "label-number-20.png"
						},{
							type: "Found",
							filename: "label-number-20-found.png"
						}
					]
				}
			},
			distractors: [
				{
					filename: "1-in-bubble.png"
				}, {
					filename: "2-in-bubble.png"
				}, {
					filename: "3-in-bubble.png"
				}, {
					filename: "4-in-bubble.png"
				}, {
					filename: "5-in-bubble.png"
				}, {
					filename: "6-in-bubble.png"
				}, {
					filename: "7-in-bubble.png"
				}, {
					filename: "8-in-bubble.png"
				}, {
					filename: "9-in-bubble.png"
				}, {
					filename: "10-in-bubble.png"
				}, {
					filename: "11-in-bubble.png"
				}, {
					filename: "12-in-bubble.png"
				}, {
					filename: "13-in-bubble.png"
				}, {
					filename: "14-in-bubble.png"
				}, {
					filename: "15-in-bubble.png"
				}, {
					filename: "16-in-bubble.png"
				}, {
					filename: "17-in-bubble.png"
				}, {
					filename: "18-in-bubble.png"
				}, {
					filename: "19-in-bubble.png"
				}
			]
		}
			/*items: [
				{
					audio: { //audio for the first item
						states: [
							{
								name: "intro",
								startTime: 0,
								duration: 2.5
							}, {
								name: "payoff",
								startTime: 3.5,
								duration: 5
							}
						]
					}
				},{
					audio: { //audio for the second item
						states: [
							{
								name: "intro",
								startTime: 9,
								duration: 4.5
							}, {
								name: "payoff",
								startTime: 14,
								duration: 4.5
							}
						]
					}
				},{
					audio: {
						states: [
							{
								name: "intro",
								startTime: 20,
								duration: 3.5
							}, {
								name: "payoff",
								startTime: 24,
								duration: 4.5
							}
						]
					}
				},{
					audio: {
						states: [
							{
								name: "intro",
								startTime: 30,
								duration: 2.8
							}, {
								name: "payoff",
								startTime: 34,
								duration: 4.5
							}
						]
					}
				},{
					audio: {
						states: [
							{
								name: "intro",
								startTime: 40,
								duration: 3.5
							}, {
								name: "payoff",
								startTime: 44,
								duration: 5.5
							}
						]
					}
				},{
					audio: {
						states: [
							{
								name: "intro",
								startTime: 50,
								duration: 4.5
							}, {
								name: "payoff",
								startTime: 55,
								duration: 4.5
							}
						]
					}
				},{
					audio: {
						states: [
							{
								name: "intro",
								startTime: 61,
								duration: 3.5
							}, {
								name: "payoff",
								startTime: 65,
								duration: 4.5
							}
						]
					}
				},{
					audio: {
						states: [
							{
								name: "intro",
								startTime: 71,
								duration: 3.5
							}, {
								name: "payoff",
								startTime: 75,
								duration: 4.5
							}
						]
					}
				},{
					audio: {
						states: [
							{
								name: "intro",
								startTime: 81,
								duration: 3.5
							}, {
								name: "payoff",
								startTime: 85,
								duration: 4.5
							}
						]
					}
				},{
					audio: {
						states: [
							{
								name: "intro",
								startTime: 91,
								duration: 3.5
							}, {
								name: "payoff",
								startTime: 95,
								duration: 4.5
							}
						]
					}
				},{
					audio: {
						states: [
							{
								name: "intro",
								startTime: 101,
								duration: 3.5
							}, {
								name: "payoff",
								startTime: 105,
								duration: 4.5
							}
						]
					}
				},{
					audio: {
						states: [
							{
								name: "intro",
								startTime: 111,
								duration: 3.5
							}, {
								name: "payoff",
								startTime: 115,
								duration: 4.5
							}
						]
					}
				},{
					audio: {
						states: [
							{
								name: "intro",
								startTime: 121,
								duration: 3.5
							}, {
								name: "payoff",
								startTime: 125,
								duration: 4.5
							}
						]
					}
				},{
					audio: {
						states: [
							{
								name: "intro",
								startTime: 131,
								duration: 3.5
							}, {
								name: "payoff",
								startTime: 135,
								duration: 4.5
							}
						]
					}
				},{
					audio: {
						states: [
							{
								name: "intro",
								startTime: 141,
								duration: 3.5
							}, {
								name: "payoff",
								startTime: 145,
								duration: 4.5
							}
						]
					}
				},{
					audio: {
						states: [
							{
								name: "intro",
								startTime: 151,
								duration: 3.5
							}, {
								name: "payoff",
								startTime: 155,
								duration: 4.5
							}
						]
					}
				},{
					audio: {
						states: [
							{
								name: "intro",
								startTime: 161,
								duration: 3.5
							}, {
								name: "payoff",
								startTime: 165,
								duration: 4.5
							}
						]
					}
				},{
					audio: {
						states: [
							{
								name: "intro",
								startTime: 171,
								duration: 3.5
							}, {
								name: "payoff",
								startTime: 175,
								duration: 4.5
							}
						]
					}
				},{
					audio: {
						states: [
							{
								name: "intro",
								startTime: 181,
								duration: 3.5
							}, {
								name: "payoff",
								startTime: 185,
								duration: 4.5
							}
						]
					}
				},{
					audio: {
						states: [
							{
								name: "intro",
								startTime: 191,
								duration: 3.5
							}, {
								name: "payoff",
								startTime: 195,
								duration: 4.5
							}
						]
					}
				}
			]*/
	]
};