angular.module("numbertap.services",[]).factory("SuspendHandler",function(){var _gameResumeCallback,_gamePauseCallback;function bindSuspensionEvents(){document.addEventListener("pause",onPause.bind(this),false);document.addEventListener("resume",onResume.bind(this),false)}window.HandleDeviceReady(bindSuspensionEvents);function onPause(){if(_gamePauseCallback){_gamePauseCallback()}}function onResume(){if(_gameResumeCallback){_gameResumeCallback()}}function _onGamePause(callback){_gamePauseCallback=callback}function _onGameResume(callback){_gameResumeCallback=callback}return{onGamePause:_onGamePause,onGameResume:_onGameResume}}).factory("BadgeNotify",function(){function _displayBadges(badges){if(!badges)return;var badgeContainer=document.getElementById("badgeContainer");if(!badgeContainer)return;for(var i=0;i<badges.length;i++){var badgeDiv=document.createElement("div");var badgeH1=document.createElement("h1");var badgeH2=document.createElement("h2");badgeDiv.className="badgetoast toastinout";badgeH1.innerText="Badge unlocked!";badgeH2.innerText=badges[i].BadgeName;badgeDiv.appendChild(badgeH1);badgeDiv.appendChild(badgeH2);badgeContainer.appendChild(badgeDiv)}setTimeout(function(){while(badgeContainer.firstChild)badgeContainer.removeChild(badgeContainer.firstChild)},6e3)}return{displayBadges:_displayBadges}}).factory("GameServer",function($http,NUMBERTAP_API_URL){var _appVersion="0.0";window.HandleDeviceReady(versionCheck);function versionCheck(){if(window.plugins&&window.plugins.version){window.plugins.version.getVersionName(function(version_name){_appVersion=version_name})}}function getUniqueId(){if(window.device){return window.device.uuid}return"TESTING"}function getGameId(){return 1}function getLoginModel(){return{ID:getUniqueId(),GameID:getGameId(),PlatformID:window.NUMBERTAP_PLATFORM}}function getUniqueParam(){var unique=(new Date).getTime();return"unique="+unique}function _login(onSuccess,onError){return $http.get(NUMBERTAP_API_URL+"v2/login?id="+getUniqueId()+"&GameID=1&PlatformId="+window.NUMBERTAP_PLATFORM+"&CurrentVersion="+_appVersion+"&"+getUniqueParam()).success(onSuccess).error(onError)}function _getRound(onSuccess,onError){return $http.get(NUMBERTAP_API_URL+"v2/getround?id="+getUniqueId()+"&PlatformId="+window.NUMBERTAP_PLATFORM+"&"+getUniqueParam()).success(onSuccess).error(onError)}function _linkCode(onSuccess,onError){return $http.post(NUMBERTAP_API_URL+"v2/linkcode",getLoginModel()).success(onSuccess).error(onError)}function _playerStats(onSuccess,onError){return $http.post(NUMBERTAP_API_URL+"v2/playerstats",getLoginModel()).success(onSuccess).error(onError)}function _gameStats(onSuccess,onError){return $http.post(NUMBERTAP_API_URL+"v2/gamestats",getLoginModel()).success(onSuccess).error(onError)}function _leaderboards(onSuccess,onError){return $http.post(NUMBERTAP_API_URL+"v2/leaderboards",getLoginModel()).success(onSuccess).error(onError)}function _changeName(username,onSuccess,onError){var data=getLoginModel();data.Username=username;return $http.post(NUMBERTAP_API_URL+"v2/changename",data).success(onSuccess).error(onError)}function _linkPlayer(linkCode,onSuccess,onError){var data=getLoginModel();data.LinkCode=linkCode;return $http.post(NUMBERTAP_API_URL+"v2/linkplayer",data).success(onSuccess).error(onError)}function _setGeo(geo,onSuccess,onError){var data=getLoginModel();data.Geo=geo;return $http.post(NUMBERTAP_API_URL+"v2/setgeo",data).success(onSuccess).error(onError)}function _uploadScore(roundId,score,questionsAnswered,correctAnswers,wrongAnswers,averageAnswerTime,questionResults,longestStreak,onSuccess,onError){var requestJson={RoundId:roundId,LiveId:getUniqueId(),GameId:getGameId(),PlatformId:window.NUMBERTAP_PLATFORM,Score:score,QuestionsAnswered:questionsAnswered,CorrectAnswers:correctAnswers,WrongAnswers:wrongAnswers,AverageAnswerTime:averageAnswerTime,QuestionResults:questionResults,LongestStreak:longestStreak,CategoryScores:[]};var data=getLoginModel();return $http.post(NUMBERTAP_API_URL+"v2/uploadscore",requestJson).success(onSuccess).error(onError)}return{login:_login,getRound:_getRound,uploadScore:_uploadScore,linkCode:_linkCode,changeName:_changeName,linkPlayer:_linkPlayer,setGeo:_setGeo,gameStats:_gameStats,playerStats:_playerStats,leaderboards:_leaderboards}});angular.module("numbertap.controller.home",[]).controller("HomeCtrl",function($scope,$rootScope,GameServer,BadgeNotify){window.HandleDeviceReady(loadHome);function loadHome(){if(!$scope.IsLoading){$scope.IsLoading=true;GameServer.login(function(response){$scope.Login=response;if(response.PlayerCreated){}if(response.Player){$rootScope.Player=response.Player}if(response.IsUpdateAvailable){$scope.IsUpdateAvailable=response.IsUpdateAvailable;$scope.LatestVersion=response.LatestVersion}if(response.Badges){BadgeNotify.displayBadges(response.Badges)}$scope.IsLoading=false},function(){$scope.IsOffline=true})}}$scope.Retry=function(){$scope.IsOffline=false;$scope.IsLoading=false;loadHome()}});angular.module("numbertap.controller.game",[]).controller("GameCtrl",function($scope,GameServer,SuspendHandler,BadgeNotify){var STATE_GAME=0,STATE_UPLOAD=1,STATE_LEADERBOARD=2;var TIMER_UPLOADTIME=15,TIMER_LEADERBOARDTIME=20;var _secondsToStart=0,_secondsLeft=0;var _countdownInterval,_gameInterval,_streakInterval;var _gameStopped=false;var _baseQuestionPoints=3;var _isRunning=false;var _currentStreak=0,_longestStreak=0;var _currentQuestionIndex=0;var _roundId;var _results=[];var _timeBonus=0;var _bestMultiplier=0;var _multiplier_1_cutoff=3;var _multiplier_1_amount=2;var _multiplier_2_cutoff=7;var _multiplier_2_amount=3;var _multiplier_3_cutoff=10;var _multiplier_3_amount=4;var _multiplier_4_cutoff=15;var _multiplier_4_amount=5;var _isAnswering=false;var __gameCount=0;$scope.TimeLeft=0;$scope.Nextroundtime=0;$scope.Score=0;$scope.QuestionsAnswered=0;$scope.Multiplier=1;$scope.State_Game=false;$scope.State_Upload=false;$scope.State_Leaderboard=true;$scope.FinishedEarly=false;$scope.MultiplierPercent=0;function game_Load(){GameServer.getRound(function(roundresponse){if(roundresponse.Badges){BadgeNotify.displayBadges(roundresponse.Badges)}if(roundresponse.Round.SecondsUntilStart>0){game_SetState(STATE_LEADERBOARD);_secondsToStart=roundresponse.Round.SecondsUntilStart;clearInterval(_countdownInterval);_countdownInterval=setInterval(game_CountdownTimer,1e3);game_LoadLeaderboard(roundresponse.LeaderBoard)}else{game_LoadRound(roundresponse.Round);clearInterval(_gameInterval);_gameInterval=setInterval(game_Timer,1e3);game_LoadLeaderboard([])}},function(){$scope.IsOffline=true})}$scope.Retry=function(){$scope.IsOffline=false;game_Load()};function game_ResetRound(){_results=[];$scope.Questions=[];$scope.Score=0;$scope.Multiplier=1;$scope.QuestionsAnswered=0;$scope.PreviousQuestion=null;$scope.PreviousAnswer=null;$scope.MultiplierPercent=0;$scope.FinishedEarly=false;$scope.AnimateTimer=false;_currentStreak=0;_longestStreak=0;_bestMultiplier=0;_gameStopped=false;_isAnswering=false}function game_Timer(){if(_gameStopped)return;_secondsLeft--;if(_secondsLeft<=0){clearInterval(_gameInterval);game_End();return}if(_secondsLeft<=15){$scope.AnimateTimer=true}if(_secondsLeft>=60){var tempseconds=(_secondsLeft-60).toString();if(tempseconds.length==1){tempseconds="0"+tempseconds}$scope.$apply(function(){$scope.TimeLeft="1:"+tempseconds})}else{$scope.$apply(function(){$scope.TimeLeft=_secondsLeft})}}function game_CountdownTimer(){_secondsToStart--;if(_secondsToStart<=0){clearInterval(_countdownInterval);game_Load()}if($scope.State_Upload){var newSecondsToGo=_secondsLeft+_secondsToStart+TIMER_LEADERBOARDTIME;$scope.$apply(function(){$scope.Nextroundtime=newSecondsToGo})}else{$scope.$apply(function(){$scope.Nextroundtime=_secondsToStart})}}function game_End(){_gameStopped=true;game_ClearQuestionAnimation();__gameCount++;var questionsAnswered=_results.length;var averageAnswerTime=0;var correctAnswers=0;var wrongAnswers=0;for(var i=0;i<_results.length;i++){if(_results[i].IsCorrect){correctAnswers++}else{wrongAnswers++}}var thisScore=$scope.Score+_timeBonus;$scope.LastScore=thisScore;$scope.LastCorrect=correctAnswers;$scope.LastQuestionsAnswered=_results.length;$scope.LastLongestStreak=_longestStreak;$scope.LastBestMultiplier=_bestMultiplier;game_SetState(STATE_UPLOAD);GameServer.uploadScore(_roundId,thisScore,questionsAnswered,correctAnswers,wrongAnswers,averageAnswerTime,_results,_longestStreak,function(response){if(response.Badges){BadgeNotify.displayBadges(response.Badges)}game_ResetRound();clearInterval(_gameInterval);clearInterval(_countdownInterval);clearInterval(_streakInterval);_secondsToStart=TIMER_UPLOADTIME;clearInterval(_countdownInterval);_countdownInterval=setInterval(game_CountdownTimer,1e3)},function(){$scope.IsOffline=true})}function game_LoadRound(round){game_SetState(STATE_GAME);_roundId=round.RoundID;_secondsLeft=120+round.SecondsUntilStart;$scope.Questions=[];for(var i=0;i<round.Questions.length;i++){$scope.Questions.push(round.Questions[i])}game_SetCurrentQuestion(0)}function game_SetCurrentQuestion(index,previousCorrect,previousAnswer){_currentQuestionIndex=index;var question=$scope.Questions[index];var nextQuestion=$scope.Questions[index+1];$scope.CurrentQuestion=question;if(previousCorrect!=null){var previousQuestion=$scope.Questions[index-1];game_ClearQuestionAnimation();setTimeout(function(){if(previousCorrect){document.getElementById("question-wrap").classList.add("correct")}else{document.getElementById("question-wrap").classList.add("incorrect")}},50);if(previousQuestion){$scope.PreviousQuestion=previousQuestion;$scope.PreviousQuestion.IsCorrect=previousCorrect;$scope.PreviousQuestion.IsIncorrect=!previousCorrect;$scope.PreviousQuestion.Answered=previousAnswer}else{$scope.PreviousQuestion=null}}if(nextQuestion){$scope.NextQuestion=nextQuestion}else{$scope.NextQuestion=null}_isAnswering=false}function game_ClearQuestionAnimation(){document.getElementById("question-wrap").classList.remove("correct");document.getElementById("question-wrap").classList.remove("incorrect")}function game_LoadLeaderboard(leaderboard){$scope.Leaderboard=leaderboard}function game_SetState(gameState){$scope.State_Game=gameState==STATE_GAME;$scope.State_Upload=gameState==STATE_UPLOAD;$scope.State_Leaderboard=gameState==STATE_LEADERBOARD}function game_RecordResult(question,answer,isBonus){if(_gameStopped)return;if(_currentStreak>_longestStreak){_longestStreak=_currentStreak}var isCorrect=question.Answer==answer;if(isCorrect){_currentStreak++;game_CalculateMultiplier();$scope.Score+=_baseQuestionPoints*$scope.Multiplier*(isBonus?2:1)}else{_currentStreak=0;game_CalculateMultiplier()}_results.push({QuestionID:question.QuestionID,IsCorrect:isCorrect,IsBonus:isBonus});if(_currentQuestionIndex+1<100){game_SetCurrentQuestion(_currentQuestionIndex+1,isCorrect,answer);$scope.QuestionsAnswered++;clearInterval(_streakInterval);_streakInterval=setInterval(game_StreakTimer,2e3)}else{game_SetCurrentQuestion(_currentQuestionIndex+1,isCorrect,answer);$scope.QuestionsAnswered++;game_EndEarly()}_isAnswering=false}function game_EndEarly(){if(_secondsLeft>0){var correctAnswers=0;var wrongAnswers=0;for(var i=0;i<_results.length;i++){if(_results[i].IsCorrect){correctAnswers++}else{wrongAnswers++}}if(correctAnswers>50){_timeBonus=parseInt(_secondsLeft*2*(correctAnswers/100))}else{_timeBonus=0}if(_timeBonus){$scope.TimeBonus=_timeBonus}$scope.FinishedEarly=true}else{_timeBonus=0}}function game_CalculateMultiplier(){if(_currentStreak>_multiplier_4_cutoff){$scope.Multiplier=_multiplier_4_amount}else if(_currentStreak>_multiplier_3_cutoff){$scope.Multiplier=_multiplier_3_amount}else if(_currentStreak>_multiplier_2_cutoff){$scope.Multiplier=_multiplier_2_amount}else if(_currentStreak>_multiplier_1_cutoff){$scope.Multiplier=_multiplier_1_amount}else{$scope.Multiplier=1}$scope.MultiplierPercent=_currentStreak/_multiplier_4_cutoff*100;if($scope.Multiplier>_bestMultiplier){_bestMultiplier=$scope.Multiplier}}function game_StreakTimer(){if(_gameStopped)return;if(_currentStreak>0){_currentStreak--;game_CalculateMultiplier()}}SuspendHandler.onGamePause(function(){});SuspendHandler.onGameResume(function(){game_ResetRound();clearInterval(_gameInterval);clearInterval(_countdownInterval);clearInterval(_streakInterval);game_Load()});if(!_isRunning){_isRunning=true;window.HandleDeviceReady(game_Load)}$scope.Answer1Click=function(event){if(_gameStopped)return;if(_secondsLeft<=0)return;if(_isAnswering)return;_isAnswering=true;var question=$scope.CurrentQuestion;game_RecordResult(question,question.AllAnswers[0],question.IsBonus)};$scope.Answer2Click=function(event){if(_gameStopped)return;if(_secondsLeft<=0)return;_isAnswering=true;var question=$scope.CurrentQuestion;game_RecordResult(question,question.AllAnswers[1],question.IsBonus)};$scope.Answer3Click=function(event){if(_gameStopped)return;if(_secondsLeft<=0)return;if(_isAnswering)return;_isAnswering=true;var question=$scope.CurrentQuestion;game_RecordResult(question,question.AllAnswers[2],question.IsBonus)};$scope.Answer4Click=function(event){if(_gameStopped)return;if(_secondsLeft<=0)return;if(_isAnswering)return;_isAnswering=true;var question=$scope.CurrentQuestion;game_RecordResult(question,question.AllAnswers[3],question.IsBonus)};$scope.BackClick=function(){history.go(-1)}});angular.module("numbertap.controller.stats",[]).controller("StatsCtrl",function($scope,$rootScope,GameServer){var _active="active";var _inactive="normal";$scope.StatsButton=_active;$scope.BadgesButton=_inactive;$scope.Stats=true;$scope.Badges=false;window.HandleDeviceReady(statsLoad);function statsLoad(){if(!$scope.IsLoading){$scope.IsLoading=true;GameServer.playerStats(function(response){if(response){$scope.PlayerStats=response.PlayerStats;$scope.PlayerBadges=response.Badges;$scope.IsLoading=false}})}}$scope.BackClick=function(){history.go(-1)};$scope.StatsClick=function(){$scope.StatsButton=_active;$scope.BadgesButton=_inactive;$scope.Stats=true;$scope.Badges=false};$scope.BadgesClick=function(){$scope.StatsButton=_inactive;$scope.BadgesButton=_active;$scope.Stats=false;$scope.Badges=true}});angular.module("numbertap.controller.settings",[]).controller("SettingsCtrl",function($scope,$rootScope,GameServer){var _active="active";var _inactive="normal";$scope.ProfileButton=_active;$scope.LinkButton=_inactive;$scope.AboutButton=_inactive;$scope.Profile=true;$scope.Link=false;$scope.About=false;window.HandleDeviceReady(settingsLoad);function settingsLoad(){if(!$scope.IsLoading){$scope.IsLoading=true;$scope.Settings={EnteredLinkCode:""};if(window.plugins&&window.plugins.version){window.plugins.version.getVersionName(function(version_name){$scope.AppVersion=version_name})}if($rootScope.Player){$scope.Player=$rootScope.Player;$scope.IsLoading=false}else{GameServer.login(function(response){if(response.Player){$rootScope.Player=response.Player;$scope.Player=response.Player}$scope.IsLoading=false})}GameServer.linkCode(function(response){if(response&&response.Success){$scope.LinkCode=response.LinkCode;$scope.HasLinkCode=true}else{$scope.HasLinkCode=false}})}}$scope.BackClick=function(){history.go(-1)};$scope.ProfileClick=function(){$scope.ProfileButton=_active;$scope.LinkButton=_inactive;$scope.AboutButton=_inactive;$scope.Profile=true;$scope.Link=false;$scope.About=false};$scope.LinkClick=function(){$scope.ProfileButton=_inactive;$scope.LinkButton=_active;$scope.AboutButton=_inactive;$scope.Profile=false;$scope.Link=true;$scope.About=false};$scope.AboutClick=function(){$scope.ProfileButton=_inactive;$scope.LinkButton=_inactive;$scope.AboutButton=_active;$scope.Profile=false;$scope.Link=false;$scope.About=true};$scope.ChangeName=function(){if($scope.IsLoading)return;$scope.ProfileError=null;$scope.ProfileSuccess=null;if(!$scope.Player.Username){$scope.ProfileError="Please enter a player name.";return}$scope.IsLoading=true;GameServer.changeName($scope.Player.Username,function(response){$scope.IsLoading=false;if(!response){$scope.ProfileError="Unable to connect to server.";return}if(response&&response.Success){$scope.ProfileSuccess="Player name updated.";$rootScope.Player.Username=$scope.Player.Username}else{$scope.ProfileError=response.Message}})};$scope.SetGeo=function(){if($scope.IsLoading)return;$scope.ProfileError=null;$scope.ProfileSuccess=null;if(!$scope.Player.Geo){$scope.ProfileError="Please enter a location.";return}$scope.IsLoading=true;GameServer.setGeo($scope.Player.Geo,function(response){$scope.IsLoading=false;if(!response){$scope.ProfileError="Unable to connect to server.";return}if(response){$scope.ProfileSuccess="Player location updated.";$rootScope.Player.Geo=$scope.Player.Geo}})};$scope.DoLink=function(){if($scope.IsLoading)return;$scope.LinkError=null;$scope.LinkSuccess=null;if(!$scope.Settings.EnteredLinkCode){$scope.LinkError="Please enter a code to link players.";return}$scope.IsLoading=true;GameServer.linkPlayer($scope.Settings.EnteredLinkCode,function(response){$scope.IsLoading=false;if(!response){$scope.LinkError="Unable to connect to server.";return}if(response&&response.Success){$scope.LinkSuccess="Player linked successfully.";if(response.Player){$rootScope.Player=response.Player;$scope.Player=response.Player}}else{$scope.LinkError=response.Message}})}});angular.module("numbertap.controller.leaders",[]).controller("LeadersCtrl",function($scope,$rootScope,GameServer,$ionicScrollDelegate){var _active="active";var _inactive="normal";$scope.DailyButton=_active;$scope.WeeklyButton=_inactive;$scope.BestButton=_inactive;$scope.Daily=true;$scope.Weekly=false;$scope.Best=false;window.HandleDeviceReady(leadersLoad);function leadersLoad(){if(!$scope.IsLoading){$scope.IsLoading=true;GameServer.leaderboards(function(response){if(response){$scope.DailyTop100=response.DailyTop100;$scope.WeeklyTop100=response.WeeklyTop100;$scope.OverallTop100=response.OverallTop100;$scope.IsLoading=false}})}}$scope.BackClick=function(){history.go(-1)};$scope.DailyClick=function(){$scope.DailyButton=_active;$scope.WeeklyButton=_inactive;$scope.BestButton=_inactive;$scope.Daily=true;$scope.Weekly=false;$scope.Best=false;$ionicScrollDelegate.scrollTop()};$scope.WeeklyClick=function(){$scope.DailyButton=_inactive;$scope.WeeklyButton=_active;$scope.BestButton=_inactive;$scope.Daily=false;$scope.Weekly=true;$scope.Best=false;$ionicScrollDelegate.scrollTop()};$scope.BestClick=function(){$scope.DailyButton=_inactive;$scope.WeeklyButton=_inactive;$scope.BestButton=_active;$scope.Daily=false;$scope.Weekly=false;$scope.Best=true;$ionicScrollDelegate.scrollTop()}});angular.module("numbertap",["ionic","numbertap.controller.home","numbertap.controller.game","numbertap.controller.stats","numbertap.controller.settings","numbertap.controller.leaders","numbertap.services"]).constant("NUMBERTAP_API_URL","http://numbertap.com/").filter("int",function(){return function(v){return parseInt(v)||""}}).config(function($compileProvider){$compileProvider.aHrefSanitizationWhitelist(/^\s*(https?|ftp|mailto|file|ghttps?|ms-appx|x-wmapp0):/)}).config(function($stateProvider,$urlRouterProvider){$stateProvider.state("home",{url:"/home",templateUrl:"views/home.html",controller:"HomeCtrl"});$stateProvider.state("game",{url:"/game",templateUrl:"views/game.html",controller:"GameCtrl"});$stateProvider.state("stats",{url:"/stats",templateUrl:"views/stats.html",controller:"StatsCtrl"});$stateProvider.state("leaderboards",{url:"/leaderboards",templateUrl:"views/leaderboards.html",controller:"LeadersCtrl"});$stateProvider.state("settings",{url:"/settings",templateUrl:"views/settings.html",controller:"SettingsCtrl"});$urlRouterProvider.otherwise("/home")});