window.plugins = window.plugins || {};
window.device = window.device || {};

var guid = (function () {
    function s4() {
        return Math.floor((1 + Math.random()) * 0x10000)
                   .toString(16)
                   .substring(1);
    }
    return function () {
        return s4() + s4() + '-' + s4() + '-' + s4() + '-' +
               s4() + '-' + s4() + s4() + s4();
    };
})();


var _app = null;


var request = window.navigator.mozApps.getSelf();
request.onsuccess = function () {
    if (request.result) {
        // Pull the name of the app out of the App object
        _app = request.result;
    }
};


window.plugins.version = {
    getVersionName: function (callback) {
        if (_app && _app.manifest) {
            callback(_app.manifest.version);
        }
        else {
            callback("1.0");
        }
    }
};

function setUuid(rawUuid) {
    if (rawUuid) {
        window.device.uuid = rawUuid;
        return;
    }

    var uuid = guid();
    window.device.uuid = uuid;
    localforage.setItem('uuid', uuid);
};

if (!window.device.uuid) {
    localforage.getItem('uuid', setUuid);
}

window.NUMBERTAP_PLATFORM = 5; //FIREFOX OS

