// Generated by CoffeeScript 1.7.1
var Element;

Element = (function() {
  function Element() {
    this.next = null;
  }

  Element.prototype.getHTML = function() {
    return $("<span class=\'basic\'></span>");
  };

  Element.prototype.getPrevious = function() {
    return this.previous;
  };

  Element.prototype.setPrevious = function(previous) {
    this.previous = previous;
  };

  Element.prototype.getNext = function() {
    return this.next;
  };

  Element.prototype.setNext = function(next) {
    this.next = next;
  };

  Element.prototype.getValue = function() {
    return null;
  };

  Element.prototype.setNextResult = function(nextResult) {
    this.nextResult = nextResult;
  };

  Element.prototype.setPreviousResult = function(previousResult) {
    this.previousResult = previousResult;
  };

  Element.prototype.getNextResult = function() {
    return this.nextResult;
  };

  Element.prototype.getPreviousResult = function() {
    return this.previousResult;
  };

  return Element;

})();
// Generated by CoffeeScript 1.7.1
var Init,
  __hasProp = {}.hasOwnProperty,
  __extends = function(child, parent) { for (var key in parent) { if (__hasProp.call(parent, key)) child[key] = parent[key]; } function ctor() { this.constructor = child; } ctor.prototype = parent.prototype; child.prototype = new ctor(); child.__super__ = parent.prototype; return child; };

Init = (function(_super) {
  __extends(Init, _super);

  function Init() {
    Init.__super__.constructor.call(this, 'init', null);
  }

  Init.prototype.getHTML = function() {
    return null;
  };

  return Init;

})(Element);
// Generated by CoffeeScript 1.7.1
var Function,
  __hasProp = {}.hasOwnProperty,
  __extends = function(child, parent) { for (var key in parent) { if (__hasProp.call(parent, key)) child[key] = parent[key]; } function ctor() { this.constructor = child; } ctor.prototype = parent.prototype; child.prototype = new ctor(); child.__super__ = parent.prototype; return child; };

Function = (function(_super) {
  __extends(Function, _super);

  function Function(type) {
    this.type = type;
    Function.__super__.constructor.apply(this, arguments);
    if (!window.HTML_FUNCTIONS.hasOwnProperty(this.type)) {
      throw 'Operand (constructor): wrong type of operand';
    }
  }

  Function.prototype.getHTML = function() {
    var inv;
    inv = '';
    if (this.type.substr(3) === 'INV') {
      inv = '<span class="top">-1</span>';
    }
    return Function.__super__.getHTML.apply(this, arguments).addClass('func').html(window.HTML_FUNCTIONS[this.type.substr(0, 3)] + inv);
  };

  Function.prototype.getValue = function() {
    return this.type;
  };

  return Function;

})(Element);
// Generated by CoffeeScript 1.7.1
var Operand,
  __hasProp = {}.hasOwnProperty,
  __extends = function(child, parent) { for (var key in parent) { if (__hasProp.call(parent, key)) child[key] = parent[key]; } function ctor() { this.constructor = child; } ctor.prototype = parent.prototype; child.prototype = new ctor(); child.__super__ = parent.prototype; return child; };

Operand = (function(_super) {
  __extends(Operand, _super);

  function Operand(type) {
    this.type = type;
    Operand.__super__.constructor.apply(this, arguments);
    if (!window.HTML.hasOwnProperty(this.type)) {
      throw "Operand (constructor): wrong type of operand (" + this.type + ")";
    }
  }

  Operand.prototype.getHTML = function() {
    return Operand.__super__.getHTML.apply(this, arguments).html(window.HTML[this.type]);
  };

  Operand.prototype.getValue = function() {
    return this.type;
  };

  return Operand;

})(Element);
// Generated by CoffeeScript 1.7.1
var Variable,
  __hasProp = {}.hasOwnProperty,
  __extends = function(child, parent) { for (var key in parent) { if (__hasProp.call(parent, key)) child[key] = parent[key]; } function ctor() { this.constructor = child; } ctor.prototype = parent.prototype; child.prototype = new ctor(); child.__super__ = parent.prototype; return child; };

Variable = (function(_super) {
  __extends(Variable, _super);

  function Variable(name, formula) {
    this.name = name;
    this.formula = formula;
    Variable.__super__.constructor.apply(this, arguments);
  }

  Variable.prototype.getHTML = function() {
    return Variable.__super__.getHTML.apply(this, arguments).html(this.name);
  };

  Variable.prototype.getValue = function() {};

  return Variable;

})(Element);
// Generated by CoffeeScript 1.7.1
var Constant,
  __hasProp = {}.hasOwnProperty,
  __extends = function(child, parent) { for (var key in parent) { if (__hasProp.call(parent, key)) child[key] = parent[key]; } function ctor() { this.constructor = child; } ctor.prototype = parent.prototype; child.prototype = new ctor(); child.__super__ = parent.prototype; return child; };

Constant = (function(_super) {
  __extends(Constant, _super);

  function Constant(name, value) {
    this.name = name;
    this.value = value;
    Constant.__super__.constructor.apply(this, arguments);
  }

  Constant.prototype.getHTML = function() {
    if (this.name === 'PI') {
      return Constant.__super__.getHTML.apply(this, arguments).html('&Pi;');
    } else if (this.name === 'e') {
      return Constant.__super__.getHTML.apply(this, arguments).html('e');
    }
  };

  Constant.prototype.getValue = function() {
    if (this.name === 'PI') {
      return window.PI;
    } else if (this.name === 'e') {
      return window.e;
    }
  };

  return Constant;

})(Variable);
// Generated by CoffeeScript 1.7.1
var NumberObj,
  __hasProp = {}.hasOwnProperty,
  __extends = function(child, parent) { for (var key in parent) { if (__hasProp.call(parent, key)) child[key] = parent[key]; } function ctor() { this.constructor = child; } ctor.prototype = parent.prototype; child.prototype = new ctor(); child.__super__ = parent.prototype; return child; };

NumberObj = (function(_super) {
  __extends(NumberObj, _super);

  function NumberObj(n) {
    var _ref;
    this.n = n;
    if (!((0 <= (_ref = this.n) && _ref <= 9) || this.n === 'FLOATPOINT')) {
      throw 'number(3): Not number passed to the Number class constructor (' + this.n + ')';
    }
    NumberObj.__super__.constructor.apply(this, arguments);
  }

  NumberObj.prototype.getHTML = function() {
    return NumberObj.__super__.getHTML.apply(this, arguments).html(this.n !== 'FLOATPOINT' ? this.n : ',');
  };

  NumberObj.prototype.getValue = function() {
    return this.n;
  };

  return NumberObj;

})(Element);
// Generated by CoffeeScript 1.7.1
var Block,
  __hasProp = {}.hasOwnProperty,
  __extends = function(child, parent) { for (var key in parent) { if (__hasProp.call(parent, key)) child[key] = parent[key]; } function ctor() { this.constructor = child; } ctor.prototype = parent.prototype; child.prototype = new ctor(); child.__super__ = parent.prototype; return child; };

Block = (function(_super) {
  __extends(Block, _super);

  function Block(display, formula) {
    this.display = display != null ? display : 'basic';
    this.formula = formula;
    Block.__super__.constructor.apply(this, arguments);
  }

  Block.prototype.getHTML = function() {
    return Block.__super__.getHTML.apply(this, arguments).removeClass('basic').addClass(this.display).html(this.formula.display());
  };

  Block.prototype.getValue = function() {
    var value;
    value = this.formula.solve();
    return value;
  };

  Block.prototype.getFormula = function() {
    return this.formula;
  };

  Block.prototype.setFormula = function(formula) {
    this.formula = formula;
  };

  return Block;

})(Element);
// Generated by CoffeeScript 1.7.1
var Brackets,
  __hasProp = {}.hasOwnProperty,
  __extends = function(child, parent) { for (var key in parent) { if (__hasProp.call(parent, key)) child[key] = parent[key]; } function ctor() { this.constructor = child; } ctor.prototype = parent.prototype; child.prototype = new ctor(); child.__super__ = parent.prototype; return child; };

Brackets = (function(_super) {
  __extends(Brackets, _super);

  function Brackets(display, formula) {
    this.display = display != null ? display : 'basic';
    this.formula = formula;
    Brackets.__super__.constructor.apply(this, arguments);
  }

  Brackets.prototype.getHTML = function() {
    return $("<span type=\'" + this.display + "\'>(</span>").add(Brackets.__super__.getHTML.apply(this, arguments).addClass('brackets')).add("<span type=\'" + this.display + "\'>)</span>");
  };

  return Brackets;

})(Block);
// Generated by CoffeeScript 1.7.1
var Root,
  __hasProp = {}.hasOwnProperty,
  __extends = function(child, parent) { for (var key in parent) { if (__hasProp.call(parent, key)) child[key] = parent[key]; } function ctor() { this.constructor = child; } ctor.prototype = parent.prototype; child.prototype = new ctor(); child.__super__ = parent.prototype; return child; };

Root = (function(_super) {
  __extends(Root, _super);

  function Root(exp, formula) {
    this.exp = exp;
    this.formula = formula;
    Root.__super__.constructor.apply(this, arguments);
  }

  Root.prototype.getValue = function() {
    return Math.pow(this.formula.solve(), 1 / this.exp.solve());
  };

  Root.prototype.getHTML = function() {
    return $("<span class=\'root_exp\'></span>").html(this.exp.display()).add($("<span class=\'root\'></span>").html(this.formula.display()));
  };

  return Root;

})(Block);
// Generated by CoffeeScript 1.7.1
var Cursor,
  __slice = [].slice;

Cursor = (function() {
  function Cursor(formula) {
    this.formula = formula;
    this.position = this.formula;
  }

  Cursor.prototype.canHigher = function() {
    return !!this.position.parent;
  };

  Cursor.prototype.getHigher = function() {
    if (this.position.parent) {
      this.position = this.position.parent;
    }
    return !!this.position.parent;
  };

  Cursor.prototype["new"] = function(el, formula) {
    var b, br;
    this.position["new"](el);
    if (el instanceof Root) {
      el.formula.setParent(this.position);
      el.exp.setParent(el.formula);
      return this.position = el.exp;
    } else if (el instanceof Block) {
      el.getFormula().setParent(this.position);
      return this.position = el.getFormula();
    } else if (el instanceof Function && el.type === 'LOG') {
      br = new Brackets('basic', new Formula());
      b = new Block('bottom', formula);
      this.position["new"](b);
      this.position["new"](br);
      b.getFormula().setParent(br.getFormula());
      br.getFormula().setParent(this.position);
      console.log(this.position);
      return this.position = b.getFormula();
    }
  };

  Cursor.prototype.newAtStart = function(el) {
    return this.position.newAtStart(el);
  };

  Cursor.prototype.newFormula = function() {
    this.formula = new Formula();
    return this.position = this.formula;
  };

  Cursor.prototype.display = function() {
    return this.formula.display();
  };

  Cursor.prototype.solve = function() {
    return this.formula.solve();
  };

  Cursor.prototype.newBrackets = function(f) {
    var b;
    b = new Brackets('basic', f);
    return this["new"](b);
  };

  Cursor.prototype.formulaInBlock = function() {
    var beginning, block, x, _i, _len;
    block = arguments[0], beginning = 2 <= arguments.length ? __slice.call(arguments, 1) : [];
    block.setFormula(this.formula);
    this.newFormula();
    block.getFormula().setParent(this.formula);
    for (_i = 0, _len = beginning.length; _i < _len; _i++) {
      x = beginning[_i];
      this["new"](x);
    }
    this["new"](block);
    return this.position = block.getFormula();
  };

  Cursor.prototype.pop = function() {
    if (this.position.tail instanceof Block && !this.position.tail.getFormula().isEmpty()) {
      this.position = this.position.tail.getFormula();
      console.log(this.position);
      return this.pop();
    } else if (this.position.tail !== this.position.head) {
      return this.position.removeLast();
    } else if (this.position !== this.formula) {
      this.position = this.position.parent;
      return this.pop();
    }
  };

  return Cursor;

})();
// Generated by CoffeeScript 1.7.1
var Formula;

Formula = (function() {
  function Formula(parent) {
    this.parent = parent != null ? parent : null;
    this.head = new Init();
    this.tail = this.head;
  }

  Formula.prototype.setParent = function(parent) {
    this.parent = parent;
  };

  Formula.prototype.getParent = function() {
    return this.parent;
  };

  Formula.prototype["new"] = function(el, after) {
    var _ref;
    if (!after) {
      this.tail.setNext(el);
      el.setPrevious(this.tail);
      return this.tail = el;
    } else {
      if ((_ref = after.getNext()) != null) {
        _ref.setPrevious(el);
      }
      el.setNext(after.getNext());
      after.setNext(el);
      return el.setPrevious(after);
    }
  };

  Formula.prototype.newBefore = function(el, before) {
    if (!before) {
      this.head.setPrevious(el);
      el.setNext(this.head);
      return this.head = el;
    } else {
      before.getPrevious().setNext(el);
      el.setPrevious(before.getPrevious());
      before.setPrevious(el);
      return el.setNext(before);
    }
  };

  Formula.prototype.newAtStart = function(el) {
    return this["new"](el, this.head);
  };

  Formula.prototype.swap = function(el1, el2) {
    if (el1.getNext() === el2) {
      el1.setNext(el2.getNext());
      el1.setPrevious(el2);
      el2.setNext(el1);
      return el2.setPrevious(el1.getPrevios());
    } else {
      throw 'Formula(swap): wrong elements given';
    }
  };

  Formula.prototype.remove = function(el) {
    if (this.head === el) {
      this.head.getNext().setPrevious(null);
      return this.head = this.head.getNext();
    } else if (this.tail === el) {
      this.tail.getPrevious().setNext(null);
      return this.tail = this.tail.getPrevious();
    } else {
      el.getPrevious().setNext(el.getNext());
      return el.getNext().setPrevious(el.getPrevious());
    }
  };

  Formula.prototype.removeLast = function() {
    if (this.tail) {
      return this.remove(this.tail);
    }
  };

  Formula.prototype.solve = function() {
    var cur, res, t, tail, tmp, _ref, _ref1, _ref2, _ref3, _ref4;
    if (this.head === this.tail) {
      return 0;
    } else {
      cur = this.head;
      while (true) {
        if (cur instanceof NumberObj || (cur instanceof Operand && cur.getValue() === 'MINUS' && cur.getNext() instanceof NumberObj && !this.isNumber(cur.getPrevious()) && cur.getPrevious().type !== 'FACT')) {
          _ref = this.getNumber(cur), tmp = _ref['cur'], res = _ref['res'];
          console.log(res);
          res = new Result(res, cur.getPrevious(), tmp != null ? tmp.getNext() : void 0);
          if (tmp != null) {
            if ((_ref1 = tmp.getNext()) != null) {
              _ref1.setPreviousResult(res);
            }
          }
          cur.getPrevious().setNextResult(res);
          cur = res;
        } else {
          cur.setNextResult(cur.getNext());
          if ((_ref2 = cur.getNext()) != null) {
            _ref2.setPreviousResult(cur);
          }
        }
        if (((_ref3 = cur.getPreviousResult()) != null ? (_ref4 = _ref3.getPreviousResult()) != null ? _ref4.type : void 0 : void 0) !== 'LOG' && this.isNumber(cur) && this.isNumber(cur.getPreviousResult())) {
          console.log(cur);
          t = new Operand('TIMES');
          cur.getPreviousResult().setNextResult(t);
          t.setPreviousResult(cur.getPreviousResult());
          cur.setPreviousResult(t);
          t.setNextResult(cur);
        }
        cur = cur != null ? cur.getNextResult() : void 0;
        if (!cur) {
          break;
        }
      }
      tail = this.head;
      while (tail.getNextResult()) {
        tail = tail.getNextResult();
      }
      this.afterOperand(this.head, {
        'FACT': this.factorial
      });
      this.twoSideOperand(this.head, {
        'POW': function(a, b) {
          return Math.pow(a, b);
        }
      });
      this.twoSideOperand(this.head, {
        'TIMES': function(a, b) {
          return a * b;
        },
        'DIVIDE': function(a, b) {
          return a / b;
        },
        'MOD': function(a, b) {
          return a % b;
        }
      });
      this.beforeFunction(tail, {
        'SIN': function(a) {
          return Math.sin(a / 180 * window.PI);
        },
        'SININV': function(a) {
          return (Math.asin(a)) * 180 / window.PI;
        },
        'COS': function(a) {
          return Math.cos(a / 180 * window.PI);
        },
        'COSINV': function(a) {
          return (Math.acos(a)) * 180 / window.PI;
        },
        'TAN': function(a) {
          return Math.tan(a / 180 * window.PI);
        },
        'TANINV': function(a) {
          return (Math.atan(a)) * 180 / window.PI;
        },
        'LOG': function(a, b) {
          return Math.log(b) / Math.log(a);
        }
      });
      this.twoSideOperand(this.head, {
        'MINUS': function(a, b) {
          return a - b;
        },
        'PLUS': function(a, b) {
          return a + b;
        },
        'AND': function(a, b) {
          return a & b;
        },
        'XOR': function(a, b) {
          return a ^ b;
        },
        'OR': function(a, b) {
          return a | b;
        }
      });
      if (this.head.getNextResult().getNextResult()) {
        throw 'INNERInvalid formula.';
      }
      if (this.head.getNextResult().getValue().toString() === "NaN") {
        throw 'INNERError in mathematic function';
      }
      if (this.precision(this.head.getNextResult().getValue()) < 14) {
        return this.head.getNextResult().getValue();
      } else {
        return Math.round(this.head.getNextResult().getValue() * Math.pow(10, 14)) / Math.pow(10, 14);
      }
    }
  };

  Formula.prototype.precision = function(n) {
    var i, x, _i, _len;
    n = n.toString();
    i = NaN;
    for (_i = 0, _len = n.length; _i < _len; _i++) {
      x = n[_i];
      if (x === '.') {
        i = 0;
        continue;
      }
      i++;
    }
    if (i.toString() !== "NaN") {
      return i;
    } else {
      return 0;
    }
  };

  Formula.prototype.isNumber = function(el) {
    return el instanceof NumberObj || el instanceof Variable || el instanceof Block || el instanceof Brackets || el instanceof Result || el instanceof Root;
  };

  Formula.prototype.beforeFunction = function(cur, func) {
    var cur_func, l, r, res, _ref, _ref1, _ref2, _results;
    _results = [];
    while (cur) {
      if (cur instanceof Function) {
        cur_func = cur.getValue();
        if (cur_func === 'LOG') {
          if (!this.isNumber(cur.getNextResult())) {
            throw 'INNERNot a number after ' + cur_func + '.';
          }
          if (!this.isNumber(cur.getNextResult().getNextResult())) {
            throw 'INNERNot a number after ' + cur_func + '.';
          }
          l = cur.getPreviousResult();
          r = cur.getNextResult();
          res = new Result(func[cur_func](r.getValue(), r.getNextResult().getValue()), l, r.getNextResult().getNextResult());
          l.setNextResult(res);
          if ((_ref = r.getNextResult()) != null) {
            if ((_ref1 = _ref.getNextResult()) != null) {
              _ref1.setPreviousResult(res);
            }
          }
        } else if (func.hasOwnProperty(cur_func)) {
          if (!this.isNumber(cur.getNextResult())) {
            throw 'INNERNot a number after ' + cur_func + '.';
          }
          l = cur.getPreviousResult();
          r = cur.getNextResult();
          res = new Result(func[cur_func](r.getValue()), l, r.getNextResult());
          l.setNextResult(res);
          if ((_ref2 = r.getNextResult()) != null) {
            _ref2.setPreviousResult(res);
          }
        }
      }
      _results.push(cur = cur != null ? cur.getPreviousResult() : void 0);
    }
    return _results;
  };

  Formula.prototype.afterOperand = function(cur, func) {
    var cur_func, l, r, res, _ref, _results;
    _results = [];
    while (cur) {
      if (cur instanceof Operand) {
        cur_func = cur.getValue();
        if (func.hasOwnProperty(cur_func)) {
          if (!this.isNumber(cur.getPreviousResult())) {
            throw 'INNERNot a number before factorial.';
          }
          l = cur.getPreviousResult();
          r = cur.getNextResult();
          res = new Result(func[cur_func](l.getValue()), l.getPreviousResult(), r);
          if ((_ref = l.getPreviousResult()) != null) {
            _ref.setNextResult(res);
          }
          if (r != null) {
            r.setPreviousResult(res);
          }
        }
      }
      _results.push(cur = cur != null ? cur.getNextResult() : void 0);
    }
    return _results;
  };

  Formula.prototype.twoSideOperand = function(cur, oper) {
    var l, operand, r, res, _ref, _ref1, _results;
    _results = [];
    while (cur) {
      if (cur instanceof Operand) {
        operand = cur.getValue();
        if (oper.hasOwnProperty(operand)) {
          if (!(this.isNumber(cur.getPreviousResult()) && this.isNumber(cur.getNextResult()))) {
            throw 'INNERNot a numbers for ' + operand + '.';
          }
          l = cur.getPreviousResult();
          r = cur.getNextResult();
          res = new Result(oper[operand](l.getValue(), r.getValue()), l.getPreviousResult(), r.getNextResult());
          if ((_ref = l.getPreviousResult()) != null) {
            _ref.setNextResult(res);
          }
          if ((_ref1 = r.getNextResult()) != null) {
            _ref1.setPreviousResult(res);
          }
        }
      }
      _results.push(cur = cur != null ? cur.getNextResult() : void 0);
    }
    return _results;
  };

  Formula.prototype.getNumber = function(cur) {
    var res;
    res = '';
    if (cur instanceof Operand && cur.getValue() === 'MINUS' && cur.getNext() instanceof NumberObj) {
      res = '-';
      cur = cur.getNext();
    }
    while (true) {
      if (cur.getValue() === 'FLOATPOINT') {
        res += '.';
      } else {
        res += cur.getValue();
      }
      if (!(cur.getNext() instanceof NumberObj)) {
        break;
      }
      cur = cur.getNext();
    }
    res = parseFloat(res);
    return {
      'res': res,
      'cur': cur
    };
  };

  Formula.prototype.display = function() {
    var cur, form;
    if (this.head !== this.tail) {
      cur = this.head.getNext();
      form = cur.getHTML();
      while ((cur = cur.getNext()) !== null) {
        $.merge(form, cur.getHTML());
      }
      return form;
    } else {
      return $('');
    }
  };

  Formula.prototype.factorial = function(a) {
    var res, x, _i;
    if (a !== 0) {
      res = 1;
      for (x = _i = 1; 1 <= a ? _i <= a : _i >= a; x = 1 <= a ? ++_i : --_i) {
        res *= x;
      }
      return res;
    } else {
      return 1;
    }
  };

  Formula.prototype.isEmpty = function() {
    return this.head === this.tail;
  };

  return Formula;

})();
// Generated by CoffeeScript 1.7.1
var Result,
  __hasProp = {}.hasOwnProperty,
  __extends = function(child, parent) { for (var key in parent) { if (__hasProp.call(parent, key)) child[key] = parent[key]; } function ctor() { this.constructor = child; } ctor.prototype = parent.prototype; child.prototype = new ctor(); child.__super__ = parent.prototype; return child; };

Result = (function(_super) {
  __extends(Result, _super);

  function Result(result, previousResult, nextResult) {
    this.result = result;
    this.previousResult = previousResult;
    this.nextResult = nextResult;
    if (this.result.toString() === "NaN") {
      throw 'INNERError in mathematic function';
    }
  }

  Result.prototype.getHTML = function() {
    return null;
  };

  Result.prototype.setPrevious = function() {
    return null;
  };

  Result.prototype.setNext = function() {
    return null;
  };

  Result.prototype.getValue = function() {
    return this.result;
  };

  return Result;

})(Element);
// Generated by CoffeeScript 1.7.1
var cursor, factorialise, fillVar, showError, tap, upActivated, upBlink,
  __indexOf = [].indexOf || function(item) { for (var i = 0, l = this.length; i < l; i++) { if (i in this && this[i] === item) return i; } return -1; };

window.PI = 3.141592653589793238462643;

window.e = 2.7182818284590452353602874;

window.HTML = {
  'MINUS': '-',
  'PLUS': '+',
  'AND': 'AND',
  'XOR': 'XOR',
  'OR': 'OR',
  'TIMES': '&times;',
  'DIVIDE': '/',
  'MOD': '%',
  'POW': '&circ;',
  'FACT': '!'
};

window.HTML_FUNCTIONS = {
  'SIN': 'sin',
  'SININV': 'sinINV',
  'COS': 'cos',
  'COSINV': 'cosINV',
  'TAN': 'tan',
  'TANINV': 'tanINV',
  'LOG': 'log'
};

window.CONST = ['PI', 'e'];

window.vars = {
  'X': null,
  'Y': null,
  'Z': null
};

window.varsUsed = {
  'X': null,
  'Y': null,
  'Z': null
};

$(window).resize(function() {
  var size, size_text;
  size = parseInt($(window).width()) - 4;
  size_text = parseInt($(window).height()) / 15 + 'px';
  $('body').css({
    'font-size': size_text,
    'line-height': size_text
  });
  $('#cont_disp').css({
    width: size + 'px'
  });
  return $('table tr td').css({
    width: parseInt(size / 7)
  });
});

window.up = $('#UP_BTN');

upActivated = function(act) {
  if (act) {
    return window.up.removeClass('deactivated');
  } else {
    return window.up.addClass('deactivated');
  }
};

upBlink = function() {
  window.up.children().removeClass('blink').addClass('set_blink');
  return setTimeout((function() {
    return window.up.children().addClass('blink');
  }), 25);
};

fillVar = function(v) {
  return $('#' + v).addClass('filled');
};

showError = function(e) {
  return $('#error_line').html(e);
};

factorialise = function(n, first) {
  var pow, prime, x, y, _i, _j, _k, _len, _len1, _ref, _ref1, _ref2;
  if (n === 0) {
    cursor["new"](new NumberObj('0'));
    return 1;
  } else {
    if (n < 0) {
      cursor["new"](new Operand('MINUS'));
      n *= -1;
    }
    prime = 0;
    pow = 0;
    for (x = _i = 2, _ref = Math.sqrt(n) + 1; 2 <= _ref ? _i <= _ref : _i >= _ref; x = 2 <= _ref ? ++_i : --_i) {
      if (n % x === 0) {
        prime = x;
        break;
      }
    }
    if (prime === 0) {
      prime = n;
      pow = 1;
      n = 1;
    }
    while (n % x === 0) {
      n /= x;
      pow++;
    }
    if (!first) {
      cursor["new"](new Operand('TIMES'));
    }
    _ref1 = prime.toString();
    for (_j = 0, _len = _ref1.length; _j < _len; _j++) {
      y = _ref1[_j];
      cursor["new"](new NumberObj(y));
    }
    if (pow > 1) {
      cursor["new"](new Operand('POW'));
      _ref2 = pow.toString();
      for (_k = 0, _len1 = _ref2.length; _k < _len1; _k++) {
        y = _ref2[_k];
        cursor["new"](new NumberObj(y));
      }
    }
    return n;
  }
};

$(window).trigger('resize');

window.resultShown = false;

window.form = $('#formula');

window.formula = new Formula();

cursor = new Cursor(window.formula);

window.form.html(window.formula.display());

tap = function(type) {
  var e, formula, isLog, r, res, t, type_old, x, _i, _j, _len, _len1, _ref, _ref1, _ref2;
  try {
    console.log(type);
    if (window.HTML.hasOwnProperty(type)) {
      cursor["new"](new Operand(type));
      window.resultShown = false;
    } else if (window.HTML_FUNCTIONS.hasOwnProperty(type) || type.toString().substr(0, 3) === 'LOG') {
      isLog = type.substr(0, 3) === 'LOG';
      if (isLog) {
        formula = new Formula();
        if (type.substr(3) === '2') {
          formula["new"](new NumberObj(2));
        }
        if (type.substr(3) === '10') {
          formula["new"](new NumberObj(1));
          formula["new"](new NumberObj(0));
        }
        type_old = type;
        type = 'LOG';
      } else {
        formula = void 0;
      }
      if (window.resultShown && !isLog) {
        cursor.formulaInBlock(new Brackets(), new Function(type));
        window.resultShown = false;
      } else {
        if (isLog && window.resultShown) {
          cursor.newFormula();
          window.resultShown = false;
        }
        cursor["new"](new Function(type), formula);
        if (!isLog) {
          cursor["new"](new Brackets('basic', new Formula()));
        }
        if (isLog && type_old !== 'LOG') {
          cursor.getHigher();
        }
      }
    } else if ((0 <= (_ref = parseInt(type)) && _ref <= 9) || type === 'FLOATPOINT') {
      if (window.resultShown) {
        cursor.newFormula();
        window.resultShown = false;
      }
      cursor["new"](new NumberObj(type));
    } else if (__indexOf.call(window.CONST, type) >= 0) {
      if (window.resultShown) {
        cursor.newFormula();
        window.resultShown = false;
      }
      cursor["new"](new Constant(type));
    } else if (type.substr(1, 2) === 'AS') {
      window.vars[type.substr(0, 1)] = jQuery.extend(true, {}, cursor.formula);
      window.varsUsed[type.substr(0, 1)] = cursor.formula;
      fillVar('VAR' + type.substr(0, 1));
    } else if (type.substr(0, 3) === 'VAR' && window.vars[type.substr(3)]) {
      if (window.varsUsed[type.substr(3)] === cursor.formula) {
        throw "INNERYou can't use formula recursively";
      }
      cursor.newBrackets(window.vars[type.substr(3)]);
    } else if (type.substr(0, 3) === 'EXP') {
      tap('TIMES');
      tap('1');
      tap('0');
      tap('POW');
      if (type.substr(3) === '-3') {
        tap('MINUS');
        tap('3');
      }
      if (type.substr(3) === '3') {
        tap('3');
      }
      window.resultShown = false;
    } else if (type.substr(0, 3) === 'POW') {
      tap('POW');
      tap(type.substr(3));
      window.resultShown = false;
    } else {
      switch (type) {
        case 'INVNUM':
          cursor.formulaInBlock(new Brackets(), new NumberObj('1'), new Operand('DIVIDE'));
          window.resultShown = false;
          break;
        case 'BRACKETS':
          if (window.resultShown) {
            cursor.formulaInBlock(new Brackets('basic'));
            window.resultShown = false;
          } else {
            cursor["new"](new Brackets('basic', new Formula()));
          }
          break;
        case 'SOLVE':
          showError('');
          res = cursor.solve();
          console.log(res);
          if (res === Infinity) {
            throw 'INNERToo big or too small number';
          }
          res = String(res).split('e');
          cursor.newFormula();
          _ref1 = res[0];
          for (_i = 0, _len = _ref1.length; _i < _len; _i++) {
            x = _ref1[_i];
            if (x === '-') {
              cursor["new"](new Operand('MINUS'));
            } else {
              if (x === '.') {
                x = 'FLOATPOINT';
              }
              cursor["new"](new NumberObj(x));
            }
          }
          if (res.length === 2) {
            cursor["new"](new Operand('TIMES'));
            cursor["new"](new NumberObj(1));
            cursor["new"](new NumberObj(0));
            cursor["new"](new Operand('POW'));
            _ref2 = res[1];
            for (_j = 0, _len1 = _ref2.length; _j < _len1; _j++) {
              x = _ref2[_j];
              if (x === '+') {
                continue;
              }
              if (x === '-') {
                cursor["new"](new Operand('MINUS'));
              } else {
                cursor["new"](new NumberObj(x));
              }
            }
          }
          window.resultShown = true;
          break;
        case 'SOLVE_FACT':
          showError('');
          res = Math.round(cursor.solve());
          cursor.newFormula();
          t = factorialise(res, true);
          while (t !== res && t > 1) {
            res = t;
            t = factorialise(res, false);
          }
          window.resultShown = true;
          break;
        case 'UP':
          if (cursor.canHigher()) {
            cursor.getHigher();
            upBlink();
          }
          break;
        case 'PERCENTAGE':
          tap('TIMES');
          tap('0');
          tap('FLOATPOINT');
          tap('0');
          tap('1');
          tap('TIMES');
          break;
        case 'REMOVE':
          cursor.pop();
          window.resultShown = false;
          break;
        case 'REMOVE_ALL':
          if (confirm('Really delete the whole formula?')) {
            cursor.newFormula();
            showError("");
          }
          break;
        case 'ROOT':
          if (window.resultShown) {
            cursor.newFormula();
            window.resultShown = false;
          }
          cursor["new"](new Root(new Formula(), new Formula()));
          break;
        case 'ROOT2':
          if (window.resultShown) {
            cursor.newFormula();
            window.resultShown = false;
          }
          r = new Root(new Formula(), new Formula());
          r.exp["new"](new NumberObj(2));
          cursor["new"](r);
          cursor.getHigher();
          break;
        case 'ROOT3':
          if (window.resultShown) {
            cursor.newFormula();
            window.resultShown = false;
          }
          r = new Root(new Formula(), new Formula());
          r.exp["new"](new NumberObj(3));
          cursor["new"](r);
          cursor.getHigher();
          break;
        case 'INFO':
          $('#info').show(1000);
          $('#info').click(function() {
            return $(this).hide(1000);
          });
      }
    }
    upActivated(cursor.canHigher());
    window.form.html(cursor.display());
  } catch (_error) {
    e = _error;
    console.log(e);
    if (e.substr(0, 5) === 'INNER') {
      showError(e.substr(5));
    } else {
      alert("We are sorry, but an unexpected error occured:\n" + e + "\nPlease contact us.");
    }
  }
};

window.hold = void 0;

window.holdPos = 0;

window.tapInterval = 0;

$(document).on('click', 'td', function() {
  if (!(window.hold || window.tapInterval + 300 > Date.now())) {
    tap($(this)[0].dataset['tap']);
  }
});

$('td').each(function() {
  Hammer(this, {
    'time': 200
  }).on('press', function(obj) {
    var jObj;
    window.navigator.vibrate(70);
    window.holdPos = obj.center.y;
    jObj = $(obj.target);
    if (jObj[0].nodeName.toUpperCase() === 'SPAN') {
      jObj = jObj.parent();
    }
    window.hold = jObj.addClass('active');
  });
});

document.addEventListener('touchmove', function(obj) {
  if (window.hold) {
    if (window.holdPos + 10 < obj.touches[0].clientY && window.hold.data('down') !== void 0) {
      if (window.hold.data('down') !== 'REMOVE_ALL') {
        tap(window.hold.data('down'));
        window.tapInterval = Date.now();
        window.hold = void 0;
      } else {
        window.hold = void 0;
        tap('REMOVE_ALL');
      }
    }
    if (window.holdPos - 10 > obj.touches[0].clientY && window.hold.data('up') !== void 0) {
      window.tapInterval = Date.now();
      tap(window.hold.data('up'));
      window.hold = void 0;
    }
  }
});

document.addEventListener('touchend', function(obj) {
  window.hold = void 0;
});
