function DetailInfo(){
    var detailInfo = {
        titleTf: $('#detail_title'),
        detailCont: $('#detail_layout'),
        addToFavBtn: $('#add_to_favoriten'),
        formularBtn: $('#formular'),
        mapBtn: $('#map'),
        phoneBtn: $('#phone'),
        linkBtn: $('#link'),
        footerCont: $('footer'),

        checkForDetailInfo: function(){ // get info for item from local storage
            window.storageManager.setItem(window.storageManager.IDK_FAVORITE_LIST_ITEM, null); // clear favoriten item from cashing when come to favoriten from main menu
            this.dataInfo = window.storageManager.getItem(window.storageManager.IDK_DETAIL_INFO);
            //console.log(this.dataInfo);
            if (!$.isEmptyObject(this.dataInfo)){
                this.setContSize();
                this.formDetailLayot(this.dataInfo);
            }else{
                console.log("Item info missed");
            }
        },
        formDetailLayot: function(data){ // form layout from detail info
            if ($.isEmptyObject(data.general)){
                PopUp.pp.alert("<p class=\"info\">Keine Information</p>", "empty");
                if (this.footerCont.length > 0) this.footerCont.hide();
                return;
            }
            this.titleTf.text(data.general.kurzname != undefined ? data.general.kurzname : data.general.name != undefined ? data.general.name : data.general.name);
            this.detailCont.append(this.formMapSection(data)!= "" ? this.formMapSection(data).fadeIn() : "");
            this.detailCont.append(this.formPhoneSection(data)!= "" ? this.formPhoneSection(data).fadeIn() : "");
            this.detailCont.append(this.formLinkSection(data)!= "" ? this.formLinkSection(data).fadeIn() : "");
            this.detailCont.append(this.formOpenHoursSection(data)!= "" ? this.formOpenHoursSection(data).fadeIn() : "");

        },
        formMapSection: function(data){ // create button to open map with info
            if (data.general.adresse){
                var mapSect = $('<div>'),
                    stadt = data.general.stadt != undefined ? data.general.stadt : "",
                    adresse = data.general.adresse != undefined ? data.general.adresse : "",
                    hausnummer = data.general.hausnummer != undefined ? data.general.hausnummer : "";
                var place = stadt + " " + adresse + " " + hausnummer,
                    mapInfo = $('<div><p><strong>'+data.general.kurzname+'</strong></p><p>'+place+'</p></div>'),
                    mapBtn = $('<a href="#" id="map"><img src="imgs/ic_location_btn.png" /></a>');
                mapBtn.data('map', place).on('click', function(e){
                    e.preventDefault();
                    var place = $(this).data('map');
                    if (place && place.length > 0){
                        window.storageManager.setItem(window.storageManager.IDK_MAP_PLACE, place);
                        window.location.href = "map.html";
                    }
                });
                mapSect.prepend(mapBtn,mapInfo);
            }
            return mapSect != undefined ? mapSect : "";
        },
        formPhoneSection: function(data){ // create link to enable phone action
            if (data.general.tel){
                var phoneSect = $('<div>');
                var phoneBtn = $('<a href="tel:'+data.general.tel+'" id="phone"><img src="imgs/ic_phone_btn.png" /></a>'),
                    phoneInfo = $('<div><span>'+data.general.tel+'</span></div>');
                phoneSect.prepend(phoneBtn, phoneInfo);
            }
            return phoneSect != undefined ? phoneSect : "";
        },
        formLinkSection: function(data){ // create link to enable phone action
            if (data.general.link){
                var linkSect = $('<div>');
                var linkBtn = $('<a target="_new" href="http://'+data.general.link+'" id="link"><img src="imgs/ic_web_btn.png" /></a>'),
                    linkInfo = $('<div><span>Internet</span></div>');
                linkSect.prepend(linkBtn, linkInfo);
            }
            return linkSect != undefined ? linkSect : "";
        },
        formOpenHoursSection: function(data){
            var openDetails = {
                getMontag1: function(){
                    if (!isNaN(parseFloat(data.general.montagauf1)) && !isNaN(parseFloat(data.general.montagzu1))){
                        return data.general.montagauf1 + "-" + data.general.montagzu1;
                    }else{
                        return "";
                    }
                },
                getMontag2: function(){
                    if (!isNaN(parseFloat(data.general.montagauf2)) && !isNaN(parseFloat(data.general.montagzu2))){
                        return data.general.montagauf2 + "-" + data.general.montagzu2;
                    }else{
                        return "";
                    }
                },
                getDienstag1: function(){
                    if (!isNaN(parseFloat(data.general.dienstagauf1)) && !isNaN(parseFloat(data.general.dienstagzu1))){
                        return data.general.dienstagauf1 + "-" + data.general.dienstagzu1;
                    }else{
                        return "";
                    }
                },
                getDienstag2: function(){
                    if (!isNaN(parseFloat(data.general.dienstagauf2)) && !isNaN(parseFloat(data.general.dienstagzu2))){
                        return data.general.dienstagauf2 + "-" + data.general.dienstagzu2;
                    }else{
                        return "";
                    }
                },
                getMittwoch1: function(){
                    if (!isNaN(parseFloat(data.general.mittwochauf1)) && !isNaN(parseFloat(data.general.mittwochauf1))){
                        return data.general.mittwochauf1 + "-" + data.general.mittwochzu1;
                    }else{
                        return "";
                    }
                },
                getMittwoch2: function(){
                    if (!isNaN(parseFloat(data.general.mittwochauf2)) && !isNaN(parseFloat(data.general.mittwochauf2))){
                        return data.general.mittwochauf2 + "-" + data.general.mittwochzu2;
                    }else{
                        return "";
                    }
                },
                getDonnerstag1: function(){
                    if (!isNaN(parseFloat(data.general.donnerstagauf1)) && !isNaN(parseFloat(data.general.donnerstagauf1))){
                        return data.general.donnerstagauf1 + "-" + data.general.donnerstagzu1;
                    }else{
                        return "";
                    }
                },
                getDonnerstag2: function(){
                    if (!isNaN(parseFloat(data.general.donnerstagauf2)) && !isNaN(parseFloat(data.general.donnerstagauf2))){
                        return data.general.donnerstagauf2 + "-" + data.general.donnerstagzu2;
                    }else{
                        return "";
                    }
                },
                getFreitag1: function(){
                    if (!isNaN(parseFloat(data.general.freitagauf1)) && !isNaN(parseFloat(data.general.freitagauf1))){
                        return data.general.freitagauf1 + "-" + data.general.freitagzu1;
                    }else{
                        return "";
                    }
                },
                getFreitag2: function(){
                    if (!isNaN(parseFloat(data.general.freitagauf2)) && !isNaN(parseFloat(data.general.freitagauf2))){
                        return data.general.freitagauf2 + "-" + data.general.freitagzu2;
                    }else{
                        return "";
                    }
                },
                getSamstag1: function(){
                    if (!isNaN(parseFloat(data.general.freitagauf1)) && !isNaN(parseFloat(data.general.freitagzu1))){
                        return data.general.freitagauf1 + "-" + data.general.freitagzu1;
                    }else{
                        return "";
                    }
                },
                getSamstag2: function(){
                    if (!isNaN(parseFloat(data.general.freitagauf2)) && !isNaN(parseFloat(data.general.freitagzu2))){
                        return data.general.freitagauf2 + "-" + data.general.freitagzu2;
                    }else{
                        return "";
                    }
                },
                getSonntag1: function(){
                    if (!isNaN(parseFloat(data.general.sonntagauf1)) && !isNaN(parseFloat(data.general.sonntagzu1))){
                        return data.general.sonntagauf1 + "-" + data.general.sonntagzu1;
                    }else{
                        return "";
                    }
                },
                getSonntag2: function(){
                    if (!isNaN(parseFloat(data.general.sonntagauf2)) && !isNaN(parseFloat(data.general.sonntagzu2))){
                        return data.general.sonntagauf2 + "-" + data.general.sonntagzu2;
                    }else{
                        return "";
                    }
                }
            };
            if (openDetails.getMontag1().length == 0 && openDetails.getDienstag1().length  == 0 && openDetails.getMittwoch1().length  == 0 && openDetails.getDonnerstag1().length
                == 0 && openDetails.getFreitag1().length  == 0 && openDetails.getSamstag1().length == 0 && openDetails.getSonntag1().length == 0){
                var noTableCont = $('<div><h1>ffnungszeiten</h1><p class="info intent top">Fr diesen Eintrag sind uns noch keine ffnungszeiten bekannt. Du kennst sie?</p></div>');
                console.log("Open hours are missed");
            }else{
                var tableCont = $('<div>'),
                    openTbl = $('<table>'),
                    tr;

                var montag1 = openDetails.getMontag1().length != 0 ? openDetails.getMontag1() : "geschlossen";
                tr = $('<tr></tr>');
                openTbl.append(tr.append('<td>Montag</td><td>'+montag1+'</td>'));
                if (openDetails.getMontag2() != "") tr.append('<td>'+openDetails.getMontag2()+'</td>');

                var dienstag1 = openDetails.getDienstag1().length != 0 ? openDetails.getDienstag1() : "geschlossen";
                tr = $('<tr></tr>');
                openTbl.append(tr.append('<td>Dienstag</td><td>'+dienstag1+'</td>'));
                if (openDetails.getDienstag2() != "") tr.append('<td>'+openDetails.getDienstag2()+'</td>');

                var mittwoch1 = openDetails.getMittwoch1().length != 0 ? openDetails.getMittwoch1() : "geschlossen";
                tr = $('<tr></tr>');
                openTbl.append(tr.append('<td>Mittwoch</td><td>'+mittwoch1+'</td>'));
                if (openDetails.getMittwoch2() != "") tr.append('<td>'+openDetails.getMittwoch2()+'</td>');

                var donnerstag1 = openDetails.getDonnerstag1().length != 0 ? openDetails.getDonnerstag1() : "geschlossen";
                tr = $('<tr></tr>');
                openTbl.append(tr.append('<td>Donnerstag</td><td>'+donnerstag1+'</td>'));
                if (openDetails.getDonnerstag2() != "") tr.append('<td>'+openDetails.getDonnerstag2()+'</td>');

                var freitag1 = openDetails.getFreitag1().length != 0 ? openDetails.getFreitag1() : "geschlossen";
                tr = $('<tr></tr>');
                openTbl.append(tr.append('<td>Freitag</td><td>'+freitag1+'</td>'));
                if (openDetails.getFreitag2() != "") tr.append('<td>'+openDetails.getFreitag2()+'</td>');

                var samstag1 = openDetails.getSamstag1().length != 0 ? openDetails.getSamstag1() : "geschlossen";
                tr = $('<tr></tr>');
                openTbl.append(tr.append('<td>Samstag</td><td>'+samstag1+'</td>'));
                if (openDetails.getSamstag2() != "") tr.append('<td>'+openDetails.getSamstag2()+'</td>');

                var sonntag1 = openDetails.getSonntag1().length != 0 ? openDetails.getSonntag1() : "geschlossen";
                tr = $('<tr></tr>');
                openTbl.append(tr.append('<td>Sonntag</td><td>'+ sonntag1 +'</td>'));
                if (openDetails.getSonntag2() != "") tr.append('<td>'+openDetails.getSonntag2()+'</td>');

                tableCont.append('<h1>ffnungszeiten</h1>', openTbl)
            }
            return tableCont !=undefined ? tableCont : noTableCont;
        },
        setContSize: function(){
            this.detailCont.outerHeight($(window).outerHeight() - $('header').outerHeight() - $('footer').outerHeight());
        },
        setFavoritenAction: function(){ // open favoriten page and save info for current item
            if (this.addToFavBtn.length > 0){
                this.addToFavBtn.on('click', function(e){
                    e.preventDefault();
                    window.storageManager.setItem(window.storageManager.IDK_FAVORITE_LIST_ITEM, detailInfo.dataInfo);
                    window.location.href= 'favoriten.html';
                });
            }else{
                delete this.addToFavBtn;
            }
        },
        setFormular: function(){ // open form for feedback
            if (this.formularBtn.length > 0){
                this.formularBtn.on('click', function(e){
                    e.preventDefault();
                    detailInfo.openFormular();
                });
            }else{
                delete this.formularBtn;
            }
        },
        meldenAction: function(params){
            window.requestManager.getData(this.IDD_FEHLER, window.requestManager.API.fehler, function(id, response){
                var csvObj = window.requestManager.csvToObject(response, ' ');
                if (csvObj.success){
                    PopUp.pp.alert("<p class=\"info\">Wir haben deinen Hinweis erhalten und werden diesen prfen</p>","success",{
                        ppTitle: "Melden erfolgreich"
                    });
                }else if (csvObj.error && csvObj.errorCode == window.requestManager.IDV_744){ // occurs if SID is not till valid, reinit session and repeat action
                    window.requestManager.reInitSession(function(){
                        detailInfo.meldenAction(params);
                    });
                }
            }, null, { // send sid and generated md5 for approving of creating session
                sid: window.requestManager.SID,
                id: detailInfo.dataInfo.general.filialId,
                von: params.name,
                email: params.mail,
                text: params.descr
            },{
                custom_url: window.requestManager.server_url_new_api
            });
        },
        openFormular: function(){ // open formular for feedback about store(item)
            PopUp.pp.confirm('<label for="user_name">Dein Name</label><input type="text" id="user_name" />' +
            '<label for="user_mail">Deine Emailadresse</label><input type="text" id="user_mail" /><label for="user_descr">Beschreibe den Fehler</label><textarea id="user_descr"></textarea>','errors',{
                ppOkButtonText: "Melden",
                ppCancelButtonText: "Abbrechen",
                ppOkButton: function(){
                    var serializedData = {
                        name: $('#user_name').val(),
                        mail: $('#user_mail').val(),
                        descr: $('#user_descr').val()
                    };
                    if (serializedData.descr.trim().length == 0){
                        PopUp.pp.alert("<p class=\"info\">Bitte gib eine Beschreibung des Fehlers ein!</p>","empty_descr",{
                            ppTitle: "Fehler"
                        });
                        return false;
                    }
                    detailInfo.meldenAction(serializedData);
                }
            });
        },
        init: function(){
            this.checkForDetailInfo();
            this.setFavoritenAction();
            this.setFormular();
            return this;
        }
    }
    return detailInfo.init();
}