function Favoriten(){
    var favoriten = {
        editModeBtn: $('#edit_mode_btn'),
        addListBtn: $('#add_list'),
        emptyLayout: $('#no_results'),
        resultLayout: $('#favoriten_items'),
        infoBlock: $('#additional_info'),
        toDetailBtn: $('#return_to_detail_page'),
        toHomeBtn: $('#back_btn'),

        PAGE_VIEW: 0,
        PAGE_ADD: 1,

        editModeAction: function(){
          if (this.editModeBtn.length > 0){
              this.editModeBtn.on('click', function(e){
                  e.preventDefault();
                  favoriten.toggleDeleteBtns();
              });
          }
        },
        toggleDeleteBtns: function(){ // switch mode for button (show or hide delete items buttons)
            this.editModeBtn.toggleClass('delete_mode');
            if (this.deleteBtns.length > 0){
                this.deleteBtns.toggle();
            }
        },
        initDeleteBtns: function(){ // init buttons for deleting items form list
            this.deleteBtns = $('.delete_item');
            if (this.deleteBtns.length > 0){
                this.deleteBtns.each(function(){
                    var deleteBtn = $(this);
                    deleteBtn.unbind('click');
                    deleteBtn.bind('click', function(){
                        PopUp.pp.confirm('<p class="info">'+deleteBtn.next().find('.label').text()+' wirklich lschen?</p>','confirmDelete'+deleteBtn.parent().index(),{
                            ppOkButton: function(){
                                window.storageManager.setItem(window.storageManager.IDK_FAVORITE_LIST, { // remove item from and its parent totally
                                    id: deleteBtn.parent().index(),
                                    add: false
                                });
                                deleteBtn.parent().remove();
                                favoriten.checkItemsCount();
                                if ($('.delete_item').length == 0){
                                    favoriten.editModeBtn.toggleClass('delete_mode');
                                }
                            },
                            ppOkButtonText: "Ja",
                            ppCancelButtonText: "Nein",
                            ppTitle: "Gesp. Suchen lschen"
                        });
                    });
                });
            }else{
                delete this.deleteBtns;
            }
        },
        checkItemsCount: function(){ // check shown items for changing layout to represent
            if ($('.delete_item').length > 0){
                this.emptyLayout.hide();
                this.editModeBtn.show();
                this.infoBlock.show();
                this.addListBtn.parent().parent().removeClass('txtCenter');
            }else{
                this.emptyLayout.show();
                this.editModeBtn.hide();
                this.infoBlock.hide();
                this.addListBtn.parent().parent().addClass('txtCenter');
            }
        },
        initAddListAction: function(){
            if (this.addListBtn.length > 0){
                this.addListBtn.on('click', function(e){
                    e.preventDefault();
                    favoriten.addNewList(0); // create new list with empty items
                });
            }else{
                delete this.addListBtn;
            }
        },
        addNewList: function(counter){ // create new list (popUp for typing name of list)
            PopUp.pp.confirm('<p class="info">Bitte gebe einen Namen fr die zu speichernde Favoritenliste an:</p><input type="text" id="list_label" tabindex="1" />',"createList",{
                ppOkButton: function(){
                    var label = $('#list_label').val();
                    favoriten.createList({
                        counter: counter, // amount of items in list
                        label: label // typed value in popUp
                    });
                    window.storageManager.setItem(window.storageManager.IDK_FAVORITE_LIST, { // save new list in local storage
                        label: label,
                        counter: counter,
                        id: $('.item').length - 1,
                        add: true
                    });
                    favoriten.storedLists = window.storageManager.getItem(window.storageManager.IDK_FAVORITE_LIST);
                },
                ppOkButtonText: "Speichern",
                ppCancelButtonText: "Abbrechen"
            });
            $('#list_label').trigger('focus');
        },
        createList: function(opt){ // create list constructor
            var tml = $('<div class="inline-block item"><img src="imgs/ic_delete_item_btn.png" class="delete_item" draggable="false" />'),
                list_item = $('<a href="#" class="btn blue large" draggable="false"><p>'+opt.counter+'</p><p class="label">'+opt.label+'</p></a>');
            this.addListBtn.parent().before(tml.append(list_item));
            list_item.on('click', function(e){
                e.preventDefault();
                favoriten.listItemAction($(this));
            });
            favoriten.initDeleteBtns();
            favoriten.checkItemsCount();
            if (this.editModeBtn.hasClass('delete_mode')) tml.find('.delete_item').show();
        },
        listItemAction: function(list_item){ // fires if user click on list item
            var curIndex = list_item.parent().index(),
                neededItem = this.storedLists[curIndex];
            switch (this.pageType){
                case this.PAGE_ADD:
                    if (neededItem.items && !$.isEmptyObject(neededItem.items)){
                        if (!$.isEmptyObject(neededItem.items[favoriten.addItemData.general.filialId])){
                           PopUp.pp.alert("<p class=\"info\">Die Filiale ist bereits in dieser Favoritenliste gespeichert!</p>", "exist_item", {
                               ppTitle: "Fehler!"
                           });
                        }else{
                            favoriten.setItemDataToList(list_item, neededItem);
                        }
                    }else{
                        neededItem.items = {};
                        favoriten.setItemDataToList(list_item, neededItem);
                    }
                    break;
                case this.PAGE_VIEW:
                    window.storageManager.setItem(window.storageManager.IDK_FAVORITE_LIST_DETAILS, neededItem);
                    window.location.href = "single_favoriten.html";
                    break;
                default:
            }
        },
        setItemDataToList: function(list_item, neededItem){
            neededItem.items[favoriten.addItemData.general.filialId] =  favoriten.addItemData;
            neededItem.counter++;
            window.storageManager.setItem(window.storageManager.IDK_FAVORITE_LIST, neededItem);
            list_item.find('p').first().text(neededItem.counter);
        },
        checkStoredLists: function(){
            this.storedLists = window.storageManager.getItem(window.storageManager.IDK_FAVORITE_LIST); // create lists from stored in localStorage
            if (this.storedLists != null){
                for (var i = 0; i < this.storedLists.length; i++){
                    this.createList({
                        label: this.storedLists[i].label,
                        counter: this.storedLists[i].counter
                    });
                }
            }else{
                console.log("No lists found");
            }
        },
        checkPageType: function(){ // check if user comes from main menu or want to add new item to list
            this.addItemData = window.storageManager.getItem(window.storageManager.IDK_FAVORITE_LIST_ITEM); // if listItem not null user comes from detail page
            if (this.addItemData != null){
                this.pageType = this.PAGE_ADD;
            }else{
                this.pageType = this.PAGE_VIEW;
                delete this.addItemData;
            }
        },
        checkBackBtns: function(){ // change visibility of back buttons depends on page type
            switch (this.pageType){
                case this.PAGE_ADD: // show button for returning to detail page
                    this.toDetailBtn.show();
                    this.toHomeBtn.hide();
                    break;
                case this.PAGE_VIEW: // show button for returning to home
                    this.toDetailBtn.hide();
                    this.toHomeBtn.show();
                    break;
                default:
            }
        },
        setBackButtonAction: function(){ // clear listItem info when returning to detail page
            this.toDetailBtn.on('click', function(){
                favoriten.clearListItemInfo();
            });
        },
        clearListItemInfo: function(){
            if (favoriten.addItemData) favoriten.addItemData = window.storageManager.setItem(window.storageManager.IDK_FAVORITE_LIST_ITEM, null);
        },
        init: function(){
            this.checkPageType();
            this.checkBackBtns();
            this.setBackButtonAction();
            this.editModeAction();
            this.initDeleteBtns();
            this.checkItemsCount();
            this.initAddListAction();
            this.checkStoredLists();
            return this;
        }
    }
    return favoriten.init();
}