function Map(){
    var mapObj = {

        mapCont: $('#map_cont'),

        initGeocoder: function(){
            this.geocoder = new google.maps.Geocoder();
        },
        setMapContSize: function(){
            this.mapCont.outerHeight($(window).outerHeight() - $('header').outerHeight());
        },
        initMap: function(){
            if (this.mapCont.length > 0){
                var place = window.storageManager.getItem(window.storageManager.IDK_MAP_PLACE);
                var itemInfo  = window.storageManager.getItem(window.storageManager.IDK_DETAIL_INFO);
                if (place != null && place.length > 0) {
                    var decodedAddress =  mapObj.geocoder.geocode( { 'address': place}, function(results, status){ // decode place string to cords
                        if (status == google.maps.GeocoderStatus.OK) {
                            var result = results[0];
                            if (result.geometry.location){
                                var latLang = [];
                                for (var i in result.geometry.location){
                                    latLang.push(result.geometry.location[i])
                                }
                                var coords = new google.maps.LatLng(latLang[0], latLang[1]);
                                var mapOptions = {
                                    zoom: 16,
                                    center: coords
                                }
                                var map = new google.maps.Map(mapObj.mapCont[0], mapOptions);
                                var marker = new google.maps.Marker({
                                    position: coords,
                                    map: map
                                });
                                var contentString = itemInfo.general.kurzname;
                                var infowindow = new google.maps.InfoWindow({
                                    content: '<span style="font-size: 16px;" id="info_window">' + contentString
                                });
                                infowindow.open(map,marker);
                            }
                        }else {
                            console.log("Geocode was not successful for the following reason: " + status);
                            if (status == "ZERO_RESULTS"){
                                PopUp.pp.alert("<p class=\"info\">Fr nicht gefunden</p>","empty")
                            }
                        }
                    });
                }
            }else{
                delete this.mapCont;
            }
        },
        init: function(){
            this.initGeocoder();
            this.setMapContSize();
            this.initMap();
            return this;
        }
    }
    return mapObj.init();
}