var PopUp = {
    // popup windows
    pp: {
        mainCont: function(){
            // creating pop_up container with modal window
            if ( $('#pp-container').length <=0 || !$('#pp-container') ){
                this.mainContainer = $("<div>").attr({id: "pp-container"});
            }
            if ($('.bg-level').length<=0 || !$('.bg-level')) {
                this.bgLevel = $('<div>').addClass("bg-level");
                this.mainContainer.append(this.bgLevel);
                $("body").addClass("overflowed").append(this.mainContainer);
            }
        },
        changeModalIndex: function(){
            // change z-index of modal layout
            if (!this.alertWin){
                this.modalIndex = 0;
                this.bgLevel.css('z-index',this.modalIndex);
            }
            else if (this.alertWin) {
                var lastWinIndex = $('.csAlert,.csConfirm,.csWindow').last().css('z-index');
                this.modalIndex = lastWinIndex - 1;
                this.bgLevel.css('z-index',this.modalIndex);
            }
        },
        show: function(id,number,ppContent,options){
            if (options && typeof options == 'object'){
                var opt = true;
            }
            // create pop_up
            this.mainCont();
            var winId;
            var closeButton = $('<span>').addClass('ppClose').addClass('popup_close');
            var contentBox = $('<div></div>').addClass('ppContent');
            contentBox.append(ppContent);
            var content = [closeButton];
            if (opt && options.ppTitle){
                var ppTitle = $('<div class="ppTitle">');
                content.push(ppTitle);
                ppTitle.prepend(options.ppTitle);
            }
            content.push(contentBox);
            if (!id){
                winId = 'popup_' + Math.random().toString(36).substr(2, 5);
            }
            else{
                winId = id;
            }
            if (!this.alertWin || this.alertWin.length <=0){
                this.alertWin = $('<div>');
                this.alertIndex = 1;
            }
            this.newAlert = this.alertWin.clone();
            this.newAlert.addClass("popup_body");
            switch (number){
                case 1:
                    this.newAlert.addClass('csAlert');
                    var alertButton = $('<span>Ok</span>').addClass('button alertButton popup_ok');
                    alertButton.click(function(){
                        if (opt){
                            if(options.ppOkButton && options.ppOkButton()==false){
                                return false;
                            }
                        }
                        PopUp.pp.close(winId,1);
                    });
                    content.push(alertButton);
                    break;
                case 2:
                    this.newAlert.addClass('csConfirm');
                    var okText = options.ppOkButtonText || 'Ok',
                        cancelText = options.ppCancelButtonText || 'Cancel';
                    var confirmButton = $('<div class="confCont"><span class="okButton">'+okText+'</span><span class="cancelButton">'+cancelText+'</span></div>');
                    confirmButton.children('.okButton').click(function(){
                        if (opt){
                            if(options.ppOkButton && options.ppOkButton()==false){
                                return false;
                            }
                        }
                        PopUp.pp.close(winId,1);
                    });
                    confirmButton.children('.cancelButton').click(function(){
                        if (opt){
                            if(options.ppCancelButton && options.ppCancelButton()==false){
                                return false;
                            }
                        }
                        PopUp.pp.close(winId,-1);
                    });
                    content.push(confirmButton);
                    break;
                case 3:
                    this.newAlert.addClass('csWindow');
                    break;
            }
            this.newAlert.attr('id',winId);
            this.newAlert.css('z-index',this.alertIndex);
            this.mainContainer.append(this.newAlert);
            this.addHtml(this.newAlert,content,opt,options);
            this.newAlert.css('max-height',$(window).height());
            if (this.newAlert[0].clientHeight>parseInt(this.newAlert.css('max-height'))){
                this.newAlert.children('.ppContent').addClass('scroll');
                this.newAlert.children('.ppContent').css('max-height',parseInt(this.newAlert.css('max-height'))-parseInt(this.newAlert.css('padding-bottom'))-parseInt(this.newAlert.css('padding-top')));
            }
            if (opt){
                if (options.ppWidth){
                    this.newAlert.width(options.ppWidth);
                    this.newAlert.css('max-width','inherit');
                }
            }
            //this.newAlert.css('margin-left',-this.newAlert.width()/2);
            //this.newAlert.css('margin-top',-(this.newAlert[0].clientHeight+parseInt(this.newAlert.css('padding-top'))+parseInt(this.newAlert.css('padding-bottom')))/2);
            this.changeModalIndex();
            this.alertIndex = this.alertIndex + 2;
        },
        addHtml: function(container,html,opt,options){
            for (var i = 0;i < html.length;i++){
                container.append(html[i]);
            }
            var jObj = {};
            jObj.opt = opt;
            jObj.options = options;
            container.children('.ppClose').click(function(){
                if (jObj.opt){
                    if (jObj.options.ppCloseButton && jObj.options.ppCloseButton()==false){
                        return false;
                    }
                }
                PopUp.pp.close(container);
            });
            return container;
        },
        alert: function(ppContent,id,options){
            this.show(id,1,ppContent,options);
        },
        confirm: function(ppContent,id,options){
            this.show(id,2,ppContent,options);
        },
        ppWin: function(ppContent,id,options){
            this.show(id,3,ppContent,options);
        },
        close: function(id,bool){
            if (typeof id == 'object'){
                $(id).remove();
            }
            else if (typeof id == 'string'){
                $('#'+id).remove();
            }
            this.changeModalIndex();
            this.alertIndex = this.alertIndex - 2;
            if ($('#pp-container').children().length == 1) {
                $('#pp-container').remove();
                $("body").removeClass("overflowed");
            }
            if (bool){
                if (bool > 0){
                    return true;
                }
                else if (bool < 0) {
                    return false;
                }
            }
        }
    }
};
$(window).load(function(){
    $(document).on("keydown", function(e){
        if(e.keyCode == 27 && $('#pp-container').children('div:last-child').is(':visible')){
            var toClose = $('#pp-container').children('div:last-child').attr('id');
            PopUp.pp.close(toClose,-1);
        }
    });
});
