function RequestManager(){
    var requestManager = {
        server_url: "http://www.oeffnungszeitenbuch.de/rpc/iphone2",
        server_url_new_api: "http://www.oeffnungszeitenbuch.de/rpc/iphone3.php",
        server_url_new_filiale: "http://www.oeffnungszeitenbuch.de/neueFiliale.html",
        challenge_value: 2,
        sid_prefix: 'tm9fy',

        API: {
            init: '?typ=init',
            auth: '?typ=auth',
            search: "?typ=query",
            new_store: '?typ=neueintrag',
            list: '?typ=list',
            fehler: '?typ=fehler',
            filiale: '?eintrag=1&appentry=1'
        },

        IDD_INIT: 10,
        IDD_AUTH: 11,
        IDD_SEARCH: 12,
        IDD_LIST: 13,
        IDD_FEHLER: 14,
        IDD_FILIALE: 15,

        IDV_200: "200",
        IDV_743: "743",
        IDV_744: "744",
        IDV_SID: "SID",
        IDV_CHALLENGE: "Challenge",
        IDV_FILIAL_ID: "Filial-ID",

        SID: window.storageManager.getItem(window.storageManager.IDK_SID), // check if SID is previously stored


        getData: function(id, url, success,fail, data, addData){
            var params = "";
            if (data){
                for (var i in data){
                    params += "&" + i + "=" + data[i];
                }
            }
            var url = (addData && addData.custom_url ? addData.custom_url : requestManager.server_url) + url + params;
            this.loader.show();
            var postOpt = {
                method: addData && addData.method ? addData.method : "GET",
                url: addData && addData.completedUrl ? addData.completedUrl : url,
                contentType: addData && addData.contentType ? addData.contentType : "text/html; charset=ISO-8859-1",
                beforeSend: function (xhr) {
                    //xhr.setRequestHeader('Accept-Charset', 'ISO-8859-1');
                    //xhr.setRequestHeader('Content-Encoding', 'gzip');
                    //xhr.setRequestHeader('Content-Type', 'text/plain');
                    xhr.overrideMimeType('text/html; charset=ISO-8859-1');
                },
                success: function(response) {
                    requestManager.loader.hide();
                    if (success){
                        success(id, response);
                    }
                },
                error: function(jqXHR, textStatus, errorThrown ){
                    requestManager.loader.hide();
                    if (fail){
                        fail(id, jqXHR, textStatus, errorThrown);
                    }
                }
            };
            if (addData && addData.data) postOpt.data = addData.data;
            $.ajax(postOpt);

        },

        csvToObject: function(csv, splitter){ // parse csv string to object response
            var csvObj = Papa.parse(csv, {
                delimiter: '\n'
            }),
                parsedCsv = {};
            if (csvObj.data && csvObj.data.length > 0){
                for (var i=0; i < csvObj.data.length; i++){
                    if (csvObj.data[i] instanceof Array && csvObj.data[i].length > 0){
                        if (csvObj.data[i][0].search('#') != 0){
                            if (csvObj.data[i][0].search(requestManager.IDV_200) != -1){ // match if success occurs
                                parsedCsv.success = true;
                                continue;
                            }else if (csvObj.data[i][0].search(requestManager.IDV_744) != -1){ // match if session expiration timeout occurs
                                parsedCsv.errorCode = requestManager.IDV_744;
                                parsedCsv.error = true;
                                continue;
                            }else if (csvObj.data[i][0].search(requestManager.IDV_743) != -1){ // match if smth from params is missed
                                parsedCsv.errorCode = requestManager.IDV_743;
                                parsedCsv.error = true;
                                continue;
                            }
                            //console.log(csvObj.data[i][0]);
                            var arr = csvObj.data[i][0].split(splitter); // splitter is diff for all responses
                            if (arr.length > 1){
                                switch (arr[0]){
                                    case requestManager.IDV_SID:
                                        parsedCsv.sid = arr[1];
                                        break;
                                    case requestManager.IDV_CHALLENGE:
                                        parsedCsv.challandge = arr[1];
                                        break;
                                    case requestManager.IDV_FILIAL_ID:
                                        parsedCsv.list = csvObj.data.slice(i+1,csvObj.data.length-4);
                                        break;
                                    default:
                                }
                            }
                        }
                    }
                }
            }
            return parsedCsv;
        },

        formateChallandge: function(sid, challandge, callback){
            challandge = this.sid_prefix + (parseFloat(challandge) + this.challenge_value); // form string for md5 generation
            var auth = calcMD5(challandge);
            if (challandge.length > 0 && auth.length > 0){
                var url = this.API.auth;
                if (url.length > 0){
                    this.getData(this.IDD_AUTH, url, function(id, response){
                        var csvObj = requestManager.csvToObject(response, ' ');
                        if (csvObj.success){
                            if (csvObj.sid){
                                requestManager.SID = csvObj.sid;
                                storageManager.setItem(storageManager.IDK_SID, requestManager.SID); // store SID for further usage on other pages and requests
                                if (callback) callback();
                            }
                        }else if (csvObj.error){
                            // TODO show alert with error
                        }
                    }, null, { // send sid and generated md5 for approving of creating session
                        sid: sid,
                        auth: auth
                    });
                }
            }
        },

        initializeSession: function(callback){
            //console.log(this.SID);
            if (!this.SID){
                this.getData(this.IDD_INIT, this.API.init, function(id, response){
                    var csvObj = requestManager.csvToObject(response, ' ');
                    if (csvObj.success) {
                        if (csvObj.sid && csvObj.challandge){
                            requestManager.formateChallandge(csvObj.sid, csvObj.challandge, callback); // if session initialized is needed to send md5 for approving
                        }
                    }else if (csvObj.error){
                        // TODO show alert with error
                    }
                });
            }
        },
        reInitSession: function(callback){ // if SID timeout occurs is needed to initialize session again
            console.log("reInitSession");
            this.clearSession();
            this.initializeSession(callback);
        },
        clearSession: function(){ // for clearing session is needed to remove SID
            this.SID = null;
            window.storageManager.setItem(window.storageManager.IDV_SID, null)
        },
        initLoader: function(){ // loading information for showing request process
            if (!this.loader){
                this.loader = $('<div class="loaderCont"><img src="imgs/loading.gif" />');
                $('body').append(this.loader.hide());
            }
        },
        init: function(){
            this.initLoader();
            this.initializeSession(); // if SID is missed is needed to initialize session
            return this;
        }
    };
    return requestManager.init();
}