$(document).ready(function(){

    $('a, img').each(function(){
        $(this).attr('draggable','false'); // prevent drag and drop for links and images
    });

    $('.inp_cont').each(function(){ // initialize custom inputs
        var par = $(this),
            inp = par.find('input');
        if (inp.hasClass('lined')){
            inp.on('focus',function(){
                par.addClass('focused');
            });
            inp.on('blur',function(){
                par.removeClass('focused');
            });
        }
    });

    window.backBtn = $('#back_btn'); // initialize action for back buttons [data-href] provides info to change window.href
    if (window.backBtn.length > 0){
        window.backBtn.on('click', function(){
            if (window.backBtn.data('href')){
                window.location.href = backBtn.data('href');
            }
        });
    }

    try{
        window.storageManager = new StorageManager(); // initialize class for manipulating of localStorage
    }catch(err){
        console.log(err);
    }
    try{
        window.requestManager = new RequestManager(); // initialize class for server-side comunication
    }catch(err){
        console.log(err);
    }

    if (PAGE_ID){ // initialize additional classes belonged to diff pages
        switch (PAGE_ID){
            case "FORM":
                window.Form = new Form();
                break;
            case "SINGLE_SEARCH":
                window.Search = new Search();
                window.SingleSearch = new SingleSearch();
                break;
            case "SINGLE_FAVORITEN":
                window.Search = new Search();
                window.SingleFavoriten = new SingleFavoriten();
                break;
            case "SEARCH":
                window.Search = new Search();
                break;
            case "SEARCH_HISTORY":
                window.Search_history = new Search_history();
                break;
            case "FAVORITEN":
                window.Favoriten = new Favoriten();
                break;
            case "DETAIL_INFO":
                window.DetailInfo = new DetailInfo();
                break;
            case "MAP":
                window.Map = new Map();
                break;
            default:
        }
    }

    $('.history_back').on('click', function(e){
        e.preventDefault();
        history.back();
    });

});

$(window).resize(function(){
    if (typeof window.Search == "object"){
        window.Search.setResultBlockParams();
    }else if (typeof window.DetailInfo == "object"){
        window.DetailInfo.setContSize();
    }else if (typeof window.Map == "object"){
        window.Map.setMapContSize();
    }

});