function Search(){
    var search = {
        searchBtn: $('#search_btn'),
        placeInp: $('#where'),
        keywordsInp : $('#what'),
        isOpenChbx: $('#just_open'),
        saveSearchBtn: $('#save_search'),
        search_results: $('#search_results'),
        search_results_list: $('#search_results').find('ul'),
        trackPositionBtn: $('#track_position'),
        panel: $('#search_panel'),
        isSearchPage: PAGE_ID == "SINGLE_SEARCH" || PAGE_ID == "SEARCH",
        isGeneralSearchPage: PAGE_ID == "SEARCH",

        initClearInpAction: function(){ // clear value for form inputs
            var inpConts = $('.custom_input');
            if (inpConts.length > 0){
                inpConts.each(function(){
                    var inpCont = $(this),
                        inp = inpCont.find('input[type="text"]'),
                        clearContr = inpCont.find('a');
                    clearContr.on('click', function(e){
                        e.preventDefault();
                        inp.val('');
                    });
                });
            }
        },
        initPanel: function(){ // create sliding search panel
            if (this.panel.length > 0){
                var panelContr = this.panel.find('#panel_control');
                panelContr.on('click', function(e){
                    e.preventDefault();
                    search.togglePanel();
                });
            }else{
                delete this.panel;
            }
        },
        initSearchLayout: function(){
            if (this.search_results.length > 0) {
                this.setResultBlockParams();
                if (this.isSearchPage){ // disallow load data on scroll on favorite single list page (just review of saved stores)
                    search.search_results_list.scroll(function(e){
                        if($(this).scrollTop() + $(this).outerHeight() + 10 >= this.scrollHeight){
                            search.searchAction({
                                lat: search.searchLat,
                                lon: search.searchLon,
                                offset: search.searchOffset,
                                offenstatus: 1,
                                suche: search.searchSuche
                            });
                        }
                    });
                }
            }else{
                delete this.search_results;
            }
        },
        setResultBlockParams: function(){
            var cM, cH = 0;
            if (this.panel){
                cM = search.panel.outerHeight()*0.5;
                cH = $(window).outerHeight() - cM - $('header').outerHeight();
            }else{
                cH = $(window).outerHeight() - $('header').outerHeight();
            }
            this.search_results.css({marginTop: cM});
            this.search_results_list.outerHeight(cH);
        },
        togglePanel: function(){
            this.panel.toggleClass('collapsed'); // switch search panel mode
        },
        collapsePanel: function(){
            this.panel.addClass('collapsed'); // switch search panel mode to collapsed
        },
        expandPanel: function(){
            this.panel.removeClass('collapsed'); // switch search panel mode to expanded
        },
        checkCurrentLocation: function(success, error){
            if ("geolocation" in navigator) {
                window.requestManager.loader.show();
                navigator.geolocation.getCurrentPosition(function(position){
                    window.requestManager.loader.hide();
                    success(position);
                }, function(e){
                    window.requestManager.loader.hide();
                    switch(e.code) {
                        case e.PERMISSION_DENIED:
                            //console.log("User denied the request for Geolocation.");
                            PopUp.pp.alert("<p class='info'>User denied the request for Geolocation.</p>", "no_geo", {
                                ppTitle: 'Fehler!'
                            });
                            break;
                        case e.POSITION_UNAVAILABLE:
                            //console.log("Location information is unavailable.");
                            PopUp.pp.alert("<p class='info'>Location information is unavailable.</p>", "no_geo", {
                                ppTitle: 'Fehler!'
                            });
                            break;
                        case e.TIMEOUT:
                            //console.log("The request to get user location timed out.");
                            PopUp.pp.alert("<p class='info'>The request to get user location timed out.</p>", "no_geo", {
                                ppTitle: 'Fehler!'
                            });
                            break;
                        case e.UNKNOWN_ERROR:
                            //console.log("An unknown error occurred.");
                            PopUp.pp.alert("<p class='info'>An unknown error occurred.</p>", "no_geo", {
                                ppTitle: 'Fehler!'
                            });
                            break;
                        default:
                    }
                    //error();
                });
            } else {
                PopUp.pp.alert("<p class='info'>Geolocation is not supported by this browser.</p>", "no_geo", {
                    ppTitle: 'Fehler!'
                });
            }
        },
        initSearchBtn: function(){
            if (this.searchBtn.length > 0){
                this.searchBtn.on('click', function(e){
                    e.preventDefault();
                    if (search.placeInp.length == 0 || search.placeInp.val() == ""){ // check if place inp value is not missed
                        PopUp.pp.alert("<p class='info'>Es sind keine Filialen gefunden worden!</p>", "no_place", {
                            ppTitle: 'Fehler!'
                        })
                    }else{
                        var decodedAddress =  search.geocoder.geocode( { 'address': search.placeInp.val()}, function(results, status){ // decode place string to cords
                            if (status == google.maps.GeocoderStatus.OK) {
                                var result = results[0];
                                if (result.geometry.location){
                                    var latLang = [];
                                    for (var i in result.geometry.location){
                                        latLang.push(result.geometry.location[i])
                                    }
                                    search.searchPlace = search.placeInp.val();
                                    search.searchLat = latLang[0];
                                    search.searchLon = latLang[1];
                                    search.searchOffenstatus = search.isOpenChbx.is(':checked') ? 1 : 0;
                                    search.searchSuche = search.keywordsInp.val();
                                    search.searchOffset = 0;
                                    search.clearSearchList();
                                    console.log({
                                        lat: search.searchLat,
                                        lon: search.searchLon,
                                        offset: 0,
                                        offenstatus: 1,
                                        suche: encodeURIComponent(search.searchSuche)
                                    });
                                    search.searchAction({
                                        lat: search.searchLat,
                                        lon: search.searchLon,
                                        offset: 0,
                                        offenstatus: 1,
                                        suche: encodeURIComponent(search.searchSuche)
                                    });
                                }
                            }else {
                                console.log("Geocode was not successful for the following reason: " + status);
                            }
                        });
                    }
                });
            }else{
                delete this.searchBtn;
            }
        },
        searchAction: function(params){
            window.requestManager.getData(window.requestManager.IDD_SEARCH, window.requestManager.API.search, function(id, response){
                var csvObj = requestManager.csvToObject(response, ';');
                if (csvObj.success && csvObj.list && csvObj.list.length >0 ){
                    var idArr = "",
                        itemAdData = {};
                    for (var i=0;i < csvObj.list.length;i++){
                        var arr = csvObj.list[i][0].split(';'); // form specific string with item ids diveded with "|"
                        if (i!=csvObj.list.length-1){
                            idArr += arr[0] + '|';
                        }else{
                            idArr += arr[0];
                        }
                        itemAdData[arr[0]] = {
                            filial_id: arr[0],
                            entfernung: arr[1],
                            offenstatus : arr[2]
                        }
                    }
                    if (idArr.length > 0){
                        search.searchOffset += csvObj.list.length;
                        search.getListByID(idArr, itemAdData); // get nfo for items by them ids
                    }
                }else if (csvObj.list && csvObj.list.length == 0){
                    PopUp.pp.alert("<p class='info'>Es sind keine Filialen gefunden worden!</p>", "no_place", {
                        ppTitle: 'Fehler!'
                    })
                }
                else if (csvObj.error && csvObj.errorCode == window.requestManager.IDV_744){ // occurs if SID is not till valid, reinit session and repeat action
                    window.requestManager.reInitSession(function(){
                        search.searchAction(params);
                    });
                }
            }, null, {
                offset: params.offset, // position in list to add results from
                sid: window.requestManager.SID,
                query: 'gps',
                lat: params.lat,
                lon: params.lon,
                offenstatus: params.offenstatus, // just oped or not shops
                suche: params.suche  // keywords to search separated via coma
            });
        },
        getListByID: function(idArr, itemAdData){
            window.requestManager.getData(window.requestManager.IDD_LIST, window.requestManager.API.list, function(id, response){ // get info for items by its id
                var csvObj = requestManager.csvToObject(response, ';');
                if (csvObj.success){
                    if (csvObj.list && csvObj.list.length > 0){
                        search.search_results.fadeIn();
                        if (search.panel) search.collapsePanel();
                        for (var i = 0; i < csvObj.list.length; i++){
                            search.formSearchList(search.parseItemsData(csvObj.list[i][0]), itemAdData);
                        }
                    }
                }else if (csvObj.error && csvObj.errorCode == window.requestManager.IDV_744){ // occurs if SID is not till valid, reinit session and repeat action
                    window.requestManager.reInitSession(function(){
                        search.getListByID(idArr, itemAdData);
                    });
                }
            }, null, {
                sid: window.requestManager.SID,
                ids: idArr
            });
        },
        parseItemsData: function(itemString){ // parse item info + build search list from it
            //console.log(itemString);
            /*
            *Filial-ID;Name;Kurzname;Adresse;Hausnummer;PLZ;Stadt;Tel;Fax;Link;Staat;MontagAuf1;MontagZu1;MontagAuf2;MontagZu2;DienstagAuf1;DienstagZu1;DienstagAuf2;DienstagZu2;MittwochAuf1;MittwochZu1;MittwochAuf2;MittwochZu2;DonnerstagAuf1;DonnerstagZu1;DonnerstagAuf2;DonnerstagZu2;FreitagAuf1;FreitagZu1;FreitagAuf2;FreitagZu2;SamstagAuf1;SamstagZu1;SamstagAuf2;SamstagZu2;SonntagAuf1;SonntagZu1;SonntagAuf2;SonntagZu2;
             122780;;Europcar Autovermietung;Car Rental Pavilion;.;12521;Berlin;030 6349160;030 63491666;www.europcar.de/autovermietung-BERLIN_FLUGH.SCHOENEF..html;DE;07:00;23:30;;?3:30;;;07:00;23:30;;;07:00;23:30;;;07:00;23:30;;;08:00;23:00;;;08:00;23:00;;;
            *
            * */
            var itemData = itemString.split(';'),
                parsedData = {};
            if (itemData.length > 1){
                //console.log(itemData);
                parsedData.filialId =  itemData[0];
                parsedData.name =  itemData[1];
                parsedData.kurzname =  itemData[2];
                parsedData.adresse =  itemData[3];
                parsedData.hausnummer =  itemData[4];
                parsedData.plz =  itemData[5];
                parsedData.stadt =  itemData[6];
                parsedData.tel =  itemData[7];
                parsedData.fax =  itemData[8];
                parsedData.link =  itemData[9];
                parsedData.staat =  itemData[10];
                parsedData.montagauf1 =  itemData[11];
                parsedData.montagzu1 =  itemData[12];
                parsedData.montagauf2 =  itemData[13];
                parsedData.montagzu2 =  itemData[14];
                parsedData.dienstagauf1 =  itemData[15];
                parsedData.dienstagzu1 =  itemData[16];
                parsedData.dienstagauf2 =  itemData[17];
                parsedData.dienstagzu2 =  itemData[18];
                parsedData.mittwochauf1 =  itemData[19];
                parsedData.mittwochzu1 =  itemData[20];
                parsedData.mittwochauf2 =  itemData[21];
                parsedData.mittwochzu2 =  itemData[22];
                parsedData.donnerstagauf1 =  itemData[23];
                parsedData.donnerstagzu1 =  itemData[24];
                parsedData.donnerstagauf2 =  itemData[25];
                parsedData.donnerstagzu2 =  itemData[26];
                parsedData.freitagauf1 =  itemData[27];
                parsedData.freitagzu1 =  itemData[28];
                parsedData.freitagauf2 =  itemData[29];
                parsedData.freitagzu2 =  itemData[30];
                parsedData.samstagauf1 =  itemData[31];
                parsedData.samstagzu1 =  itemData[32];
                parsedData.samstagauf2 =  itemData[33];
                parsedData.samstagzu2 =  itemData[34];
                parsedData.sonntagauf1 =  itemData[35];
                parsedData.sonntagzu1 =  itemData[36];
                parsedData.sonntagauf2 =  itemData[37];
                parsedData.sonntagzu2 =  itemData[38];
            }
            return parsedData;
        },
        clearSearchList: function (){
            if (this.search_results_list.children().length > 0) this.search_results_list.html('')
        },
        formSearchList: function(itemData, itemAdData){
            if (!$.isEmptyObject(itemData)){
                if (itemAdData != null) itemAdData = itemAdData[itemData.filialId];
                if (search.searchOffenstatus == 1 && itemAdData.offenstatus == 0) return false;
                var item = $('<li><div></div></li>');
                this.search_results_list.append(item);
                var itemCont = item.find('div');

                if (itemData.kurzname != undefined) itemCont.prepend('<p>' + itemData.kurzname + '</p>');
                if (itemData.adresse != undefined){
                    var houseNum = itemData.hausnummer != undefined ? itemData.hausnummer : "",
                        stadt = itemData.stadt != undefined ? itemData.stadt : "";
                    itemCont.append('<p>' + itemData.adresse + ' ' + houseNum + ', ' + stadt + '</p>');
                }
                if (itemData.name != undefined) itemCont.append('<p>' + itemData.name + '</p>');

                if (itemAdData && !$.isEmptyObject(itemAdData)){
                    if (itemAdData.offenstatus != ""){
                        switch (parseFloat(itemAdData.offenstatus)){
                            case 1:
                                item.addClass('open');
                                break;
                            case 0:
                                item.addClass('closed');
                                break;
                            default:
                        }
                    }
                    if (itemAdData.entfernung != "") itemCont.append('<span>' + itemAdData.entfernung + ' km</span>');
                }

                item.on('click', function(){
                    window.storageManager.setItem(window.storageManager.IDK_DETAIL_INFO,{ // store all item data to storage for detail page usage
                        general: itemData,
                        additional: itemAdData
                    });
                    //console.log(window.storageManager.getItem(window.storageManager.IDK_DETAIL_INFO));
                    if (search.isGeneralSearchPage) { // if user is on search pages (single stored and general search) store params for usinf when returning from next page
                        window.storageManager.setItem(window.storageManager.IDK_SEARCH_PARAMS,{
                            lat: search.searchLat,
                            lon: search.searchLon,
                            offset: 0,
                            offenstatus: search.searchOffenstatus,
                            suche: search.searchSuche,
                            place: search.searchPlace
                        });
                    }
                    window.location.href = "detail_info.html";
                });
            }
        },
        checkStoredParams: function(){ // restore search status when coming form detail page
            if (this.isGeneralSearchPage){
                var storedParams = window.storageManager.getItem(window.storageManager.IDK_SEARCH_PARAMS);
                if (storedParams != null && !$.isEmptyObject(storedParams)){
                    search.searchPlace = storedParams.place; // synchronize store params with class variables
                    search.searchLat = storedParams.lat;
                    search.searchLon = storedParams.lon;
                    search.searchOffenstatus = storedParams.offenstatus;
                    search.searchSuche = storedParams.suche;
                    search.searchOffset = 0;
                    search.placeInp.val(search.searchPlace); // recover search params to search form
                    search.searchOffenstatus == 1 ? search.isOpenChbx.prop('checked','checked') : search.isOpenChbx.prop('checked', false);
                    search.keywordsInp.val(search.searchSuche);
                   this.searchAction({
                       lat: search.searchLat,
                       lon: search.searchLon,
                       offset: 0,
                       offenstatus: 1,
                       suche: search.searchSuche,
                       place: search.searchPlace
                   });
                    window.storageManager.setItem(window.storageManager.IDK_SEARCH_PARAMS, null); // clear stored params
                }
            }
        },
        initSaveSearchAction: function(){
            if (this.saveSearchBtn.length > 0){
                this.saveSearchBtn.on('click', function(e){
                    e.preventDefault();
                    PopUp.pp.confirm('<p class="info">Bitte gebe einen Namen fr die zu speichernde Suche an:</p><input type="text" id="list_label" tabindex="1" />',"createList",{
                        ppOkButton: function(){
                            window.storageManager.setItem(window.storageManager.IDK_SEARCH_LIST, {
                                keywords: search.searchSuche,
                                place: {
                                    lat: search.searchLat,
                                    lon: search.searchLon,
                                    place: search.searchPlace
                                },
                                label: $('#list_label').val(),
                                offenstatus: search.searchOffenstatus,
                                add: true
                            })
                        },
                        ppOkButtonText: "Speichern",
                        ppCancelButtonText: "Abbrechen"
                    });
                    $('#list_label').trigger('focus');
                });
            }else{
                delete this.saveSearchBtn;
            }
        },
        initGeocoder: function(){
            this.geocoder = new google.maps.Geocoder();
        },
        initTrackPositionAction: function(){
            if (this.trackPositionBtn.length > 0){
                this.trackPositionBtn.on('click', function(e){
                    e.preventDefault();
                    search.checkCurrentLocation(function(position){
                        search.geocoder.geocode(
                            {'latLng': new google.maps.LatLng(position.coords.latitude, position.coords.longitude)},
                            function(results, status) {
                                if (status == google.maps.GeocoderStatus.OK) {
                                    if (results[0]) {
                                        search.placeInp.val(results[0].formatted_address);
                                    }
                                    else  {
                                        console.log("address not found");
                                    }
                                }
                                else {
                                    console.log("Geocoder failed due to: " + status);
                                }
                            }
                        );
                    });
                });
            }else{
                delete this.trackPositionBtn;
            }
        },
        init: function(){
            this.initClearInpAction();
            this.initTrackPositionAction();
            this.initPanel();
            this.initSearchLayout();
            this.initSearchBtn();
            this.initGeocoder();
            this.initSaveSearchAction();
            this.checkStoredParams();
            return this;
        }
    }
    return search.init();
}