function Search_history(){
    var search_history = {
        editModeBtn: $('#edit_mode_btn'),
        emptyLayout: $('#no_results'),
        resultLayout: $('#search_history'),
        resultCont: $('#search_history').children('div'),

        editModeAction: function(){
          if (this.editModeBtn.length > 0){
              this.editModeBtn.on('click', function(e){
                  e.preventDefault();
                  search_history.toggleDeleteBtns();
              });
          }
        },
        toggleDeleteBtns: function(){
            this.editModeBtn.toggleClass('delete_mode');
            if (this.deleteBtns.length > 0){
                this.deleteBtns.toggle();
            }
        },
        initDeleteBtns: function(){
            this.deleteBtns = $('.delete_item');
            if (this.deleteBtns.length > 0){
                this.deleteBtns.each(function(){
                    var deleteBtn = $(this);
                    deleteBtn.on('click', function(){
                        PopUp.pp.confirm('<p class="info">'+deleteBtn.next().find('.label').text()+' wirklich lschen?</p>','confirmDelete',{
                            ppOkButton: function(){
                                window.storageManager.setItem(window.storageManager.IDK_SEARCH_LIST,{ // remove item form list in localdata by id
                                    id: deleteBtn.parent().index(),
                                    add: false
                                });
                                deleteBtn.parent().remove();
                                search_history.checkItemsCount();
                            },
                            ppOkButtonText: "Ja",
                            ppCancelButtonText: "Nein",
                            ppTitle: "Gesp. Suchen lschen"
                        });
                    });
                });
            }else{
                delete this.deleteBtns;
            }
        },
        storeSearchParams: function(itemData){
            window.storageManager.setItem(window.storageManager.IDK_SINGLE_SEARCH, itemData);
        },
        checkItemsCount: function(){
            if ($('.delete_item').length > 0){
                this.emptyLayout.hide();
                this.resultLayout.show();
            }else{
                this.emptyLayout.show();
                this.resultLayout.hide();
            }
        },
        checkSearchListInStorage: function (){ // read saved searches in local storage
            this.searchHistory = window.storageManager.getItem(window.storageManager.IDK_SEARCH_LIST);
            if (this.searchHistory != null && this.searchHistory.length > 0){
                for (var i = 0; i < this.searchHistory.length; i++){
                    if (!$.isEmptyObject(this.searchHistory[i])) this.formListItem(this.searchHistory[i]);
                }
            }else{
                delete this.searchHistory;
            }
        },

        formListItem: function(itemData){ // create list item form stored data
            var cont = $('<div class="inline-block">'),
                delBtn = $('<img src="imgs/ic_delete_item_btn.png" class="delete_item" />'),
                searchCntrl = $('<a href="#" class="btn blue large txtLeft search_control"><p class="label">'+itemData.label+'</p><p>Was:<span> '+itemData.keywords+'</span></p><p>Wo:<span> '+itemData.place.place+'</span></p><img src="imgs/ic_home_search.png" /></a>')
            this.resultCont.append(cont.append(delBtn, searchCntrl));
            searchCntrl.on('click', function(e){
                e.preventDefault();
                search_history.storeSearchParams(itemData); // store search params for usage on next page
                window.location.href = "single_search.html";
            });
        },

        init: function(){
            this.checkSearchListInStorage();
            this.editModeAction();
            this.initDeleteBtns();
            this.checkItemsCount();
            return this;
        }
    }
    return search_history.init();
}