function StorageManager(){
    var storage = {

        IDK_FAVORITE_LIST: 'favourite_list',
        IDK_SEARCH_LIST: 'search_list',
        IDK_SINGLE_SEARCH: 'single_search',
        IDK_SEARCH_PARAMS: 'search_params',
        IDK_DETAIL_INFO: 'detail_info',
        IDK_SID: 'sid',
        IDK_MAP_PLACE: 'map_place',
        IDK_FAVORITE_LIST_ITEM: 'favorite_list_item',
        IDK_FAVORITE_LIST_DETAILS: 'favorite_list_details',

        isSupported: function() {
            try {
                return 'localStorage' in window && window['localStorage'] !== null; // check if localStorage is supported in browser
            } catch(e){
                return false;
            }
        },
        setItem: function(key, data){
            var storageData;
            switch (key){
                case this.IDK_FAVORITE_LIST:
                    storageData = this.getItem(this.IDK_FAVORITE_LIST);
                    if (storageData == null){
                        storageData = [];
                    }
                    if (data != null){
                        if (data.add){ // check action for list
                            storageData[data.id] = data;
                        }else{
                            var index = storageData.indexOf(storageData[data.id]); // remove specific item form list
                            if (index > -1) {
                                storageData.splice(index, 1);
                            }
                            if (storageData.length == 0){
                                storageData = null;
                            }
                        }
                    }
                    break;

                case this.IDK_SEARCH_LIST:
                    storageData = this.getItem(this.IDK_SEARCH_LIST);
                    if (storageData == null){
                        storageData = [];
                    }
                    if (data != null){
                        if (data.add){ // check action for list
                            storageData[storageData.length.toString()] = data;
                        }else{
                            var index = storageData.indexOf(storageData[data.id]); // remove specific item form list
                            if (index > -1) {
                                storageData.splice(index, 1);
                            }
                            if (storageData.length == 0){
                                storageData = null;
                            }
                        }
                    }
                    break;
                case this.IDK_SINGLE_SEARCH:
                case this.IDK_SID:
                case this.IDK_DETAIL_INFO:
                case this.IDK_MAP_PLACE:
                case this.IDK_FAVORITE_LIST_ITEM:
                case this.IDK_FAVORITE_LIST_DETAILS:
                case this.IDK_SEARCH_PARAMS:
                    storageData = data;
                    break;
                default:
            }
            localStorage.setItem(key, JSON.stringify(storageData));
        },
        getItem: function(key){
            var data = localStorage.getItem(key);
            if (data != null && data.length > 0){
                return JSON.parse(data);
            }else{
                console.log('Item '+ key + ' not found in localStorage');
                return null;
            }
        },
        init: function(){
            if (!this.isSupported()){
                console.log("Local storage is not available.");
            }
            return storage;

        }
    };
    return storage.init()
}