/*

* app.js - Main application logic for EzOfficeInventory Mobile App
*

*/

$(function(){

    var phonegapAvailable   = false;       
    
    if (isMobileDevice()){
      document.addEventListener("deviceready", onDeviceReady, false);
    } else {
      onDeviceReady(); //this is the browser
    }

    viewmodels = {
        assetview:      new AssetViewModel(),
        inventoryview:  new InventoryViewModel(), 
        alertview:      new AlertViewModel(),
        assetlist:      new AssetsViewModel(),
        dashboard:      new DashboardViewModel(),
        locbox:         new LocationsBoxModel(),
        usersbox:       new UsersBoxModel(),
        groupbox:       new GroupBoxModel(),
        checkoutbox:    new CheckoutBoxModel(),
        checkinbox:     new CheckinBoxModel(),
        historyview:    new HistoryViewModel(),
        stockhistview:  new StockHistoryViewModel(),
        auditview:      new AuditViewModel(),
        vendorbox:      new VendorBoxModel()
    };
    

    ko.applyBindings(viewmodels);

    //call at load of each page
    
    $(document).ajaxStart(function() {
        $.mobile.showPageLoadingMsg("","loading...",true);
    });
    
    $(document).ajaxComplete(function() {
        $.mobile.hidePageLoadingMsg();
    });

    $('[data-role=page]').live('pageshow', function (event, ui) {
        try {
            _gaq.push(['_setAccount', 'UA-20639874-3']);

            hash = location.hash;

            if (hash) {
                _gaq.push(['_trackPageview', hash.substr(1)]);
            } else {
                _gaq.push(['_trackPageview']);
            }
            
            if(deviceType == "Android"){            
                window.plugins.analytics.trackPageView(hash.substr(1), function(){
                    console.log("Track: success");
                }, function(){
                    console.log("Track: failure");
                });
            }else{
                window.plugins.googleAnalyticsPlugin.trackPageview("/" + hash.substr(1));
            }
        } catch(err) {

        }

    });

    //Login to Server
    $('#login-form').bind('submit', function(e){
        e.preventDefault();
        e.stopPropagation();
        $('#login').trigger('tap');
    });
    $('#login').bind('tap', function( e, ui ){
        var formdata = $('#login-form').serialize();
        var formdataArray = $('#login-form :input').serializeArray();        
        if(getValFromSerializedArray('user[email]', formdataArray) !== '' && getValFromSerializedArray('user[password]', formdataArray) !== ''){
            var reqUrl;
            if(deviceType == "Android"){
                reqUrl = 'http://www'+ domain +'/tokens.json?device=android&version=' + version ;
            }
            else if(deviceType.match(/(iPhone|iPod|iPad)/)){
                reqUrl = 'http://www'+ domain +'/tokens.json?device=ios&version=' + version ;   
            }
            else if(deviceType.match(/(Firefox)/)){
                reqUrl = 'http://www'+ domain +'/tokens.json?device=ffos&version=' + version ;
            }
            else{
                reqUrl = 'http://www'+ domain +'/tokens.json?version=' + version ;   
            }
            var req = $.ajax({
                url: reqUrl,
                data: formdata,
                type: 'POST',
                dataType: 'json'
            });
            req.success(function(resp){
                //handle success scenario
                //Save the token / subdomain in Local storage
                window.localStorage.clear();
                var userResponse = JSON.parse(resp['user']);
                setData("token", userResponse.user.authentication_token);
                setData("user_id", userResponse.user.id);
                setData("role_id", userResponse.user.role_id);
                setData("name", userResponse.user.first_name + ' ' + userResponse.user.last_name);
                setData("subdomain", userResponse.user.companies[0].subdomain);
                setData("isarbitrated", userResponse.user.companies[0].is_arbitrated);
                
                viewmodels.dashboard.loggedInAs(getData("name"));
                if(getData("role_id") == '1'){
                    setData("adminView",true);
                    viewmodels.dashboard.adminView(true);
                }else{
                    viewmodels.dashboard.adminView(false);
                }
                //initApp();
                //Move to next Page
                if(!isMobileDevice()){
                    $('#scan-container').hide();
                }
                $.mobile.changePage('#dashboard');
                //check version of app
            });
            req.error(function(resp){
                //expire any stored data on failure
                $('#login-form #user_email').val('');
                $('#login-form #user_password').val('');
                window.localStorage.clear();
                companyLoaded = false;
                notificationAlert('invalid email or password');
            });      
        }else{
            notificationAlert('Email or Password cant be blank!!');
        }             
    }); 
    //Signout if logged In
    $('.signout-btn').bind("tap", function ( e, ui ){
        e.preventDefault();
        $('#login-form #user_email').val('');
        $('#login-form #user_password').val('');
        window.localStorage.clear();
        companyLoaded = false;
        $.mobile.changePage('#authenticate');
    });
    //Go back to home
    $('.home-btn').bind("tap", function( e, ui ){
        e.preventDefault();
        $.mobile.changePage('#dashboard');
    });
    $('.back-btn').bind("tap", function(e,ui){
        e.preventDefault();
        history.back();
    });
    
    $('#detail').delegate('#request-checkout', "tap", function(e,ui){
        e.preventDefault();
        var reqUrl = 'http://'+ getData('subdomain') + domain + '/assets/' + viewmodels.assetview.assetNumber() + '/request_checkout.json';
        var reqData = 'token=' + getData("token");
        $.get(reqUrl, reqData, function(resp, txtstatus, xhr){
            if(!isMobileDevice()){
                resp = JSON.parse(resp);
            }
            viewmodels.assetview.assetStatus(resp["asset"].state);
            notificationAlert('the checkout request was successfully sent');
        }).error(function(){
            notificationAlert('the checkout request could not be sent');
        });  
    });
    $('#checkout-box').delegate('#checkout', "tap", function(e,ui){
        e.preventDefault();
        var reqUrl = 'http://'+ getData('subdomain') + domain + '/assets/' + viewmodels.assetview.assetNumber() + '/checkout.json';            
        $('#checkout-form #token').val(getData("token"));
        var formdataArray = $('#checkout-form').serializeArray();
        var selLoc = viewmodels.locbox.selectedLocNewAsset();
        if(selLoc != undefined)
        {
            setValInSerializedArray('checkout_values[location_id]', selLoc.id, formdataArray);
        }
        var req = $.ajax({
            url: reqUrl,
            data: formdataArray,
            type: 'POST',
            dataType: 'json'
        });
        req.success(function(resp){
            viewmodels.assetview.assetStatus(resp["asset"].state);
            viewmodels.assetview.assigned(resp["asset"].assigned_to_id);
            viewmodels.assetview.assignedName(resp["asset"].assigned_to_user_name);
            notificationAlert('the asset was successfully checked out');
            $('#checkout-form').each(function(){
                this.reset();
            });
        });
        req.error(function(resp){
            notificationAlert('the asset could not be successfully checked out');
            $('#checkout-form').each(function(){
                this.reset();
            });
        });
    });
    $('#checkin-box').delegate('#checkin-submit', "tap", function(e,ui){
        e.preventDefault();
        var reqUrl = 'http://'+ getData('subdomain') + domain + '/assets/' + viewmodels.assetview.assetNumber();             
        if(getData("isarbitrated") == 1 && getData("role_id") != '1'){
            reqUrl = reqUrl + '/arbitrated_checkin_request.json';
        }else{
            reqUrl = reqUrl  + '/checkin.json';    
        }
        
        $('#checkin-form #token').val(getData("token"));
        var formdataArray = $('#checkin-form').serializeArray();
        var selLoc = viewmodels.locbox.selectedLocNewAsset();
        if(selLoc != undefined)
        {
            setValInSerializedArray('checkin_values[location_id]', selLoc.id, formdataArray);
        }
        var req = $.ajax({
            url: reqUrl,
            data: formdataArray,
            type: 'POST',
            dataType: 'json'
        });
        req.success(function(resp){
            viewmodels.assetview.assetStatus(resp["asset"].state);
            viewmodels.assetview.assetCheckInDue('');            
            if(getData("isarbitrated") == 1 && getData("role_id") != '1'){
                notificationAlert('the asset check in request was successfully sent');
            }else{
                notificationAlert('the asset was successfully checked in');
            }
            $('#checkin-form').each(function(){
                this.reset();
            });
        });
        req.error(function(resp){
            if(getData("isarbitrated") == 1 && getData("role_id") != '1'){
                notificationAlert('the asset check in request could not be sent');
            }else{
                notificationAlert('the asset could not be successfully checked in');
            }
            $('#checkout-in').each(function(){
                this.reset();
            });
        });
    });
    $('#extend-form').delegate('#extend', "tap", function(e,ui){
        e.preventDefault();
        var reqUrl  = 'http://'+ getData('subdomain') + domain + '/assets/' + viewmodels.assetview.assetNumber() + '/extend_checkout.json';
        $('#extend-form #token').val(getData("token"));
        var req = $.ajax({
            url: reqUrl,
            data: $('#extend-form').serialize(),
            type: 'POST',
            dataType: 'json'
        });
        req.success(function(resp){
            notificationAlert('the asset checkin date has been successfully extended');
        });
        req.error(function(resp){
            notificationAlert('the asset checkin could not be extended');
        });
    });
    $('#request-form').delegate('#request', "tap", function(e,ui){
        e.preventDefault();
        var reqUrl  = 'http://'+ getData('subdomain') + domain + '/assets/' + viewmodels.assetview.assetNumber() + '/request_checkin.json';
        $('#request-form #token').val(getData("token"));
        var req = $.ajax({
            url: reqUrl,
            data: $('#request-form').serialize(),
            type: 'POST',
            dataType: 'json'
        });
        req.success(function(resp){
            notificationAlert('the asset checkin request has been successfully sent');
        });
        req.error(function(resp){
            notificationAlert('the asset checkin request could not be sent');
        });
    });
    $('#inventory-detail').delegate('#stock-history-btn',"tap", function(e,ui){
        e.preventDefault();
        var reqUrl = 'http://'+ getData('subdomain') + domain + '/inventory/' + viewmodels.inventoryview.assetNumber() + '/history.json';
        var reqData = 'token=' + getData("token");
        $.get(reqUrl, reqData, function(resp, txtstatus, xhr){
            if(!isMobileDevice()){
                resp = JSON.parse(resp);
            }
            viewmodels.stockhistview.items.removeAll();
            viewmodels.stockhistview.name(viewmodels.inventoryview.assetName());
            $('#no_stock').html("");
            if(resp.length == 0){
                $('#no_stock').html("No history exists!");
            }
            for (var i = 0; i < resp.length; i++) {
                var selHistory = resp[i]["line_item"];
                 if(selHistory.quantity > 0){
                     var isstock = true; 
                     var message = "Stock of "+ selHistory.quantity +" item(s) ($" + parseFloat(selHistory.price).toFixed(2) + ") was added on " + frmtDate(selHistory.created_at, true) + " by " + selHistory.user_full_name;
                 }else{
                     var isstock = false;
                     var message = "Sale of "+ selHistory.quantity +" item(s) ($" + parseFloat(selHistory.price).toFixed(2) + ") on " + frmtDate(selHistory.created_at, true) + " by " + selHistory.user_full_name;
                 }
                viewmodels.stockhistview.items.push({message: message, sale:!isstock , stock:isstock });
            };
            $.mobile.changePage('#stock-history');
            $('.ui-listview').listview('refresh');
        }).error(function(resp){
            notificationAlert('could not fetch the stock history for this inventory');
        });
    });
    $('#detail').delegate('#history-btn', "tap", function(e,ui){
        e.preventDefault();
        var reqUrl = 'http://'+ getData('subdomain') + domain + '/assets/' + viewmodels.assetview.assetNumber() + '/history.json';
        var reqData = 'token=' + getData("token");
        $.get(reqUrl, reqData, function(resp, txtstatus, xhr){
            if(!isMobileDevice()){
                resp = JSON.parse(resp);
            }
            viewmodels.historyview.items.removeAll();
            viewmodels.historyview.name(viewmodels.assetview.assetName());
            $('#no_checkout').html("");
            if(resp.length == 0){
                $('#no_checkout').html("No history exists!");
            }
            for (var i = 0; i < resp.length; i++) {
                var selHistory = resp[i]["history"];
                if(selHistory.is_checkout){
                    var message = "Checked out on " + frmtDate(selHistory.created_at, true) + " to " + selHistory.assigned_to_name;
                }else{
                    var message = "Checked in on " + frmtDate(selHistory.created_at, true) + " from " + selHistory.assigned_to_name;
                }
                viewmodels.historyview.items.push({message: message, checkout: selHistory.is_checkout, checkin: !selHistory.is_checkout});
            };
            $.mobile.changePage('#history');
            $('.ui-listview').listview('refresh');
        }).error(function(resp){
            notificationAlert('could not fetch the check in/out history for this asset');
        });
    });
    $('#detail').delegate('#audit-btn', "tap", function(e,ui){
        e.preventDefault();
        var reqUrl = 'http://'+ getData('subdomain') + domain + '/assets/' + viewmodels.assetview.assetNumber() + '/audits.json';
        var reqData = 'token=' + getData("token");
        $.get(reqUrl, reqData, function(resp, txtstatus, xhr){
            viewmodels.auditview.items.removeAll();
            viewmodels.historyview.name(viewmodels.assetview.assetName());
            if(!isMobileDevice()){
                resp = JSON.parse(resp);
            }
            $('#no_audit').html("");
            if(resp.length == 0){
                $('#no_audit').html("No history exists!");
            }
            for (var i = 0; i < resp.length; i++) {
                var selAudit = resp[i]["audit"];
                if(selAudit.state == "closed"){
                    var message = "Audit initiated by " + selAudit.requested_by_name + " was closed by " + selAudit.closure_by_name + " on " + frmtDate(selAudit.closure_date, true);
                }else if(selAudit.state == "cancelled"){
                    var message = "Audit initiated by " + selAudit.requested_by_name + " was cancelled on " + frmtDate(selAudit.closure_date, true);
                }else{
                    var message = "Audit initiated by " + selAudit.requested_by_name + " is still pending on " + selAudit.assigned_to_name ;
                }
                viewmodels.auditview.items.push({message: message});
            };
            $.mobile.changePage('#audits');
            $('.ui-listview').listview('refresh');
        }).error(function(resp){
            notificationAlert('could not fetch the audit history for this asset');
        });
    });
    $('#detail').delegate('#print', "tap", function(e,ui){
        e.preventDefault();
        var reqUrl = 'http://' + getData('subdomain') + domain + '/qrcodes.json?asset_seq=' + viewmodels.assetview.assetNumber();
        var reqData = 'token=' + getData("token");
        $.post(reqUrl, reqData, function(resp, txtstatus, xhr){
            notificationAlert(resp.notice.toString());
        }).error(function(){
            notificationAlert('could not add the asset to print queue');
        });
    });

    $('#detail').delegate('#cancel-audit', "tap", function(e,ui){
        e.preventDefault();
        var reqUrl = 'http://'+ getData('subdomain') + domain + '/assets/' + viewmodels.assetview.assetNumber() + '/audits/' + viewmodels.assetview.audits()[0].id + '/cancel.json' ;
        var req = $.ajax({
            url: reqUrl,
            type: 'POST',
            data: 'token=' + getData("token") + '&_method=put',
            dataType: 'json'
        });
        req.success(function(resp){
            viewmodels.assetview.assetStatus(resp["state"]);
            notificationAlert('You have successfully cancelled the audit request');
        });
        req.error(function(resp){
            notificationAlert('There was problem in cancelling the audit request');
        });       
    });

    $('#detail').delegate('#acknowledge', "tap", function(e,ui){
        e.preventDefault();
        var reqUrl = 'http://'+ getData('subdomain') + domain + '/assets/' + viewmodels.assetview.assetNumber() + '/audits/' + viewmodels.assetview.audits()[0].id + '/acknowledge.json' ;
        var data = 'token=' + getData("token") + '&_method=put';
        var req = $.ajax({
            url: reqUrl,
            type: 'POST',
            data: data,
            dataType: 'json'
        });
        req.success(function(resp){

            if (!resp["success"]){
              notificationAlert(resp["message"].toString());
            }else if(viewmodels.assetview.audits()[0].photo_required || viewmodels.assetview.audits()[0].custom_required){
              $('#custom_note').html(" ");
              $('#custom_note').html(viewmodels.assetview.audits()[0].custom_note);
              $.mobile.changePage('#acknowledge-box', 'pop', true, true);
            }
            else{
                viewmodels.assetview.assetStatus(resp["state"]);
                notificationAlert('You have acknowledged the possesion of ' + viewmodels.assetview.assetName().toString());
            }
        });
        req.error(function(resp){
          notificationAlert('There was problem in acknowledgement of ' + viewmodels.assetview.assetName().toString());
        });       
    });

    $('#detail').delegate('#verifyPossession', "tap", function(e,ui){
        e.preventDefault();
        var reqUrl = 'http://'+ getData('subdomain') + domain + '/assets/' + viewmodels.assetview.assetNumber() + '/audits/' + viewmodels.assetview.assetNumber() + '/self_audit.json' ;
        var data = 'token=' + getData("token");
        var req = $.ajax({
            url: reqUrl,
            type: 'POST',
            data: data,
            dataType: 'json'
        });
        req.success(function(resp){
            if(!resp["success"]){
                notificationAlert(resp["message"].toString());
            }else{
                notificationAlert('You have acknowledged the possesion of ' + viewmodels.assetview.assetName().toString());
            }
        });
        req.error(function(resp){
            notificationAlert('There was problem in acknowledgement of ' + viewmodels.assetview.assetName().toString());
        });       
    });

    $('#inventory-detail').delegate('#print', "tap", function(e,ui){
        e.preventDefault();
        var reqUrl = 'http://' + getData('subdomain') + domain + '/qrcodes.json?asset_seq=' + viewmodels.inventoryview.assetNumber();
        var reqData = 'token=' + getData("token");
        $.post(reqUrl, reqData, function(resp, txtstatus, xhr){
            notificationAlert(resp.notice.toString());
        }).error(function(){
            notificationAlert('could not add the asset to print queue');
        });
    });


    $('#inventory-detail').delegate('#new-sale-btn', "tap", function(e,ui){
        e.preventDefault();
        var reqUrl = 'http://'+ getData('subdomain') + domain + '/locations/get_line_item_locations.json' ;
        var data = 'asset_action=New Sale' + '&asset_id=' + viewmodels.inventoryview.assetNumber() + '&token=' + getData("token");
        var req = $.ajax({
            url: reqUrl,
            type: 'GET',
            data: data,
            dataType: 'json'
        });

        req.success(function(resp){
          $("#company_location_select").html(" ");
          $("#company_location_select").append("<option selected='selected' value=''></option>");
          for(i=0 ; i < resp.length ; i++){
            $("#company_location_select").append('<option value="' + resp[i].location.id + '">'+resp[i].location.name +'</option>');
          }
          $.mobile.changePage('#new-sale-box','pop',true,true);
        });
        req.error(function(resp){
            notificationAlert('the sale of items could not be added');
        });      
    });


    $('#inventory-detail').delegate('#add-stock-btn', "tap", function(e,ui){
        e.preventDefault();
        var reqUrl = 'http://'+ getData('subdomain') + domain + '/locations/get_line_item_locations.json' ;
        var data = 'asset_action=New Purchase' + '&asset_id=' + viewmodels.inventoryview.assetNumber() + '&token=' + getData("token");
        var req = $.ajax({
            url: reqUrl,
            type: 'GET',
            data: data,
            dataType: 'json'
        });

        req.success(function(resp){
          $("#company_location_select1").html(" ");
          $("#company_location_select1").append("<option selected='selected' value=''></option>");
          for(i=0 ; i < resp.length ; i++){
            $("#company_location_select1").append('<option value="' + resp[i].location.id + '">'+resp[i].location.name +'</option>');
          }
          $.mobile.changePage('#add-stock-box','pop',true,true);
        });
        req.error(function(resp){
            notificationAlert('The stock of items could not be added');
        });      
    });

    $('#inventory-detail').delegate('#quant-loc-btn', "tap", function(e,ui){
        e.preventDefault();
        var reqUrl = 'http://'+ getData('subdomain') + domain + '/inventory/' + viewmodels.inventoryview.assetNumber() + '/quantity_by_location.json' ;
        var data = 'token=' + getData("token");
        var req = $.ajax({
            url: reqUrl,
            type: 'GET',
            data: data,
            dataType: 'json'
        });

        req.success(function(resp){
          $('#quant_by_loc').html("");
          $('#quant_by_loc').html(resp["quantity_by_location"]);
          $.mobile.changePage('#location-quantity-box','pop',true,true);
        });
        req.error(function(resp){
            notificationAlert('Could not fetch data');
        });      
    });

    $('#new-sale-box').delegate('#new-sale', "tap", function(e,ui){
        e.preventDefault();
        var reqUrl = 'http://' + getData('subdomain') + domain + '/inventory/' + viewmodels.inventoryview.assetNumber() + '/order.json'+'?token=' + getData("token");
        $('#new-sale-form #order_type').val('new sale');

        var req = $.ajax({
            url: reqUrl,
            data: $('#new-sale-form').serialize(),
            type: 'POST',
            dataType: 'json'  
        });
        req.success(function(resp){
            notificationAlert('The sale of items was successfully added');
        });
        req.error(function(resp){
            notificationAlert('The sale of items could not be added');
        });        
    });
    $('#add-stock-box').delegate('#add-stock', "tap", function(e,ui){
        e.preventDefault();
        var reqUrl = 'http://' + getData('subdomain') + domain + '/inventory/' + viewmodels.inventoryview.assetNumber() + '/order.json';
        $('#add-stock-form #token').val(getData("token"));
        $('#add-stock-form #order_type').val('add stock');
        var req = $.ajax({
            url: reqUrl,
            data: $('#add-stock-form').serialize(),
            type: 'POST',
            dataType: 'json'  
        });
        req.success(function(resp){
            notificationAlert('The stock of items was successfully added');
        });
        req.error(function(resp){
            notificationAlert('The stock of items could not be added');
        });
    });

    $('#request-reservation-box').delegate('#request-reservation', "tap", function(e,ui){
        e.preventDefault();
        var reqUrl = 'http://' + getData('subdomain') + domain + '/assets/' + viewmodels.assetview.assetNumber() + '/reservation_requests.json';
        $('#request-reservation-form #token').val(getData("token"));

        var req = $.ajax({
            url: reqUrl,
            data: $('#request-reservation-form').serialize(),
            type: 'POST',
            dataType: 'json'  
        });
        req.success(function(resp){
            notificationAlert('Reservation request has successfully been sent');
        });
        req.error(function(resp){
            notificationAlert('Reservation request could not be sent successfully');
        });
    });
    $('#request-audit-box').delegate('#request-audit', "tap", function(e,ui){
        e.preventDefault();
        var reqUrl = 'http://' + getData('subdomain') + domain + '/assets/' + viewmodels.assetview.assetNumber() + '/audits.json';
        $('#audit_form #token').val(getData("token"));
        var req = $.ajax({
            url: reqUrl,
            data: $('#audit_form').serialize(),
            type: 'POST',
            dataType: 'json'  
        });
        req.success(function(resp){
            notificationAlert('Audit request  has successfully been sent');
        });
        req.error(function(resp){
            notificationAlert('Audit request could not be sent successfully');
        });
    });


  $('#acknowledge-box').delegate('#acknowledge-btn', "tap", function(e,ui){
    e.preventDefault();
    var reqUrl = 'http://'+ getData('subdomain') + domain + '/assets/' + viewmodels.assetview.assetNumber() + '/audits/' + viewmodels.assetview.audits()[0].id + '/update_audit_for_app.json' ;
    var data = 'token=' + getData("token");
    var req = $.ajax({
        url: reqUrl,
        data: data,
        type: 'POST',
        dataType: 'json'  
    });
    req.success(function(resp){
        notificationAlert('You have acknowledged the possesion of ' + viewmodels.assetview.assetName().toString());
    });
    req.error(function(resp){
        notificationAlert('There was a problem in acknowledgement of ' + viewmodels.assetview.assetName().toString());
    });
});

  $('#acknowledge-box').delegate('#capture-btn', "tap", function(e,ui){
    e.preventDefault();
    navigator.camera.getPicture(uploadPhoto,reDirectToAssetPage,{sourceType:1,quality:50});

  });

  $('#acknowledge-box').delegate('#gallery-btn', "tap", function(e,ui){
    e.preventDefault();
    navigator.camera.getPicture(uploadPhoto,reDirectToAssetPage,{sourceType:0,quality:50});

  });

    $('.asset-filters').bind('tap',function(e,ui){
        e.preventDefault();
        $.mobile.changePage('#filters');
    });
    $('#available').bind('tap', function(e,ui){
        e.preventDefault();
        var query = new FilterQuery();
        query.assets_index = 'assets_index';        
        query.status = 'available';
        query.token  = getData("token");
        filterAssets(query);
    });
    $('#checkedout').bind('tap', function(e,ui){
        e.preventDefault();
        var query = new FilterQuery();
        query.assets_index = 'assets_index';        
        query.status = 'checked_out';
        query.token  = getData("token");
        filterAssets(query);
    });
    $('#auditpending').bind('tap', function(e,ui){
        e.preventDefault();
        var query = new FilterQuery();
        query.assets_index = 'assets_index';        
        query.status = 'pending_audit';
        query.token  = getData("token");
        filterAssets(query);
    });
    $('#retired').bind('tap', function(e,ui){
        e.preventDefault();
        var query = new FilterQuery();
        query.assets_index = 'assets_index';        
        query.status = 'retired';
        query.token  = getData("token");
        filterAssets(query);
    });
    $('#overdue').bind('tap', function(e,ui){
        e.preventDefault();
        var query = new FilterQuery();
        query.assets_index = 'assets_index';        
        query.status = 'overdue';
        query.token  = getData("token");
        filterAssets(query);
    });
    $('#fixed-asset').bind('tap', function(e,ui){
        e.preventDefault();
        viewmodels.assetlist.fixedFilterView(true);
        viewmodels.assetlist.inventoryFilterView(false);
        viewmodels.assetlist.filterView(false);
        viewmodels.assetlist.page(1);
        var reqData = 'token=' + getData("token")+ "&show=fixed_assets";
        var assetsUrl = 'http://'+ getData('subdomain') + domain + '/assets.json';
        
        $.get(assetsUrl, reqData, function(resp, txtstatus, xhr){
            if(!isMobileDevice()){
                resp = JSON.parse(resp);
            }
            viewmodels.assetlist.assets.removeAll();
            
            var assets = resp.assets;
            //var assets = resp;
            for (var i = 0; i < assets.length; i++) {
                var selAsset = assets[i]["asset"];
                selAsset.path = 'http://' + getData('subdomain') + domain + '/assets/' + selAsset.sequence_num + '.json';
                selAsset.isAssigned = selAsset.assigned_to_user_name == null ? false : true;
                selAsset.isFixedAsset = true;
                viewmodels.assetlist.assets.push(selAsset);
            };                
            viewmodels.assetlist.total_pages(resp.total_pages);
            $.mobile.changePage('#assets');
            $('.ui-listview').listview('refresh');
        }).error(function(){
            notificationAlert('the asset list could not be retrieved');
        });
    });

    $('#inventory-filter').bind('tap', function(e,ui){
        e.preventDefault();
        viewmodels.assetlist.inventoryFilterView(true);
        viewmodels.assetlist.fixedFilterView(false);
        viewmodels.assetlist.filterView(false);
        viewmodels.assetlist.page(1);
        var reqData = 'token=' + getData("token")+ "&show=volatile_assets";
        var assetsUrl = 'http://'+ getData('subdomain') + domain + '/assets.json';
        
        $.get(assetsUrl, reqData, function(resp, txtstatus, xhr){
            if(!isMobileDevice()){
                resp = JSON.parse(resp);
            }
            viewmodels.assetlist.assets.removeAll();
            
            var assets = resp.assets;
            //var assets = resp;
            for (var i = 0; i < assets.length; i++) {
                var selAsset = assets[i]["asset"];
                selAsset.path = 'http://' + getData('subdomain') + domain + '/inventory/' + selAsset.sequence_num + '.json';
                //selAsset.isAssigned = selAsset.assigned_to_user_name == null ? false : true;
                selAsset.isVolatileAsset = true;
                viewmodels.assetlist.assets.push(selAsset);
            };                
            viewmodels.assetlist.total_pages(resp.total_pages);
            $.mobile.changePage('#assets');
            $('.ui-listview').listview('refresh');
        }).error(function(){
            notificationAlert('the asset list could not be retrieved');
        });
    });
    
    $('#searchAssets').bind('tap', function(e,ui){
        e.preventDefault();
        viewmodels.assetlist.assets.removeAll();
        $('#search-form')[0].reset();
        $('#search-results').html(" ");
        $.mobile.changePage("#search-asset");
    });
    $('#search-form').bind('submit', function(e){
        e.preventDefault();
        e.stopPropagation();
        $('#search').trigger('tap');
    });

    $('#search').bind('tap', function(e){
        var formdata = $('#search-form').serialize();
        var formdataArray = $('#search-form :input').serializeArray();
        var search = getValFromSerializedArray('search[content]', formdataArray);        
        var reqData = 'token=' + getData("token")+ "&search="+search;
        viewmodels.assetlist.filterView(false); 
        viewmodels.assetlist.queryObject(null);
        viewmodels.assetlist.page(1);        
        if(search != ''){
            var reqUrl = 'http://'+ getData('subdomain') + domain +'/mobilesearch.json';
            $.get(reqUrl, reqData, function(resp, txtstatus, xhr){
                if(!isMobileDevice()){
                    resp = JSON.parse(resp);
                }
                viewmodels.assetlist.assets.removeAll();
                if(getData("role_id") == '1'){
                    viewmodels.assetlist.adminView(true);
                }else{
                    viewmodels.assetlist.adminView(false);
                }
                var assets = resp.results;
                if(assets.length==0){
                    $('#search-results').html("No results found!");
                }
                for (var i = 0; i < assets.length; i++) {
                    var selAsset = assets[i]["asset"];
                    selAsset.path = 'http://' + getData('subdomain') + domain + '/assets/' + selAsset.sequence_num + '.json';
                    selAsset.isAssigned = selAsset.assigned_to_user_name == null ? false : true;
                    selAsset.isFixedAsset = selAsset.asset_type == "FixedAsset" ? true : false;
                    selAsset.isVolatileAsset = selAsset.asset_type == "VolatileAsset" ? true : false;
                    viewmodels.assetlist.assets.push(selAsset);
                };                
                $('.ui-listview').listview('refresh');
            }).error(function(){
                notificationAlert('data could not be loaded');
            });     
        }else{
            notificationAlert('Search cant be blank');
        }
    });

    $('#create-asset,#create-volatile-asset').live('pageshow', function(e,ui){
        e.preventDefault();
        var tappedButton = this.id;
        var reqUrl;
        if(tappedButton == "create-asset")
        {
            reqUrl = 'http://'+ getData('subdomain') + domain +'/assets/new.json';
        }else{
            reqUrl = 'http://'+ getData('subdomain') + domain +'/inventory/new.json';
        }
        var reqData = 'token=' + getData("token");
            $.get(reqUrl, reqData, function(resp, txtstatus, xhr){
                if(!isMobileDevice()){
                    resp = JSON.parse(resp);
                }
                if(tappedButton == "create_asset"){
                    $('#create-asset-form').each(function(){
                        this.reset();
                    });
                }else{
                    $('#create-volatile-asset-form').each(function(){
                        this.reset();
                    });
                }
                $('#cust_attr,#cust_attr_volatile').html(" ");
                $('#cust_attr,#cust_attr_volatile').append(resp["view"]);
                var custom_html = $('#custom_attribute_form_FixedAsset,#custom_attribute_form_VolatileAsset').html();    
                $('#cust_attr,#cust_attr_volatile').html(" ");
                $('#cust_attr,#cust_attr_volatile').append(custom_html);
                $('#cust_attr,#cust_attr_volatile').trigger("create");
                if(tappedButton == "create-asset"){
                    var currentTime = new Date();
                    var month = currentTime.getMonth() + 1;
                    var date = currentTime.getFullYear() + "-" + month + "-" + currentTime.getDate();
                    $('#asset_purchased').trigger('datebox', {'method':'set', 'value':date});
                }
            }).error(function(){
                notificationAlert('data could not be loaded');
            });
    });

    $('#add_identifier,#add_identifier_volatile').bind('tap', function(e,ui){
        e.preventDefault();
        $('#add_identifier,#add_identifier_volatile').hide();
        $('#asset_identifier_number,#asset_identifier_number_volatile').show();
    });

    $('#remove_identifier,#remove_identifier_volatile').bind('tap', function(e,ui){
        e.preventDefault();
        $('#asset_identifier_number,#asset_identifier_number_volatile').hide();
        $('#add_identifier,#add_identifier_volatile').show();
    });

    $('#asset_group,#volatile_asset_group').bind('change',function(e,ui){
        e.preventDefault();
        var selGroup = viewmodels.groupbox.selectedGroupNewAsset();

        if(selGroup != undefined && viewmodels.dashboard.isAdmin() && (($.mobile.activePage.data('url')) == "create-asset" || ($.mobile.activePage.data('url')) == "create-volatile-asset"))
        {
            data = "group=" + selGroup.id;
            if(this.id == "asset_group"){
                data = data + "&asset=new&type=FixedAsset";
            }else{
                data = data + "&asset=new&type=VolatileAsset";
            }
            var reqUrl = 'http://'+ getData('subdomain') + domain +'/assets/change_group.json'; 
            var req = $.ajax({
                type: "GET", 
                url: reqUrl, 
                data: data + '&token=' + getData("token")
            });
            req.success(function(resp){
                if(!isMobileDevice()){
                    resp = JSON.parse(resp);
                }
                $('#cust_attr,#cust_attr_volatile').empty();
                $('#cust_attr,#cust_attr_volatile').append(resp["view"]);
                var custom_html = $('#custom_attribute_form_FixedAsset,#custom_attribute_form_VolatileAsset').html();    
                $('#cust_attr,#cust_attr_volatile').empty();
                $('#cust_attr,#cust_attr_volatile').append(custom_html);
                $('#cust_attr,#cust_attr_volatile').trigger("create");
            });
            req.error(function(resp){
                notificationAlert('data could not be loaded');
            });
        }
    });

    $('#create-asset-form,#create-volatile-asset-form').bind('submit', function(e){
        e.preventDefault();
        e.stopPropagation();
        if(this.id == "create-asset-form"){
            $('#create_asset_submit').trigger('tap');
        }else{
            $('#create_volatile_asset_submit').trigger('tap');
        }
    });
    $('#create_asset_submit').bind('tap', function( e, ui ){
        e.preventDefault();
        var formdataArray = $('#create-asset-form').serializeArray();
        var selGroup = viewmodels.groupbox.selectedGroupNewAsset();
        if(selGroup != undefined)
        {
            setValInSerializedArray('fixed_asset[group_id]', selGroup.id, formdataArray);
        }
        var selLoc = viewmodels.locbox.selectedLocNewAsset();
        if(selLoc != undefined)
        {
            setValInSerializedArray('fixed_asset[location_id]', selLoc.id, formdataArray);
        }
        var selVendor = viewmodels.vendorbox.selectedVendorNewAsset();
        if(selVendor != undefined)
        {
            setValInSerializedArray('fixed_asset[vendor_id]', selVendor.id, formdataArray);
        }

        var reqUrl = 'http://'+ getData('subdomain') + domain +'/assets.json?token=' + getData("token");
        var req = $.ajax({
            url: reqUrl,
            data: formdataArray,
            type: 'POST', 
            dataType: 'json'
        });
        var message;
        req.success(function(resp){
            if(resp["success"]){
                notificationAlert(resp["message"].toString());
                var asset = JSON.parse(resp["asset"]);
                viewmodels.assetview.update(asset["asset"]);
                $.mobile.changePage("#detail");
            }
            else{
                notificationAlert(resp["errors"].toString());
            }
        });
        req.error(function(resp){
            notificationAlert('data could not be loaded');
        });                   
    });

    $('#create_volatile_asset_submit').bind('tap', function( e, ui ){
        e.preventDefault();
        var formdataArray = $('#create-volatile-asset-form').serializeArray();
        var selGroup = viewmodels.groupbox.selectedGroupNewAsset();
        if(selGroup != undefined)
        {
            setValInSerializedArray('volatile_asset[group_id]', selGroup.id, formdataArray);
        }
        var selLoc = viewmodels.locbox.selectedLocNewAsset();
        if(selLoc != undefined)
        {
            setValInSerializedArray('volatile_asset[location_id]', selLoc.id, formdataArray);
        }
        var selVendor = viewmodels.vendorbox.selectedVendorNewAsset();
        if(selVendor != undefined)
        {
            setValInSerializedArray('volatile_asset[vendor_id]', selVendor.id, formdataArray);
        }

        var reqUrl = 'http://'+ getData('subdomain') + domain +'/inventory.json?token=' + getData("token"); 
        var req = $.ajax({
            url: reqUrl,
            data: formdataArray,
            type: 'POST', 
            dataType: 'json'
        });
        req.success(function(resp){
            if(resp["success"]){
                notificationAlert(resp["message"].toString());
                var asset = JSON.parse(resp["asset"]);
                viewmodels.inventoryview.update(asset["asset"]);
                $.mobile.changePage("#inventory-detail");
            }
            else{
                notificationAlert(resp["errors"].toString());
            }
        });
        req.error(function(resp){
            notificationAlert(resp["errors"].toString());
        });                   
    });

    $('#scan-idf,#scan-idf-volatile').bind('tap', function (e,ui){
       e.preventDefault();
       //call PhoneGap 
       window.plugins.barcodeScanner.scan(
        function( res ){
            if(res.cancelled){
                // Dont do anything here                
            }else{
                var barcodeFormats = ['CODE_128', 'DATA_MATRIX', 'UPC_E', 'UPC_A', 'EAN_8', 'EAN_13', 'CODE_39', 'CODE_93', 'CODABAR', 'ITF', 'RSS14', 'PDF417', 'RSS_EXPANDED'];
                if(res.format != 'QR_CODE'){
                    if(barcodeFormats.indexOf(res.format) == -1){
                        notificationAlert('Unsupported  Barcode / QR Code Format');
                        return;    
                    }
                }
                if(res.format != 'QR_CODE'){
                    var ain = res.text;
                    $('#asset_identifier').val(ain);
                    $.mobile.changePage("#create-asset");
                }         
            }           
        },
        function( error ){
            //console.log("Scan failed:" + error);
        });               
    });

    $('.list-assets').bind('tap', function(e,ui){
        e.preventDefault();
        
        var reqData = 'token=' + getData("token");
        var assetsUrl = 'http://'+ getData('subdomain') + domain + '/assets.json';
        
        viewmodels.assetlist.filterView(false);
        viewmodels.assetlist.fixedFilterView(false);
        viewmodels.assetlist.inventoryFilterView(false); 
        viewmodels.assetlist.queryObject(null);
        viewmodels.assetlist.page(1);
        $.get(assetsUrl, reqData, function(resp, txtstatus, xhr){
            if(!isMobileDevice()){
                resp = JSON.parse(resp);
            }
            viewmodels.assetlist.assets.removeAll();
            if(getData("role_id") == '1'){
                viewmodels.assetlist.adminView(true);
            }else{
                viewmodels.assetlist.adminView(false);
            }

            var assets = resp.assets;
            //var assets = resp;
            for (var i = 0; i < assets.length; i++) {
                var selAsset = assets[i]["asset"];
                selAsset.path = 'http://' + getData('subdomain') + domain + '/assets/' + selAsset.sequence_num + '.json';
                selAsset.isAssigned = selAsset.assigned_to_user_name == null ? false : true;
                selAsset.isFixedAsset = selAsset.asset_type == "FixedAsset" ? true : false;
                selAsset.isVolatileAsset = selAsset.asset_type == "VolatileAsset" ? true : false;
                viewmodels.assetlist.assets.push(selAsset);
            };              
            viewmodels.assetlist.total_pages(resp.total_pages);
            $.mobile.changePage('#assets');
            $('.ui-listview').listview('refresh');
        }).error(function(){
            notificationAlert('the asset list could not be retrieved');
        });
    });
    //scan a QR Code via Device Camera
    $('#scan').bind('tap', function (e,ui){
       e.preventDefault();
       //call PhoneGap 
       window.plugins.barcodeScanner.scan(
        function( res ){
            if(res.cancelled){
                // Dont do anything here                
            }else{
                var barcodeFormats = ['CODE_128', 'DATA_MATRIX', 'UPC_E', 'UPC_A', 'EAN_8', 'EAN_13', 'CODE_39', 'CODE_93', 'CODABAR', 'ITF', 'RSS14', 'PDF417', 'RSS_EXPANDED'];
                if(res.format != 'QR_CODE'){
                    if(barcodeFormats.indexOf(res.format) == -1){
                        notificationAlert('Unsupported  Barcode / QR Code Format');
                        return;    
                    }
                }

                if(res.format != 'QR_CODE'){
                    var ain = res.text;
                    var fullScannedUrl = 'http://' + getData('subdomain') + domain + '/lookup.json?identifier=' + ain;
                }else{
                    if(!isUrl(res.text)){
                        notificationAlert('QR Code does not contain a URL');
                        return;
                    }else{
                        var parsedUrl = $.mobile.path.parseUrl(res.text);
                        var fullScannedUrl = parsedUrl.domain + parsedUrl.pathname + ".json" + parsedUrl.search;       
                    }    
                }
                setData('fullScannedUrl',fullScannedUrl);
                if(navigator.geolocation){
                   navigator.geolocation.getCurrentPosition(savePosition,showError,{ enableHighAccuracy: true });
                }        
            }           
        },
        function( error ){
            notificationAlert('some error occured while scanning');
        }
        );
    });
    $('.custom_attr_history').live('tap',function (e,ui){
        e.preventDefault();
        var reqData = 'token=' + getData("token");
        var assetUrl = 'http://'+ getData('subdomain') + domain + '/assets/' + viewmodels.assetview.assetNumber() + '/custom_attribute_history.json?custom_attribute_id=' + this.id.match(/\d+/);
        $.get(assetUrl, reqData, function(resp, txtstatus, xhr){
            if(!isMobileDevice()){
                resp = JSON.parse(resp);
            }
            $('#custom_history').html(" ");
            $('#custom_history').html(resp["view"]);
            $.mobile.changePage('#custom-attr-history-box');
        }).error(function(){
            notificationAlert('the history could not be retrieved');
        });
    });              
});

// Lifecycle functions

function onDeviceReady(){ 
    phonegapAvailable = true;
    document.addEventListener("backbutton", bbkeydown, true);

    if(deviceType == "Android"){
        window.plugins.analytics.start("UA-20639874-3", function(){
            console.log("Analytics: start success");
        }, function(){
            console.log("Analytics: start failure");
        });
    }
    else if (deviceType.match(/(iPhone|iPod|iPad)/)){
        window.plugins.googleAnalyticsPlugin.startTrackerWithAccountID("UA-20639874-3");
    }
    else{

    } 

    if (isMobileDevice()){
        if(checkIfLoggedIn()){
            viewmodels.dashboard.loggedInAs(getData("name"));
            viewmodels.dashboard.adminView(getData("adminView"));
            $.mobile.changePage('#dashboard');        
        }else{
            $.mobile.changePage('#authenticate');
            $('#login').button('enable');
            $('#login').button('refresh');        
        }
    }else{
        $.mobile.changePage('#authenticate');
    }
}
//cleanup in case of failure
function cleanupAndExit(){
    window.localStorage.clear();
    navigator.app.exitApp();
}

function reDirectToAssetPage(){
  notificationAlert('You have closed the action');
}

function uploadPhoto(imageURI){

    var options = new FileUploadOptions();
    options.chunkedMode = false;
    options.fileKey= "audit[photo]";
    options.fileName=imageURI.substr(imageURI.lastIndexOf('/')+1);
    options.mimeType="image/jpeg";
    var ft = new FileTransfer();
    $.mobile.showPageLoadingMsg("","FIle Uploading...",true);
    ft.upload(imageURI, 'http://'+ getData('subdomain') + domain + '/assets/' + viewmodels.assetview.assetNumber() + '/audits/' + viewmodels.assetview.audits()[0].id + '/update_audit_for_app.json' + '?token=' + getData('token'), onUpload, fail, options, true);

}


function onUpload(r) {
  $.mobile.hidePageLoadingMsg();
  notificationAlert('You have acknowledged the possesion of ' + viewmodels.assetview.assetName().toString());
}

function fail(error) {
    $.mobile.hidePageLoadingMsg();
    notificationAlert('There was a problem in acknowledgement of ' + viewmodels.assetview.assetName().toString());
}

function savePosition(position)
{
  latitude = position.coords.latitude;
  longitude = position.coords.longitude;
  getAssetDetailsAfterScan(latitude,longitude,true);
}

function showError(error)
{
  getAssetDetailsAfterScan(-1,-1,false);
}

function getAssetDetailsAfterScan(lat, long, resp)
{
  var reqData;
  if(resp){
   reqData = 'token=' + getData("token") + '&version='+version +'&from_scan_method=1' + '&latitude=' +lat+ '&longitude=' + long;
  }
  else{
   reqData = 'token=' + getData("token") + '&version='+version +'&from_scan_method=1';
  }
  var fullScannedUrl = getData('fullScannedUrl');
  $.get(fullScannedUrl, reqData, function(resp, txtstatus, xhr){                   
    //populate the detail page
    var asset=JSON.parse(resp["asset"]);           
    if(asset["asset"].asset_type == "FixedAsset"){                                           
        viewmodels.assetview.update(asset["asset"]);
        $.mobile.changePage('#detail');
    }else{
        viewmodels.inventoryview.update(asset["asset"]);
        $.mobile.changePage('#inventory-detail');
    }                    
  }).error(function(resp){
    if(resp["status"] == 403){
        notificationAlert('Invalid url / value scanned');    
    }else{
        notificationAlert('there was an error in fetching data'); 
    }  
  });
}

function setCustomAttributesForCheckInDialog(resp){
    $('#checkin-box #custom_attr_checkin').html(resp["custom_attribute_checkin"]).trigger('create');
    viewmodels.checkinbox.showLocationCheckIn(resp["show_location_checkin"]);
    viewmodels.checkinbox.locationEditable(resp["location_editable"]);
}

$( '#dashboard' ).live('pageshow',function(event){
    try{
        initApp();
    }catch(e){
        navigator.notification.alert(
            'Could not load data from server, Please try again',
            cleanupAndExit,
            'API Error',
            'Ok'
        );
    }
});

function notificationAlert(message){
    if (isMobileDevice()){
      navigator.notification.alert(
        message,
        $('.ui-dialog').dialog('close'),
        'Notice',
        'Ok'
      );
    }else{
        alert(message);
        $('.ui-dialog').dialog('close');
    }
}


$('#detail').live('pageshow', function(event){
    try{
        var reqData = 'token=' + getData("token") + '&version='+version;    
        $.get(viewmodels.assetview.assetPath(), reqData, function(resp, txtstatus, xhr){
            if(!isMobileDevice()){
                resp = JSON.parse(resp);
            }
            var asset = resp["asset"];
            asset = JSON.parse(asset);
            viewmodels.assetview.update(asset["asset"]);  
            $('#custom_attribute').html(" ");
            $('#custom_attribute').html(resp["view"]);
            $('h5').remove();
            $('#reservations').html(" ");
            $('#reservations').html(resp["request_reservations"]);
            $('#checkout-box #custom_attr_checkout').html(" ");
            $('#checkout-box #custom_attr_checkout').html(resp["custom_attribute_checkout"]).trigger('create');
            viewmodels.checkoutbox.showLocation(resp["show_location"]);
            viewmodels.checkoutbox.locationEditable(resp["location_editable"]);
            setCustomAttributesForCheckInDialog(resp);
        }).error(function(){
            notificationAlert('couldnt fetch details for this asset');
        });
    }catch(e){
        navigator.notification.alert(
            'some thing went wrong while loading data from server, Please try again',
            cleanupAndExit,
            'API Error',
            'Ok'
        );   
    }
});

$('#inventory-detail').live('pageshow', function(event){
    try{
        var reqData = 'token=' + getData("token") + '&version='+version;        
        $.get(viewmodels.inventoryview.inventoryPath(), reqData, function(resp, txtstatus, xhr){
            if(!isMobileDevice()){
                resp = JSON.parse(resp);
            }
            var asset=JSON.parse(resp["asset"]);
            viewmodels.inventoryview.update(asset["asset"]);
            $('#custom_attribute_invent').html(" ");
            $('#custom_attribute_invent').html(resp["view"]);
            $('h5').remove();
        }).error(function(){
            notificationAlert('couldnt fetch details for this inventory');
        });
    }catch(e){
        navigator.notification.alert(
            'some thing went wrong while loading data from server, Please try again',
            cleanupAndExit,
            'API Error',
            'Ok'
        );   
    }
});

//Backbutton handling for Android wouldn't work on iOS
function bbkeydown(){
    if($('.ui-page-active').attr('id') == 'dashboard' || $('.ui-page-active').attr('id') == 'authenticate'){
        navigator.app.exitApp();
    }else{
        navigator.app.backHistory();
    }
}

function initApp(){
    reqUrl  = 'http://'+ getData('subdomain') + domain + '/mobile/data.json'; 
    reqData = 'token=' + getData("token") + '&version='+ version;
    if(!companyLoaded){
        $.get(reqUrl, reqData, function(resp, txtstatus, xhr){
            if(resp.show){
              notificationAlert(resp.message.toString());
            }

            var canSelfAudit;
            if (isMobileDevice()){
                canSelfAudit = JSON.parse(resp['can_self_audit']);
            }else{
                resp = JSON.parse(resp);
                canSelfAudit = resp.can_self_audit;
            }
            setData("canselfaudit",canSelfAudit);

            if(resp.members == undefined){ 
                throw "undefined";
            }else{
                viewmodels.usersbox.users.removeAll();
                viewmodels.checkoutbox.users.removeAll();
                var members = resp.members;
                for (var i = 0; i < members.length; i++) {
                    var selMember = members[i]["user"];
                    viewmodels.usersbox.users.push(selMember);
                    viewmodels.checkoutbox.users.push(selMember);
                    if(selMember.id == getData("user_id")){
                        viewmodels.checkoutbox.selectedUser(selMember);
                    }
                };    
            }
            
            if(resp.groups == undefined){
                throw "undefined";
            }else{
                viewmodels.groupbox.groups.removeAll();
                var groups  = resp.groups; 
                for (var i = 0; i < groups.length; i++) {
                    var selGroup = groups[i]["group"];
                    viewmodels.groupbox.groups.push(selGroup);
                };   
            }
            
            if(resp.locations == undefined){
                throw "undefined";
            }else{
                viewmodels.locbox.locations.removeAll();
                var locations   = resp.locations;
                for (var i = 0; i < locations.length; i++) {
                    var selLocation = locations[i]["location"];
                    viewmodels.locbox.locations.push(selLocation);
                };
            }

            if(resp.vendors == undefined){
                throw "undefined";
            }else{
                viewmodels.vendorbox.vendors.removeAll();
                var vendors   = resp.vendors;
                for (var i = 0; i < vendors.length; i++) {
                    var selVendor = vendors[i]["vendor"];
                    viewmodels.vendorbox.vendors.push(selVendor);
                };
            }
            viewmodels.groupbox.selectedGroupNewAsset(viewmodels.groupbox.groups()[0].name);
            companyLoaded = true;        
        }).error(function(){
            navigator.notification.alert(
                'Could not load data from server, Please try again',
                navigator.app.exitApp,
                'API Error',
                'Ok'
            );
        });
    }    
}


// View Models
function AuthenticateViewModel(){}
function DashboardViewModel(){
    this.scanCaption    = ko.observable('scan a label');
    this.listCaption    = ko.observable('list all assets');
    this.searchCaption    = ko.observable('search for assets');
    this.newAssetCaption    = ko.observable('add asset');
    this.newInventoryCaption    = ko.observable('add inventory');
    this.loggedInAs     = ko.observable('Anonymous');
    this.adminView      = ko.observable(false);
    this.isAdmin        = ko.computed(function(){
        return this.adminView();
    },this);
}

function AlertViewModel(){
    //contains all types for errors / Alerts / messages
    this.heading    = ko.observable('Alert'); 
    this.message    = ko.observable('Sorry! could not validate your credentials, Try again'); 
}

function LocationsBoxModel(){
    this.locations      = ko.observableArray();
    this.selectedLoc    = ko.observable();
    this.selectedLocNewAsset = ko.observable();
    this.selectedLoc.subscribe(function(value){
        if(value != undefined){            
            var query = new FilterQuery();
            query.filter_param_val = value.id;        
            query.status = 'location';
            query.token  = getData("token");
            $('.ui-dialog').dialog('close');
            filterAssets(query);
        }
    });
}

function UsersBoxModel(){
    this.users          = ko.observableArray(); 
    this.selectedUser   = ko.observable();
    this.selectedUser.subscribe(function(value){
        if(value != undefined){
            var query = new FilterQuery();
            query.filter_param_val = value.id;        
            query.status = 'possessions_of';
            query.token  = getData("token");
            $('.ui-dialog').dialog('close');
            filterAssets(query);
        }
    });
}

function GroupBoxModel(){
    this.groups         = ko.observableArray();
    this.selectedGroup  = ko.observable();
    this.selectedGroupNewAsset  = ko.observable();
    this.selectedGroup.subscribe(function(value){
        if(value != undefined){
            var reqUrl = 'http://'+ getData('subdomain') + domain + '/groups/' + value.id + '.json'; 
        }else{
            var reqUrl = 'http://'+ getData('subdomain') + domain + '/assets.json'; 
        }       
        var reqData = 'token=' + getData("token");
        $('.ui-dialog').dialog('close');
        $.get(reqUrl, reqData, function(resp, txtstatus, xhr){
            if(!isMobileDevice()){
                resp = JSON.parse(resp);
            }
            viewmodels.assetlist.assets.removeAll();
            if(value != undefined){
                var assets = resp;
            }else{
                var assets = resp.assets;
            }
            for (var i = 0; i < assets.length; i++) {
                var selAsset = assets[i]["asset"];
                selAsset.isAssigned = selAsset.assigned_to_user_name == null ? false : true;
                selAsset.path = 'http://' + getData('subdomain') + domain + '/assets/' + assets[i]["asset"].sequence_num + '.json';                    
                selAsset.isFixedAsset = selAsset.asset_type == "FixedAsset" ? true : false;
                selAsset.isVolatileAsset = selAsset.asset_type == "VolatileAsset" ? true : false;
                viewmodels.assetlist.assets.push(selAsset);
            };
            $.mobile.changePage('#assets');
            $('.ui-listview').listview('refresh');
        }).error(function(){
            notificationAlert('couldnt fetch items for this group');
        });
    });
}

function VendorBoxModel(){
    this.vendors        = ko.observableArray();
    this.selectedVendorNewAsset = ko.observable();
}

function AssetsViewModel(){
    var self            = this;
    self.title          = ko.observable('All Assets');
    self.assets         = ko.observableArray(); 
    self.page           = ko.observable(1);
    self.total_pages    = ko.observable(1);
    self.filterView     = ko.observable(false);
    self.fixedFilterView     = ko.observable(false);
    self.inventoryFilterView = ko.observable(false);
    self.queryObject    = ko.observable(null);    
    self.adminView      = ko.observable(false);
    self.more           = ko.computed(function(){
        if(self.page() < self.total_pages()){
            return true;
        }else{
            return false;
        }
    });
    self.isEmpty        = ko.computed(function(){
        if(self.assets().length > 0){
            return false;
        }else{
            return true;
        }
    });
    self.isAdmin        = ko.computed(function(){
        return self.adminView();
    });
    self.nextPage       = function(){        
        var nPage = self.page() + 1;
        self.page(nPage); 

        if(self.filterView()){
            var query = self.queryObject();
            query.page = nPage;
            var reqData = dataStrFromObj(query);
            var assetspath = 'http://' + getData('subdomain') + domain + '/assets/filter.json';
        }else if(self.fixedFilterView()){
            var reqData = 'token=' + getData("token") + '&page=' + nPage + '&show=fixed_assets';
            var assetspath = 'http://' + getData('subdomain') + domain + '/assets.json';
        }
        else if(self.inventoryFilterView()){
            var reqData = 'token=' + getData("token") + '&page=' + nPage + '&show=volatile_assets';
            var assetspath = 'http://' + getData('subdomain') + domain + '/assets.json';
        }else{
            var reqData = 'token=' + getData("token") + '&page=' + nPage;
            var assetspath = 'http://' + getData('subdomain') + domain + '/assets.json';    
        }
                
         
        $.get(assetspath, reqData, function(resp, txtstatus, xhr){
            if(!isMobileDevice()){
                resp = JSON.parse(resp);
            } 
            var assets = resp.assets;
            //var assets = resp;
            for (var i = 0; i < assets.length; i++) {
                var selAsset = assets[i]["asset"];
                //should be called for Fixed assets only
                if (selAsset["asset_type"] == "VolatileAsset"){
                    selAsset.isAssigned = false;
                    selAsset.isVolatileAsset = true;
                }
                else{
                    selAsset.isAssigned = selAsset.assigned_to_user_name == null ? false : true;
                    selAsset.isFixedAsset = true;
                }    
                self.assets.push(selAsset);
            };
            $('.ui-listview').listview('refresh');            
        });
    };
    self.showDetail     = function(asset){
        //var reqData = 'token=' + getData("token");
        // $.get(asset.path, reqData, function(resp, txtstatus, xhr){
        //     viewmodels.assetview.update(resp["asset"]);
        //     $.mobile.changePage('#detail');
        // }).error(function(){
        //     alert('couldnt fetch details for this asset');
        // });
        if (asset["asset_type"] == "VolatileAsset") {
            //presently i think this code would not run
            viewmodels.inventoryview.update(asset);
            $.mobile.changePage('#inventory-detail');
        }else{
            viewmodels.assetview.update(asset);
            $.mobile.changePage('#detail');
        };
    };
}

function InventoryViewModel(){
    this.assetName      = ko.observable('');
    this.assetDesc      = ko.observable('');
    this.groupName      = ko.observable('n/a');
    this.vendorName     = ko.observable('n/a');
    this.assetModelNo   = ko.observable('n/a');
    this.assetNumber    = ko.observable('n/a');
    this.locationName   = ko.observable('n/a');
    this.quantity       = ko.observable(0);
    this.stockPrice     = ko.observable(0.00); 
    this.adminView      = ko.observable(false);
    this.comments       = ko.observableArray();
    
    this.isArbitrated   = ko.computed(function(){
        if(getData("isarbitrated") == 'true'){
            return true;
        }else{
            return false;
        }
    },this);
    
    this.isAdmin        = ko.computed(function(){
        return this.adminView();
    },this);

    this.formatedPrice      = ko.computed(function(){
        return parseFloat(this.stockPrice()).toFixed(2);
    },this);
    
    this.showDescription = ko.computed(function(){
            if(this.assetDesc() != null){
                if(this.assetDesc().length > 0){
                    return true;
                }else{
                    return false;
                }    
            }else{
                return false;
            }
            
    },this);

    this.showComments = ko.computed(function(){
            if(this.comments().length > 0){
                return true;
            }else{
                return false;
            }
    },this);

    this.inventoryPath  = ko.computed(function(){
        return 'http://' + getData('subdomain') + domain + '/inventory/' + this.assetNumber() + '.json';
    },this);

    this.update         = function (inventory){ 
        this.assetName(inventory.name);
        this.assetDesc(inventory.description);    
        this.assetModelNo(inventory.product_model_number); 
        this.assetNumber(inventory.sequence_num); 
        this.quantity(inventory.net_quantity);
        this.stockPrice(inventory.price);

        if(getData("role_id") == '1'){
            this.adminView(true);
        }else{
            this.adminView(false);
        }
        if(inventory["group"] != undefined){
            this.groupName(inventory["group"].name);
        }else{
            this.groupName('n/a');
        }
        if (inventory["vendor"] != undefined) {
            this.vendorName(inventory["vendor"].name);
        }else{
            this.vendorName('n/a');
        }    
        if (inventory["location"] != undefined) {
            this.locationName(inventory["location"].name);
        }else{
            this.locationName('n/a');
        };

        this.comments.removeAll();
        if(inventory['comments'] != undefined){
            for (var i = 0; i < inventory['comments'].length; i++) {
                this.comments.push({content:inventory['comments'][i].content});
            };    
        }
     };
}

function AssetViewModel(){
    self                = this;
    this.assetName      = ko.observable('');
    this.assetDesc      = ko.observable('');
    this.assetStatus    = ko.observable('n/a');
    this.groupName      = ko.observable('n/a');
    this.vendorName     = ko.observable('n/a');
    this.assetModelNo   = ko.observable('n/a');
    this.assetPurchased = ko.observable('n/a');
    this.assetNumber    = ko.observable('n/a');
    this.locationName   = ko.observable('n/a'); 
    this.assetPrice     = ko.observable(0);
    this.assigned       = ko.observable(null);
    this.assignedName   = ko.observable(null);
    this.adminView      = ko.observable(false);
    this.statusdict     = asset_states;
    this.assetCheckInDue = ko.observable('');
    //empty observable arrays 
    this.comments       = ko.observableArray();
    this.services       = ko.observableArray();
    this.histories      = ko.observableArray();
    this.audits         = ko.observableArray();
    this.canSelfAudit   = ko.observable(false);
    
    this.btnCheckOut    = ko.computed(function(){
        if(this.assetStatus() == 'available'){

            if (getData("isarbitrated") == 'true' && this.isAdmin()) {
                return true;
            }else if (getData("isarbitrated") == 'false') {
                return true;
            }else{
                return false;
            }
        }else{
            return false;
        }

        // if(this.assetStatus() == 'available' && getData("isarbitrated") == 'false'){
        //     return true;
        // }else{
        //     if(this.assetStatus() == 'available' && getData("isarbitrated") == 'true' && getData("role_id") == '1'){
        //         return true;
        //     }else{
        //         return false;    
        //     }            
        // }
    },this);
    
    this.isArbitrated   = ko.computed(function(){
        if(getData("isarbitrated") == 'true'){
            return true;
        }else{
            return false;
        }
    },this);
    
    this.checkoutNotRequested = ko.computed(function(){
        if(this.assetStatus() == 'arbitrated_request_checkout'){
            return false;
        }else{
            if(this.assetStatus() == 'available'){
                return true;
            }else{
                return false;
            }
        }
    },this);

    this.btnCheckIn     = ko.computed(function(){
        if(this.assetStatus() == 'checked_out'){
            if(this.isAdmin() || this.assigned() == getData("user_id")){
                return true;
            }else{
                return false;
            }
        }else{
            return false;
        }                    
    },this);
    
    this.checkoutByOther    = ko.computed(function(){
        if(this.assetStatus() == 'checked_out' && this.assigned() != getData("user_id")){
            return true;
        }else{
            return false
        }
    },this);
    
    this.checkoutByOtherAndIsAdmin = ko.computed(function(){
    	if(this.checkoutByOther() && this.isAdmin()){
    		return true;
    	}
    	else{
    		return false;
    	}  	
    },this);

    this.formatedPurchased  = ko.computed(function(){
        return frmtDate(this.assetPurchased(), false);
        //return moment(this.assetPurchased()).format('MMMM DD, YYYY');
    },this);

    this.formatedCheckInDue  = ko.computed(function(){
        if(this.assetCheckInDue() != null){
            return frmtDate(this.assetCheckInDue(), false);
        }
        else{
            return null;
        }
    },this);

    this.formatedPrice      = ko.computed(function(){
        return parseFloat(this.assetPrice()).toFixed(2);
    },this);

    this.statusDisplay      = ko.computed(function(){
        if(this.assetStatus() == 'checked_out'){
            return this.statusdict[this.assetStatus()] + this.assignedName(); 
        }else if (this.assetStatus() == 'audited') {
            return this.statusdict[this.assetStatus()] + this.assignedName();
        }else{
            return this.statusdict[this.assetStatus()];
        };        
    },this);
    
    this.isAdmin            = ko.computed(function(){
        return this.adminView();
    },this);
    
    this.isNotAdmin            = ko.computed(function(){
        return !this.isAdmin();
    },this);

    this.showDescription = ko.computed(function(){
        if(this.assetDesc() != null){
            if(this.assetDesc().length > 0){
                return true;
            }else{
                return false;
            }    
        }else{
            return false;
        }
            
    },this);
    
    this.showService = ko.computed(function(){
            if(this.services().length > 0){
                return true;
            }else{
                return false;
            }
    },this);
    
    this.showComments = ko.computed(function(){
            if(this.comments().length > 0){
                return true;
            }else{
                return false;
            }
    },this);
    
    this.showHistory = ko.computed(function(){
            if(this.histories().length > 0){
                return true;
            }else{
                return false;
            }
    },this);
    
    this.assetPath  = ko.computed(function(){
        return 'http://' + getData('subdomain') + domain + '/assets/' + this.assetNumber() + '.json';
    },this);

    this.cancelAudit = ko.computed(function(){
      if(this.assetStatus() == 'audited' && this.assigned() != getData("user_id") && this.isAdmin()){
        return true;
      }
      else{
        return false;
      }
    },this);

    this.acknowledge = ko.computed(function(){
      if(this.assetStatus() == 'audited' && this.assigned() == getData("user_id") && this.isNotAdmin()){
        return true;
      }
      else{
        return false;
      }
    },this);


    this.custom_required = ko.computed(function(){
      if (this.audits()[0] != undefined ){
        return this.audits()[0].custom_required;
      }
    },this);


    this.photo_required = ko.computed(function(){
      if(this.audits()[0] != undefined){
        return this.audits()[0].photo_required;
      }
    },this);

    this.only_custom_required = ko.computed(function(){
      if (this.audits()[0] != undefined ){
        return this.audits()[0].custom_required && !this.audits()[0].photo_required;
      }
    },this);

    this.verifyPossession = ko.computed(function(){
      if(this.canSelfAudit() && this.assigned() == getData("user_id") && this.assetStatus() == 'checked_out'){
        return true;
      }
      else{
        return false;
      }
     },this);

    this.update     = function(asset){
        this.assetName(asset.name);
        this.assetDesc(asset.description);
        this.assetStatus(asset.state); 
        this.assetModelNo(asset.product_model_number);
        this.assetPurchased(asset.purchased_on);
        this.assetNumber(asset.sequence_num); 
        this.assetPrice(asset.price);
        this.assigned(asset.assigned_to_id);
        this.assignedName(asset.assigned_to_user_name);
        this.assetCheckInDue(asset.checkin_due_on); 
        if(getData("canselfaudit") == 'true'){
            this.canSelfAudit(true);
        }else{
            this.canSelfAudit(false);
        }
        if(getData("role_id") == '1'){
            this.adminView(true);
            viewmodels.checkoutbox.adminView(true);
            viewmodels.checkinbox.adminView(true);
        }else{
            this.adminView(false);
            viewmodels.checkoutbox.adminView(false);
            viewmodels.checkinbox.adminView(false);
        }
        if(asset["group"] != undefined){
            this.groupName(asset["group"].name);
        }else{
            this.groupName('n/a');
        }
        if (asset["vendor"] != undefined) {
            this.vendorName(asset["vendor"].name);
        }else{
            this.vendorName('n/a');
        }    
        if (asset["location"] != undefined) {
            this.locationName(asset["location"].name);
        }else{
            this.locationName('n/a');
        };
        
        this.comments.removeAll();
        if(asset['comments'] != undefined){
            for (var i = 0; i < asset['comments'].length; i++) {

                this.comments.push({content: asset['comments'][i].content});
            };    
        }
        
        this.services.removeAll();
        if(asset['services'] != undefined){
            for (var i = 0; i < asset['services'].length; i++) {
                this.services.push({description: asset['services'][i].description, cost: parseFloat(asset['services'][i].cost).toFixed(2)});              
            };
        }
        this.audits.removeAll();
        if (asset['audits'] != undefined && asset['audits'].length > 0) {
             this.audits.push({id: asset["audits"][asset['audits'].length -1].id, custom_note: asset["audits"][asset['audits'].length -1].custom_note, photo_required: asset["audits"][asset['audits'].length -1].photo_required, custom_required: asset["audits"][asset['audits'].length -1].custom_required }) ;
        }

    }                
}

function HistoryViewModel(){
    this.name       = ko.observable();
    this.items      = ko.observableArray();
}

function StockHistoryViewModel(){
    this.name       = ko.observable();
    this.items      = ko.observableArray();
}

function AuditViewModel(){
    this.name       = ko.observable();
    this.items      = ko.observableArray();
}

function CheckoutBoxModel(){
    this.users             = ko.observableArray();
    this.selectedUser      = ko.observable();
    this.adminView         = ko.observable(false);
    this.showLocation      = ko.observable(false);
    this.locationEditable  = ko.observable(false);
    this.selectedUser.subscribe(function(value){
        $('#checkout-form #user_id').val(value.id);
    });
    this.isAdmin        = ko.computed(function(){
        return this.adminView();       
    },this);
    this.locationView = ko.computed(function(){
       if(this.showLocation()){
            if(this.adminView() && this.locationEditable()){
                return true;
            }else if(this.adminView() && this.locationEditable() == false){
                return true;
            }else if(this.adminView() == false && this.locationEditable()){
                return true;
            }else{
                return false;
            }
       }else{
            return false;
       }
    },this);
}

function CheckinBoxModel(){
    this.adminView           = ko.observable(false);
    this.showLocationCheckIn = ko.observable(false);
    this.locationEditable    = ko.observable(false);
    this.isAdmin             = ko.computed(function(){
        return this.adminView();       
    },this);
    this.locationViewCheckIn = ko.computed(function(){
       if(this.showLocationCheckIn()){
            if(this.adminView() && this.locationEditable()){
                return true;
            }else if(this.adminView() && this.locationEditable() == false){
                return true;
            }else if(this.adminView() == false && this.locationEditable()){
                return true;
            }else{
                return false;
            }
       }else{
            return false;
       }
    },this);
}

//utility functions

//Taken from http://snippets.dzone.com/posts/show/452
function isUrl(s){
    var urlre = /(ftp|http|https):\/\/(\w+:{0,1}\w*@)?(\S+)(:[0-9]+)?(\/|\/([\w#!:.?+=&%@!\-\/]))?/
    return urlre.test(s);
}

function getData(key){
    return window.localStorage.getItem(key);
}

function setData(key, value){
    window.localStorage.setItem(key, value);
}

function FilterQuery(){
    this.filter_param_val   = '';
    this.assets_index       = '';
    this.status             = '';
    this.token              = '';
    this.page               = 1;
}

function filterAssets(queryObject){
    viewmodels.assetlist.filterView(true); //make false at other places
    viewmodels.assetlist.queryObject(queryObject);
    viewmodels.assetlist.page(1);
    var filterUrl = 'http://'+ getData('subdomain') + domain + '/assets/filter.json';
    $.get(filterUrl, dataStrFromObj(queryObject), function(resp, txtstatus, xhr){
        if(!isMobileDevice()){
            resp = JSON.parse(resp);
        }
        if(queryObject.page == 1){
            viewmodels.assetlist.assets.removeAll();    
        }
        var assets = resp.assets;
        if(assets.length > 0){
            for (var i = 0; i < assets.length; i++) {
                var selAsset = assets[i]["asset"];
                selAsset.path = 'http://' + getData('subdomain') + domain + '/assets/' + assets[i]["asset"].sequence_num + '.json';
                selAsset.isAssigned = selAsset.assigned_to_user_name == null ? false : true;
                selAsset.isFixedAsset = selAsset.asset_type == "FixedAsset" ? true : false;
                selAsset.isVolatileAsset = selAsset.asset_type == "VolatileAsset" ? true : false;
                viewmodels.assetlist.assets.push(selAsset);
            }    
        }
        viewmodels.assetlist.total_pages(resp.total_pages); //disable paging
        $.mobile.changePage('#assets');
        $('.ui-listview').listview('refresh');
    }).error(function(){
        notificationAlert('the filtered assets list could not be retrieved');
    });
}

function dataStrFromObj(obj){
    var rstr = "";
    for(prop in obj){
        rstr = rstr + prop + "=" + obj[prop] + "&";
    }
    return rstr.substring(0, rstr.length - 1);
}

function cons(obj){
    for(prop in obj){
        var propstr = "Property: " + prop + " Value: " + obj[prop];
        console.log(propstr);
    }        
}

function frmtDate(datestr, showtime){    
    var arr = datestr.split(/[- :]/);     
    if(!showtime){
         var dt = new Date(arr[0], arr[1]-1, arr[2]);
         return moment(dt).format('MMMM DD, YYYY');
     }else{
        var dt = new Date(arr[0], arr[1]-1, arr[2], arr[3], arr[4], arr[5]);
        return moment(dt).format('MMMM DD, YYYY HH:mm');    
    }
    
};

function checkIfLoggedIn(){
    //poll the server 
    var token = getData("token");
    if(token == null){
        return false;
    }else{
        return true;
    } 
}
function getValFromSerializedArray( name, array ){
    var retVal = null;
    $.each(array, function ( i, field ){
       if(field.name == name){
           retVal = field.value;
       }  
    });
    return retVal;
}
function setValInSerializedArray( name, value, array ){
    var retVal = null;
    $.each(array, function ( i, field ){
       if(field.name == name){
           field.value=value;
       }  
    });
}
function isMobileDevice(){
    return (navigator.userAgent.match(/(iPhone|iPod|iPad|Android)/)) ? true : false;
}

