/*
 * This file is part of Offline Timetable
 * Copyright (C) 2014 Chien-Yu Chen <abc9070410@gmail.com>
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

// ex. "var S_A = new Array( "一", "one" );" , "TTRR" -> var S_A = new Array( "一", "one", "TTRR" );
// ex. saveTextFile( getMergedLanguage( gsLanguage, new Array( gsNewLanguage2, gsNewLanguage3, gsNewLanguage4 ) ) );
function getMergedLanguage( sLanguageData, asNowLanguage )
{
    var aasLanguages = new Array();
    
    for ( var i = 0; i < asNowLanguage.length; i ++ )
    {
        aasLanguages[i] = asNowLanguage[i].split( "_" );
    }
    
    var indexOfLanguage = 0;
    
    var asAllTokens = sLanguageData.split( "var" );
    
    var sHTML = "";

    for ( var i = 0; i < asAllTokens.length; i ++ )
    {
        indexEnd = asAllTokens[i].indexOf( "'" ) + 1;
        
        if ( indexEnd <= 0 )
        {
            sHTML += "var" + asAllTokens[i] + "\r\n";
            continue;
        }
        
        // go to the index of the last "'" 
        while ( asAllTokens[i].indexOf( "'", indexEnd ) > 0 )
        {
            indexEnd++;
        }
        
        var sFront = asAllTokens[i].substring( 0, indexEnd );
        var sBack = asAllTokens[i].substring( indexEnd, asAllTokens[i].length );
        
        sHTML += "var" + sFront;
        for ( var j = 0; j < aasLanguages.length; j ++ )
        {
            var sNew = aasLanguages[j][indexOfLanguage];

            sNew = sNew == null ? "" : sNew.trim();
            sHTML += ", '" + sNew + "'"; 
        }

        sHTML += sBack + "\r\n";
        
        indexOfLanguage++;
    }
    
    log( "sHTML = " + sHTML );

    return sHTML;
    //updateDiv( sNowDivID, sHTML );
    //document.innerHTML = sHTML;
}


// ex. "var S_A = new Array( "一", "one" );var S_B = new Array( "二", "two" );" -> ( "一", "二" )
// ex. saveTextFile( getLanguage( gsLanguage, ZH ) );
function getLanguage( sLanguageData, iLanguageIndex )
{
    log( "sLanguageData.length=" + sLanguageData.length );

    var asAllTokens = sLanguageData.split( "var" );
    
    log( "asAllTokens.length=" + asAllTokens.length );
    
    var asLanguages = new Array();
    
    for ( var i = 0; i < 13; i ++ )
    {
        log( "" + i + ". " + asAllTokens[i] );
    }
    
    var indexBegin = 0;
    var indexEnd = 0;
    var indexOfZH = 0;
    var asZH = new Array();
    var sHTML = "";
    
    for ( var i = 0; i < asAllTokens.length; i ++ )
    {
        indexBegin = 0;
        for ( var j = 0; j < iLanguageIndex; j ++ )
            indexBegin = asAllTokens[i].indexOf( ",", indexBegin ) + 1;
        
        indexBegin = asAllTokens[i].indexOf( "'", indexBegin ) + 1;
        
        if ( indexBegin <= 0 )
            continue;
            
        indexEnd = asAllTokens[i].indexOf( "'", indexBegin );
        
        asZH[indexOfZH] = asAllTokens[i].substring( indexBegin, indexEnd );
        
        sHTML += asZH[indexOfZH] + "\r\n";
        
        indexOfZH ++;
    }
    
    log( "asZH.toString() = " + asZH.toString() );
    
    //updateDiv( sNowDivID, asZH.toString() );
    //document.innerHTML = asZH.toString();
    
    return sHTML;
}



﻿var gsLanguage = "var S_APP_NAME = new Array( '離線時刻表', 'Offline Timetable' );var S_BACK = new Array( '回上頁', 'Back' );var S_SEARCH = new Array( '查詢', 'Search' );var S_FAVOURITE = new Array( '最愛', 'Favorite' );var S_RECORD = new Array( '紀錄', 'Record' );var S_OPTION = new Array( '選項', 'Option' );var S_ABOUT = new Array( '關於', 'About' );var S_START_STATION = new Array( '出發車站', 'Start' );var S_END_STATION = new Array( '到達車站', 'End' );var S_CHOSEN_DATE = new Array( '啟程日期', 'Date' );var S_CHOSEN_TIME = new Array( '上車時間', 'Time' );var S_START_SEARCH = new Array( '開始搜尋', 'Start search' );var S_MENU = new Array( '菜單', 'Menu' );var S_LOCATION = new Array( '地區', 'Location' );var S_PLEASE_CHOSE_ONE = new Array( '請挑選一個', 'Please chose one' );var S_SEARCH_RESULT = new Array( '搜尋結果', 'Search Result' );// Sun, Mon, Tue, Wed, Thu, Fri, Satvar S_SUN = new Array( '日', 'Sun' );var S_MON = new Array( '一', 'Mon' );var S_TUE = new Array( '二', 'Tue' );var S_WED = new Array( '三', 'Wed' );var S_THU = new Array( '四', 'Thu' );var S_FRI = new Array( '五', 'Fri' );var S_SAT = new Array( '六', 'Sat' );var S_WEEK_ARRAY = new Array( S_SUN, S_MON, S_TUE, S_WED, S_THU, S_FRI, S_SAT );var S_CHOICE_PLEASE = new Array( '請選擇', 'please select the' );var S_EARLIEST_TIME_GET_ON = new Array( '最早的上車時間', 'earliest time to get on' );var S_LATEST_TIME_GET_ON = new Array( '最晚的上車時間', 'latest time to get on' );var S_CLOCK = new Array( '點', ':00' );var INDEX_STYLE_WINDOWS_8 = 0;var INDEX_STYLE_ANDROID = 1;var INDEX_STYLE_IOS = 2;var INDEX_STYLE_IOS_7 = 3;var S_WINDOWS_8 = new Array( 'Windows 8', 'Windows 8' );var S_ANDROID = new Array( 'Android', 'Android' );var S_IOS = new Array( 'IOS', 'IOS' );var S_IOS_7 = new Array( 'IOS 7', 'IOS 7' );var S_STYLE_ARRAY = new Array( S_WINDOWS_8, S_ANDROID, S_IOS, S_IOS_7 );var S_ZH = new Array( '繁體中文', '繁體中文' );var S_EN = new Array( 'English', 'English' );var S_CN = new Array( '简体中文', '简体中文' );var S_JA = new Array( '日本の', '日本の' );var S_KO = new Array( '한국의', '한국의' );var S_LANGUAGE_ARRAY = new Array( S_ZH, S_EN, S_CN, S_JA, S_KO );var S_UPDATE = new Array( '更新', 'Update' );var S_LAST_UPDATE = new Array( '最後更新日期', 'Last update' );var S_UPDATE_TIMETABLE = new Array( '更新時刻表', 'Update timetable' );var S_UPDATE_ARRAY = new Array( S_LAST_UPDATE, S_UPDATE_TIMETABLE );var S_DISPLAY = new Array( '顯示', 'Display' );var S_STYLE = new Array( '風格', 'Style' );var S_LANGUAGE = new Array( '語言', 'Language' );var S_FONT_SIZE = new Array( '字體大小', 'Font size' );var S_FONT_COLOR = new Array( '字體顏色', 'Font color' );var S_BACKGROUND_COLOR = new Array( '背景顏色', 'Background color' );var S_BACKGROUND_IMAGE = new Array( '背景圖片', 'Background image' );var S_RESULT_LIMIT = new Array( '搜尋結果數量上限', 'Result limit' );var S_RECORD_LIMIT = new Array( '紀錄數量上限', 'Record limit' );var S_ALWAYS_SHOW_MENU = new Array( '永遠顯示功能按鈕', 'Always show menu' );var S_LAST_FIVE = new Array( '最後五筆', 'The last five' );var S_LAST_TEN = new Array( '最後十筆', 'The last ten' );var S_LAST_FIFTEEN = new Array( '最後十五筆', 'The last fifteen' );var S_RECORD_LIMIT_ARRAY = new Array( S_LAST_FIVE, S_LAST_TEN, S_LAST_FIFTEEN );var S_TOP_FIVE = new Array( '前面五筆', 'Top five' );var S_TOP_TEN = new Array( '前面十筆', 'Top ten' );var S_TOP_TWENTY = new Array( '前面二十筆', 'Top ten' );var S_TOP_ALL = new Array( '全部', 'All' );var S_RESULT_LIMIT_ARRAY = new Array( S_TOP_FIVE, S_TOP_TEN, S_TOP_TWENTY, S_TOP_ALL );var S_RECOVERY = new Array( '清理', 'Recovery' );var S_CLEAN_ALL_RECORDS = new Array( '清除所有紀錄', 'Clean all records' );var S_CLEAN_ALL_FAVOURITES = new Array( '清除所有最愛', 'Clean all favourites' );var S_BACK_TO_DEFAULT_SETTING = new Array( '回歸原始設定', 'Back to default setting' );var S_RECOVERY_ARRAY = new Array( S_CLEAN_ALL_RECORDS, S_CLEAN_ALL_FAVOURITES, S_BACK_TO_DEFAULT_SETTING );var S_ARE_YOU_SURE = new Array( '確認要', 'Are you sure to ' );var S_CONDITION = new Array( '條件', 'Condition' );var S_TICKET_CATEGORY = new Array( '車票種類', 'Ticket Category' );var S_TRANSPORT_CATEGORY = new Array( '交通工具種類', 'Transport Category' );var S_OTHER_ARRAY = new Array( S_TICKET_CATEGORY, S_TRANSPORT_CATEGORY, S_ALWAYS_SHOW_MENU );var S_TICKET = new Array( '車票', 'Ticket' );var S_FULL_FARE = new Array( '全票', 'Full fare' );var S_HALF_FARE = new Array( '半票', 'Half fare' );var S_ROUND_TRIP = new Array( '來回票', 'Round trip' );var S_TICKET_ARRAY = new Array( S_FULL_FARE, S_HALF_FARE, S_ROUND_TRIP );var S_TRAVEL_CLASS = new Array( '車廂', 'Travel Class' );var S_NON_RESERVED_CLASS = new Array( '自由座車廂', 'Non-reserved' );var S_STANDARD_CLASS = new Array( '標準車廂', 'Standard' );var S_BUSINESS_CLASS = new Array( '商務車廂', 'Business' );var S_TRAVEL_CLASS_ARRAY = new Array( S_NON_RESERVED_CLASS, S_STANDARD_CLASS, S_BUSINESS_CLASS );// car type TCLE : 自強 , CKE : 莒光 , LT : 區間var S_LOCAL_TRAIN = new Array( '區間車', 'Local Train' );var S_CHU_KUANG_EXPRESS = new Array( '莒光號', 'Chu-Kuang Express' );//var S_FU_HSIN_EXPRESS = new Array( '復興號', 'Fu-Hsin Express' );var S_TZE_CHIANG_LIMITED_EXPRESS = new Array( '自強號', 'Tze-Chiang Limited Express' );//var S_FULL_TRA = new Array( '台灣鐵路', 'Taiwan Railways Administration' );var S_FULL_THSR = new Array( '高速鐵路', 'Taiwan High Speed Rail' );var S_FULL_KINGBUS = new Array( '國光客運', 'Kingbus' );var S_FULL_UBUS = new Array( '統聯客運', 'Ubus' );var S_TRANSPORT_CATEGORY_ARRAY = new Array( S_LOCAL_TRAIN, S_CHU_KUANG_EXPRESS, S_TZE_CHIANG_LIMITED_EXPRESS, S_FULL_THSR, S_FULL_KINGBUS, S_FULL_UBUS );var S_ABOUT = new Array( '關於', 'About' );var S_ABOUT_APP = new Array( '關於程式', 'About APP' );var S_ABOUT_AUTHOR = new Array( '關於作者', 'About Author' );var S_RELATED_LINKS = new Array( '相關鏈結', 'Related Links' );var S_ABOUT_ARRAY = new Array( S_ABOUT_APP, S_ABOUT_AUTHOR, S_RELATED_LINKS );var S_GOOGLE_PLAY = new Array( 'Google Play', 'Google Play' );var S_GITHUB = new Array( 'GitHub', 'GitHub' );var S_TRA_OFFICE_SITE = new Array( '', 'TRA Office Site' );var S_THSR_OFFICE_SITE = new Array( '', 'THSR Office Site' );var S_KINGBUS_OFFICE_SITE = new Array( '', 'Kingbus Office Site' );var S_UBUS_OFFICE_SITE = new Array( '', 'Ubus Office Site' );var S_RELATED_LINKS_ARRAY = new Array( S_GOOGLE_PLAY, S_GITHUB, S_TRA_OFFICE_SITE, S_THSR_OFFICE_SITE, S_KINGBUS_OFFICE_SITE, S_UBUS_OFFICE_SITE );var S_ABOUT_APP_DETAIL = new Array( 'Open Source', 'Open Source' );var S_ABOUT_AUTHOR_DETAIL = new Array( 'surveyorK', 'surveyorK' );// record sorted byvar S_DATE = new Array( '日期', 'Date' );var S_NAME = new Array( '名稱', 'Name' );var S_TIME = new Array( '時間', 'Time' );var S_ADD_INTO_FAVOURITE = new Array( '加入最愛', 'Add into favourite' );var S_SEND_TO_SEARCH = new Array( '送往搜尋', 'Send to search' );var S_REMOVE_THIS_RECORD = new Array( '刪除此紀錄', 'Remove this record' );var S_RECORD_BUTTONS = new Array( S_REMOVE_THIS_RECORD, S_SEND_TO_SEARCH, S_ADD_INTO_FAVOURITE );var S_REMOVE_THIS_FAVOURITE = new Array( '刪除此最愛', 'Remove this favourite' );var S_FAVOURITE_BUTTONS = new Array( S_REMOVE_THIS_FAVOURITE, S_SEND_TO_SEARCH );var S_YES = new Array( '是', 'Yes' );var S_NO = new Array( '否', 'No' );var S_YES_AND_NO_ARRAY = new Array( S_YES, S_NO );var S_RECORD_LIMIT = new Array( '紀錄數量上限', 'Record limit' );var S_CONFIRM = new Array( '確定', 'Confirm' );var S_CANCEL = new Array( '取消', 'Cancel' );var S_CLOSEST_STATION = new Array( '鄰近車站', 'Closest Station' );var S_STATION_LEVEL = new Array( '車站等級', 'Station Level' );var S_ORDER = new Array( '順序', 'Order' );var S_STATION_NAME = new Array( '站名', 'Station Name' );var S_DEPARTURE_TIME = new Array( '出發時間', 'Departure Time' );var S_ARRIVAL_TIME = new Array( '到達時間', 'Arrival Time' );var S_MOUNTAINS_LINE = new Array( '山線', 'Mountains Line' );var S_COAST_LINE = new Array( '海線', 'Coast Line' );var S_NORTH_BOUND_LINE = new Array( '上行', 'North-bound Line' );var S_SOUTH_BOUND_LINE = new Array( '下行', 'South-bound Line' );var S_TRAIN_TYPE = new Array( '車種', 'Train Type' );var S_ORIGIN_STATION = new Array( '起點車站', 'Origin' );var S_DESTINATION_STATION = new Array( '終點車站', 'Destination' );var S_STOPPING_AT = new Array( '停靠車站', 'Stopping at' );var S_REMARKS = new Array( '備註', 'Remarks' );var S_TRAIN_NUMBER = new Array( '列車班次', 'Train Number' );// define index cause the sort conditions exist in language.js and global.jsvar INDEX_PRICE = 0;var INDEX_ARRIVAL_TIME = 1;var INDEX_TRAVEL_TIME = 2;var INDEX_TRANSSHIP = 3;var S_SORT_BY = new Array( '排序', 'Sort' );var S_PRICE = new Array( '價錢', 'Price' );var S_TRAVEL_TIME = new Array( '花費時間', 'Spend Time' );var S_TRANSSHIP = new Array( '轉乘次數', 'Transship Count' );var S_SORT_ARRAY = new Array();S_SORT_ARRAY[INDEX_PRICE] = S_PRICE;S_SORT_ARRAY[INDEX_ARRIVAL_TIME] = S_ARRIVAL_TIME;S_SORT_ARRAY[INDEX_TRAVEL_TIME] = S_TRAVEL_TIME;S_SORT_ARRAY[INDEX_TRANSSHIP] = S_TRANSSHIP;var S_TRA = new Array( '台鐵', 'TRA' );var S_THSR = new Array( '高鐵', 'THSR' );//var S_TRTC = new Array( '北捷', 'TRTC' );//var S_KRTC = new Array( '高捷', 'KRTC' );var S_KINGBUS = new Array( '國光', 'Kingbus' );var S_UBUS = new Array( '統聯', 'Ubus' );var S_BUS = new Array( '客運', 'Bus' );var S_MRT = new Array( '捷運', 'MRT' );var S_CAR_ARRAY = new Array( S_TRA, S_THSR, S_KINGBUS, S_UBUS );var S_SPEED_PRIORITY = new Array( '速度優先', 'Speed ​​Priority' );var S_PRICE_PRIORITY = new Array( '價格優先', 'Price ​​Priority' );var S_ROUTE = new Array( '路線', 'Route' );var S_SPEND_TIME = new Array( '耗時', 'Spend' );var S_SPECIAL_LEVEL = new Array( '特等站', 'Special Level' );var S_FIRST_LEVEL = new Array( '一等站', 'First Level' );var S_SECOND_LEVEL = new Array( '二等站', 'Second Level' );var S_THIRD_LEVEL = new Array( '三等站', 'Third Level' );var S_SIMPLE_LEVEL = new Array( '簡易站', 'Simple Level' );var S_CALL_LEVEL = new Array( '招呼站', 'Call Level' );var S_STATION_LEVEL_ARRAY = new Array( S_SPECIAL_LEVEL, S_FIRST_LEVEL, S_SECOND_LEVEL, S_THIRD_LEVEL, S_SIMPLE_LEVEL, S_CALL_LEVEL );var S_DRIVE_EVERYDAY = new Array( '每天行駛', 'Drive everyday' );var S_ADDITION_TRAIN = new Array( '加班車', 'Addition Train' );var S_TAROKO = new Array( '太魯閣號', 'Taroko' );var S_OVER_NIGHT = new Array( '跨日車', 'Over night' );var S_DINER = new Array( '附掛餐車', 'Diner' );var S_CRIPPLE = new Array( '設身障旅客專用座位車', 'Cripple' );var S_BIKE_PORTABLE = new Array( '可攜帶「置於攜車袋之自行車」(放置12車)', 'Bike portable' );var PIC_EXPLANATION_ARRAY = new Array( S_DRIVE_EVERYDAY, S_ADDITION_TRAIN, S_TAROKO,  S_OVER_NIGHT, S_DINER, S_CRIPPLE, S_BIKE_PORTABLE );var S_CLOCKWISE = new Array( '北上', 'Clockwise' );var S_COUNTERCLOCKWISE = new Array( '南下', 'Counterclockwise' );var S_AT = new Array( '在', ' at ' );var S_OVER_NIGHT = new Array( '跨日', 'Over night' );var S_SETTING_DONE = new Array( '設置完成', 'Setting Done' );var S_GO_BACK_TO = new Array( '回到', 'Go back to ' );var S_IMAGE_NAME = new Array( '圖檔名稱', 'Image Name' );var S_IMAGE_TYPE = new Array( '圖檔類別', 'Image Type' );var S_IMAGE_SIZE = new Array( '圖檔大小', 'Image Size' );var S_APP_INFO_0 = new Array( '程式語言 : HTML + Javascript', 'Language : HTML + Javascript' );var S_APP_INFO_1 = new Array( '主體框架 : Phonegap + jqMobi', 'Framework : Phonegap + jqMobi' );var S_APP_INFO_2 = new Array( '開發環境 : Firefox + Firebug', 'Environment : Firefox + Firebug' );var S_APP_INFO_3 = new Array( '編輯工具 : Notepad++', 'Editor : Notepad++' );var S_APP_INFO_ARRAY = new Array( S_APP_INFO_0, S_APP_INFO_1, S_APP_INFO_2, S_APP_INFO_3 );var S_AUTHOR_INFO_0 = new Array( '彰化子弟', 'Born in Changhua' );var S_AUTHOR_INFO_1 = new Array( '新竹打工仔', 'Working in Hsinchu' );var S_AUTHOR_INFO_2 = new Array( '以下略...', 'Skip the following...' );var S_AUTHOR_INFO_ARRAY = new Array( S_AUTHOR_INFO_0, S_AUTHOR_INFO_1, S_AUTHOR_INFO_2 );var S_EMAIL_TO_AUTHOR = new Array( '寫信給作者', 'Email to Author' );var S_UP_SITE = new Array( '上車地點', 'Up Site' );var S_DOWN_SITE = new Array( '下車地點', 'Down Site' );var S_REVERSE_LOCATION = new Array( '車站互換', 'Switch' );var S_NOT_FOUND = new Array( '此條件下無法取得適合路線', 'not found on current search conditions' );var S_TIME_GAP_FOR_TRANSPORT_CHANGE = new Array( '轉乘時間間隔', 'Time Gap for transport change' );var S_SAME_PLATFORM = new Array( '相同系統 (例如台鐵轉台鐵)', 'Same Platform (ex. TRA -> TRA)' );var S_DIFFERENT_PLATFORM = new Array( '不同系統 (例如台鐵轉高鐵)', 'Different Platform (ex. TRA -> THSR)' );var S_MINUTES = new Array( '分鐘', 'minutes' );var S_MORE_THAN = new Array( '至少', 'more than ' );";


var gsNewLanguage2 = "离线时刻表_回上页_查询_最爱_纪录_选项_关于_出发车站_到达车站_启程日期_上车时间_开始搜寻_菜单_地区_请挑选一个_搜寻结果_日_一_二_三_四_五_六_请选择_最早的上车时间_最晚的上车时间_点_Windows 8的_Android的_内部监督办公室_IOS 7_繁体中文_英语_简体中文_日本の_한국의_更新_最后更新日期_更新时刻表_显示_风格_语言_字体大小_字体颜色_背景颜色_背景图片_搜寻结果数量上限_纪录数量上限_永远显示功能按钮_最后五笔_最后十笔_最后十五笔_前面五笔_前面十笔_前面二十笔_全部_清理_清除所有纪录_清除所有最爱_回归原始设定_确认要_条件_车票种类_交通工具种类_车票_全票_半票_来回票_车厢_自由座车厢_标准车厢_商务车厢_区间车_莒光号_复兴号_自强号_台湾铁路_高速铁路_国光客运_统联客运_关于_关于程式_关于作者_相关链结_谷歌播放_GitHub的_____开源_surveyorK_日期_名称_时间_加入最爱_送往搜寻_删除此纪录_删除此最爱_是_否_纪录数量上限_确定_取消_邻近车站_车站等级_顺序_站名_出发时间_到达时间_山线_海线_上行_下行_车种_起点车站_终点车站_停靠车站_备注_列车班次_排序_价钱_花费时间_转乘次数_台铁_高铁_北捷_高捷_国光_统联_客运_捷运_速度优先_价格优先_路线_耗时_特等站_一等站_二等站_三等站_简易站_招呼站_每天行驶_加班车_太鲁阁号_跨日车_附挂餐车_设身障旅客专用座位车_可携带「置于携车袋之自行车」 （放置12车）_北上_南下_在_跨日_设置完成_回到_图档名称_图档类别_图档大小_程式语言： HTML + JavaScript，将_主体框架： PhoneGap的+ jqMobi_开发环境： Firefox的Firebug的+_编辑工具：记事本+ +_彰化子弟_新竹打工仔_以下略..._写信给作者_上车地点_下车地点_车站互换_此条件下无法取得适合路线_转乘时间间隔_相同系统（例如台铁转台铁）_不同系统（例如台铁转高铁）_分钟_至少";


var gsNewLanguage3 = "オフライン時刻表_バック_検索_お気に入り_記録_オプション_約_スタート_終わり_日付_時間_検索を開始_メニュー_場所_1を選んだください_検索結果_太陽_モン_火曜_結婚_木_金_土_選択してください_に乗って最も早い時間_乗るために最新の時間_： 00_Windowsの8_アンドロイド_IOS_IOS 7_繁体中文_英語_简体中文_日本の_한국의_アップデート_最終更新日_更新時刻表_ディスプレイ_スタイル_言語_フォントサイズ_フォントの色_背景色_背景画像_結果の制限_レコード制限_常にメニューを表示_最後の5_最後の10_最後の15_トップ5_トップ10_トップ10_すべて_回復_すべてのレコードをきれいに_すべてのお気に入りをきれいに_初期画面に戻る_あなたはしますか_条件_チケットのカテゴリー_輸送部門_チケット_正規運賃_半額運賃_往復_トラベルクラス_非予約_標準_ビジネス_普通列車_チュ·クァンエクスプレス_FU-シンエクスプレス_ツィー·チェンマイ特急_台湾鉄道管理_台湾高速鉄道_Kingbus_UBUS_約_アプリについて_著者について_関連リンク_グーグルプレイ_GitHubの_TRAオフィスサイト_高速鉄道庁サイト_Kingbusオフィスサイト_UBUSオフィスサイト_オープンソース_surveyorK_日付_名前_時間_お気に入りに追加_検索する送る_このレコードを削除する_このお気に入りを削除_はい_いいえ_レコード制限_確認する_キャンセル_最寄りの駅_ステーションレベル_オーダー_駅名_出発時間_到着時刻_山ライン_コーストライン_ノースバウンドライン_南に結合したライン_列車の種類_起源_先_で停止_備考_列車番号_ソート_価格_時間を過ごす_カウントの積み替え_TRA_高速鉄道_TRTC_KRTC_Kingbus_UBUS_バス_MRT_速度優先_価格優先_ルート_過ごす_特別なレベル_最初のレベル_第二レベル_第3レベル_簡単なレベル_コール·レベル_日常のドライブ_さらに電車_太魯閣_オーバーナイト_ダイナー_不具_バイクポータブル_右回りに_反時計回りの_ に_オーバーナイト_設定完了_に戻る_画像名_イメージタイプ_画像サイズ_言語： HTML + Javascriptの_フレームワーク： PhoneGapの+ jqMobi_環境： FirefoxのFirebugの+_エディタ：メモ帳+ +_彰化で生まれ_新竹で働く_次の検索..._作者への電子メール_サイトアップ_サイトダウン_スイッチ_現在の検索条件には見られない_輸送の変更のための時間的ギャップ_同じプラットフォーム（例： TRA - > TRA ）_別のプラットフォーム（例： TRA - >高速鉄道）_分_超える";

var gsNewLanguage4 = "오프라인 시간표_백_수색_마음에 드는_기록_선택권_약_스타트_끝_날짜_시간_검색 을 시작합니다_메뉴_위치_하나를 선택 하십시오_검색 결과_태양_월_화_결혼시키다_목_(금)_토_선택하세요_에서 얻을 수있는 가장 빠른 시간_에서 얻을 수있는 최신 시간_: 00_윈도우 8_안드로이드_IOS_IOS 7_繁体 中文_영어_简体 中文_日本 の_한국의_업데이트_마지막 업데이트_업데이트 일정_디스플레이_스타일_언어_폰트 크기_글꼴 색_배경 색상_배경 이미지_결과 제한_레코드 제한_항상 메뉴를 표시_마지막 다섯_지난 10_지난 15_상위 5_최고 열_최고 열_모든_회복_모든 레코드를 청소_모든 즐겨 찾기 를 청소_돌아 가기 기본 설정으로_당신은 확실하다_조건_티켓 종류_교통 카테고리_표_전체 요금_절반 요금_왕복_여행 클래스_비 예약_표준_사업_보통 열차_추 쿠앙 익스프레스_푸 - Hsin의 익스프레스_문츠 - 치앙마이 특급_대만 철도 관리_대만 고속 철도_Kingbus_Ubus_약_APP 소개_저자에 관하여_관련 링크_구글 플레이_GitHub의_TRA 대리점 사이트_THSR 대리점 사이트_Kingbus 대리점 사이트_Ubus 대리점 사이트_오픈 소스_surveyorK_날짜_이름_시간_좋아하는 에 추가_검색 보내기_이 레코드를 제거_이 즐겨 찾기 삭제_예_아니_레코드 제한_확인_취소_가장 가까운 역_역 수준_주문_역 이름_출발 시각_도착 시간_산 라인_코스트 라인_노스 바운드 라인_사우스 바운드 라인_기차 유형_유래_목적지_에서 중지_비고_기차 번호_종류_가격_시간을 보내고_카운트 환적_TRA_THSR_TRTC_KRTC_Kingbus_Ubus_버스_MRT_속도 우선_가격 우선 순위_노선_지출_특수 레벨_첫 번째 수준_두 번째 수준_세 번째 수준_간단한 수준_레벨 전화_매일 드라이브_또한 기차_타로_야간에_식당_불구자_자전거 휴대용_시계 방향으로_반 시계 방향으로_ 에_야간에_설정 완료_로 돌아 가기_이미지 이름_이미지 형식_이미지 크기_언어 : HTML + 자바 스크립트_프레임 워크 : Phonegap + jqMobi_환경 : 파이어 폭스 + 방화범_에디터 : 메모장 + +_장화 현 에서 출생_신주 에서 작업_다음 을 이동_저자 에게 이메일로 보내기_사이트 최대_사이트 다운_스위치_현재 검색 조건 에서 찾을 수 없습니다_전송 변화를위한 시간 간격_같은 플랫폼 ( 예 : TRA -> TRA )_다른 플랫폼 ( 예 : TRA -> THSR )_분_이상";