/*
 *  Some DOM utilities
 */

DomUtil = {};

DomUtil.setText = function (node, text) {
	// https://developer.mozilla.org/en-US/docs/Using_Web_Standards_in_your_Web_Pages/Using_the_W3C_DOM

	if (typeof node.textContent === 'string') {
		node.textContent = text;
	} else if (typeof node.innerText === 'string') {
		node.innerText = text;
	} else {
		/* Fallback in case neither textContext nor innerText is
		 * available.
		 */
		while (node.firstChild) {
			node.removeChild(node.firstChild);
		}
		node.appendChild(document.createTextNode(text));
	}
};

DomUtil.setTextToId = function (id, text) {
	var elem = document.getElementById(id);
	if (elem) {
		DomUtil.setText(elem, text);
	}
};
