/*
 *  Main
 */

function lockToPortraitRaw() {
	if (window.screen && window.screen.lockOrientation) {
		var allowed = window.screen.lockOrientation('portrait-primary');
		//alert('orientation lock allowed: ' + allowed);
	} else if (window.screen && window.screen.mozLockOrientation) {
		var allowed = window.screen.mozLockOrientation('portrait-primary');
		//alert('orientation lock allowed: ' + allowed);
	}
}
function lockToPortrait() {
	try {
		lockToPortraitRaw();
	} catch (e) {
		alert(e);
	}
}

function onloadInit() {
	var canStart = true;

	if (window.applicationCache) {
		webAppCache = window.applicationCache;

		webAppCache.addEventListener('updateready',
		function() {
			alert('Application update ready, please reload.');
		}, false);
	} else {
		// This is not a critical issue especially when
		// running as a Firefox OS app.
		//alert('No offline app support in browser.');
	}

	if (window.localStorage) {
		;
	} else {
		alert('No local storage support in browser. ' +
		      'Offtrail cannot start, please close the page.');
		canStart = false;
	}

	if (canStart) {
		app = new OfftrailApplication();
		app.init();
	}

	// For some reason this must be called some time after loading,
	// at least on ZTE Open C
	setTimeout(lockToPortrait, 200);
}

window.onload = function () {
	try {
		onloadInit();
	} catch (e) {
		alert(e);
	}
};
