/*
 *  https://developer.mozilla.org/en-US/docs/Web/Guide/User_experience/Using_the_Page_Visibility_API
 *  http://www.html5rocks.com/en/tutorials/pagevisibility/intro/
 */

var isHidden;
var isVisible;
var onVisibilityChange;

(function () {
	var propNames = [ 'hidden', 'mozHidden', 'msHidden', 'webkitHidden', 'oHidden' ];
	var eventNamePrefixes = [ '', 'moz', 'ms', 'webkit', 'o' ];
	var hiddenProp, eventName;
	var i;

	for (i = 0; i < propNames.length; i++) {
		if (propNames[i] in document) {
			hiddenProp = propNames[i];
			eventName = eventNamePrefixes[i] + 'visibilitychange';
		}
	}
	if (!hiddenProp) {
		alert('No page visibility API support.');
	}
	isHidden = function () {
		if (!hiddenProp) { return false; }
		return document[hiddenProp];
	};
	isVisible = function () {
		return !isHidden();
	};
	onVisibilityChange = function (cb) {
		if (!eventName) { return; }
		document.addEventListener(eventName, cb);
	};
})();
